/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.transaction;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAction;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.transaction.TransactionManager;
import com.streamscape.ds.transaction.TransactionManagerCommon;

public class TransactionManager2PL
extends TransactionManagerCommon
implements TransactionManager {
    public TransactionManager2PL(DataspaceStore db) {
        super(db);
        this.txModel = 0;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return false;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 0;
    }

    @Override
    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    @Override
    public boolean prepareCommitActions(Session session) {
        session.actionTimestamp = this.nextChangeTimestamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int limit = session.rowActionList.size();
        Object[] list = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.endTransaction(session);
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                action.commit(session);
            }
            this.persistCommit(session, 0, limit, false);
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
        session.tempSet.clear();
        return true;
    }

    @Override
    public void rollback(Session session) {
        session.abortTransaction = false;
        session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
        this.rollbackPartial(session, 0, session.transactionTimestamp);
        this.endTransaction(session);
        this.writeLock.lock();
        try {
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
        this.endActionTPL(session);
    }

    void rollbackPartial(Session session, int start, long timestamp) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = limit - 1; i >= start; --i) {
            RowAction action = (RowAction)list[i];
            if (action == null || action.type == 0 || action.type == 3) continue;
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row == null) continue;
            action.rollback(session, timestamp);
            int type = action.mergeRollback(session, timestamp, row);
            action.store.rollbackRow(session, row, type, this.txModel);
        }
        session.rowActionList.setSize(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, Row row, int[] colMap, boolean forUpdate) {
        RowAction action;
        Row row2 = row;
        synchronized (row2) {
            action = RowAction.addDeleteAction(session, table, row, colMap, forUpdate);
        }
        session.rowActionList.add(action);
        PersistentStore store = table.getRowStore(session);
        store.delete(session, row);
        row.rowAction = null;
        return action;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns, boolean forUpdate) {
        RowAction action = row.rowAction;
        if (action == null) {
            System.out.println("null insert action " + String.valueOf(session) + " " + session.actionTimestamp);
        }
        store.indexRow(session, row);
        session.rowActionList.add(action);
        row.rowAction = null;
    }

    @Override
    public boolean canRead(Session session, Row row, int mode, int[] colMap) {
        return true;
    }

    @Override
    public boolean canRead(Session session, int id, int mode) {
        return true;
    }

    @Override
    public void setTransactionInfo(CachedObject object) {
    }

    @Override
    public void removeTransactionInfo(CachedObject object) {
    }

    @Override
    public void beginTransaction(Session session) {
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement cs) {
        if (session.hasLocks(cs)) {
            return;
        }
        this.writeLock.lock();
        try {
            boolean canProceed;
            if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = cs = session.statementManager.getStatement(session, cs);
                if (cs == null) {
                    return;
                }
            }
            if (canProceed = this.setWaitedSessionsTPL(session, cs)) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, cs);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        session.actionTimestamp = this.nextChangeTimestamp();
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp;
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    void endTransaction(Session session) {
        if (session.isTransaction) {
            session.isTransaction = false;
            --this.transactionCount;
        }
    }
}

