/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.state;

import com.streamscape.ds.NameManager;
import com.streamscape.tools.parser.ParserPositionalException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class StateHolder<T> {
    protected T state;
    private Map<SuspectStateOriginator, String> suspectOriginators = new HashMap<SuspectStateOriginator, String>();
    private T suspectState;
    private T onlineState;
    private String lastError = "";

    public StateHolder(T initialState, T suspectState, T onlineState) {
        this.state = initialState;
        this.suspectState = suspectState;
        this.onlineState = onlineState;
    }

    public synchronized T getState() {
        return this.state;
    }

    public synchronized void setState(T state) {
        this.state = state;
        this.suspectOriginators.clear();
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
    }

    public synchronized void setSuspectState(StateHolder<T> holder) {
        if (holder.isSuspectState()) {
            this.suspectOriginators.putAll(holder.suspectOriginators);
            this.state = holder.getState();
        }
    }

    public synchronized void setSuspectState(SuspectStateOriginator originator, String error) {
        this.suspectOriginators.put(originator, error);
        this.state = this.suspectState;
    }

    public synchronized void setSuspectState(SuspectStateOriginator originator, Exception exception) {
        this.setSuspectState(originator, exception, null);
    }

    public synchronized void setSuspectState(SuspectStateOriginator originator, Exception exception, String add) {
        this.setSuspectState(originator, (String)(exception instanceof ParserPositionalException ? exception.getMessage() + "\n\n" + ((ParserPositionalException)((Object)exception)).getLineAndPositionMessage() : exception.getMessage()) + (String)(add != null && add.length() > 0 ? "\n" + add : ""));
    }

    public synchronized void resetSuspectState(SuspectStateOriginator originator) {
        this.suspectOriginators.remove(originator);
        if (this.suspectOriginators.size() == 0) {
            this.state = this.onlineState;
        }
    }

    public synchronized boolean isSuspectState() {
        return this.state == this.suspectState;
    }

    public synchronized Map<SuspectStateOriginator, String> getSuspectStateOriginators() {
        return new HashMap<SuspectStateOriginator, String>(this.suspectOriginators);
    }

    public StateHolder<T> clone() {
        StateHolder<T> cloned = this.doClone();
        cloned.lastError = this.lastError;
        cloned.onlineState = this.onlineState;
        cloned.state = this.state;
        cloned.suspectState = this.suspectState;
        cloned.suspectOriginators = new HashMap<SuspectStateOriginator, String>(this.suspectOriginators);
        return cloned;
    }

    protected abstract StateHolder<T> doClone();

    public static List<Map.Entry<SuspectStateOriginator, String>> excludeOriginators(Map<SuspectStateOriginator, String> originators, Predicate<SuspectStateOriginator> predicate) {
        List<Map.Entry<SuspectStateOriginator, String>> sublist = originators.entrySet().stream().filter(e -> predicate.test((SuspectStateOriginator)e.getKey())).collect(Collectors.toList());
        originators.entrySet().removeIf(e -> predicate.test((SuspectStateOriginator)e.getKey()));
        return sublist;
    }

    public static abstract class SuspectStateOriginator {
        public abstract String getName();

        public abstract String getFullName();

        public String toString() {
            return this.getFullName();
        }
    }

    public static abstract class AbstractNamedSuspectStateOriginator
    extends SuspectStateOriginator {
        private String name;

        protected AbstractNamedSuspectStateOriginator(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getFullName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractNamedSuspectStateOriginator)) {
                return false;
            }
            AbstractNamedSuspectStateOriginator that = (AbstractNamedSuspectStateOriginator)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static abstract class AbstractObjectNamedSuspectStateOriginator
    extends SuspectStateOriginator {
        private NameManager.ObjectName objectName;

        protected AbstractObjectNamedSuspectStateOriginator(NameManager.ObjectName objectName) {
            this.objectName = objectName;
        }

        @Override
        public String getName() {
            return this.objectName.name;
        }

        @Override
        public String getFullName() {
            return this.objectName.getSchemaQualifiedStatementName();
        }

        public int hashCode() {
            return 31 + (this.objectName == null ? 0 : this.objectName.getSchemaQualifiedStatementName().hashCode());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AbstractObjectNamedSuspectStateOriginator other = (AbstractObjectNamedSuspectStateOriginator)object;
            return this.objectName == other.objectName || this.objectName != null && object != null && ((AbstractObjectNamedSuspectStateOriginator)object).objectName.getSchemaQualifiedStatementName().equals(other.objectName.getSchemaQualifiedStatementName());
        }
    }
}

