/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.state;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.schema.SchemaManager;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.ReferenceLink;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.state.ConnectionFactoryRepositoryUtils;
import com.streamscape.ds.state.StateHolder;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.TriggerDefSQL;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.operation.dataspace.ListDataspacesOperation;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.enums.ComponentState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataspaceStateHolder
extends StateHolder<DataspaceStoreState> {
    public static StateHolder.SuspectStateOriginator lob = new LobDataspaceSuspectStateOriginator();
    public static StateHolder.SuspectStateOriginator flob = new FlobDataspaceSuspectStateOriginator();
    public static StateHolder.SuspectStateOriginator syntax = new SyntaxSuspectStateOriginator();
    public static StateHolder.SuspectStateOriginator invalid = new InvalidSuspectStateOriginator();
    public static StateHolder.SuspectStateOriginator outOfSync = new OutOfSyncSuspectStateOriginator();
    public static StateHolder.SuspectStateOriginator dataSource = new DataSourceDataspaceSuspectStateOriginator();
    public static StateHolder.SuspectStateOriginator serverConnection = new ServerConnectionDataspaceSuspectStateOriginator();

    public DataspaceStateHolder() {
        this(DataspaceStoreState.ONLINE);
    }

    public DataspaceStateHolder(DataspaceStoreState initialState) {
        super(initialState, DataspaceStoreState.SUSPECT, DataspaceStoreState.ONLINE);
    }

    @Override
    protected StateHolder<DataspaceStoreState> doClone() {
        return new DataspaceStateHolder();
    }

    public synchronized void setRecoveryFailedState() {
        this.state = DataspaceStoreState.RECOVERY_FAILED;
    }

    public synchronized boolean isRecoveryFailedState() {
        return this.state == DataspaceStoreState.RECOVERY_FAILED;
    }

    public String getLastOrSyntaxOrAllErrors() {
        String lastError = this.getLastError();
        if (this.isSuspectState()) {
            Map<StateHolder.SuspectStateOriginator, String> originators = this.getSuspectStateOriginators();
            List<Map.Entry<StateHolder.SuspectStateOriginator, String>> syntaxOriginators = StateHolder.excludeOriginators(originators, e -> e instanceof SyntaxSuspectStateOriginator);
            if (originators.size() == 0 && syntaxOriginators.size() == 1) {
                lastError = syntaxOriginators.get(0).getValue();
            } else if (lastError.length() == 0) {
                lastError = originators.entrySet().stream().map(e -> DataspaceStateHolder.formatErrorMessage((StateHolder.SuspectStateOriginator)e.getKey(), (String)e.getValue())).collect(Collectors.joining());
            }
        }
        return lastError;
    }

    private static String formatErrorMessage(StateHolder.SuspectStateOriginator originator, String error) {
        if (error == null || error.length() == 0) {
            error = "is suspect";
        }
        return originator.getFullName() + " " + error + ". ";
    }

    public static CollectionDataspaceSuspectStateOriginator collection(NameManager.ObjectName name) {
        return new CollectionDataspaceSuspectStateOriginator(name);
    }

    public static StateHolder.SuspectStateOriginator dataspace(NameManager.ObjectName name) {
        return new DataspaceDataspaceSuspectStateOriginator(name);
    }

    public static StateHolder.SuspectStateOriginator dataspaceRecoveryFailed(NameManager.ObjectName name) {
        return new DataspaceDataspaceSuspectRecoveryFailedStateOriginator(name);
    }

    public static DomainSuspectStateOriginator domain(NameManager.ObjectName name) {
        return new DomainSuspectStateOriginator(name);
    }

    public static TypeSuspectStateOriginator type(NameManager.ObjectName name) {
        return new TypeSuspectStateOriginator(name);
    }

    public static StateHolder.SuspectStateOriginator prototype(String eventId) {
        return new PrototypeSuspectStateOriginator(eventId);
    }

    public static StateHolder.SuspectStateOriginator eventFilter(String eventId) {
        return new EventFilterSuspectStateOriginator(eventId);
    }

    public static StateHolder.SuspectStateOriginator semanticType(String typeName) {
        return new SemanticTypeSuspectStateOriginator(typeName);
    }

    public static StateHolder.SuspectStateOriginator fileDescriptor(String fileDescriptorName) {
        return new FileDescriptorSuspectStateOriginator(fileDescriptorName);
    }

    public static StateHolder.SuspectStateOriginator connectionFactory(String connectionFactoryName) {
        return new ConnectionFactorySuspectStateOriginator(connectionFactoryName);
    }

    public static FunctionSuspectStateOriginator function(NameManager.ObjectName name) {
        return new FunctionSuspectStateOriginator(name);
    }

    public static StateHolder.SuspectStateOriginator actor(NameManager.ObjectName name) {
        return new ActorSuspectStateOriginator(name);
    }

    public static StateHolder.SuspectStateOriginator index(NameManager.ObjectName name) {
        return new IndexSuspectStateOriginator(name);
    }

    public static StateHolder.SuspectStateOriginator trigger(NameManager.ObjectName name) {
        return new TriggerSuspectStateOriginator(name);
    }

    public static StateHolder.SuspectStateOriginator referenceLink(NameManager.ObjectName name) {
        return new ReferenceLinkSuspectStateOriginator(name);
    }

    public static StateHolder.SuspectStateOriginator sequence(NameManager.ObjectName name) {
        return new SequenceSuspectStateOriginator(name);
    }

    public static StateHolder.SuspectStateOriginator object(NameManager.ObjectName name) {
        return new ObjectSuspectStateOriginator(name);
    }

    public static TextIndexSuspectStateOriginator textIndex(NameManager.ObjectName name) {
        return new TextIndexSuspectStateOriginator(name);
    }

    public static void aggregateState(DataspaceStateHolder stateHolder, Set references, SchemaManager schemaManager) {
        if (references == null) {
            return;
        }
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            NameManager.ObjectName referenceName = (NameManager.ObjectName)iterator.next();
            if (referenceName == null) continue;
            try {
                if (referenceName.type == 10) {
                    DataspaceStateHolder.aggregateStateColumn(stateHolder, referenceName, schemaManager);
                    continue;
                }
                if (referenceName.type == 36) {
                    DataspaceStateHolder.validateEventPrototype(stateHolder, referenceName.name);
                    continue;
                }
                if (referenceName.type == 35) {
                    DataspaceStateHolder.validateSemanticType(stateHolder, referenceName.name);
                    continue;
                }
                if (referenceName.type == 39) {
                    DataspaceStateHolder.validateFileDescriptor(stateHolder, referenceName.name);
                    continue;
                }
                if (referenceName.type == 40) {
                    DataspaceStateHolder.validateConnectionFactory(stateHolder, referenceName.name);
                    continue;
                }
                if (referenceName.type == 14 || referenceName.type == 13) {
                    DataspaceStateHolder.aggregateStateDomainOrType(stateHolder, referenceName, (Type)schemaManager.findSchemaObject(referenceName));
                    continue;
                }
                if (referenceName.type == 4) {
                    DataspaceStateHolder.aggregateStateCollection(stateHolder, referenceName, (AbstractCollection)schemaManager.findSchemaObject(referenceName));
                    continue;
                }
                if (referenceName.type == 3 && referenceName.schema != SqlInvariants.MODULE_NAME) {
                    if (referenceName.schema != null && referenceName.schema.name.equalsIgnoreCase("SYS")) continue;
                    SchemaObject object = schemaManager.findSchemaObject(referenceName.name, referenceName.schema.name, 4);
                    if (object == null) {
                        object = schemaManager.findSchemaObject(referenceName.name, referenceName.schema.name, 3);
                    }
                    if (!(object instanceof AbstractCollection)) continue;
                    DataspaceStateHolder.aggregateStateCollection(stateHolder, referenceName, (AbstractCollection)object);
                    continue;
                }
                if (referenceName.type == 17 || referenceName.type == 18 || referenceName.type == 25) {
                    DataspaceStateHolder.aggregateStateFunctionOrProcedure(stateHolder, referenceName, schemaManager.findSchemaObject(referenceName));
                    continue;
                }
                if (referenceName.type == 32) {
                    DataspaceStateHolder.aggregateStateActor(stateHolder, referenceName, (Actor)schemaManager.findSchemaObject(referenceName));
                    continue;
                }
                if (referenceName.type == 9) {
                    DataspaceStateHolder.aggregateStateTrigger(stateHolder, referenceName, (TriggerDefSQL)schemaManager.findSchemaObject(referenceName));
                    continue;
                }
                if (referenceName.type == 8) {
                    DataspaceStateHolder.aggregateStateSequence(stateHolder, referenceName, schemaManager.findSchemaObject(referenceName));
                    continue;
                }
                if (referenceName.type != 37) continue;
                DataspaceStateHolder.aggregateStateReferenceLink(stateHolder, referenceName, (ReferenceLink)schemaManager.findSchemaObject(referenceName));
            }
            catch (Throwable exception) {
                stateHolder.setSuspectState(DataspaceStateHolder.object(referenceName), "Failed to get object state. Error: " + exception.getMessage());
            }
        }
    }

    public static void aggregateState(DataspaceStateHolder stateHolder, SchemaObject schemaObject, SchemaManager schemaManager) {
        if (schemaObject == null) {
            return;
        }
        try {
            if (schemaObject.getObjectType() == 10) {
                DataspaceStateHolder.aggregateStateColumn(stateHolder, schemaObject.getObjectName(), schemaManager);
            } else if (schemaObject.getObjectType() == 14 || schemaObject.getObjectType() == 13) {
                DataspaceStateHolder.aggregateStateDomainOrType(stateHolder, schemaObject.getObjectName(), (Type)schemaObject);
            } else if (schemaObject.getObjectType() == 4) {
                DataspaceStateHolder.aggregateStateCollection(stateHolder, schemaObject.getObjectName(), (AbstractCollection)schemaObject);
            } else if (schemaObject.getObjectType() == 3) {
                if (schemaObject.getObjectName().schema == null || !schemaObject.getObjectName().schema.name.equalsIgnoreCase("SYS")) {
                    SchemaObject object = schemaManager.findSchemaObject(schemaObject.getObjectName().name, schemaObject.getObjectName().schema.name, 4);
                    if (object == null) {
                        object = schemaManager.findSchemaObject(schemaObject.getObjectName().name, schemaObject.getObjectName().schema.name, 3);
                    }
                    if (object instanceof AbstractCollection) {
                        DataspaceStateHolder.aggregateStateCollection(stateHolder, schemaObject.getObjectName(), (AbstractCollection)object);
                    }
                }
            } else if (schemaObject.getObjectType() == 17 || schemaObject.getObjectType() == 18) {
                DataspaceStateHolder.aggregateStateFunctionOrProcedure(stateHolder, schemaObject.getObjectName(), schemaObject);
            } else if (schemaObject.getObjectType() == 32) {
                DataspaceStateHolder.aggregateStateActor(stateHolder, schemaObject.getObjectName(), (Actor)schemaObject);
            } else if (schemaObject.getObjectType() == 9) {
                DataspaceStateHolder.aggregateStateTrigger(stateHolder, schemaObject.getObjectName(), (TriggerDefSQL)schemaObject);
            } else if (schemaObject.getObjectType() == 8) {
                DataspaceStateHolder.aggregateStateSequence(stateHolder, schemaObject.getObjectName(), schemaObject);
            } else if (schemaObject.getObjectType() == 37) {
                DataspaceStateHolder.aggregateStateReferenceLink(stateHolder, schemaObject.getObjectName(), (ReferenceLink)schemaObject);
            }
        }
        catch (Throwable exception) {
            stateHolder.setSuspectState(DataspaceStateHolder.object(schemaObject.getObjectName()), "Failed to get object state. Error: " + exception.getMessage());
        }
    }

    public static void validateEventPrototype(DataspaceStateHolder stateHolder, String eventId) {
        if (!StringUtils.isEmpty(eventId)) {
            DatagramPrototypeCache cache = DataspaceStore.getContext().getDatagramPrototypeCache();
            try {
                CompositeFilter filter = new CompositeFilter(eventId);
                if (!filter.isSimple() || filter.hasMetacharacters()) {
                    if (!filter.isSimple() || filter.hasMetacharacters()) {
                        ArrayList eventIds = new ArrayList();
                        filter.getFilters().forEach(simpleFiler -> eventIds.addAll(cache.listEventIdsByFilter((Filter)simpleFiler)));
                        if (eventIds.isEmpty()) {
                            stateHolder.setSuspectState(DataspaceStateHolder.eventFilter(eventId), "has no suitable prototypes");
                        } else {
                            boolean valid = eventIds.stream().map(cache::lookupPrototype).anyMatch(Prototype::isValid);
                            if (!valid) {
                                stateHolder.setSuspectState(DataspaceStateHolder.eventFilter(eventId), "has no valid suitable prototypes");
                            }
                        }
                    }
                } else {
                    Prototype prototype = cache.lookupPrototype(eventId);
                    if (prototype == null) {
                        stateHolder.setSuspectState(DataspaceStateHolder.prototype(eventId), "does not exist");
                    } else if (!prototype.isValid()) {
                        stateHolder.setSuspectState(DataspaceStateHolder.prototype(eventId), "is invalid");
                    }
                }
            }
            catch (FilterFormatException exception) {
                stateHolder.setSuspectState(DataspaceStateHolder.eventFilter(eventId), "has invalid format");
            }
        }
    }

    public static void validateSemanticType(DataspaceStateHolder stateHolder, String semanticTypeName) {
        if (semanticTypeName != null && semanticTypeName.length() > 0) {
            SemanticType semanticType = TypeFactory.getContext().getSemanticTypeCache().lookupSemanticType(semanticTypeName);
            if (semanticType == null) {
                stateHolder.setSuspectState(DataspaceStateHolder.semanticType(semanticTypeName), "does not exist");
            } else if (!semanticType.isValid()) {
                stateHolder.setSuspectState(DataspaceStateHolder.semanticType(semanticTypeName), "is invalid");
            }
        }
    }

    public static void validateFileDescriptor(DataspaceStateHolder stateHolder, String fileDescriptorName) {
        if (fileDescriptorName != null && fileDescriptorName.length() > 0) {
            try {
                if (!FileDescriptorRepositoryUtils.existsFileDescriptor(fileDescriptorName)) {
                    stateHolder.setSuspectState(DataspaceStateHolder.fileDescriptor(fileDescriptorName), "does not exist");
                }
            }
            catch (ObjectConfigurationException objectConfigurationException) {
                // empty catch block
            }
        }
    }

    public static void validateConnectionFactory(DataspaceStateHolder stateHolder, String connectionFactoryName) {
        if (connectionFactoryName != null && connectionFactoryName.length() > 0 && !ConnectionFactoryRepositoryUtils.existsConnectionFactory(connectionFactoryName)) {
            stateHolder.setSuspectState(DataspaceStateHolder.connectionFactory(connectionFactoryName), "does not exist");
        }
    }

    private static void aggregateStateFunctionOrProcedure(DataspaceStateHolder stateHolder, NameManager.ObjectName objectName, SchemaObject procedure) {
        RplScript script = null;
        if (procedure instanceof RoutineSchema) {
            if (((RoutineSchema)procedure).routines.length == 1) {
                script = ((RoutineSchema)procedure).routines[0];
            } else {
                Trace.logError(DataspaceStateHolder.class, "WARNING: Procedure {} has more than one({}) rpl scripts.", procedure.getObjectName().name, ((RoutineSchema)procedure).routines.length);
            }
        } else if (procedure instanceof RplScript) {
            script = (RplScript)procedure;
        }
        if (script != null) {
            DataspaceStateHolder state = script.aggregateStateHolder();
            if (state.isSuspectState()) {
                stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.function(procedure.getObjectName()), "");
            }
        } else {
            stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.function(objectName), "does not exist");
        }
    }

    public static void aggregateStateColumn(DataspaceStateHolder stateHolder, NameManager.ObjectName columnName, SchemaManager schemaManager) {
        Table table = (Table)schemaManager.getSchemaObject(columnName.parent);
        if (table != null) {
            ColumnSchema column = table.getColumn(columnName.name);
            if (column != null) {
                Type columnType = column.getDataType();
                if (columnType instanceof OtherType && ((OtherType)columnType).userTypeModifier != null) {
                    OtherType otherColumnType = (OtherType)columnType;
                    if (schemaManager.getDomainOrDistinctType(otherColumnType.userTypeModifier.getName().name, otherColumnType.userTypeModifier.getName().schema.name, false) == null) {
                        if (otherColumnType.isDomainType()) {
                            stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.domain(columnType.getObjectName()), "does not exist.");
                        } else if (otherColumnType.isDistinctType()) {
                            stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.type(columnType.getObjectName()), "does not exist.");
                        }
                    } else {
                        DataspaceStateHolder.aggregateStateDomainOrType(stateHolder, otherColumnType.getObjectName(), otherColumnType);
                    }
                }
            } else if (!table.isView || !table.aggregateObjectStateHolder().isSuspectState()) {
                Trace.logError(DataspaceStateHolder.class, "WARNING: Column {} not found in table {}.", columnName.getSchemaQualifiedStatementName(), columnName.parent.getSchemaQualifiedStatementName());
            }
        } else if (columnName.parent.schema == null || !columnName.parent.schema.name.equalsIgnoreCase("SYS")) {
            Trace.logError(DataspaceStateHolder.class, "WARNING: Table for column {} not found.", columnName);
        }
    }

    public static void aggregateStateDomainOrType(DataspaceStateHolder stateHolder, NameManager.ObjectName objectName, Type domain) {
        if (domain != null && domain.userTypeModifier != null && domain.userTypeModifier.aggregateStateHolder().isSuspectState()) {
            if (domain.isDomainType()) {
                stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.domain(domain.getObjectName()), "");
            } else if (domain.isDistinctType()) {
                stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.type(domain.getObjectName()), "");
            }
        } else if (domain == null) {
            if (objectName.type == 14) {
                stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.domain(objectName), "does not exist");
            } else if (objectName.type == 13) {
                stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.type(objectName), "does not exist");
            }
        }
    }

    private static void aggregateStateCollection(DataspaceStateHolder stateHolder, NameManager.ObjectName objectName, AbstractCollection collection) {
        if (collection != null && collection.aggregateStateHolder().isSuspectState()) {
            stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.collection(collection.getObjectName()), "");
        } else if (collection == null && !objectName.name.equals("SYSTEM_SUBQUERY")) {
            stateHolder.setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.collection(objectName), "does not exist");
        }
    }

    private static void aggregateStateActor(DataspaceStateHolder stateHolder, NameManager.ObjectName objectName, Actor actor) {
        if (actor != null && actor.aggregateStateHolder().isSuspectState()) {
            stateHolder.setSuspectState(DataspaceStateHolder.actor(actor.getObjectName()), "");
        } else if (actor == null) {
            stateHolder.setSuspectState(DataspaceStateHolder.actor(objectName), "does not exist");
        }
    }

    private static void aggregateStateTrigger(DataspaceStateHolder stateHolder, NameManager.ObjectName objectName, TriggerDefSQL trigger) {
        if (trigger instanceof EventTriggerDefSQL && ((EventTriggerDefSQL)trigger).aggregateStateHolder().isSuspectState()) {
            stateHolder.setSuspectState(DataspaceStateHolder.trigger(trigger.getObjectName()), "");
        } else if (trigger == null) {
            stateHolder.setSuspectState(DataspaceStateHolder.trigger(objectName), "does not exist");
        }
    }

    private static void aggregateStateSequence(DataspaceStateHolder stateHolder, NameManager.ObjectName objectName, SchemaObject sequence) {
        if (sequence == null) {
            stateHolder.setSuspectState(DataspaceStateHolder.sequence(objectName), "does not exist");
        }
    }

    private static void aggregateStateReferenceLink(DataspaceStateHolder stateHolder, NameManager.ObjectName objectName, ReferenceLink referenceLink) {
        if (referenceLink == null) {
            stateHolder.setSuspectState(DataspaceStateHolder.referenceLink(objectName), "does not exist");
        } else if (referenceLink.aggregateStateHolder().isSuspectState()) {
            stateHolder.setSuspectState(DataspaceStateHolder.referenceLink(referenceLink.getObjectName()), "");
        }
    }

    public void exposeState(RowSetNavigatorClient navigator, boolean withValid, boolean withLastError, String stateName, Class<?> ... originatorClasses) {
        this.exposeState(navigator, withValid, withLastError, stateName, null, Arrays.asList(originatorClasses));
    }

    public void exposeState(RowSetNavigatorClient navigator, boolean withValid, boolean withLastError, String stateName, ComponentState componentState, Class<?> ... originatorClasses) {
        this.exposeState(navigator, withValid, withLastError, stateName, componentState, Arrays.asList(originatorClasses));
    }

    public void exposeState(RowSetNavigatorClient navigator, boolean withValid, boolean withLastError, String stateName, ComponentState componentState, List<Class<?>> originatorClassesList) {
        List invalidObjects;
        List invalidSequences;
        List invalidTriggers;
        List invalidIndexes;
        List invalidActors;
        List invalidFunctions;
        List invalidCollections;
        String error;
        List invalidConnectionFactories;
        List invalidPrototypes;
        List invalidFileDescriptors;
        List invalidTypes;
        List invalidDomains;
        List invalidDataspaces;
        String state = componentState != null ? ListDataspacesOperation.getDataspaceStateString(componentState, (DataspaceStoreState)((Object)this.getState())) : ((DataspaceStoreState)((Object)this.getState())).name();
        navigator.add(new Object[]{stateName, state});
        Map<StateHolder.SuspectStateOriginator, String> originators = this.getSuspectStateOriginators();
        originatorClassesList = new ArrayList(originatorClassesList);
        boolean allClasses = originatorClassesList.isEmpty();
        if ((allClasses || originatorClassesList.remove(DataspaceDataspaceSuspectStateOriginator.class)) && ((invalidDataspaces = StateHolder.excludeOriginators(originators, e -> e instanceof DataspaceDataspaceSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName()).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Suspect Dataspaces", invalidDataspaces.size() > 0 ? invalidDataspaces.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(DataspaceDataspaceSuspectRecoveryFailedStateOriginator.class)) && ((invalidDataspaces = StateHolder.excludeOriginators(originators, e -> e instanceof DataspaceDataspaceSuspectRecoveryFailedStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName()).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Recovery Failed Dataspaces", invalidDataspaces.size() > 0 ? invalidDataspaces.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(DomainSuspectStateOriginator.class)) && ((invalidDomains = StateHolder.excludeOriginators(originators, e -> e instanceof DomainSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName() + DataspaceStateHolder.getError((String)e.getValue())).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Suspect Domains", invalidDomains.size() > 0 ? invalidDomains.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(TypeSuspectStateOriginator.class)) && ((invalidTypes = StateHolder.excludeOriginators(originators, e -> e instanceof TypeSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName() + DataspaceStateHolder.getError((String)e.getValue())).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Suspect Types", invalidTypes.size() > 0 ? invalidTypes.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(SemanticTypeSuspectStateOriginator.class)) && ((invalidTypes = StateHolder.excludeOriginators(originators, e -> e instanceof SemanticTypeSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName() + DataspaceStateHolder.getError((String)e.getValue())).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Invalid Semantic Types", invalidTypes.size() > 0 ? invalidTypes.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(FileDescriptorSuspectStateOriginator.class)) && ((invalidFileDescriptors = StateHolder.excludeOriginators(originators, e -> e instanceof FileDescriptorSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName() + DataspaceStateHolder.getError((String)e.getValue())).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Invalid File Descriptors", invalidFileDescriptors.size() > 0 ? invalidFileDescriptors.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(PrototypeSuspectStateOriginator.class)) && ((invalidPrototypes = StateHolder.excludeOriginators(originators, e -> e instanceof PrototypeSuspectStateOriginator).stream().map(e -> StringUtils.wrapEventId(((StateHolder.SuspectStateOriginator)e.getKey()).getName()) + DataspaceStateHolder.getError((String)e.getValue())).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Invalid Prototypes", invalidPrototypes.size() > 0 ? invalidPrototypes.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(ConnectionFactorySuspectStateOriginator.class)) && ((invalidConnectionFactories = StateHolder.excludeOriginators(originators, e -> e instanceof ConnectionFactorySuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName() + DataspaceStateHolder.getError((String)e.getValue())).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Invalid Connection Factories", invalidConnectionFactories.size() > 0 ? invalidConnectionFactories.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(lob.getClass())) && ((error = originators.remove(lob)) != null || withValid)) {
            navigator.add(new Object[]{"Broken LOBs", error != null ? error : "none"});
        }
        if ((allClasses || originatorClassesList.remove(flob.getClass())) && ((error = originators.remove(flob)) != null || withValid)) {
            navigator.add(new Object[]{"Broken FLOBs", error != null ? error : "none"});
        }
        if ((allClasses || originatorClassesList.remove(CollectionDataspaceSuspectStateOriginator.class)) && ((invalidCollections = StateHolder.excludeOriginators(originators, e -> e instanceof CollectionDataspaceSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName()).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Suspect Collections", invalidCollections.size() > 0 ? invalidCollections.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(FunctionSuspectStateOriginator.class)) && ((invalidFunctions = StateHolder.excludeOriginators(originators, e -> e instanceof FunctionSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName()).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Suspect Functions", invalidFunctions.size() > 0 ? invalidFunctions.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(ActorSuspectStateOriginator.class)) && ((invalidActors = StateHolder.excludeOriginators(originators, e -> e instanceof ActorSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName()).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Suspect Actors", invalidActors.size() > 0 ? invalidActors.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(IndexSuspectStateOriginator.class)) && ((invalidIndexes = StateHolder.excludeOriginators(originators, e -> e instanceof IndexSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName() + "(" + (String)e.getValue() + ")").collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Suspect Indexes", invalidIndexes.size() > 0 ? invalidIndexes.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(TriggerSuspectStateOriginator.class)) && ((invalidTriggers = StateHolder.excludeOriginators(originators, e -> e instanceof TriggerSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName()).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Suspect Triggers", invalidTriggers.size() > 0 ? invalidTriggers.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(SequenceSuspectStateOriginator.class)) && ((invalidSequences = StateHolder.excludeOriginators(originators, e -> e instanceof SequenceSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName()).collect(Collectors.toList())).size() > 0 || withValid)) {
            navigator.add(new Object[]{"Suspect Sequences", invalidSequences.size() > 0 ? invalidSequences.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(SyntaxSuspectStateOriginator.class)) && ((error = originators.remove(syntax)) != null || withValid)) {
            navigator.add(new Object[]{"Syntax/Compilation Errors", error != null ? error : "none"});
        }
        if ((allClasses || originatorClassesList.remove(OutOfSyncSuspectStateOriginator.class)) && (error = originators.remove(outOfSync)) != null) {
            navigator.add(new Object[]{"Out of Sync", error});
        }
        if ((allClasses || originatorClassesList.remove(DataSourceDataspaceSuspectStateOriginator.class)) && (error = originators.remove(dataSource)) != null) {
            navigator.add(new Object[]{"Invalid Data Source", error});
        }
        if ((allClasses || originatorClassesList.remove(ServerConnectionDataspaceSuspectStateOriginator.class)) && (error = originators.remove(serverConnection)) != null) {
            navigator.add(new Object[]{"Invalid Server Connection", error});
        }
        if ((invalidObjects = StateHolder.excludeOriginators(originators, e -> e instanceof ObjectSuspectStateOriginator).stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getName()).collect(Collectors.toList())).size() > 0) {
            navigator.add(new Object[]{"Invalid Objects", invalidObjects.size() > 0 ? invalidObjects.toString() : "none"});
        }
        if ((allClasses || originatorClassesList.remove(InvalidSuspectStateOriginator.class)) && (error = originators.remove(invalid)) != null) {
            navigator.add(new Object[]{"Invalid State", error});
        }
        if (this.getLastError() != null && this.getLastError().length() > 0) {
            navigator.add(new Object[]{"Last Error", this.getLastError()});
        } else if (withLastError) {
            navigator.add(new Object[]{"Last Error", "---"});
        }
        if (originatorClassesList.size() > 0) {
            Trace.logError(this, "WARNING: Unknown originator classes: {}", originatorClassesList);
        }
        if (!originators.isEmpty()) {
            Trace.logError(this, "WARNING: Unknown originators: {}", originators);
            List invalidOthers = originators.entrySet().stream().map(e -> ((StateHolder.SuspectStateOriginator)e.getKey()).getFullName() + "(" + (String)e.getValue() + ")").collect(Collectors.toList());
            if (invalidOthers.size() > 0) {
                navigator.add(new Object[]{"Invalid Properties", invalidOthers.toString()});
            }
        }
    }

    private static String getError(String error) {
        return error != null && error.length() > 0 ? "(" + error + ")" : "";
    }

    public static class CollectionDataspaceSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private CollectionDataspaceSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Collection " + super.getFullName();
        }
    }

    public static class DataspaceDataspaceSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private DataspaceDataspaceSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Dataspace " + NameManager.quoteNameIfNeeded(super.getFullName());
        }
    }

    public static class DataspaceDataspaceSuspectRecoveryFailedStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private DataspaceDataspaceSuspectRecoveryFailedStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Dataspace " + NameManager.quoteNameIfNeeded(super.getFullName());
        }
    }

    public static class DomainSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private DomainSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Domain [" + super.getName() + "]";
        }
    }

    public static class TypeSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private TypeSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Type [" + super.getName() + "]";
        }
    }

    public static class PrototypeSuspectStateOriginator
    extends StateHolder.AbstractNamedSuspectStateOriginator {
        private PrototypeSuspectStateOriginator(String name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Prototype [" + this.getName() + "]";
        }
    }

    public static class EventFilterSuspectStateOriginator
    extends StateHolder.AbstractNamedSuspectStateOriginator {
        private EventFilterSuspectStateOriginator(String name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Event filter [" + this.getName() + "]";
        }
    }

    public static class SemanticTypeSuspectStateOriginator
    extends StateHolder.AbstractNamedSuspectStateOriginator {
        private SemanticTypeSuspectStateOriginator(String name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Semantic Type [" + super.getFullName() + "]";
        }
    }

    public static class FileDescriptorSuspectStateOriginator
    extends StateHolder.AbstractNamedSuspectStateOriginator {
        private FileDescriptorSuspectStateOriginator(String name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "File Descriptor [" + super.getFullName() + "]";
        }
    }

    public static class ConnectionFactorySuspectStateOriginator
    extends StateHolder.AbstractNamedSuspectStateOriginator {
        private ConnectionFactorySuspectStateOriginator(String name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Connection Factory [" + super.getFullName() + "]";
        }
    }

    public static class FunctionSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private FunctionSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Function " + super.getFullName();
        }
    }

    public static class ActorSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private ActorSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Actor " + super.getFullName();
        }
    }

    public static class IndexSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private IndexSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Index " + super.getFullName();
        }
    }

    public static class TriggerSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private TriggerSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Trigger " + super.getFullName();
        }
    }

    public static class ReferenceLinkSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private ReferenceLinkSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Reference Link " + super.getFullName();
        }
    }

    public static class SequenceSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private SequenceSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Sequence " + super.getFullName();
        }
    }

    public static class ObjectSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private ObjectSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Schema Object " + super.getFullName();
        }
    }

    public static class TextIndexSuspectStateOriginator
    extends StateHolder.AbstractObjectNamedSuspectStateOriginator {
        private TextIndexSuspectStateOriginator(NameManager.ObjectName name) {
            super(name);
        }

        @Override
        public String getFullName() {
            return "Text Index " + super.getFullName();
        }
    }

    public static class SyntaxSuspectStateOriginator
    extends StateHolder.SuspectStateOriginator {
        private SyntaxSuspectStateOriginator() {
        }

        @Override
        public String getName() {
            return "Syntax";
        }

        @Override
        public String getFullName() {
            return this.getName();
        }
    }

    public static class OutOfSyncSuspectStateOriginator
    extends StateHolder.SuspectStateOriginator {
        private OutOfSyncSuspectStateOriginator() {
        }

        @Override
        public String getName() {
            return "Out of Sync";
        }

        @Override
        public String getFullName() {
            return this.getName();
        }
    }

    public static class DataSourceDataspaceSuspectStateOriginator
    extends StateHolder.SuspectStateOriginator {
        private DataSourceDataspaceSuspectStateOriginator() {
        }

        @Override
        public String getName() {
            return "Data Source";
        }

        @Override
        public String getFullName() {
            return this.getName();
        }
    }

    public static class ServerConnectionDataspaceSuspectStateOriginator
    extends StateHolder.SuspectStateOriginator {
        private ServerConnectionDataspaceSuspectStateOriginator() {
        }

        @Override
        public String getName() {
            return "Server Connection";
        }

        @Override
        public String getFullName() {
            return this.getName();
        }
    }

    public static class InvalidSuspectStateOriginator
    extends StateHolder.SuspectStateOriginator {
        private InvalidSuspectStateOriginator() {
        }

        @Override
        public String getName() {
            return "Invalid";
        }

        @Override
        public String getFullName() {
            return this.getName();
        }
    }

    public static class LobDataspaceSuspectStateOriginator
    extends StateHolder.SuspectStateOriginator {
        private LobDataspaceSuspectStateOriginator() {
        }

        @Override
        public String getName() {
            return "LOB";
        }

        @Override
        public String getFullName() {
            return this.getName();
        }
    }

    public static class FlobDataspaceSuspectStateOriginator
    extends StateHolder.SuspectStateOriginator {
        private FlobDataspaceSuspectStateOriginator() {
        }

        @Override
        public String getName() {
            return "FLOB";
        }

        @Override
        public String getFullName() {
            return this.getName();
        }
    }
}

