/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;

public class TypeUtils {
    public static final List<String> TRUE_STRINGS = Arrays.asList("T", "t", "Y", "y", "TRUE", "true", "True", "1");
    public static final List<String> TRUE_STRINGS_FOR_DETECTION = Arrays.asList("T", "t", "Y", "y", "TRUE", "true", "True");
    public static final List<String> FALSE_STRINGS = Arrays.asList("F", "f", "N", "n", "FALSE", "false", "False", "0");
    public static final List<String> FALSE_STRINGS_FOR_DETECTION = Arrays.asList("F", "f", "N", "n", "FALSE", "false", "False");
    private static final String missingInd1 = "NaN";
    private static final String missingInd2 = "*";
    private static final String missingInd3 = "NA";
    private static final String missingInd4 = "null";
    public static final List<String> MISSING_INDICATORS = Arrays.asList("NaN", "*", "NA", "null");
    private static final DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final DateTimeFormatter dtf3 = DateTimeFormatter.ofPattern("MM-dd-yyyy");
    private static final DateTimeFormatter dtf4 = DateTimeFormatter.ofPattern("MM.dd.yyyy");
    private static final DateTimeFormatter dtf5 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter dtf6 = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter dtf7 = DateTimeFormatter.ofPattern("dd/MMM/yyyy");
    private static final DateTimeFormatter dtf8 = DateTimeFormatter.ofPattern("dd-MMM-yyyy");
    private static final DateTimeFormatter dtf9 = DateTimeFormatter.ofPattern("M/d/yyyy");
    private static final DateTimeFormatter dtf10 = DateTimeFormatter.ofPattern("M/d/yy");
    private static final DateTimeFormatter dtf11 = DateTimeFormatter.ofPattern("MMM/dd/yyyy");
    private static final DateTimeFormatter dtf12 = DateTimeFormatter.ofPattern("MMM-dd-yyyy");
    private static final DateTimeFormatter dtf13 = DateTimeFormatter.ofPattern("MMM/dd/yy");
    private static final DateTimeFormatter dtf14 = DateTimeFormatter.ofPattern("MMM-dd-yy");
    private static final DateTimeFormatter dtf15 = DateTimeFormatter.ofPattern("MMM/dd/yyyy");
    private static final DateTimeFormatter dtf16 = DateTimeFormatter.ofPattern("MMM/d/yyyy");
    private static final DateTimeFormatter dtf17 = DateTimeFormatter.ofPattern("MMM-dd-yy");
    private static final DateTimeFormatter dtf18 = DateTimeFormatter.ofPattern("MMM dd, yyyy");
    private static final DateTimeFormatter dtf19 = DateTimeFormatter.ofPattern("MMM d, yyyy");
    public static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendOptional(dtf1).appendOptional(dtf2).appendOptional(dtf3).appendOptional(dtf4).appendOptional(dtf5).appendOptional(dtf6).appendOptional(dtf7).appendOptional(dtf8).appendOptional(dtf9).appendOptional(dtf10).appendOptional(dtf11).appendOptional(dtf12).appendOptional(dtf13).appendOptional(dtf14).appendOptional(dtf15).appendOptional(dtf16).appendOptional(dtf17).appendOptional(dtf18).appendOptional(dtf19).toFormatter();
    private static final DateTimeFormatter dtTimef0 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter dtTimef1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter dtTimef2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S");
    private static final DateTimeFormatter dtTimef3 = DateTimeFormatter.ofPattern("MM/dd/yyyy hh:mm:ss a");
    private static final DateTimeFormatter dtTimef4 = DateTimeFormatter.ofPattern("dd-MMM-yyyy HH:mm");
    private static final DateTimeFormatter dtTimef5 = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private static final DateTimeFormatter dtTimef6 = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendLiteral('.').appendPattern("SSS").toFormatter();
    private static final DateTimeFormatter dtTimef7 = DateTimeFormatter.ofPattern("M/d/yy H:mm");
    private static final DateTimeFormatter dtTimef8 = DateTimeFormatter.ofPattern("M/d/yyyy h:mm:ss a");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendOptional(dtTimef2).appendOptional(dtTimef3).appendOptional(dtTimef4).appendOptional(dtTimef1).appendOptional(dtTimef0).appendOptional(dtTimef5).appendOptional(dtTimef6).appendOptional(dtTimef7).appendOptional(dtTimef8).toFormatter();
    private static final DateTimeFormatter timef1 = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final DateTimeFormatter timef2 = DateTimeFormatter.ofPattern("hh:mm:ss a");
    private static final DateTimeFormatter timef3 = DateTimeFormatter.ofPattern("h:mm:ss a");
    private static final DateTimeFormatter timef4 = DateTimeFormatter.ISO_LOCAL_TIME;
    private static final DateTimeFormatter timef5 = DateTimeFormatter.ofPattern("hh:mm a");
    private static final DateTimeFormatter timef6 = DateTimeFormatter.ofPattern("h:mm a");
    public static final DateTimeFormatter TIME_DETECTION_FORMATTER = new DateTimeFormatterBuilder().appendOptional(timef5).appendOptional(timef2).appendOptional(timef3).appendOptional(timef1).appendOptional(timef4).appendOptional(timef6).toFormatter();
    private static final DateTimeFormatter timef7 = DateTimeFormatter.ofPattern("HHmm");
    public static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendOptional(timef5).appendOptional(timef2).appendOptional(timef3).appendOptional(timef1).appendOptional(timef4).appendOptional(timef6).appendOptional(timef7).toFormatter();
    private static List<DateTimeFormatter> dateFormatters = Arrays.asList(dtf1, dtf2, dtf3, dtf4, dtf5, dtf6, dtf7, dtf8, dtf9, dtf10, dtf11, dtf12, dtf13, dtf14, dtf15, dtf16, dtf17, dtf18, dtf19);
    private static List<DateTimeFormatter> dateTimeFormatters = Arrays.asList(dtTimef0, dtTimef1, dtTimef2, dtTimef3, dtTimef4, dtTimef5, dtTimef6);
    private static List<DateTimeFormatter> timeFormatters = Arrays.asList(timef1, timef2, timef3, timef4, timef5, timef6);
    public static final long pointerSize = 8L;
    public static final long integerSize = 16L;

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private TypeUtils() {
    }

    public static DateTimeFormatter getDateFormatter(String dateValue) {
        for (DateTimeFormatter formatter : dateFormatters) {
            try {
                formatter.parse(dateValue);
                return formatter;
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return DATE_FORMATTER;
    }

    public static DateTimeConverter getDateTimeFormatter(String dateTimeValue) {
        for (DateTimeFormatter formatter : dateTimeFormatters) {
            if (!TypeUtils.canParse(formatter, dateTimeValue)) continue;
            return new DateTimeConverter(formatter);
        }
        if (TypeUtils.canParse(DATE_FORMATTER, dateTimeValue)) {
            return new DateTimeConverter(DATE_FORMATTER);
        }
        if (TypeUtils.canParse(DATE_TIME_FORMATTER, dateTimeValue)) {
            return new DateTimeConverter(DATE_TIME_FORMATTER);
        }
        try {
            Long.parseLong(dateTimeValue);
            return new DateTimeConverter();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Could not find datetime parser for " + dateTimeValue);
        }
    }

    private static boolean canParse(DateTimeFormatter formatter, String dateTimeValue) {
        try {
            formatter.parse(dateTimeValue);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    public static DateTimeFormatter getTimeFormatter(String timeValue) {
        for (DateTimeFormatter formatter : timeFormatters) {
            try {
                formatter.parse(timeValue);
                return formatter;
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return DATE_FORMATTER;
    }

    public static final long stringSize(String s) {
        return s != null ? 8L * (long)Math.ceil((double)(32 + s.length() * 2) / 8.0) : 0L;
    }

    public static class DateTimeConverter {
        private final boolean isTimestamp;
        private final DateTimeFormatter dtFormatter;

        public DateTimeConverter() {
            this.dtFormatter = null;
            this.isTimestamp = true;
        }

        public DateTimeConverter(DateTimeFormatter dtFormatter) {
            this.dtFormatter = dtFormatter;
            this.isTimestamp = false;
        }

        public LocalDateTime convert(String dateTime) {
            return this.isTimestamp ? Instant.ofEpochMilli(Long.parseLong(dateTime)).atZone(ZoneOffset.UTC).toLocalDateTime() : LocalDateTime.parse(dateTime, this.dtFormatter);
        }
    }
}

