/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.utils;

import com.streamscape.ds.stable.utils.TypeUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DictionaryMap {
    private final Map<Integer, String> keyToValue = new HashMap<Integer, String>();
    private final Map<String, Integer> valueToKey = new HashMap<String, Integer>();
    private final Map<Integer, Integer> keyUsages = new HashMap<Integer, Integer>();

    public DictionaryMap() {
    }

    public DictionaryMap(DictionaryMap original) {
        for (Map.Entry<Integer, String> entry : original.keyToValue.entrySet()) {
            this.keyToValue.put(entry.getKey(), entry.getValue());
            this.valueToKey.put(entry.getValue(), entry.getKey());
        }
    }

    public void put(int key, String value) {
        this.keyToValue.put(key, value);
        this.valueToKey.put(value, key);
        this.keyUsages.put(key, 1);
    }

    public String get(int key) {
        return this.keyToValue.get(key);
    }

    public int get(String value) {
        Integer result = this.valueToKey.get(value);
        if (result == null) {
            result = -1;
        }
        return result;
    }

    public void remove(int key) {
        String value = this.keyToValue.remove(key);
        this.valueToKey.remove(value);
        this.keyUsages.remove(key);
    }

    public void remove(String value) {
        Integer key = this.valueToKey.remove(value);
        if (key != null) {
            this.keyToValue.remove(key);
            this.keyUsages.remove(key);
        }
    }

    public void clear() {
        this.keyToValue.clear();
        this.valueToKey.clear();
        this.keyUsages.clear();
    }

    public boolean contains(String stringValue) {
        return this.valueToKey.containsKey(stringValue);
    }

    public int size() {
        return this.categories().size();
    }

    public Set<String> categories() {
        return this.valueToKey.keySet();
    }

    public String[] categoryArray() {
        return this.keyToValue.values().toArray(new String[this.size()]);
    }

    public Collection<Integer> values() {
        return this.valueToKey.values();
    }

    public Map<Integer, String> keyToValueMap() {
        return this.keyToValue;
    }

    public Map<String, Integer> valueToKeyMap() {
        return this.valueToKey;
    }

    public int sizeInMemoryData() {
        int result = 0;
        result = (int)((long)result + (long)this.keyToValue.size() * 24L);
        for (Map.Entry<Integer, String> entry : this.keyToValue.entrySet()) {
            result = (int)((long)result + TypeUtils.stringSize(entry.getValue()));
        }
        result = (int)((long)result + (long)this.valueToKey.size() * 24L);
        for (Map.Entry<Object, Object> entry : this.valueToKey.entrySet()) {
            result = (int)((long)result + TypeUtils.stringSize((String)entry.getKey()));
        }
        result = (int)((long)result + (long)this.keyUsages.size() * 24L * 2L);
        return result;
    }

    public int sizeInMemoryFull() {
        int result = 0;
        result = (int)((long)result + (long)this.keyToValue.size() * 24L);
        for (Map.Entry<Integer, String> entry : this.keyToValue.entrySet()) {
            result = (int)((long)result + TypeUtils.stringSize(entry.getValue()));
        }
        result = (int)((long)result + (long)this.valueToKey.size() * 24L);
        for (Map.Entry<Object, Object> entry : this.valueToKey.entrySet()) {
            result = (int)((long)result + TypeUtils.stringSize((String)entry.getKey()));
        }
        result = (int)((long)result + (long)this.keyUsages.size() * 24L * 2L);
        return result;
    }

    public void trimToSize() {
    }

    public void incrementUsages(int key) {
        Integer usagesCount;
        Integer n = usagesCount = this.keyUsages.getOrDefault(key, 0);
        usagesCount = usagesCount + 1;
        this.keyUsages.put(key, usagesCount);
    }

    public void decrementUsages(int key) {
        Integer usagesCount;
        Integer n = usagesCount = this.keyUsages.getOrDefault(key, 0);
        usagesCount = usagesCount - 1;
        if (usagesCount > 0) {
            this.keyUsages.put(key, usagesCount);
        }
        if (usagesCount <= 0) {
            this.remove(key);
        }
    }

    public int getUsagesCount(int key) {
        return this.keyUsages.getOrDefault(key, 0);
    }

    public void setUsagesCount(int key, int count) {
        this.keyUsages.put(key, count);
    }
}

