/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.utils;

import com.streamscape.ds.stable.lists.IntArrayList;
import com.streamscape.ds.stable.utils.Selection;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.RoaringBitmap;

public class BitmapBackedSelection
implements Selection {
    private final RoaringBitmap bitmap = new RoaringBitmap();
    private Boolean empty = true;
    private int size = -1;

    @Override
    public void add(int i) {
        this.bitmap.add(i);
        this.empty = false;
        this.size = -1;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = this.bitmap.getCardinality();
        }
        return this.size;
    }

    @Override
    public int[] toArray() {
        return this.bitmap.toArray();
    }

    @Override
    public RoaringBitmap toBitmap() {
        return this.bitmap;
    }

    @Override
    public IntArrayList toIntArrayList() {
        return new IntArrayList(this.bitmap.toArray());
    }

    @Override
    public Selection and(Selection otherSelection) {
        this.bitmap.and(otherSelection.toBitmap());
        this.empty = null;
        this.size = -1;
        return this;
    }

    @Override
    public Selection or(Selection otherSelection) {
        this.bitmap.or(otherSelection.toBitmap());
        this.empty = null;
        this.size = -1;
        return this;
    }

    @Override
    public Selection andNot(Selection otherSelection) {
        this.bitmap.andNot(otherSelection.toBitmap());
        this.empty = null;
        this.size = -1;
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (this.empty == null) {
            this.empty = this.size() == 0;
        }
        return this.empty;
    }

    @Override
    public void clear() {
        this.bitmap.clear();
        this.empty = true;
        this.size = 0;
    }

    @Override
    public boolean contains(int i) {
        return this.bitmap.contains(i);
    }

    @Override
    public void addRange(int start, int end) {
        this.bitmap.add(start, end);
        this.empty = false;
        this.size = -1;
    }

    @Override
    public int get(int i) {
        return this.bitmap.select(i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmapBackedSelection integers = (BitmapBackedSelection)o;
        return this.bitmap.equals((Object)integers.bitmap);
    }

    public int hashCode() {
        return this.bitmap.hashCode();
    }

    @Override
    public com.streamscape.ds.stable.lists.IntIterator iterator() {
        return new com.streamscape.ds.stable.lists.IntIterator(){
            private final IntIterator iterator;
            {
                this.iterator = BitmapBackedSelection.this.bitmap.getIntIterator();
            }

            @Override
            public int nextInt() {
                return this.iterator.next();
            }

            @Override
            public int skip(int k) {
                throw new UnsupportedOperationException("Selections do not support skipping in the iterator");
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Integer next() {
                return this.iterator.next();
            }
        };
    }

    @Override
    public com.streamscape.ds.stable.lists.IntIterator reverseIterator() {
        return new com.streamscape.ds.stable.lists.IntIterator(){
            private final IntIterator iterator;
            {
                this.iterator = BitmapBackedSelection.this.bitmap.getReverseIntIterator();
            }

            @Override
            public int nextInt() {
                return this.iterator.next();
            }

            @Override
            public int skip(int k) {
                throw new UnsupportedOperationException("Selections do not support skipping in the iterator");
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Integer next() {
                return this.iterator.next();
            }
        };
    }
}

