/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.utils;

import com.streamscape.ds.stable.lists.IntComparator;

public class ArraySort {
    private static final int QUICKSORT_NO_REC = 16;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;
    private static final int MERGESORT_NO_REC = 16;

    public static void quickSort(int[] x, IntComparator comp) {
        ArraySort.quickSort(x, 0, x.length, comp);
    }

    public static void quickSort(int[] x, int from, int to, IntComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            ArraySort.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ArraySort.med3(x, l, l + s, l + 2 * s, comp);
            m = ArraySort.med3(x, m - s, m, m + s, comp);
            n = ArraySort.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = ArraySort.med3(x, l, m, n, comp);
        int v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ArraySort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ArraySort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ArraySort.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        ArraySort.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        ArraySort.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            ArraySort.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            ArraySort.quickSort(x, to - s, to, comp);
        }
    }

    public static void swap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ArraySort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void swap(int[] x, int[] y, int a, int b) {
        int t = x[a];
        int u = y[a];
        x[a] = x[b];
        y[a] = y[b];
        x[b] = t;
        y[b] = u;
    }

    public static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void selectionSort(int[] a, int from, int to, IntComparator comp) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            int u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }
}

