/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SIndexMetadata;
import com.streamscape.ds.stable.table.SnapshotTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TableMetadata {
    private String name;
    private final int rowCount;
    private final int deletedCount;
    private final List<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();
    private final List<SIndexMetadata> sIndexMetadataList = new ArrayList<SIndexMetadata>();

    public TableMetadata(SnapshotTable table) {
        this.name = table.name();
        this.rowCount = table.rowCountWithDeleted();
        this.deletedCount = table.getDeletedRows().count();
        for (Column column : table.columns()) {
            this.columnMetadataList.add(new ColumnMetadata(column));
        }
        for (SIndex sIndex : table.listSIndexes()) {
            if (!sIndex.isValid()) continue;
            this.sIndexMetadataList.add(new SIndexMetadata(sIndex));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableMetadata that = (TableMetadata)o;
        return this.rowCount == that.rowCount && Objects.equals(this.name, that.name) && Objects.equals(this.columnMetadataList, that.columnMetadataList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rowCount, this.columnMetadataList);
    }

    public String getName() {
        return this.name;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getDeletedCount() {
        return this.deletedCount;
    }

    public List<ColumnMetadata> getColumnMetadataList() {
        return this.columnMetadataList;
    }

    public List<SIndexMetadata> getSIndexMetadataList() {
        return this.sIndexMetadataList;
    }

    public void setName(String name) {
        this.name = name;
    }
}

