/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.CategoryColumnImpl;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.DateColumn;
import com.streamscape.ds.stable.columns.DateTimeColumn;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.FloatColumn;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.ShortColumn;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.columns.TimeColumn;
import com.streamscape.ds.stable.index.AbstractSIndex;
import com.streamscape.ds.stable.index.SAVLIndex;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SIndexMetadata;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.stable.index.SReadOnlyIndex;
import com.streamscape.ds.stable.lists.DoubleIterator;
import com.streamscape.ds.stable.lists.FloatIterator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.lists.LongIterator;
import com.streamscape.ds.stable.lists.ShortIterator;
import com.streamscape.ds.stable.table.DeletedRowsSelection;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.table.TableMetadata;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.iq80.snappy.SnappyFramedInputStream;
import org.iq80.snappy.SnappyFramedOutputStream;

public class StorageManager {
    private static final int FLUSH_AFTER_ITERATIONS = 10000;
    private static final String FILE_EXTENSION = "snap";
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(FileSystems.getDefault().getSeparator()));
    private static final String DELETE_MAP_FILENAME = "delete_map";
    private static final int READER_POOL_SIZE = 4;

    public static void writeTableMetadata(FileSystem fileSystem, String directoryPath, Snapshot table) throws IOException {
        StorageManager.writeTableMetadata(fileSystem, directoryPath, new TableMetadata((SnapshotTable)table));
    }

    public static void writeTableMetadata(FileSystem fileSystem, String directoryPath, TableMetadata tableMetadata) throws IOException {
        String metadataFilePath = StorageManager.getMetadataFilePath(fileSystem, directoryPath);
        if (fileSystem.exists(metadataFilePath)) {
            fileSystem.delete(metadataFilePath, false);
        }
        fileSystem.createNewFile(metadataFilePath);
        try (OutputStream fOut = fileSystem.openForWrite(metadataFilePath);
             OutputStreamWriter myOutWriter = new OutputStreamWriter(fOut);){
            try {
                HTTPUtils.getJsonSerializerForRestNoRoot().withPrettyPrint(true).serialize((Object)tableMetadata, myOutWriter);
            }
            catch (SerializerException exception) {
                Trace.logException(StorageManager.class, exception, true);
                throw new IOException("Serialization failed. Cause: " + exception.toString());
            }
        }
    }

    public static TableMetadata readTableMetadata(FileSystem fileSystem, String directoryPath) throws IOException {
        byte[] encoded;
        String metadataFilePath = StorageManager.getMetadataFilePath(fileSystem, directoryPath);
        try (InputStream input = fileSystem.open(metadataFilePath);){
            encoded = FileIOUtils.getStreamContent(input, -1L);
        }
        catch (UtilitiesException e) {
            throw new IOException(Utils.formatExceptionWithUnrepeatedCauses(e));
        }
        try {
            return HTTPUtils.getJsonSerializerForRestNoRoot().deserialize(TableMetadata.class, new String(encoded, StandardCharsets.UTF_8));
        }
        catch (SerializerException exception) {
            Trace.logException(StorageManager.class, exception, true);
            throw new IOException("Deserialization failed. Cause: " + exception.toString());
        }
    }

    public static String getMetadataFilePath(FileSystem fileSystem, String directoryPath) throws IOException {
        return directoryPath + fileSystem.separator() + "metadata.json";
    }

    public static String buildDirectoryName(String tableName) {
        tableName = WHITE_SPACE_PATTERN.matcher(tableName).replaceAll("");
        tableName = SEPARATOR_PATTERN.matcher(tableName).replaceAll("_");
        return tableName + ".snap";
    }

    public static String buildFilepath(FileSystem fileSystem, String path, String filename) throws IOException {
        return path + fileSystem.separator() + filename + ".snap";
    }

    public static String buildDirectoryPath(FileSystem fileSystem, String path, String tableName) throws IOException {
        return path + fileSystem.separator() + tableName;
    }

    public static SnapshotTable readTable(FileSystem fileSystem, String path) throws IOException {
        return StorageManager.readTable(fileSystem, path, null, false);
    }

    /*
     * WARNING - void declaration
     */
    public static SnapshotTable readTable(FileSystem fileSystem, String path, SnapshotTable tableSchema, boolean force) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        ExecutorCompletionService<Void> readerCompletionService = new ExecutorCompletionService<Void>(executorService);
        TableMetadata tableMetadata = StorageManager.readTableMetadata(fileSystem, path);
        TableMetadata schemaMetadata = tableSchema != null ? new TableMetadata(tableSchema) : null;
        StorageManager.checkTableSchema(tableMetadata, schemaMetadata, force);
        SnapshotTable table = SnapshotTable.create(tableMetadata);
        ConcurrentLinkedQueue columnList = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue<SReadOnlyIndex> indexesList = new ConcurrentLinkedQueue<SReadOnlyIndex>();
        try {
            int futuresCount = 0;
            ArrayList failedToLoadColumns = new ArrayList();
            ArrayList failedToLoadIndexes = new ArrayList();
            AtomicBoolean failedToLoadDeletedMap = new AtomicBoolean(false);
            for (ColumnMetadata columnMetadata : tableMetadata.getColumnMetadataList()) {
                readerCompletionService.submit(() -> {
                    try {
                        columnList.add(StorageManager.readColumn(fileSystem, StorageManager.buildFilepath(fileSystem, path, column.getId()), column));
                    }
                    catch (Exception exception) {
                        Trace.logError(StorageManager.class, "Failed to read column " + column.getName() + " for table " + tableMetadata.getName() + ". " + exception.toString());
                        failedToLoadColumns.add(column);
                        columnList.add(column.createColumn());
                    }
                    return null;
                });
                ++futuresCount;
            }
            for (SIndexMetadata sIndexMetadata : tableMetadata.getSIndexMetadataList()) {
                Object var17_35 = null;
                if (schemaMetadata != null) {
                    void var17_38;
                    SIndexMetadata sIndexMetadata2;
                    SIndexMetadata sIndexMetadata3 = schemaMetadata.getSIndexMetadataList().stream().filter(i -> i.getName().equals(sIndexMetadata.getName())).findAny().orElse(null);
                    if (sIndexMetadata3 == null && sIndexMetadata.isPrimaryKey() && (sIndexMetadata2 = (SIndexMetadata)schemaMetadata.getSIndexMetadataList().stream().filter(i -> i.isPrimaryKey()).findAny().orElse(null)) != null) {
                        Trace.logInfo(StorageManager.class, "Snapshot table {} primary key name: {}, old name: {}.", tableSchema.name(), sIndexMetadata2.getName(), sIndexMetadata.getName());
                    }
                    if (var17_38 == null) {
                        Trace.logInfo(StorageManager.class, "Warning: Index '" + sIndexMetadata.getName() + "' for table '" + tableSchema.name() + "': doesn't exist in table schema. Skip it.");
                        continue;
                    }
                    if (var17_38.getColumns().size() != sIndexMetadata.getColumns().size()) {
                        Trace.logInfo(StorageManager.class, "Warning: Index '" + sIndexMetadata.getName() + "' for table '" + tableSchema.name() + "': columns mismatch. Skip it.");
                        continue;
                    }
                    boolean mismatch = false;
                    for (int i2 = 0; i2 < var17_38.getColumns().size(); ++i2) {
                        if (var17_38.getColumns().get(i2).equals(sIndexMetadata.getColumns().get(i2))) continue;
                        Trace.logInfo(StorageManager.class, "Warning: Index '" + sIndexMetadata.getName() + "' for table '" + tableSchema.name() + "': columns mismatch. Skip it.");
                        mismatch = true;
                        break;
                    }
                    if (mismatch) continue;
                }
                if (sIndexMetadata.isBuilt()) {
                    void var17_34;
                    String sIndexMetadataSchemaIndexName = var17_34 != null ? var17_34.getName() : null;
                    readerCompletionService.submit(() -> {
                        try {
                            SIndex sIndex = StorageManager.readSIndex(fileSystem, path, sIndexMetadata.getId(), sIndexMetadata, table);
                            if (sIndexMetadataSchemaIndexName != null) {
                                sIndex.rename(sIndexMetadataSchemaIndexName);
                            }
                            indexesList.add((SReadOnlyIndex)sIndex);
                        }
                        catch (Exception exception) {
                            Trace.logError(StorageManager.class, "Failed to read SIndex " + sIndexMetadata.getName() + " for table " + tableMetadata.getName() + ". " + exception.toString());
                            failedToLoadIndexes.add(sIndexMetadata);
                            indexesList.add((SReadOnlyIndex)(sIndexMetadata.getType() == SIndexType.READ_ONLY ? new SReadOnlyIndex(sIndexMetadata) : new SAVLIndex(sIndexMetadata)));
                        }
                        return null;
                    });
                    ++futuresCount;
                    continue;
                }
                indexesList.add((SReadOnlyIndex)(sIndexMetadata.getType() == SIndexType.READ_ONLY ? new SReadOnlyIndex(sIndexMetadata) : new SAVLIndex(sIndexMetadata)));
            }
            readerCompletionService.submit(() -> {
                try {
                    StorageManager.readDeletedRowsMap(fileSystem, StorageManager.buildFilepath(fileSystem, path, DELETE_MAP_FILENAME), table);
                }
                catch (Exception exception) {
                    Trace.logError(StorageManager.class, "Failed to deleted map for table " + tableMetadata.getName() + ". " + exception.toString());
                    failedToLoadDeletedMap.set(true);
                }
                return null;
            });
            ++futuresCount;
            for (int i3 = 0; i3 < futuresCount; ++i3) {
                Future future = readerCompletionService.take();
                future.get();
            }
            if (failedToLoadColumns.size() > 0 || failedToLoadIndexes.size() > 0 || failedToLoadDeletedMap.get()) {
                if (failedToLoadColumns.size() > 0) {
                    Trace.logError(StorageManager.class, "WARNING: The following columns were failed to read for Snapshot table " + tableMetadata.getName() + ": " + failedToLoadColumns.stream().map(c -> c.getName()).collect(Collectors.joining(",")) + ". Don't load the table.");
                }
                if (failedToLoadIndexes.size() > 0) {
                    Trace.logError(StorageManager.class, "WARNING: The following indexes were failed to laod for Snapshot table " + tableMetadata.getName() + ": " + failedToLoadIndexes.stream().map(c -> c.getName()).collect(Collectors.joining(",")) + ". Don't load the table.");
                }
                if (failedToLoadDeletedMap.get()) {
                    Trace.logError(StorageManager.class, "WARNING: Deleted map was failed to load for Snapshot tbale " + tableMetadata.getName() + ". Don't load the table.");
                }
                for (Column column : columnList) {
                    column.clear();
                }
                for (SIndex sIndex : indexesList) {
                    sIndex.invalidate();
                }
            }
            HashMap<String, Column> columns = new HashMap<String, Column>();
            for (Column column : columnList) {
                columns.put(column.id(), column);
            }
            for (ColumnMetadata columnMetadata : tableMetadata.getColumnMetadataList()) {
                String id = columnMetadata.getId();
                table.addColumn((Column)columns.get(id));
            }
            HashMap<String, SIndex> sIndexes = new HashMap<String, SIndex>();
            for (SIndex sIndex : indexesList) {
                sIndexes.put(sIndex.getName(), sIndex);
            }
            for (SIndexMetadata sIndexMetadata : schemaMetadata != null ? schemaMetadata.getSIndexMetadataList() : tableMetadata.getSIndexMetadataList()) {
                String name = sIndexMetadata.getName();
                SIndex sIndex = (SIndex)sIndexes.get(name);
                if (sIndex == null) continue;
                sIndex.buildColumnsMetadata(table);
                table.addSIndex(sIndex);
            }
            if (schemaMetadata != null) {
                for (SIndexMetadata sIndexMetadata : schemaMetadata.getSIndexMetadataList()) {
                    if (sIndexes.get(sIndexMetadata.getName()) != null) continue;
                    AbstractSIndex sIndex = sIndexMetadata.getType() == SIndexType.READ_ONLY ? new SReadOnlyIndex(sIndexMetadata) : new SAVLIndex(sIndexMetadata);
                    sIndex.buildColumnsMetadata(table);
                    sIndex.reset();
                    table.addSIndex(sIndex);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        executorService.shutdown();
        return table;
    }

    private static void readDeletedRowsMap(FileSystem fileSystem, String filename, SnapshotTable table) throws IOException {
        try (InputStream fis = fileSystem.open(filename);
             SnappyFramedInputStream sis = new SnappyFramedInputStream(fis, true);
             DataInputStream dis = new DataInputStream(sis);){
            table.getDeletedRows().deserialize(dis);
        }
    }

    private static void checkTableSchema(TableMetadata metadata, TableMetadata schemaMetadata, boolean force) {
        if (schemaMetadata == null) {
            return;
        }
        if (!force && !metadata.getName().equals(schemaMetadata.getName())) {
            throw new DataspaceException("Provided data belongs to another table with name '" + metadata.getName() + "'.");
        }
        if (metadata.getColumnMetadataList().size() != schemaMetadata.getColumnMetadataList().size()) {
            throw new DataspaceException("Provided data mismatch: expected columns count: " + schemaMetadata.getColumnMetadataList().size() + ", but provided " + metadata.getColumnMetadataList().size() + ".");
        }
        for (int i = 0; i < metadata.getColumnMetadataList().size(); ++i) {
            ColumnMetadata columnMetadata = metadata.getColumnMetadataList().get(i);
            if (!columnMetadata.getName().equals(schemaMetadata.getColumnMetadataList().get(i).getName())) {
                throw new DataspaceException("Provided data mismatch: column with index '" + i + "' has name '" + columnMetadata.getName() + "' instead of '" + schemaMetadata.getColumnMetadataList().get(i).getName() + "'.");
            }
            if (columnMetadata.getType() == schemaMetadata.getColumnMetadataList().get(i).getType()) continue;
            throw new DataspaceException("Provided data mismatch: column with name '" + schemaMetadata.getColumnMetadataList().get(i).getName() + "' has type '" + String.valueOf((Object)columnMetadata.getType()) + "' instead of '" + String.valueOf((Object)schemaMetadata.getColumnMetadataList().get(i).getType()) + "'.");
        }
    }

    private static SIndex readSIndex(FileSystem fileSystem, String path, String fileName, SIndexMetadata sIndexMetadata, SnapshotTable table) throws IOException {
        if (sIndexMetadata.getType() == SIndexType.READ_ONLY) {
            return StorageManager.readSReadOnlyIndex(fileSystem, path, fileName, sIndexMetadata);
        }
        return StorageManager.readSAVLIndex(fileSystem, path, fileName, sIndexMetadata);
    }

    private static SReadOnlyIndex readSReadOnlyIndex(FileSystem fileSystem, String path, String fileName, SIndexMetadata sIndexMetadata) throws IOException {
        SReadOnlyIndex sIndex = new SReadOnlyIndex(sIndexMetadata);
        try {
            String filepath = StorageManager.buildFilepath(fileSystem, path, fileName);
            StorageManager.readIntArray(fileSystem, filepath, sIndex.getOrderArray());
            sIndex.setSizeOnDisk(fileSystem.getSize(filepath));
        }
        catch (Exception exception) {
            sIndex.invalidate();
        }
        return sIndex;
    }

    private static SAVLIndex readSAVLIndex(FileSystem fileSystem, String path, String fileName, SIndexMetadata sIndexMetadata) throws IOException {
        SAVLIndex sIndex = new SAVLIndex(sIndexMetadata);
        try {
            String parentsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_parents");
            String leftsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_lefts");
            String rightsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_rights");
            String heightsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_heights");
            String settingsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_settings");
            int[] settings = new int[4];
            StorageManager.readIntArray(fileSystem, settingsFilename, settings);
            int size = settings[2] > 0 ? settings[2] : 0;
            int[] parents = new int[size];
            int[] lefts = new int[size];
            int[] rights = new int[size];
            int[] heights = new int[size];
            StorageManager.readIntArray(fileSystem, parentsFilename, parents);
            StorageManager.readIntArray(fileSystem, leftsFilename, lefts);
            StorageManager.readIntArray(fileSystem, rightsFilename, rights);
            StorageManager.readIntArray(fileSystem, heightsFilename, heights);
            sIndex.getTree().init(parents, lefts, rights, heights, settings);
            sIndex.setSizeOnDisk(fileSystem.getSize(parentsFilename) + fileSystem.getSize(leftsFilename) + fileSystem.getSize(rightsFilename) + fileSystem.getSize(heightsFilename) + fileSystem.getSize(settingsFilename));
        }
        catch (Exception exception) {
            sIndex.invalidate();
        }
        return sIndex;
    }

    private static void readIntArray(FileSystem fileSystem, String filename, int[] a) throws IOException {
        try (InputStream fis = fileSystem.open(filename);
             SnappyFramedInputStream sis = new SnappyFramedInputStream(fis, true);
             DataInputStream dis = new DataInputStream(sis);){
            int[] i = new int[]{0};
            StorageManager.whileNotEOF(dis, () -> {
                int n = i[0];
                i[0] = n + 1;
                a[n] = dis.readInt();
            });
        }
    }

    /*
     * Exception decompiling
     */
    private static Column readColumn(FileSystem fileSystem, String fileName, ColumnMetadata columnMetadata) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Column readColumn(DataInputStream dis, ColumnMetadata columnMetadata) throws IOException {
        switch (columnMetadata.getType()) {
            case FLOAT: {
                return StorageManager.readFloatColumn(dis, columnMetadata);
            }
            case DOUBLE: {
                return StorageManager.readDoubleColumn(dis, columnMetadata);
            }
            case INTEGER: {
                return StorageManager.readIntColumn(dis, columnMetadata);
            }
            case BOOLEAN: {
                return StorageManager.readBooleanColumn(dis, columnMetadata);
            }
            case LOCAL_DATE: {
                return StorageManager.readLocalDateColumn(dis, columnMetadata);
            }
            case LOCAL_TIME: {
                return StorageManager.readLocalTimeColumn(dis, columnMetadata);
            }
            case LOCAL_DATE_TIME: {
                return StorageManager.readLocalDateTimeColumn(dis, columnMetadata);
            }
            case CATEGORY: {
                return StorageManager.readCategoryColumn(dis, columnMetadata);
            }
            case STRING: {
                return StorageManager.readStringColumn(dis, columnMetadata);
            }
            case SHORT: {
                return StorageManager.readShortColumn(dis, columnMetadata);
            }
            case LONG: {
                return StorageManager.readLongColumn(dis, columnMetadata);
            }
            case DECIMAL: {
                return StorageManager.readDecimalColumn(dis, columnMetadata);
            }
        }
        throw new IllegalStateException("Unhandled column type writing columns");
    }

    private static void whileNotEOF(DataInputStream dis, RunnableIOException runnable) throws IOException {
        boolean EOF2 = false;
        while (!EOF2) {
            try {
                runnable.execute();
            }
            catch (EOFException e) {
                EOF2 = true;
            }
        }
    }

    private static FloatColumn readFloatColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        FloatColumn floats = FloatColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> floats.append(dis.readFloat()));
        return floats;
    }

    private static DoubleColumn readDoubleColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        DoubleColumn doubles = DoubleColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> doubles.append(dis.readDouble()));
        return doubles;
    }

    private static IntColumn readIntColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        IntColumn ints = IntColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> ints.append(dis.readInt()));
        return ints;
    }

    private static ShortColumn readShortColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        ShortColumn ints = ShortColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> ints.append(dis.readShort()));
        return ints;
    }

    private static LongColumn readLongColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        LongColumn ints = LongColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> ints.append(dis.readLong()));
        return ints;
    }

    private static DecimalColumn readDecimalColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        DecimalColumn ints = DecimalColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> ints.append(dis.readLong(), ints.getScale()));
        return ints;
    }

    private static DateColumn readLocalDateColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        DateColumn dates = DateColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> dates.append(dis.readLong()));
        return dates;
    }

    private static DateTimeColumn readLocalDateTimeColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        DateTimeColumn dates = DateTimeColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> dates.append(dis.readLong()));
        return dates;
    }

    private static TimeColumn readLocalTimeColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        TimeColumn times = TimeColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> times.append(dis.readLong()));
        return times;
    }

    static CategoryColumn readCategoryColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        CategoryColumnImpl stringColumn = (CategoryColumnImpl)CategoryColumn.create(metadata);
        int stringCount = dis.readInt();
        for (int j = 0; j < stringCount; ++j) {
            int i = dis.readInt();
            int u = dis.readInt();
            byte isNull = dis.readByte();
            String value = null;
            if (isNull == 0) {
                value = dis.readUTF();
            }
            stringColumn.dictionaryMap().put(i, value);
            stringColumn.dictionaryMap().setUsagesCount(i, u);
        }
        int size = metadata.getSize();
        for (int i = 0; i < size; ++i) {
            stringColumn.values().add(dis.readInt());
        }
        stringColumn.initId();
        return stringColumn;
    }

    static StringColumn readStringColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        StringColumn stringColumn = StringColumn.create(metadata);
        int count = dis.readInt();
        for (int j = 0; j < count; ++j) {
            byte isNull = dis.readByte();
            String value = null;
            if (isNull == 0) {
                value = dis.readUTF();
            }
            stringColumn.append(value);
        }
        return stringColumn;
    }

    private static BooleanColumn readBooleanColumn(DataInputStream dis, ColumnMetadata metadata) throws IOException {
        BooleanColumn bools = BooleanColumn.create(metadata);
        StorageManager.whileNotEOF(dis, () -> {
            byte b = dis.readByte();
            bools.append(b);
        });
        return bools;
    }

    public static String saveTable(FileSystem fileSystem, String storageFolder, SnapshotTable table) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        ExecutorCompletionService<Void> writerCompletionService = new ExecutorCompletionService<Void>(executorService);
        if (!fileSystem.exists(storageFolder)) {
            try {
                fileSystem.mkdir(storageFolder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StorageManager.writeTableMetadata(fileSystem, storageFolder, table);
        try {
            int futuresCount = 0;
            for (Column column : table.columns()) {
                writerCompletionService.submit(() -> {
                    StorageManager.writeColumn(fileSystem, StorageManager.buildFilepath(fileSystem, storageFolder, column.id()), column);
                    return null;
                });
                ++futuresCount;
            }
            for (SIndex sIndex : table.listSIndexes()) {
                if (!sIndex.isBuilt()) continue;
                writerCompletionService.submit(() -> {
                    if (sIndex.getType() == SIndexType.READ_ONLY) {
                        StorageManager.writeSReadOnlyIndex(fileSystem, StorageManager.buildFilepath(fileSystem, storageFolder, sIndex.getId()), (SReadOnlyIndex)sIndex);
                    } else {
                        StorageManager.writeSAVLIndex(fileSystem, storageFolder, sIndex.getId(), (SAVLIndex)sIndex);
                    }
                    return null;
                });
                ++futuresCount;
            }
            writerCompletionService.submit(() -> {
                StorageManager.writeDeletedRowsMap(fileSystem, StorageManager.buildFilepath(fileSystem, storageFolder, DELETE_MAP_FILENAME), table.getDeletedRows());
                return null;
            });
            ++futuresCount;
            for (int i = 0; i < futuresCount; ++i) {
                Future future = writerCompletionService.take();
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        executorService.shutdown();
        return storageFolder;
    }

    private static void writeDeletedRowsMap(FileSystem fileSystem, String fileName, DeletedRowsSelection deletedRowsSelection) throws IOException {
        try (OutputStream fos = fileSystem.create(fileName, true);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream(fos);
             DataOutputStream dos = new DataOutputStream(sos);){
            deletedRowsSelection.serialize(dos);
            dos.flush();
        }
    }

    private static void writeColumn(FileSystem fileSystem, String fileName, Column column) throws IOException {
        try (OutputStream fos = fileSystem.create(fileName, true);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream(fos);
             DataOutputStream dos = new DataOutputStream(sos);){
            int[] i = new int[]{0};
            RunnableIOException flusher = () -> {
                if (i[0] % 10000 == 0) {
                    dos.flush();
                }
                i[0] = i[0] + 1;
            };
            switch (column.type()) {
                case FLOAT: {
                    StorageManager.writeColumn(dos, flusher, (FloatColumn)column);
                    break;
                }
                case DOUBLE: {
                    StorageManager.writeColumn(dos, flusher, (DoubleColumn)column);
                    break;
                }
                case INTEGER: {
                    StorageManager.writeColumn(dos, flusher, (IntColumn)column);
                    break;
                }
                case BOOLEAN: {
                    StorageManager.writeColumn(dos, flusher, (BooleanColumn)column);
                    break;
                }
                case LOCAL_DATE: {
                    StorageManager.writeColumn(dos, flusher, (DateColumn)column);
                    break;
                }
                case LOCAL_TIME: {
                    StorageManager.writeColumn(dos, flusher, (TimeColumn)column);
                    break;
                }
                case LOCAL_DATE_TIME: {
                    StorageManager.writeColumn(dos, flusher, (DateTimeColumn)column);
                    break;
                }
                case CATEGORY: {
                    StorageManager.writeColumn(dos, flusher, (CategoryColumn)column);
                    break;
                }
                case STRING: {
                    StorageManager.writeColumn(dos, flusher, (StringColumn)column);
                    break;
                }
                case SHORT: {
                    StorageManager.writeColumn(dos, flusher, (ShortColumn)column);
                    break;
                }
                case LONG: {
                    StorageManager.writeColumn(dos, flusher, (LongColumn)column);
                    break;
                }
                case DECIMAL: {
                    StorageManager.writeColumn(dos, flusher, (DecimalColumn)column);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled column type writing columns");
                }
            }
            dos.flush();
        }
        ((AbstractColumn)column).setSizeOnDisk(fileSystem.getSize(fileName));
    }

    private static void writeSReadOnlyIndex(FileSystem fileSystem, String fileName, SReadOnlyIndex sIndex) throws IOException {
        StorageManager.writeIntArray(fileSystem, fileName, sIndex.getOrderArray(), 0, sIndex.getOrderArray() != null ? sIndex.getOrderArray().length : 0);
        sIndex.setSizeOnDisk(fileSystem.getSize(fileName));
    }

    private static void writeSAVLIndex(FileSystem fileSystem, String path, String fileName, SAVLIndex sIndex) throws IOException {
        String parentsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_parents");
        String leftsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_lefts");
        String rightsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_rights");
        String heightsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_heights");
        String settingsFilename = StorageManager.buildFilepath(fileSystem, path, fileName + "_settings");
        StorageManager.writeIntArray(fileSystem, parentsFilename, sIndex.getTree().getParents(), 0, sIndex.getTree().getSize());
        StorageManager.writeIntArray(fileSystem, leftsFilename, sIndex.getTree().getLefts(), 0, sIndex.getTree().getSize());
        StorageManager.writeIntArray(fileSystem, rightsFilename, sIndex.getTree().getRights(), 0, sIndex.getTree().getSize());
        StorageManager.writeIntArray(fileSystem, heightsFilename, sIndex.getTree().getHeights(), 0, sIndex.getTree().getSize());
        StorageManager.writeIntArray(fileSystem, settingsFilename, sIndex.getTree().getSettings(), 0, sIndex.getTree().getSettings().length);
        sIndex.setSizeOnDisk(fileSystem.getSize(parentsFilename) + fileSystem.getSize(leftsFilename) + fileSystem.getSize(rightsFilename) + fileSystem.getSize(heightsFilename) + fileSystem.getSize(settingsFilename));
    }

    private static void writeIntArray(FileSystem fileSystem, String fileName, int[] array, int start, int end) throws IOException {
        try (OutputStream fos = fileSystem.create(fileName, true);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream(fos);
             DataOutputStream dos = new DataOutputStream(sos);){
            int[] i = new int[]{0};
            RunnableIOException flusher = () -> {
                if (i[0] % 10000 == 0) {
                    dos.flush();
                }
                i[0] = i[0] + 1;
            };
            if (array != null) {
                for (int j = start; j < end; ++j) {
                    dos.writeInt(array[j]);
                    flusher.execute();
                }
            }
            dos.flush();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, FloatColumn column) throws IOException {
        FloatIterator floatIterator = column.data().iterator();
        while (floatIterator.hasNext()) {
            float d = ((Float)floatIterator.next()).floatValue();
            dos.writeFloat(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, DoubleColumn column) throws IOException {
        DoubleIterator doubleIterator = column.data().iterator();
        while (doubleIterator.hasNext()) {
            double d = (Double)doubleIterator.next();
            dos.writeDouble(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, CategoryColumn column) throws IOException {
        CategoryColumnImpl categoryColumn = (CategoryColumnImpl)column;
        int categoryCount = categoryColumn.dictionaryMap().size();
        dos.writeInt(categoryCount);
        TreeSet<Integer> keys = new TreeSet<Integer>(categoryColumn.dictionaryMap().keyToValueMap().keySet());
        IntIterator intIterator = keys.iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            dos.writeInt(key);
            dos.writeInt(categoryColumn.dictionaryMap().getUsagesCount(key));
            String value = categoryColumn.dictionaryMap().get(key);
            dos.writeByte(value != null ? 0 : 1);
            if (value == null) continue;
            dos.writeUTF(value);
        }
        dos.flush();
        intIterator = categoryColumn.values().iterator();
        while (intIterator.hasNext()) {
            int d = (Integer)intIterator.next();
            dos.writeInt(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, StringColumn column) throws IOException {
        dos.writeInt(column.dataSize());
        for (String s : column.data()) {
            dos.writeByte(s == null ? 1 : 0);
            if (s != null) {
                dos.writeUTF(s);
            }
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, IntColumn column) throws IOException {
        IntIterator intIterator = column.data().iterator();
        while (intIterator.hasNext()) {
            int d = (Integer)intIterator.next();
            dos.writeInt(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, ShortColumn column) throws IOException {
        ShortIterator shortIterator = column.data().iterator();
        while (shortIterator.hasNext()) {
            short d = (Short)shortIterator.next();
            dos.writeShort(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, LongColumn column) throws IOException {
        LongIterator longIterator = column.data().iterator();
        while (longIterator.hasNext()) {
            long d = (Long)longIterator.next();
            dos.writeLong(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, DecimalColumn column) throws IOException {
        LongIterator longIterator = column.data().iterator();
        while (longIterator.hasNext()) {
            long d = (Long)longIterator.next();
            dos.writeLong(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, DateColumn column) throws IOException {
        LongIterator longIterator = column.data().iterator();
        while (longIterator.hasNext()) {
            long d = (Long)longIterator.next();
            dos.writeLong(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, DateTimeColumn column) throws IOException {
        LongIterator longIterator = column.data().iterator();
        while (longIterator.hasNext()) {
            long d = (Long)longIterator.next();
            dos.writeLong(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, TimeColumn column) throws IOException {
        LongIterator longIterator = column.data().iterator();
        while (longIterator.hasNext()) {
            long d = (Long)longIterator.next();
            dos.writeLong(d);
            flusher.execute();
        }
    }

    static void writeColumn(DataOutputStream dos, RunnableIOException flusher, BooleanColumn column) throws IOException {
        for (int i = 0; i < column.dataSize(); ++i) {
            byte value = column.getByte(i);
            dos.writeByte(value);
            flusher.execute();
        }
    }

    private static interface RunnableIOException {
        public void execute() throws IOException;
    }
}

