/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.Order;
import com.streamscape.ds.stable.utils.Selection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SnapshotView
extends Snapshot {
    private Snapshot table;
    private List<Column> columns;
    private String name;
    private SIndex sIndex = null;

    public SnapshotView(Snapshot table, String ... columnNames) {
        this.table = table;
        this.name = table.name() + "-View";
        this.columns = new ArrayList<Column>();
        if (columnNames != null && columnNames.length > 0) {
            for (String columnName : columnNames) {
                this.columns.add(table.column(columnName));
            }
        } else {
            this.columns.addAll(table.columns());
        }
    }

    public Snapshot setSIndex(SIndex sIndex) {
        this.sIndex = sIndex;
        return this;
    }

    @Override
    public Snapshot addColumn(Column ... cols) {
        throw new UnsupportedOperationException("Column cannot be added to view.");
    }

    @Override
    public Snapshot setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Snapshot removeColumns(Column ... columns) {
        throw new UnsupportedOperationException("Column cannot be removed from view.");
    }

    @Override
    public Column column(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    @Override
    public int columnCount() {
        return this.columns.size();
    }

    @Override
    public int rowCount() {
        return this.table.rowCount();
    }

    @Override
    public List<Column> columns() {
        return new ArrayList<Column>(this.columns);
    }

    @Override
    public int columnIndex(Column col) {
        return this.columns.indexOf(col);
    }

    @Override
    public String get(int r, int c) {
        return this.columns.get(c).getString(r);
    }

    @Override
    public String name() {
        return this.name;
    }

    public void clear() {
        throw new UnsupportedOperationException("View cannot be cleared.");
    }

    @Override
    public List<String> columnNames() {
        return this.columns.stream().map(c -> c.name()).collect(Collectors.toList());
    }

    @Override
    public IntIterator iterator() {
        if (this.sIndex != null && this.sIndex.isBuilt()) {
            return this.sIndex.iterator();
        }
        return this.table.iterator();
    }

    @Override
    public IntIterator reverseIterator() {
        if (this.sIndex != null && this.sIndex.isBuilt()) {
            return this.sIndex.reverseIterator();
        }
        return this.table.reverseIterator();
    }

    @Override
    public SnapshotTable toSnapshotTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SnapshotView sortOn(String[] columnNames, Order[] order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Selection getSelection() {
        return this.table.getSelection();
    }

    public int insert(Snapshot table) {
        throw new UnsupportedOperationException("Insert cannot be done to view.");
    }

    @Override
    public SIndex getSIndexForColumns(String[] columnNames) {
        if (this.sIndex != null && this.sIndex.isGoodForColumns(columnNames)) {
            return this.sIndex;
        }
        return this.table.getSIndexForColumns(columnNames);
    }

    @Override
    public int deleteWhere(Selection selection) {
        return this.table.deleteWhere(selection);
    }
}

