/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.stable.columns.AbstractStringColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.index.AbstractSIndex;
import com.streamscape.ds.stable.index.SAVLIndex;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.stable.index.SIndexWrapper;
import com.streamscape.ds.stable.index.SReadOnlyIndex;
import com.streamscape.ds.stable.lists.IntArrayList;
import com.streamscape.ds.stable.lists.IntIterable;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.table.DataFrame;
import com.streamscape.ds.stable.table.DeletedRowsSelection;
import com.streamscape.ds.stable.table.RemovedRowsSelectionImpl;
import com.streamscape.ds.stable.table.Rows;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.table.SnapshotView;
import com.streamscape.ds.stable.table.TableMetadata;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Order;
import com.streamscape.ds.stable.utils.Selection;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SnapshotTable
extends Snapshot
implements IntIterable {
    private String name;
    private final List<Column> columnList = new ArrayList<Column>();
    private Map<String, SIndex> sIndexes = new HashMap<String, SIndex>();
    private List<SIndex>[] columnIndexToSIndex = null;
    private DeletedRowsSelection deletedRows = new RemovedRowsSelectionImpl(this);

    private SnapshotTable(String name) {
        this.name = name;
    }

    private SnapshotTable(TableMetadata metadata) {
        this.name = metadata.getName();
    }

    protected SnapshotTable(String name, Column ... columns) {
        this(name);
        for (Column column : columns) {
            this.addColumn(column);
        }
    }

    public static SnapshotTable create(String tableName) {
        return new SnapshotTable(tableName);
    }

    public static SnapshotTable create(TableMetadata metadata) {
        return new SnapshotTable(metadata);
    }

    public static SnapshotTable create(String tableName, Column ... columns) {
        return new SnapshotTable(tableName, columns);
    }

    @Override
    public SnapshotTable setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void addSequenceColumn(String columnName, int startsWith) {
        IntColumn sequenceColumn = IntColumn.create(columnName, this.rowCountWithDeleted());
        int count = 0;
        for (int i = 0; i < this.rowCountWithDeleted(); ++i) {
            if (this.deletedRows.contains(i)) {
                sequenceColumn.append(-1);
                continue;
            }
            sequenceColumn.append(startsWith + count++);
        }
        this.addColumn(sequenceColumn);
    }

    @Override
    public SnapshotTable addColumn(Column ... cols) {
        for (Column c : cols) {
            this.validateColumn(c);
            this.columnList.add(c);
        }
        this.rebuildSIndexes();
        return this;
    }

    public SnapshotTable addColumn(int index, Column column) {
        this.validateColumn(column);
        this.columnList.add(index, column);
        this.rebuildSIndexes();
        return this;
    }

    public SnapshotTable replaceColumn(int colIndex, Column newColumn) {
        this.removeColumns(this.column(colIndex));
        this.addColumn(colIndex, newColumn);
        return this;
    }

    public SnapshotTable replaceColumn(String columnName, Column newColumn) {
        int colIndex = this.columnIndex(columnName);
        this.replaceColumn(colIndex, newColumn);
        return this;
    }

    private void validateColumn(Column newColumn) {
        if (newColumn == null) {
            throw new NullPointerException("Attempted to add a null to the columns in table " + this.name);
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (String name : this.columnNames()) {
            stringList.add(name.toLowerCase());
        }
        if (stringList.contains(newColumn.name().toLowerCase())) {
            String message = String.format("Cannot add column with duplicate name %s to table %s", newColumn, this.name);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public Column column(int columnIndex) {
        return this.columnList.get(columnIndex);
    }

    @Override
    public int columnCount() {
        return this.columnList.size();
    }

    @Override
    public List<Column> columns() {
        return this.columnList;
    }

    @Override
    public int columnIndex(String columnName) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnList.size(); ++i) {
            if (!this.columnList.get(i).name().equalsIgnoreCase(columnName)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", columnName, this.name));
        }
        return columnIndex;
    }

    @Override
    public int columnIndex(Column column) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnList.size(); ++i) {
            if (!this.columnList.get(i).equals(column)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", column.name(), this.name));
        }
        return columnIndex;
    }

    @Override
    public List<String> columnNames() {
        ArrayList<String> names = new ArrayList<String>(this.columnList.size());
        names.addAll(this.columnList.stream().map(Column::name).collect(Collectors.toList()));
        return names;
    }

    @Override
    public SnapshotTable removeColumns(Column ... columns) {
        this.columnList.removeAll(Arrays.asList(columns));
        for (Column column : columns) {
            for (SIndex sIndex : this.sIndexes.values()) {
                if (!sIndex.removeColumn(column)) continue;
                sIndex.invalidate();
            }
        }
        this.rebuildSIndexes();
        return this;
    }

    public Column getAndRemoveColumn(String columnName) {
        Column c = this.column(columnName);
        this.removeColumns(c);
        return c;
    }

    public Column getAndRemoveColumn(int columnIndex) {
        Column c = this.column(columnIndex);
        this.removeColumns(c);
        return c;
    }

    public void retainColumns(Column ... columns) {
        List<Column> retained = Arrays.asList(columns);
        this.columnList.retainAll(retained);
        this.rebuildSIndexes();
    }

    public void retainColumns(String ... columnNames) {
        this.columnList.retainAll(this.columns(columnNames));
        this.rebuildSIndexes();
    }

    public Column columnById(String id) {
        return this.columnList.stream().filter(c -> c.id().equals(id)).findFirst().orElse(null);
    }

    public SIndex createSIndex(String name, SIndexType sIndexType, boolean isPrimaryKey, boolean isUnique, String ... columnsNames) {
        return this.createSIndex(name, sIndexType, isPrimaryKey, isUnique, this.columns(columnsNames));
    }

    public SIndex createSIndex(String name, SIndexType sIndexType, boolean isPrimaryKey, boolean isUnique, int ... columnsIndexes) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int columnIndex : columnsIndexes) {
            columns.add(this.column(columnIndex));
        }
        return this.createSIndex(name, sIndexType, isPrimaryKey, isUnique, columns);
    }

    public SIndex createSIndex(String name, SIndexType sIndexType, boolean isPrimaryKey, boolean isUnique, List<Column> columns) {
        if (sIndexType == SIndexType.READ_ONLY && (isUnique || isPrimaryKey)) {
            throw new DataspaceException("Read only index cannot be unique or primary key.");
        }
        if (isPrimaryKey && this.getPrimaryKey() != null) {
            throw new DataspaceException("Primary key already exists.");
        }
        AbstractSIndex index = sIndexType == SIndexType.READ_ONLY ? new SReadOnlyIndex(name, columns) : new SAVLIndex(name, isPrimaryKey, isUnique, columns);
        this.sIndexes.put(name, index);
        this.rebuildSIndexes();
        return index;
    }

    public SIndex getPrimaryKey() {
        return this.sIndexes.values().stream().filter(c -> c.isPrimaryKey()).findFirst().orElseGet(() -> null);
    }

    public void addSIndex(SIndex sIndex) {
        this.sIndexes.put(sIndex.getName(), sIndex);
        this.rebuildSIndexes();
    }

    public SIndex getSIndex(String name) {
        return this.sIndexes.get(name);
    }

    public SIndex removeSIndex(String name) {
        SIndex result = this.sIndexes.remove(name);
        this.rebuildSIndexes();
        return result;
    }

    public List<SIndex> listSIndexes() {
        return new ArrayList<SIndex>(this.sIndexes.values());
    }

    @Override
    public SIndex getSIndexForColumns(String ... names) {
        SIndex result = null;
        for (Map.Entry<String, SIndex> entry : this.sIndexes.entrySet()) {
            SIndex index = entry.getValue();
            if (!index.isGoodForColumns(names) || result != null && index.getColumns().size() >= result.getColumns().size()) continue;
            result = index;
        }
        return result;
    }

    public SIndex getSIndexForColumns(int ... columnIndexes) {
        SIndex result = null;
        for (Map.Entry<String, SIndex> entry : this.sIndexes.entrySet()) {
            SIndex index = entry.getValue();
            if (index.getColumns().size() < columnIndexes.length) continue;
            boolean isOk = true;
            for (int i = 0; i < columnIndexes.length; ++i) {
                if (index.getColumns().get(i).getIndex() == columnIndexes[i]) continue;
                isOk = false;
                break;
            }
            if (!isOk || result != null && index.getColumns().size() >= result.getColumns().size()) continue;
            result = index;
        }
        return result;
    }

    private List<SIndex> getColumnSIndexes(int columnIndex) {
        if (this.columnIndexToSIndex == null) {
            return null;
        }
        return this.columnIndexToSIndex[columnIndex];
    }

    public void buildAllIndexes() {
        for (SIndex sIndex : this.sIndexes.values()) {
            sIndex.build(this.getSelection());
        }
    }

    public void renameSIndex(String name, String newName) {
        SIndex sIndex = this.sIndexes.remove(name);
        if (sIndex != null) {
            sIndex.rename(newName);
            this.sIndexes.put(newName, sIndex);
        }
    }

    public SIndex.RowIndex getRowIndex(boolean fromFirst) {
        return new SReadOnlyIndex.RowIndexSequence(fromFirst ? 0 : this.rowCountWithDeleted() - 1, this.rowCountWithDeleted(), this.deletedRows);
    }

    public DeletedRowsSelection getDeletedRows() {
        return this.deletedRows;
    }

    private void rebuildSIndexes() {
        for (int i = 0; i < this.columnList.size(); ++i) {
            Column c = this.columnList.get(i);
            c.setSnapshotTable(this);
            if (c.getIndex() == i) continue;
            c.setIndex(i);
        }
        this.columnIndexToSIndex = new List[this.columnList.size()];
        for (SIndex sIndex : this.sIndexes.values()) {
            for (Column column : sIndex.getColumns()) {
                if (this.columnIndexToSIndex[column.getIndex()] == null) {
                    this.columnIndexToSIndex[column.getIndex()] = new ArrayList<SIndex>();
                }
                this.columnIndexToSIndex[column.getIndex()].add(sIndex);
            }
        }
        for (SIndex sIndex : this.sIndexes.values()) {
            for (Column column : sIndex.getColumns()) {
                if (this.columnList.contains(column)) continue;
                sIndex.invalidate();
                sIndex.removeColumn(column);
            }
        }
    }

    @RPLMethod(description="Truncates table.")
    public void clear() {
        this.columnList.forEach(Column::clear);
        this.deletedRows.reset();
    }

    @RPLMethod(description="Deletes all rows.")
    public int deleteAll() {
        int result = this.rowCount();
        this.clear();
        return result;
    }

    @Override
    @RPLMethod(syntax="(<column name>.<is method name>(...) {and | or | and not} ....)", samples={"myTable.deleteWhere(age.isGreaterThan(30) and state.isEqualsTo('NY'))"}, description="Deletes rows corresponding the specified selection.")
    public int deleteWhere(Selection selection) {
        int[] count = new int[]{0};
        selection.iterate(i -> {
            if (this.deleteRow(i)) {
                count[0] = count[0] + 1;
            }
        });
        return count[0];
    }

    @Override
    public int rowCount() {
        int result = this.rowCountWithDeleted();
        return result -= this.deletedRows.count();
    }

    public int rowCountWithDeleted() {
        int result = 0;
        if (!this.columnList.isEmpty()) {
            result = this.columnList.get(0).dataSize();
        }
        return result;
    }

    @Override
    public String get(int r, int c) {
        Column column = this.column(c);
        return column.getString(r);
    }

    public SnapshotTable fullCopy() {
        SnapshotTable copy = this.emptyCopy();
        IntArrayList integers = new IntArrayList();
        for (int i = 0; i < this.rowCountWithDeleted(); ++i) {
            integers.add(i);
        }
        Rows.copyRowsToTable(integers, (Snapshot)this, copy);
        copy.deletedRows.addAll(this.deletedRows);
        return copy;
    }

    @Override
    public SnapshotTable emptyCopy() {
        SnapshotTable copy = new SnapshotTable(this.name);
        for (Column column : this.columns()) {
            copy.addColumn(column.emptyCopy());
        }
        return copy;
    }

    @Override
    public SnapshotTable emptyCopy(int rowSize) {
        SnapshotTable copy = new SnapshotTable(this.name);
        for (Column column : this.columnList) {
            copy.addColumn(column.emptyCopy(rowSize));
        }
        return copy;
    }

    public void append(SnapshotTable tableToAppend) {
        for (Column column : this.columnList) {
            Column columnToAppend = tableToAppend.column(column.name());
            column.append(columnToAppend);
        }
    }

    public void appendWithRollback(SnapshotTable tableToAppend) {
        ArrayList<Integer> columnsLength = new ArrayList<Integer>();
        for (Column column : this.columnList) {
            columnsLength.add(column.size());
            Column columnToAppend = tableToAppend.column(column.name());
            try {
                column.append(columnToAppend);
            }
            catch (Exception exception) {
                for (int i = 0; i < columnsLength.size(); ++i) {
                    Column columnToRollback = this.columnList.get(i);
                    while (columnToRollback.size() > (Integer)columnsLength.get(i)) {
                        columnToRollback.removeLast();
                    }
                }
                throw exception;
            }
        }
    }

    public void appendRow(Runnable appendRowRunnable) {
        int rowCountBefore = this.rowCountWithDeleted();
        try {
            appendRowRunnable.run();
        }
        catch (Exception exception) {
            for (Column column : this.columnList) {
                while (column.dataSize() > rowCountBefore) {
                    column.removeLast();
                }
            }
            throw exception;
        }
    }

    public void appendRow(Object[] values) {
        if (values == null || values.length != this.columns().size()) {
            throw new IllegalArgumentException("Columns values mismatch");
        }
        this.appendRow(() -> {
            for (int i = 0; i < values.length; ++i) {
                this.column(i).appendObject(values[i]);
            }
        });
    }

    public boolean deleteRow(int index) {
        boolean result = false;
        if (index >= 0 && index < this.rowCountWithDeleted()) {
            result = this.deletedRows.add(index);
        }
        for (SIndex sIndex : this.sIndexes.values()) {
            if (sIndex.getType() != SIndexType.AVL) continue;
            sIndex.onColumnDataRemoved(index);
        }
        for (Column column : this.columnList) {
            if (!(column instanceof AbstractStringColumn)) continue;
            ((AbstractStringColumn)column).removeRow(index);
        }
        return result;
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private int i = 0;

            @Override
            public int nextInt() {
                return this.i++;
            }

            @Override
            public boolean hasNext() {
                while (SnapshotTable.this.deletedRows.contains(this.i)) {
                    ++this.i;
                }
                return this.i < SnapshotTable.this.rowCountWithDeleted();
            }

            @Override
            public Integer next() {
                return this.nextInt();
            }
        };
    }

    @Override
    public IntIterator reverseIterator() {
        return new IntIterator(){
            private int i;
            {
                this.i = SnapshotTable.this.rowCountWithDeleted() - 1;
            }

            @Override
            public int nextInt() {
                return this.i--;
            }

            @Override
            public boolean hasNext() {
                while (SnapshotTable.this.deletedRows.contains(this.i)) {
                    --this.i;
                }
                return this.i >= 0;
            }

            @Override
            public Integer next() {
                return this.nextInt();
            }
        };
    }

    public IntIterator iteratorDeleted() {
        return this.deletedRows.iterator();
    }

    public void onColumnDataFullyUpdated(int columnIndex) {
        List<SIndex> list = this.getColumnSIndexes(columnIndex);
        if (list != null) {
            for (SIndex sIndex : list) {
                sIndex.reset();
                if (sIndex.getType() != SIndexType.AVL) continue;
                sIndex.build(this.getSelection());
            }
        }
    }

    public void onColumnDataAppended(int dataIndex) {
        for (SIndex sIndex : this.sIndexes.values()) {
            sIndex.onColumnDataAppended(dataIndex);
        }
    }

    public void onColumnDataAppended(int columnIndex, int dataIndex) {
        List<SIndex> list = this.getColumnSIndexes(columnIndex);
        if (list != null) {
            for (SIndex sIndex : list) {
                if (sIndex.getColumns().size() > 1) {
                    int size = -1;
                    boolean notAllColumnsFilled = false;
                    for (Column column : sIndex.getColumns()) {
                        if (size != -1 && column.dataSize() != size) {
                            notAllColumnsFilled = true;
                            break;
                        }
                        size = column.dataSize();
                    }
                    if (notAllColumnsFilled) continue;
                }
                sIndex.onColumnDataAppended(dataIndex);
            }
        }
    }

    public void onColumnDataRemoved(int columnIndex, int dataIndex) {
        List<SIndex> list = this.getColumnSIndexes(columnIndex);
        if (list != null) {
            for (SIndex sIndex : list) {
                if (sIndex.getColumns().size() > 1) {
                    int size = -1;
                    boolean notAllColumnsFilled = false;
                    for (Column column : sIndex.getColumns()) {
                        if (size != -1 && column.dataSize() != size) {
                            notAllColumnsFilled = true;
                            break;
                        }
                        size = column.dataSize();
                    }
                    if (notAllColumnsFilled) continue;
                }
                sIndex.onColumnDataRemoved(dataIndex);
            }
        }
    }

    public void onColumnDataChanged(int columnIndex, int dataIndex) {
        List<SIndex> list = this.getColumnSIndexes(columnIndex);
        if (list != null) {
            for (SIndex sIndex : list) {
                sIndex.onColumnDataChanged(dataIndex);
            }
        }
    }

    public void onColumnDataCleared(int columnIndex) {
        List<SIndex> list = this.getColumnSIndexes(columnIndex);
        if (list != null) {
            for (SIndex sIndex : list) {
                sIndex.onColumnDataCleared();
            }
        }
    }

    public long sizeInMemoryData() {
        long result = 0L;
        for (Column column : this.columnList) {
            result += column.sizeInMemoryData();
        }
        for (SIndex sIndex : this.sIndexes.values()) {
            result += sIndex.sizeInMemoryData();
        }
        return result += this.deletedRows.sizeInMemory();
    }

    public long sizeInMemoryFull() {
        long result = 0L;
        for (Column column : this.columnList) {
            result += column.sizeInMemoryFull();
        }
        for (SIndex sIndex : this.sIndexes.values()) {
            result += sIndex.sizeInMemoryFull();
        }
        return result += this.deletedRows.sizeInMemory();
    }

    public long sizeOnDisk() {
        long s;
        long result = 0L;
        for (Column column : this.columnList) {
            s = column.sizeOnDisk();
            if (s == -1L) {
                return -1L;
            }
            result += s;
        }
        for (SIndex sIndex : this.sIndexes.values()) {
            s = sIndex.sizeOnDisk();
            if (s == -1L) {
                return -1L;
            }
            result += s;
        }
        return result += this.deletedRows.sizeOnDisk();
    }

    public void trimToSize() {
        for (Column column : this.columnList) {
            column.trimToSize();
        }
        for (SIndex sIndex : this.sIndexes.values()) {
            sIndex.trimToSize();
        }
        this.deletedRows.trimToSize();
    }

    public void defrag(boolean withTrim) {
        if (this.deletedRows.count() > 0) {
            int[] moveMap = new int[this.rowCountWithDeleted()];
            int i = 0;
            IntIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                int x = iterator.nextInt();
                moveMap[x] = i + 1;
                ++i;
            }
            this.deletedRows.reset();
            for (Column column : this.columnList) {
                column.defrag(moveMap, withTrim);
            }
            for (SIndex sIndex : this.sIndexes.values()) {
                if (!sIndex.isBuilt()) continue;
                sIndex.defrag(moveMap, withTrim);
            }
        }
        if (withTrim) {
            this.trimToSize();
        }
    }

    @Override
    public SnapshotView sortOn(String[] columnNames, Order[] order) {
        if (order == null) {
            order = new Order[columnNames.length];
            Arrays.fill((Object[])order, (Object)Order.ASC);
        }
        SnapshotView view = new SnapshotView(this, new String[0]);
        SIndex index = this.getSIndexForColumns(columnNames);
        if (index != null) {
            if (index.isValid()) {
                if (!index.isOrder(order) && order.length == 1) {
                    index = new SIndexWrapper(this, index){

                        @Override
                        public IntIterator iterator() {
                            return super.reverseIterator();
                        }

                        @Override
                        public IntIterator reverseIterator() {
                            return super.iterator();
                        }
                    };
                }
                if (!index.isBuilt()) {
                    if (index.getType() == SIndexType.READ_ONLY) {
                        index.build(this.getSelection());
                    } else {
                        index = null;
                    }
                }
            } else {
                index = null;
            }
        }
        if (index == null) {
            index = new SReadOnlyIndex("sort-on-index", this.columns(columnNames), Arrays.asList(order));
            index.build(this.getSelection());
        }
        view.setSIndex(index);
        return view;
    }

    @Override
    public SnapshotTable toSnapshotTable() {
        return this;
    }

    @Override
    public Selection getSelection() {
        return this.deletedRows.getInvertedSelection();
    }

    @RPLMethod(description="Appends specified table to the current table.\nColumns counts should match. If types don't not match automatic conversion will be done if possible, otherwise exception will be thrown.\nReturns number of inserted rows.", syntax="(<tablename>)", samples={"mytable.insert(yourtable)", "mytable.insert(yourtable.where(id.isLessThan(10).select(id,name)))"})
    public int insert(Snapshot table) {
        if (this.columnCount() != table.columnCount()) {
            throw new DataspaceException("Columns count mismatch.");
        }
        int count = 0;
        int maxCount = table.rowCount();
        IntIterator iterator = table.iterator();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            this.appendRow(() -> {
                for (int i = 0; i < this.columnCount(); ++i) {
                    Column thisColumn = this.column(i);
                    Column tableColumn = table.column(i);
                    if (thisColumn.type() == tableColumn.type()) {
                        thisColumn.append(tableColumn, row);
                        continue;
                    }
                    thisColumn.appendObject(tableColumn.getObject(row));
                }
            });
            if (++count < maxCount) continue;
            break;
        }
        return count;
    }

    @RPLMethod(description="Appends specified DataFrame to the current table.\nColumns counts should match. If types don't not match automatic conversion will be done if possible, otherwise exception will be thrown.\nReturns number of inserted rows.", syntax="(<data frame>)", samples={"mytable.insert(mydataframe)"})
    public int insert(DataFrame dataFrame) {
        if (this.columnCount() != dataFrame.columnCount()) {
            throw new DataspaceException("Columns count mismatch.");
        }
        int count = 0;
        int row = 0;
        while (row < dataFrame.rowCount()) {
            int finalRow = row++;
            this.appendRow(() -> {
                for (int i = 0; i < this.columnCount(); ++i) {
                    Column thisColumn = this.column(i);
                    if (thisColumn instanceof DoubleColumn) {
                        ((DoubleColumn)thisColumn).append(dataFrame.getData()[finalRow][i]);
                        continue;
                    }
                    thisColumn.appendObject(dataFrame.getData()[finalRow][i]);
                }
            });
            ++count;
        }
        return count;
    }

    @Override
    public SnapshotTable structure() {
        SnapshotTable t = new SnapshotTable("Structure of " + this.name());
        IntColumn index = IntColumn.create("Index", this.columnCount());
        CategoryColumn columnName = CategoryColumn.create("Column Name", this.columnCount());
        CategoryColumn columnType = CategoryColumn.create("Column Type", this.columnCount());
        t.addColumn(index);
        t.addColumn(columnName);
        t.addColumn(columnType);
        columnName.appendAll(this.columnNames());
        for (int i = 0; i < this.columnCount(); ++i) {
            Column column = this.columnList.get(i);
            index.append(i);
            columnType.append(column.type().name());
        }
        return t;
    }

    public SnapshotTable sample(double proportion) {
        int[] selectedRecords;
        int tableCount = (int)Math.round((double)this.rowCountWithDeleted() * proportion);
        BitmapBackedSelection table1Selection = new BitmapBackedSelection();
        for (int selectedRecord : selectedRecords = SnapshotTable.generateUniformBitmap(tableCount, this.rowCountWithDeleted())) {
            table1Selection.add(selectedRecord);
        }
        return this.where(table1Selection).toSnapshotTable();
    }

    static int[] generateUniformBitmap(int N, int Max) {
        if (N > Max) {
            throw new IllegalArgumentException("Illegal arguments: N (" + N + ") greater than Max (" + Max + ")");
        }
        int[] ans = new int[N];
        if (N == Max) {
            for (int k = 0; k < N; ++k) {
                ans[k] = k;
            }
            return ans;
        }
        BitSet bs = new BitSet(Max);
        int cardinality = 0;
        SecureRandom random = new SecureRandom();
        while (cardinality < N) {
            int v = random.nextInt(Max);
            if (bs.get(v)) continue;
            bs.set(v);
            ++cardinality;
        }
        int pos = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            ans[pos++] = i;
            i = bs.nextSetBit(i + 1);
        }
        return ans;
    }
}

