/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.table.SnapshotSlice;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SnapshotSliceGroup {
    private Snapshot view;
    private final String[] splitColumnNames;
    private final List<Column> splitColumns;
    private List<SnapshotSlicePair> slices = new ArrayList<SnapshotSlicePair>();

    public SnapshotSliceGroup(Snapshot table, String[] columnNames) {
        this.view = table;
        if (columnNames.length > 0) {
            this.view = table.sortOn(columnNames);
        }
        this.splitColumnNames = columnNames;
        this.splitColumns = this.view.columns(this.splitColumnNames);
        this.split();
    }

    private void split() {
        SnapshotSlice slice;
        if (this.splitColumns.size() == 0) {
            SnapshotSlice slice2 = new SnapshotSlice(this.view, this.view.getSelection());
            ((Snapshot)slice2).setName("singleslice");
            this.addSlice(slice2, 0);
            return;
        }
        List<Column> splitColumnsString = this.splitColumns.stream().filter(column -> column instanceof StringColumn).collect(Collectors.toList());
        List<Column> splitColumnsNonString = this.splitColumns.stream().filter(column -> !(column instanceof StringColumn)).collect(Collectors.toList());
        int byteSizeNonString = splitColumnsNonString.stream().mapToInt(column -> column.byteSize()).sum();
        byte[] currentKey = null;
        int currentKeyRow = -1;
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntIterator iterator = this.view.iterator();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            byte[] newKey = this.keyToBytes(row, splitColumnsString, splitColumnsNonString, byteSizeNonString);
            if (currentKeyRow == -1) {
                currentKey = newKey;
                currentKeyRow = row;
            }
            if (!Arrays.equals(newKey, currentKey)) {
                slice = new SnapshotSlice(this.view, selection);
                ((Snapshot)slice).setName(this.buildSliceName(currentKeyRow));
                this.addSlice(slice, currentKeyRow);
                currentKey = newKey;
                currentKeyRow = row;
                selection = new BitmapBackedSelection();
                selection.add(row);
                continue;
            }
            selection.add(row);
        }
        if (!selection.isEmpty()) {
            slice = new SnapshotSlice(this.view, selection);
            ((Snapshot)slice).setName(this.buildSliceName(currentKeyRow));
            this.addSlice(slice, currentKeyRow);
        }
    }

    private byte[] keyToBytes(int row, List<Column> splitColumnsString, List<Column> splitColumnsNonString, int byteSizeNonString) {
        ByteBuffer byteBuffer;
        if (splitColumnsString.size() == 0) {
            byteBuffer = ByteBuffer.allocate(byteSizeNonString);
            for (Column column : splitColumnsNonString) {
                byteBuffer.put(column.asBytes(row));
            }
        } else {
            byte[][] stringColumnBytes = new byte[splitColumnsString.size()][];
            int byteSizeString = 0;
            for (int i = 0; i < splitColumnsString.size(); ++i) {
                stringColumnBytes[i] = splitColumnsString.get(i).asBytes(row);
                byteSizeString += stringColumnBytes[i] != null ? stringColumnBytes[i].length : 0;
            }
            byteBuffer = ByteBuffer.allocate(byteSizeNonString + byteSizeString);
            for (Column column : splitColumnsNonString) {
                byteBuffer.put(column.asBytes(row));
            }
            for (Object bytes : (Object)stringColumnBytes) {
                byteBuffer.put((byte[])bytes);
            }
        }
        return byteBuffer.array();
    }

    private String buildSliceName(int currentKeyRow) {
        return this.splitColumns.stream().map(c -> c.getString(currentKeyRow)).collect(Collectors.joining("~~~"));
    }

    private void addSlice(Snapshot slice, int row) {
        this.slices.add(new SnapshotSlicePair(slice, row));
    }

    public List<Column> getSplitColumns() {
        return this.splitColumns;
    }

    public List<SnapshotSlicePair> getSlices() {
        return this.slices;
    }

    public static class SnapshotSlicePair {
        private final Snapshot slice;
        private final int row;

        public SnapshotSlicePair(Snapshot slice, int row) {
            this.slice = slice;
            this.row = row;
        }

        public Snapshot getSlice() {
            return this.slice;
        }

        public int getRow() {
            return this.row;
        }
    }
}

