/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SReadOnlyIndex;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.table.Rows;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.table.SnapshotView;
import com.streamscape.ds.stable.utils.Order;
import com.streamscape.ds.stable.utils.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SnapshotSlice
extends Snapshot {
    private Snapshot table;
    private Selection selection;
    private String name;
    private final List<Column> columns;

    public SnapshotSlice(Snapshot table, Selection selection) {
        this.table = table;
        this.selection = selection;
        this.name = table.name() + "-Slice";
        this.columns = table.columns().stream().map(c -> c.wrap(this.selection)).collect(Collectors.toList());
    }

    @Override
    public Snapshot addColumn(Column ... cols) {
        throw new UnsupportedOperationException("Column cannot be added to table slice.");
    }

    @Override
    public Snapshot setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Snapshot removeColumns(Column ... columns) {
        throw new UnsupportedOperationException("Column cannot be removed from slice.");
    }

    @Override
    public Column column(int columnIndex) {
        this.table.column(columnIndex);
        return this.columns.get(columnIndex);
    }

    @Override
    public int columnCount() {
        return this.table.columnCount();
    }

    @Override
    public int rowCount() {
        return this.selection.size();
    }

    @Override
    public List<Column> columns() {
        return new ArrayList<Column>(this.columns);
    }

    @Override
    public int columnIndex(Column col) {
        try {
            return this.table.columnIndex(col);
        }
        catch (Exception exception) {
            int index = this.columns.indexOf(col);
            if (index == -1) {
                throw exception;
            }
            return index;
        }
    }

    @Override
    public String get(int r, int c) {
        return this.table.column(c).getString(this.selection.get(r));
    }

    @Override
    public String name() {
        return this.name;
    }

    @RPLMethod(samples={"myTable.deleteWhere(age.isGreaterThan(30) and state.isEqualsTo('NY'))"}, description="Deletes rows in current selection.")
    public int delete() {
        return this.table.deleteWhere(this.selection);
    }

    @Override
    public int deleteWhere(Selection selection) {
        return this.table.deleteWhere(selection);
    }

    @Override
    public List<String> columnNames() {
        return this.table.columnNames();
    }

    @Override
    public IntIterator iterator() {
        return this.selection.iterator();
    }

    @Override
    public IntIterator reverseIterator() {
        return this.selection.reverseIterator();
    }

    @Override
    public Selection getSelection() {
        return this.selection;
    }

    @Override
    public SnapshotTable toSnapshotTable() {
        SnapshotTable newTable = this.table.emptyCopy(this.selection.size());
        Rows.copyRowsToTable(this.selection, (Snapshot)this, newTable);
        return newTable;
    }

    @Override
    public SnapshotView sortOn(String[] columnNames, Order[] order) {
        SnapshotView view = new SnapshotView(this, new String[0]);
        SReadOnlyIndex index = new SReadOnlyIndex("sort-on-index", this.columns(columnNames), order != null ? Arrays.asList(order) : null);
        index.build(this.getSelection());
        view.setSIndex(index);
        return view;
    }

    @Override
    public SIndex getSIndexForColumns(String[] columnNames) {
        return this.table.getSIndexForColumns(columnNames);
    }
}

