/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.table.SnapshotView;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SnapshotJoiner {
    private JoinType joinType;
    private final Snapshot table;
    private final List<Snapshot> tables;
    private List<String> columnNames;

    public SnapshotJoiner(JoinType joinType, Snapshot table, Snapshot[] tables) {
        this.joinType = joinType;
        this.table = table;
        this.tables = Arrays.asList(tables);
    }

    public SnapshotTable on(String ... columnNames) {
        this.columnNames = Arrays.asList(columnNames);
        this.columnNames.forEach(n -> {
            this.table.column((String)n);
            this.tables.forEach(t -> t.column((String)n));
        });
        switch (this.joinType.ordinal()) {
            case 0: {
                return this.joinInternal(false);
            }
            case 1: {
                return this.joinInternal(true);
            }
            case 2: {
                return this.joinInternalRight();
            }
            case 3: {
                throw new DataspaceException("Full outer join not yet supported.");
            }
        }
        throw new DataspaceException("Invalid join type '" + String.valueOf((Object)this.joinType) + "' specified.");
    }

    private SnapshotTable joinInternal(boolean outer) {
        Snapshot joined = this.table;
        for (Snapshot table2 : this.tables) {
            joined = this.joinInternal(joined, table2, outer);
        }
        return (SnapshotTable)joined;
    }

    private SnapshotTable joinInternal(Snapshot table1, Snapshot table2, boolean outer) {
        SIndex sIndex1 = table1.getSIndexForColumns(this.columnNames.toArray(new String[0]));
        SnapshotView table2Sorted = table2.sortOn(this.columnNames.toArray(new String[0]));
        SIndex sIndex2 = table2Sorted.getSIndexForColumns(this.columnNames.toArray(new String[0]));
        List onColumns1 = this.columnNames.stream().map(n -> table1.column((String)n)).collect(Collectors.toList());
        List onColumns2 = this.columnNames.stream().map(n -> table2Sorted.column((String)n)).collect(Collectors.toList());
        int[] table2ColumnIndexesMap = this.createTable2ColumnIndexesMap(table2Sorted, table1.columnCount());
        SnapshotTable result = SnapshotJoiner.createResultTable(table1, table2, outer, this.columnNames);
        IntComparator comparator = (k1, k2) -> {
            for (int i = 0; i < onColumns1.size(); ++i) {
                int c = ((Column)onColumns1.get(i)).compare(k1, (Column)onColumns2.get(i), k2);
                if (c == 0) continue;
                return c;
            }
            return 0;
        };
        if (sIndex1 == null || !sIndex1.isBuilt()) {
            IntIterator iterator = table1.iterator();
            while (iterator.hasNext()) {
                int row1 = iterator.nextInt();
                SIndex.RowIndex rowIndex2 = this.findFirst(sIndex2, comparator, row1);
                if (rowIndex2 != null) {
                    int row2;
                    while (rowIndex2.hasNext() && comparator.compare(row1, row2 = (rowIndex2 = rowIndex2.next()).currentIndex()) == 0) {
                        this.addJoinedRow(result, table1, table2Sorted, table2ColumnIndexesMap, row1, row2);
                    }
                    continue;
                }
                if (!outer) continue;
                this.addJoinedRowWithMissing(result, table1, table2ColumnIndexesMap, row1);
            }
        } else {
            IntIterator iterator1 = sIndex1.iterator();
            BackIntIterator iterator2 = new BackIntIterator(sIndex2.iterator());
            BitmapBackedSelection selection2 = new BitmapBackedSelection();
            while (iterator1.hasNext()) {
                int row2;
                int row1 = iterator1.nextInt();
                boolean selectionEmpty = true;
                IntIterator selection2Iterator = selection2.iterator();
                if (selection2Iterator.hasNext()) {
                    row2 = selection2Iterator.nextInt();
                    if (comparator.compare(row1, row2) != 0) {
                        selection2.clear();
                    } else {
                        selectionEmpty = false;
                    }
                }
                if (selectionEmpty) {
                    while (iterator2.hasNext()) {
                        row2 = iterator2.nextInt();
                        if (comparator.compare(row1, row2) == 0) {
                            selection2.add(row2);
                            continue;
                        }
                        iterator2.stepback();
                        break;
                    }
                }
                if ((selection2Iterator = selection2.iterator()).hasNext()) {
                    while (selection2Iterator.hasNext()) {
                        this.addJoinedRow(result, table1, table2Sorted, table2ColumnIndexesMap, row1, selection2Iterator.nextInt());
                    }
                    continue;
                }
                if (!outer) continue;
                this.addJoinedRowWithMissing(result, table1, table2ColumnIndexesMap, row1);
            }
        }
        return result;
    }

    private void addJoinedRow(SnapshotTable result, Snapshot table1, SnapshotView table2, int[] table2ColumnIndexesMap, int row1, int row2) {
        int i;
        for (i = 0; i < table1.columnCount(); ++i) {
            result.column(i).append(table1.column(i), row1);
        }
        for (i = 0; i < table2ColumnIndexesMap.length; ++i) {
            int j = table2ColumnIndexesMap[i];
            if (j < 0) continue;
            result.column(j).append(table2.column(i), row2);
        }
    }

    private void addJoinedRowWithMissing(SnapshotTable result, Snapshot table1, int[] table2ColumnIndexesMap, int row1) {
        int i;
        for (i = 0; i < table1.columnCount(); ++i) {
            result.column(i).append(table1.column(i), row1);
        }
        for (i = 0; i < table2ColumnIndexesMap.length; ++i) {
            int j = table2ColumnIndexesMap[i];
            if (j < 0) continue;
            result.column(j).appendMissing();
        }
    }

    private SIndex.RowIndex findFirst(SIndex sIndex, IntComparator comparator, int rowIndex1) {
        SIndex.RowIndexNode rowIndexNode = sIndex.getRowIndexNode();
        int result = -1;
        int xx = rowIndexNode.root();
        int n = -1;
        while (xx != -1) {
            int c = comparator.compare(rowIndex1, rowIndexNode.value(xx));
            if (c == 0) {
                result = xx;
                n = rowIndexNode.left(xx);
            } else if (c < 0) {
                n = rowIndexNode.left(xx);
            } else if (c > 0) {
                n = rowIndexNode.right(xx);
            }
            if (n == -1) break;
            xx = n;
        }
        if (result >= 0) {
            return rowIndexNode.getRowIndex(result);
        }
        return null;
    }

    public static SnapshotTable createResultTable(Snapshot table1, List<Snapshot> tables2, boolean outer, List<String> columnNames) {
        Snapshot result = table1;
        for (Snapshot table2 : tables2) {
            result = SnapshotJoiner.createResultTable(result, table2, outer, columnNames);
        }
        return (SnapshotTable)result;
    }

    public static SnapshotTable createResultTable(Snapshot table1, Snapshot table2, boolean outer, List<String> columnNames) {
        SnapshotTable result = new SnapshotTable(table1.name() + "-join-" + (outer ? "outer-" : "") + table2.name(), new Column[0]);
        for (Column column : table1.columns()) {
            result.addColumn(column.emptyCopy());
        }
        for (Column column : table2.columns()) {
            Object name = column.name();
            if (columnNames.contains(name)) continue;
            if (result.hasColumn((String)name)) {
                name = table2.name() + "-" + (String)name;
            }
            while (result.hasColumn((String)name)) {
                name = (String)name + "1";
            }
            result.addColumn(column.emptyCopy().setName((String)name));
        }
        return result;
    }

    private int[] createTable2ColumnIndexesMap(Snapshot table2, int start) {
        int[] indexes = new int[table2.columnCount()];
        for (int i = 0; i < table2.columnCount(); ++i) {
            indexes[i] = !this.columnNames.contains(table2.column(i).name()) ? start++ : -1;
        }
        return indexes;
    }

    private SnapshotTable joinInternalRight() {
        SnapshotTable joined = null;
        for (Snapshot table2 : this.tables) {
            joined = this.joinInternalRight(table2);
        }
        return joined;
    }

    private SnapshotTable joinInternalRight(Snapshot table2) {
        SnapshotTable leftOuter = table2.joinLeft(this.table).on(this.columnNames.toArray(new String[0]));
        SnapshotTable result = SnapshotTable.create(leftOuter.name());
        for (String name : this.table.columnNames()) {
            result.addColumn(leftOuter.column(name));
        }
        for (String name : table2.columnNames()) {
            if (result.columnNames().contains(name)) continue;
            result.addColumn(leftOuter.column(name));
        }
        return result;
    }

    public static enum JoinType {
        INNER,
        LEFT_OUTER,
        RIGHT_OUTER,
        FULL_OUTER;

    }

    static class BackIntIterator
    implements IntIterator {
        private boolean previousSet = false;
        private int previous = 0;
        private IntIterator iterator;

        public BackIntIterator(IntIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public int nextInt() {
            if (this.previousSet) {
                this.previousSet = false;
                return this.previous;
            }
            this.previous = this.iterator.nextInt();
            return this.previous;
        }

        @Override
        public boolean hasNext() {
            return this.previousSet || this.iterator.hasNext();
        }

        public void stepback() {
            this.previousSet = true;
        }
    }
}

