/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.aggregate.AggregateFunction;
import com.streamscape.ds.stable.aggregate.AggregateFunctionPair;
import com.streamscape.ds.stable.aggregate.Summarizer;
import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DateColumn;
import com.streamscape.ds.stable.columns.DateTimeColumn;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.FloatColumn;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.NumericColumn;
import com.streamscape.ds.stable.columns.ShortColumn;
import com.streamscape.ds.stable.columns.TimeColumn;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.lists.IntArrayList;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.table.DataFrame;
import com.streamscape.ds.stable.table.Filter;
import com.streamscape.ds.stable.table.RowIterator;
import com.streamscape.ds.stable.table.SnapshotJoiner;
import com.streamscape.ds.stable.table.SnapshotRow;
import com.streamscape.ds.stable.table.SnapshotSlice;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.table.SnapshotView;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.DataFramePrinter;
import com.streamscape.ds.stable.utils.Order;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import java.io.ByteArrayOutputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Snapshot {
    public abstract Snapshot setName(String var1);

    @RPLMethod(description="Returns table name.")
    public abstract String name();

    public abstract List<Column> columns();

    public abstract int columnIndex(Column var1);

    public abstract Column column(int var1);

    public abstract Snapshot addColumn(Column ... var1);

    public abstract Snapshot removeColumns(Column ... var1);

    public abstract List<String> columnNames();

    public boolean hasColumn(String columnName) {
        try {
            this.columnIndex(columnName);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasColumn(Column column) {
        try {
            this.columnIndex(column);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @RPLMethod(description="Returns columns count.")
    public abstract int columnCount();

    public ColumnType[] columnTypes() {
        ColumnType[] columnTypes = new ColumnType[this.columnCount()];
        for (int i = 0; i < this.columnCount(); ++i) {
            columnTypes[i] = this.columns().get(i).type();
        }
        return columnTypes;
    }

    public Snapshot removeColumn(int columnIndex) {
        this.removeColumns(this.column(columnIndex));
        return this;
    }

    public Snapshot removeColumns(String ... columnName) {
        Column[] cols = new Column[columnName.length];
        for (int i = 0; i < columnName.length; ++i) {
            cols[i] = this.column(columnName[i]);
        }
        this.removeColumns(cols);
        return this;
    }

    public int columnIndex(String columnName) {
        for (int i = 0; i < this.columnCount(); ++i) {
            if (!this.columnNames().get(i).equalsIgnoreCase(columnName)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column %s is not present in table %s", columnName, this.name()));
    }

    public Column column(String columnName) {
        for (Column column : this.columns()) {
            String name = column.name().trim();
            if (!name.equalsIgnoreCase(columnName)) continue;
            return column;
        }
        throw new IllegalStateException(String.format("Column %s does not exist in table %s", columnName, this.name()));
    }

    public List<Column> columns(String ... columnNames) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String columnName : columnNames) {
            columns.add(this.column(columnName));
        }
        return columns;
    }

    public int[] colWidths() {
        int cols = this.columnCount();
        int[] widths = new int[cols];
        for (int i = 0; i < this.columnCount(); ++i) {
            widths[i] = this.columns().get(i).columnWidth();
        }
        return widths;
    }

    public abstract int deleteWhere(Selection var1);

    public SnapshotTable emptyCopy() {
        SnapshotTable copy = new SnapshotTable(this.name(), new Column[0]);
        for (Column column : this.columns()) {
            copy.addColumn(column.emptyCopy());
        }
        return copy;
    }

    public SnapshotTable emptyCopy(int rowSize) {
        SnapshotTable copy = new SnapshotTable(this.name(), new Column[0]);
        for (Column column : this.columns()) {
            copy.addColumn(column.emptyCopy(rowSize));
        }
        return copy;
    }

    public SnapshotView sortOn(String[] columnNames) {
        return this.sortOn(columnNames, null);
    }

    public abstract SnapshotView sortOn(String[] var1, Order[] var2);

    @RPLMethod(syntax="(<columnName1> [{asc | desc}], ...)", description="Returns table view sorted on specified columns with specified order. Source table is not changed.")
    public SnapshotView orderBy(String[] columnNames, Order[] order) {
        return this.sortOn(columnNames, order);
    }

    public abstract SIndex getSIndexForColumns(String[] var1);

    public Summarizer summarize(String columnName1, AggregateFunction ... functions) {
        return this.summarize(Arrays.asList(functions).stream().map(f -> new AggregateFunctionPair(columnName1, (AggregateFunction)f)).collect(Collectors.toList()));
    }

    @RPLMethod(syntax="(<aggregate function>(<column name>) [as <alias>], ...).by([<columnName1>, ...])", returnType="SnapshotTable", description="Groups rows by specified columns and executes aggregate functions on them.\nIf by columns not specified aggregate functions are executed over all rows.")
    public Summarizer summarize(AggregateFunctionPair ... functionPairs) {
        return new Summarizer(this, functionPairs);
    }

    public Summarizer summarize(List<AggregateFunctionPair> functionPairs) {
        return new Summarizer(this, functionPairs);
    }

    @RPLMethod(syntax="(<rows count>)", description="Returns the snapshot with specified count of first rows.")
    public SnapshotSlice first(int nRows) {
        BitmapBackedSelection newSelection = new BitmapBackedSelection();
        IntIterator iterator = this.iterator();
        while (iterator.hasNext() && nRows-- > 0) {
            newSelection.add(iterator.nextInt());
        }
        return new SnapshotSlice(this, newSelection);
    }

    @RPLMethod(syntax="(<rows count>)", description="Returns the snapshot with specified count of last rows.")
    public SnapshotSlice last(int nRows) {
        BitmapBackedSelection newSelection = new BitmapBackedSelection();
        IntIterator iterator = this.reverseIterator();
        while (iterator.hasNext() && nRows-- > 0) {
            newSelection.add(iterator.nextInt());
        }
        return new SnapshotSlice(this, newSelection);
    }

    @RPLMethod(description="Checks if table is empty or not.")
    public boolean isEmpty() {
        return this.rowCount() == 0;
    }

    @RPLMethod(syntax="(<column name>.<is method name>(...) {and | or | and not} ....)", samples={"myTable.where(age.isGreaterThan(30) and state.isEqualsTo('NY'))"}, description="Returns selection from the table according to the specified selector.")
    public SnapshotSlice where(Selection selection) {
        return new SnapshotSlice(this, selection);
    }

    public SnapshotSlice where(Filter filter) {
        return new SnapshotSlice(this, filter.apply(this));
    }

    @RPLMethod(syntax="(<column name>[.<operation method>(...)] [as <alias>], ....)", samples={"mytable.select(name as EmployeeName, age, salary.multiply(0.6) as slary_net)"}, description="Returns new snapshot table with selected columns from the current snapshot.")
    public SnapshotTable select(Column ... columns) {
        SnapshotTable result = SnapshotTable.create(this.name() + "-select");
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (this.hasColumn(column) || column.getSelection().size() > 0) {
                column = column.trimToSelection();
            }
            result.addColumn(column);
        }
        return result;
    }

    @RPLMethod(description="Returns rows count.")
    public abstract int rowCount();

    public abstract String get(int var1, int var2);

    public BooleanColumn booleanColumn(int columnIndex) {
        return (BooleanColumn)this.column(columnIndex);
    }

    public BooleanColumn booleanColumn(String columnName) {
        return (BooleanColumn)this.column(columnName);
    }

    public NumericColumn numericColumn(int columnIndex) {
        Column c = this.column(columnIndex);
        if (c.type() == ColumnType.CATEGORY) {
            CategoryColumn categoryColumn = (CategoryColumn)c;
            return categoryColumn.toIntColumn();
        }
        if (c.type() == ColumnType.BOOLEAN) {
            BooleanColumn booleanColumn = (BooleanColumn)c;
            return booleanColumn.toIntColumn();
        }
        return (NumericColumn)this.column(columnIndex);
    }

    public NumericColumn numericColumn(String columnName) {
        Column c = this.column(columnName);
        if (c.type() == ColumnType.CATEGORY) {
            CategoryColumn categoryColumn = (CategoryColumn)c;
            return categoryColumn.toIntColumn();
        }
        if (c.type() == ColumnType.BOOLEAN) {
            BooleanColumn booleanColumn = (BooleanColumn)c;
            return booleanColumn.toIntColumn();
        }
        return (NumericColumn)this.column(columnName);
    }

    public FloatColumn floatColumn(int columnIndex) {
        return (FloatColumn)this.column(columnIndex);
    }

    public FloatColumn floatColumn(String columnName) {
        return (FloatColumn)this.column(columnName);
    }

    public DoubleColumn doubleColumn(int columnIndex) {
        return (DoubleColumn)this.column(columnIndex);
    }

    public DoubleColumn doubleColumn(String columnName) {
        return (DoubleColumn)this.column(columnName);
    }

    public IntColumn intColumn(String columnName) {
        return (IntColumn)this.column(columnName);
    }

    public IntColumn intColumn(int columnIndex) {
        return (IntColumn)this.column(columnIndex);
    }

    public ShortColumn shortColumn(String columnName) {
        return (ShortColumn)this.column(columnName);
    }

    public ShortColumn shortColumn(int columnIndex) {
        return (ShortColumn)this.column(columnIndex);
    }

    public LongColumn longColumn(String columnName) {
        return (LongColumn)this.column(columnName);
    }

    public LongColumn longColumn(int columnIndex) {
        return (LongColumn)this.column(columnIndex);
    }

    public DateColumn dateColumn(int columnIndex) {
        return (DateColumn)this.column(columnIndex);
    }

    public DateColumn dateColumn(String columnName) {
        return (DateColumn)this.column(columnName);
    }

    public TimeColumn timeColumn(String columnName) {
        return (TimeColumn)this.column(columnName);
    }

    public TimeColumn timeColumn(int columnIndex) {
        return (TimeColumn)this.column(columnIndex);
    }

    public CategoryColumn categoryColumn(String columnName) {
        return (CategoryColumn)this.column(columnName);
    }

    public CategoryColumn categoryColumn(int columnIndex) {
        return (CategoryColumn)this.column(columnIndex);
    }

    public DateTimeColumn dateTimeColumn(int columnIndex) {
        return (DateTimeColumn)this.column(columnIndex);
    }

    public DateTimeColumn dateTimeColumn(String columnName) {
        return (DateTimeColumn)this.column(columnName);
    }

    public abstract IntIterator iterator();

    public abstract IntIterator reverseIterator();

    @RPLMethod(description="Returns iterator over snapshot rows.", samples={"RowIterator i = mytable.rowIterator();\nwhile(i.hasNext()) {\n   SnapshotRow r = i.next();\n   r.getInt(0);\n   r.getString('id')\n}"})
    public RowIterator rowIterator() {
        return new RowIterator(){
            IntIterator iterator;
            {
                this.iterator = Snapshot.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SnapshotRow next() {
                return new SnapshotRow(Snapshot.this, this.iterator.nextInt());
            }
        };
    }

    public IntIterator iterator(final Selection selection) {
        return new IntIterator(){
            private IntIterator iterator;
            {
                this.iterator = selection.iterator();
            }

            @Override
            public int nextInt() {
                return this.iterator.nextInt();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    public RowIterator rowIterator(final Selection selection) {
        return new RowIterator(){
            private IntIterator iterator;
            {
                this.iterator = selection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SnapshotRow next() {
                return new SnapshotRow(Snapshot.this, this.iterator.next());
            }
        };
    }

    public abstract Selection getSelection();

    @RPLMethod(description="Performs inner join of current table with specified tables.", syntax="(<tablename>,...).on(<columnname>,...)", samples={"orders.join(employees).on(orderId)"}, returnType="SnapshotTable")
    public SnapshotJoiner join(Snapshot ... tables) {
        return new SnapshotJoiner(SnapshotJoiner.JoinType.INNER, this, tables);
    }

    @RPLMethod(description="Performs left outer join of current table with specified tables.", syntax="(<tablename>,...).on(<columnname>,...)", samples={"orders.joinLeft(employees).on(orderId)"}, returnType="SnapshotTable")
    public SnapshotJoiner joinLeft(Snapshot ... tables) {
        return new SnapshotJoiner(SnapshotJoiner.JoinType.LEFT_OUTER, this, tables);
    }

    @RPLMethod(description="Performs right outer join of current table with specified tables.", syntax="(<tablename>,...).on(<columnname>,...)", samples={"orders.joinRight(employees).on(orderId)"}, returnType="SnapshotTable")
    public SnapshotJoiner joinRight(Snapshot ... tables) {
        return new SnapshotJoiner(SnapshotJoiner.JoinType.RIGHT_OUTER, this, tables);
    }

    @RPLMethod(description="Converts SnapshotView or SnapshotSlice to the snapshot table.")
    public abstract SnapshotTable toSnapshotTable();

    @RPLMethod(description="Converts snapshot table to RowSet.")
    public RowSet toRowSet() {
        return this.toRowSet(null);
    }

    public RowSet toRowSet(Session session) {
        IntArrayList dateTimeColumns = new IntArrayList();
        RowMetaData metaData = new RowMetaData();
        for (Column column : this.columns()) {
            SQLType type = null;
            switch (column.type()) {
                case BOOLEAN: {
                    type = SQLType.BOOLEAN;
                    break;
                }
                case CATEGORY: 
                case STRING: {
                    type = SQLType.STRING;
                    break;
                }
                case FLOAT: {
                    type = SQLType.FLOAT;
                    break;
                }
                case DOUBLE: {
                    type = SQLType.DOUBLE;
                    break;
                }
                case SHORT: {
                    type = SQLType.SMALLINT;
                    break;
                }
                case INTEGER: {
                    type = SQLType.INTEGER;
                    break;
                }
                case LONG: {
                    type = SQLType.LONG;
                    break;
                }
                case DECIMAL: {
                    type = SQLType.DECIMAL;
                    break;
                }
                case LOCAL_DATE: {
                    type = SQLType.SQLDATE;
                    dateTimeColumns.add(column.getIndex());
                    break;
                }
                case LOCAL_DATE_TIME: {
                    type = SQLType.SQLTIMESTAMP;
                    dateTimeColumns.add(column.getIndex());
                    break;
                }
                case LOCAL_TIME: {
                    type = SQLType.SQLTIME;
                    dateTimeColumns.add(column.getIndex());
                }
            }
            metaData.addColumn(column.name(), type, true);
        }
        RowSet rowSet = new RowSet(metaData);
        RowIterator rowIterator = this.rowIterator();
        while (rowIterator.hasNext()) {
            try {
                Object[] rowArray = rowIterator.next().getRowArray();
                if (session != null) {
                    IntIterator intIterator = dateTimeColumns.iterator();
                    while (intIterator.hasNext()) {
                        int i = (Integer)intIterator.next();
                        if (rowArray[i] instanceof Timestamp) {
                            rowArray[i] = Type.SQL_TIMESTAMP.convertSQLToJava(session, new TimestampData(((Timestamp)rowArray[i]).getTime()));
                            continue;
                        }
                        if (rowArray[i] instanceof Time) {
                            rowArray[i] = Type.SQL_TIME.convertSQLToJava(session, new TimeData((int)(((Time)rowArray[i]).getTime() / 1000L), 0, 0));
                            continue;
                        }
                        if (!(rowArray[i] instanceof Date)) continue;
                        rowArray[i] = Type.SQL_DATE.convertSQLToJava(session, new TimestampData(((Date)rowArray[i]).getTime()));
                    }
                }
                rowSet.addToRowSet(rowArray);
            }
            catch (SQLException e) {
                throw new DataspaceException(e);
            }
        }
        return rowSet;
    }

    @RPLMethod(description="Converts snapshot table to DataFrame.")
    public DataFrame toDataFrame() {
        DataFrame dataFrame = new DataFrame(this.name(), this.rowCount(), this.columnCount());
        dataFrame.setColumnNames(new ArrayList<String>(this.columnNames()));
        for (int i = 0; i < this.columnCount(); ++i) {
            dataFrame.setColumn(i, this.column(i).toDoubleArray());
        }
        return dataFrame;
    }

    public String toString() {
        return "Table " + this.name() + ": Size = " + this.rowCount() + " x " + this.columnCount();
    }

    public String print(int rowLimit) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataFramePrinter printer = new DataFramePrinter(rowLimit, baos);
        printer.print(this);
        return new String(baos.toByteArray());
    }

    public String print() {
        return this.print(20);
    }

    public SnapshotTable structure() {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("Table: ").append(this.name()).append(" - ").append(this.rowCount()).append(" observations (rows) of ").append(this.columnCount()).append(" variables (cols)");
        SnapshotTable structure = SnapshotTable.create(nameBuilder.toString());
        structure.addColumn(IntColumn.create("Index"));
        structure.addColumn(CategoryColumn.create("Column Name"));
        structure.addColumn(CategoryColumn.create("Type"));
        structure.addColumn(IntColumn.create("Unique Values"));
        structure.addColumn(CategoryColumn.create("First"));
        structure.addColumn(CategoryColumn.create("Last"));
        for (Column column : this.columns()) {
            structure.intColumn("Index").append(this.columnIndex(column));
            structure.categoryColumn("Column Name").append(column.name());
            structure.categoryColumn("Type").append(column.type().name());
            structure.intColumn("Unique Values").append(column.countUnique());
            structure.categoryColumn("First").append(column.first());
            structure.categoryColumn("Last").append(column.getString(column.size() - 1));
        }
        return structure;
    }

    public String summary() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("Table summary for: ").append(this.name()).append("\n");
        for (Column column : this.columns()) {
            builder.append(column.summary().print());
            builder.append("\n");
        }
        builder.append("\n");
        return builder.toString();
    }

    public String shape() {
        return this.rowCount() + " rows X " + this.columnCount() + " cols";
    }
}

