/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.CategoryColumnImpl;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DateColumn;
import com.streamscape.ds.stable.columns.DateTimeColumn;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DecimalColumnUtils;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.FloatColumn;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.ShortColumn;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.columns.TimeColumn;
import com.streamscape.ds.stable.lists.IntArrayList;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.Selection;

public class Rows {
    private Rows() {
    }

    public static void copyRowsToTable(IntArrayList rows, Snapshot oldTable, SnapshotTable newTable) {
        block14: for (int columnIndex = 0; columnIndex < oldTable.columnCount(); ++columnIndex) {
            ColumnType columnType = oldTable.column(columnIndex).type();
            switch (columnType) {
                case FLOAT: {
                    Rows.copy(rows, (FloatColumn)oldTable.column(columnIndex), (FloatColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case INTEGER: {
                    Rows.copy(rows, (IntColumn)oldTable.column(columnIndex), (IntColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case SHORT: {
                    Rows.copy(rows, (ShortColumn)oldTable.column(columnIndex), (ShortColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case LONG: {
                    Rows.copy(rows, (LongColumn)oldTable.column(columnIndex), (LongColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case CATEGORY: {
                    Rows.copy(rows, (CategoryColumn)oldTable.column(columnIndex), (CategoryColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case STRING: {
                    Rows.copy(rows, (StringColumn)oldTable.column(columnIndex), (StringColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case BOOLEAN: {
                    Rows.copy(rows, (BooleanColumn)oldTable.column(columnIndex), (BooleanColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case DOUBLE: {
                    Rows.copy(rows, (DoubleColumn)oldTable.column(columnIndex), (DoubleColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case DECIMAL: {
                    Rows.copy(rows, (DecimalColumn)oldTable.column(columnIndex), (DecimalColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case LOCAL_DATE: {
                    Rows.copy(rows, (DateColumn)oldTable.column(columnIndex), (DateColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case LOCAL_DATE_TIME: {
                    Rows.copy(rows, (DateTimeColumn)oldTable.column(columnIndex), (DateTimeColumn)newTable.column(columnIndex));
                    continue block14;
                }
                case LOCAL_TIME: {
                    Rows.copy(rows, (TimeColumn)oldTable.column(columnIndex), (TimeColumn)newTable.column(columnIndex));
                    continue block14;
                }
                default: {
                    throw new IllegalStateException("Unhandled column type in case statement");
                }
            }
        }
    }

    public static void appendRowToTable(int row, SnapshotTable oldTable, SnapshotTable newTable) {
        IntArrayList rows = new IntArrayList();
        rows.add(row);
        Rows.copyRowsToTable(rows, (Snapshot)oldTable, newTable);
    }

    public static boolean compareRows(int rowInOriginal, SnapshotTable original, SnapshotTable tempTable) {
        block14: for (int columnIndex = 0; columnIndex < original.columnCount(); ++columnIndex) {
            ColumnType columnType = original.column(columnIndex).type();
            switch (columnType) {
                case FLOAT: {
                    boolean result = Rows.compare(rowInOriginal, (FloatColumn)tempTable.column(columnIndex), (FloatColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case DOUBLE: {
                    boolean result = Rows.compare(rowInOriginal, (DoubleColumn)tempTable.column(columnIndex), (DoubleColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case INTEGER: {
                    boolean result = Rows.compare(rowInOriginal, (IntColumn)tempTable.column(columnIndex), (IntColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case SHORT: {
                    boolean result = Rows.compare(rowInOriginal, (ShortColumn)tempTable.column(columnIndex), (ShortColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case LONG: {
                    boolean result = Rows.compare(rowInOriginal, (LongColumn)tempTable.column(columnIndex), (LongColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case DECIMAL: {
                    boolean result = Rows.compare(rowInOriginal, (DecimalColumn)tempTable.column(columnIndex), (DecimalColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case CATEGORY: {
                    boolean result = Rows.compare(rowInOriginal, (CategoryColumn)tempTable.column(columnIndex), (CategoryColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case STRING: {
                    boolean result = Rows.compare(rowInOriginal, (StringColumn)tempTable.column(columnIndex), (StringColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case BOOLEAN: {
                    boolean result = Rows.compare(rowInOriginal, (BooleanColumn)tempTable.column(columnIndex), (BooleanColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case LOCAL_DATE: {
                    boolean result = Rows.compare(rowInOriginal, (DateColumn)tempTable.column(columnIndex), (DateColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case LOCAL_DATE_TIME: {
                    boolean result = Rows.compare(rowInOriginal, (DateTimeColumn)tempTable.column(columnIndex), (DateTimeColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                case LOCAL_TIME: {
                    boolean result = Rows.compare(rowInOriginal, (TimeColumn)tempTable.column(columnIndex), (TimeColumn)original.column(columnIndex));
                    if (result) continue block14;
                    return false;
                }
                default: {
                    throw new RuntimeException("Unhandled column type in case statement");
                }
            }
        }
        return true;
    }

    public static void copyRowsToTable(Selection rows, Snapshot oldTable, SnapshotTable newTable) {
        int[] r = rows.toArray();
        IntArrayList rowArray = new IntArrayList(r);
        Rows.copyRowsToTable(rowArray, oldTable, newTable);
    }

    public static void head(int rowCount, SnapshotTable oldTable, SnapshotTable newTable) {
        IntArrayList rows = new IntArrayList(rowCount);
        int start = 0;
        while (rowCount > 0) {
            if (!oldTable.getDeletedRows().contains(start)) {
                rows.add(start);
                --rowCount;
            }
            ++start;
        }
        Rows.copyRowsToTable(rows, (Snapshot)oldTable, newTable);
    }

    public static void tail(int rowsToInclude, SnapshotTable oldTable, SnapshotTable newTable) {
        IntArrayList rows = new IntArrayList(rowsToInclude);
        for (int start = oldTable.rowCountWithDeleted() - 1; rowsToInclude > 0 && start >= 0; --start) {
            if (oldTable.getDeletedRows().contains(start)) continue;
            rows.add(start);
            --rowsToInclude;
        }
        Rows.copyRowsToTable(rows, (Snapshot)oldTable, newTable);
    }

    private static void copy(IntArrayList rows, FloatColumn oldColumn, FloatColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static void copy(IntArrayList rows, DoubleColumn oldColumn, DoubleColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static void copy(IntArrayList rows, DecimalColumn oldColumn, DecimalColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, FloatColumn tempTable, FloatColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static boolean compare(int row, DoubleColumn tempTable, DoubleColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, CategoryColumn oldColumn, CategoryColumn newColumn) {
        ((CategoryColumnImpl)newColumn).initializeWith(((CategoryColumnImpl)oldColumn).getValues(rows), ((CategoryColumnImpl)oldColumn).dictionaryMap());
    }

    private static void copy(IntArrayList rows, StringColumn oldColumn, StringColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, CategoryColumn tempTable, CategoryColumn original) {
        String t = tempTable.get(tempTable.size() - 1);
        String o = original.get(row);
        return o.equals(t);
    }

    private static boolean compare(int row, StringColumn tempTable, StringColumn original) {
        String t = tempTable.get(tempTable.size() - 1);
        String o = original.get(row);
        return o.equals(t);
    }

    private static void copy(IntArrayList rows, BooleanColumn oldColumn, BooleanColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, BooleanColumn tempTable, BooleanColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, IntColumn oldColumn, IntColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, IntColumn tempTable, IntColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, ShortColumn oldColumn, ShortColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, ShortColumn tempTable, ShortColumn original) {
        short t = tempTable.get(tempTable.size() - 1);
        short o = original.get(row);
        return o == t;
    }

    private static void copy(IntArrayList rows, LongColumn oldColumn, LongColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, LongColumn tempTable, LongColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static boolean compare(int row, DecimalColumn tempTable, DecimalColumn original) {
        return original.getLongUnscaled(row) == DecimalColumnUtils.convertToLongInScale(tempTable.getLongUnscaled(tempTable.size() - 1), original.getScale(), tempTable.getScale());
    }

    private static void copy(IntArrayList rows, DateTimeColumn oldColumn, DateTimeColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.getLong(index));
        }
    }

    private static boolean compare(int row, DateTimeColumn tempTable, DateTimeColumn original) {
        return original.getLong(row) == tempTable.getLong(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, DateColumn oldColumn, DateColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.getLong(index));
        }
    }

    private static boolean compare(int row, DateColumn tempTable, DateColumn original) {
        return original.getLong(row) == tempTable.getLong(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, TimeColumn oldColumn, TimeColumn newColumn) {
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            newColumn.append(oldColumn.getLong(index));
        }
    }

    private static boolean compare(int row, TimeColumn tempTable, TimeColumn original) {
        return original.getLong(row) == tempTable.getLong(tempTable.size() - 1);
    }
}

