/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.DeletedRowsSelection;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.ContinuousSelection;
import com.streamscape.ds.stable.utils.InvertedSelection;
import com.streamscape.ds.stable.utils.Selection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.roaringbitmap.RoaringBitmap;

public class RemovedRowsSelectionImpl
implements DeletedRowsSelection {
    private final SnapshotTable sTable;
    private BitmapBackedSelection selection = new BitmapBackedSelection();
    private int min = -1;
    private int max = -1;
    private int count = 0;

    public RemovedRowsSelectionImpl(SnapshotTable sTable) {
        this.sTable = sTable;
    }

    @Override
    public boolean contains(int x) {
        return this.selection.contains(x);
    }

    @Override
    public int min() {
        return this.min;
    }

    @Override
    public int max() {
        return this.max;
    }

    @Override
    public boolean add(int x) {
        if (this.selection.contains(x)) {
            return false;
        }
        this.selection.add(x);
        ++this.count;
        if (this.min == -1) {
            this.min = x;
        } else if (x < this.min) {
            this.min = x;
        }
        if (this.max == -1) {
            this.max = x;
        } else if (x > this.max) {
            this.max = x;
        }
        return true;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public void reset() {
        this.min = -1;
        this.max = -1;
        this.selection.clear();
        this.count = 0;
    }

    @Override
    public void addAll(DeletedRowsSelection removedRows) {
        IntIterator iterator = removedRows.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.nextInt());
        }
    }

    @Override
    public void serialize(DataOutput dos) throws IOException {
        this.selection.toBitmap().serialize(dos);
    }

    @Override
    public void deserialize(DataInput dis) throws IOException {
        RoaringBitmap bitmapBkp = new RoaringBitmap();
        bitmapBkp.deserialize(dis);
        Iterator iterator = bitmapBkp.iterator();
        while (iterator.hasNext()) {
            this.add((Integer)iterator.next());
        }
    }

    @Override
    public long sizeInMemory() {
        return this.selection.toBitmap().getLongSizeInBytes();
    }

    @Override
    public long sizeOnDisk() {
        return this.selection.toBitmap().serializedSizeInBytes();
    }

    @Override
    public void trimToSize() {
        this.selection.toBitmap().trim();
    }

    @Override
    public Selection getSelection() {
        return this.selection;
    }

    @Override
    public Selection getInvertedSelection() {
        if (this.selection.size() > 0) {
            return new InvertedSelection(this.selection, this.sTable.rowCountWithDeleted());
        }
        return new ContinuousSelection(this.sTable.rowCountWithDeleted());
    }

    @Override
    public IntIterator iterator() {
        return this.selection.iterator();
    }
}

