/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.table;

import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DataFrame {
    private String name;
    private List<String> columnNames;
    private double[][] data;

    public DataFrame() {
    }

    public DataFrame(String name) {
        this.name = name;
    }

    public DataFrame(String name, int rowsCount, int columnsCount) {
        this(name);
        this.data = new double[rowsCount][columnsCount];
    }

    public DataFrame(String name, List<String> columnNames, double[][] data) {
        this.name = name;
        this.columnNames = columnNames;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public DataFrame setName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public DataFrame setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
        return this;
    }

    public double[][] getData() {
        return this.data;
    }

    public double[] getDoubleColumn(String columnName) {
        return this.getDoubleColumn(this.getColumnIndex(columnName));
    }

    public double[] getDoubleColumn(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        double[] result = new double[this.rowCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.data[i][columnIndex];
        }
        return result;
    }

    public int[] getIntColumn(String columnName) {
        return this.getIntColumn(this.getColumnIndex(columnName));
    }

    public int[] getIntColumn(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        int[] result = new int[this.rowCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)this.data[i][columnIndex];
        }
        return result;
    }

    public String[] getStringColumn(String columnName) {
        return this.getStringColumn(this.getColumnIndex(columnName));
    }

    public String[] getStringColumn(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        String[] result = new String[this.rowCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = String.valueOf(this.data[i][columnIndex]);
        }
        return result;
    }

    public DataFrame setData(double[][] data) {
        this.data = data;
        return this;
    }

    public DataFrame set(int rowIndex, int columnIndex, double value) {
        if (rowIndex < 0 || rowIndex >= this.rowCount()) {
            throw new IndexOutOfBoundsException("Row index if out of range " + rowIndex);
        }
        this.checkColumnIndex(columnIndex);
        this.data[rowIndex][columnIndex] = value;
        return this;
    }

    public double get(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.rowCount()) {
            throw new IndexOutOfBoundsException("Row index if out of range " + rowIndex);
        }
        this.checkColumnIndex(columnIndex);
        return this.data[rowIndex][columnIndex];
    }

    public DataFrame setColumn(int columnIndex, double[] column) {
        if (columnIndex < 0 || columnIndex >= this.columnCount()) {
            throw new IndexOutOfBoundsException("Column index is out of range " + columnIndex);
        }
        if (column.length != this.rowCount()) {
            throw new IndexOutOfBoundsException("Invalid length of data, should be '" + this.rowCount());
        }
        for (int i = 0; i < column.length; ++i) {
            this.data[i][columnIndex] = column[i];
        }
        return this;
    }

    public DataFrame setRow(int rowIndex, double[] row) {
        if (rowIndex < 0 || rowIndex >= this.rowCount()) {
            throw new IndexOutOfBoundsException("Row index if out of range " + rowIndex);
        }
        if (row.length != this.columnCount()) {
            throw new IndexOutOfBoundsException("Invalid length of data, should be '" + this.rowCount());
        }
        System.arraycopy(row, 0, this.data[rowIndex], 0, row.length);
        return this;
    }

    public int columnCount() {
        return this.data != null && this.data.length > 0 ? this.data[0].length : 0;
    }

    public int rowCount() {
        return this.data != null ? this.data.length : 0;
    }

    public DataFrame withRowsCount(int newRowsCount) {
        double[][] newData = new double[newRowsCount][this.columnCount()];
        for (int i = 0; i < Math.min(newData.length, this.data.length); ++i) {
            System.arraycopy(this.data[i], 0, newData, 0, this.data[i].length);
        }
        return new DataFrame(this.name, new ArrayList<String>(this.columnNames), newData);
    }

    public RowSet toRowSet() throws SQLException {
        RowMetaData metaData = new RowMetaData();
        for (int i = 0; i < this.columnCount(); ++i) {
            Object columnName = null;
            if (i < this.columnNames.size()) {
                columnName = this.columnNames.get(i);
            }
            if (columnName == null || ((String)columnName).length() == 0) {
                columnName = "C" + i;
            }
            metaData.addColumn((String)columnName, Double.TYPE);
        }
        RowSet rowSet = new RowSet(metaData);
        for (int i = 0; i < this.rowCount(); ++i) {
            Object[] row = new Object[this.columnCount()];
            for (int j = 0; j < this.columnCount(); ++j) {
                row[j] = this.data[i][j];
            }
            rowSet.addToRowSet(row);
        }
        return rowSet;
    }

    public int getColumnIndex(String columnName) {
        int columnIndex = this.columnNames.indexOf(columnName);
        if (columnIndex == -1) {
            throw new IllegalArgumentException("Invalid column name " + columnName);
        }
        return columnIndex;
    }

    private void checkColumnIndex(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnCount()) {
            throw new IndexOutOfBoundsException("Column index is out of range " + columnIndex);
        }
    }
}

