/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.rplmethod;

import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.lib.utils.ClassUtils;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RPLMethodsCacheImpl
implements RPLMethodsCache {
    private Map<Class<?>, List<RPLMethodsCache.RPLMethodInfo>> methods = new HashMap();

    public synchronized void addMethodsForClass(Class<?> clazz) {
        ArrayList<RPLMethodsCache.RPLMethodInfo> list = new ArrayList<RPLMethodsCache.RPLMethodInfo>();
        this.doAddMethodsForClass(clazz, list);
        if (list.size() > 0) {
            this.methods.put(clazz, list);
        }
    }

    public synchronized void doAddMethodsForClass(Class<?> clazz, List<RPLMethodsCache.RPLMethodInfo> list) {
        for (Method method : clazz.getDeclaredMethods()) {
            RPLMethod rplMethod = ClassUtils.getAnnotationOnMethod(method, RPLMethod.class);
            if (rplMethod == null) continue;
            List toRemove = list.stream().filter(info -> info.method().getName().equals(method.getName()) && Arrays.equals(info.method().getParameterTypes(), method.getParameterTypes()) && info.method().getReturnType().isAssignableFrom(method.getReturnType())).collect(Collectors.toList());
            list.removeAll(toRemove);
            list.add(new RPLMethodsCache.RPLMethodInfo(method, rplMethod));
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            this.doAddMethodsForClass(clazz.getSuperclass(), list);
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            this.doAddMethodsForClass((Class<?>)genericDeclaration, list);
        }
    }

    @Override
    public synchronized List<RPLMethodsCache.RPLMethodInfo> lookupMethod(Class<?> parent, String name) {
        ArrayList<RPLMethodsCache.RPLMethodInfo> result = new ArrayList<RPLMethodsCache.RPLMethodInfo>();
        List<RPLMethodsCache.RPLMethodInfo> parentMethods = this.methods.get(parent);
        if (parentMethods != null) {
            for (RPLMethodsCache.RPLMethodInfo methodInfo : parentMethods) {
                if (!methodInfo.name().equals(name)) continue;
                result.add(methodInfo);
            }
        }
        return result;
    }

    @Override
    public synchronized List<RPLMethodsCache.RPLMethodInfo> lookupMethodWithInherited(Class<?> parent, String name) {
        ArrayList<RPLMethodsCache.RPLMethodInfo> result = new ArrayList<RPLMethodsCache.RPLMethodInfo>();
        for (Map.Entry<Class<?>, List<RPLMethodsCache.RPLMethodInfo>> entry : this.methods.entrySet()) {
            if (!parent.isAssignableFrom(entry.getKey())) continue;
            for (RPLMethodsCache.RPLMethodInfo methodInfo : entry.getValue()) {
                if (!methodInfo.name().equals(name)) continue;
                result.add(methodInfo);
            }
        }
        return result;
    }

    @Override
    public synchronized List<RPLMethodsCache.RPLMethodInfo> listMethods(Class<?> parent) {
        ArrayList<RPLMethodsCache.RPLMethodInfo> result = new ArrayList<RPLMethodsCache.RPLMethodInfo>();
        List<RPLMethodsCache.RPLMethodInfo> parentMethods = this.methods.get(parent);
        if (parentMethods != null) {
            result.addAll(parentMethods);
        }
        return result;
    }

    @Override
    public synchronized List<RPLMethodsCache.RPLMethodInfo> listMethodsWithInherited(Class<?> parent) {
        ArrayList<RPLMethodsCache.RPLMethodInfo> result = new ArrayList<RPLMethodsCache.RPLMethodInfo>();
        for (Map.Entry<Class<?>, List<RPLMethodsCache.RPLMethodInfo>> entry : this.methods.entrySet()) {
            if (!parent.isAssignableFrom(entry.getKey())) continue;
            result.addAll((Collection<RPLMethodsCache.RPLMethodInfo>)entry.getValue());
        }
        return result;
    }

    public static RPLMethodsCache.RPLMethodInfo getRPLMethodInfo(Method method) {
        RPLMethod rplMethod = ClassUtils.getAnnotationOnMethod(method, RPLMethod.class);
        return rplMethod != null ? new RPLMethodsCache.RPLMethodInfo(method, rplMethod) : null;
    }
}

