/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.rplmethod;

import com.streamscape.ds.stable.rplmethod.RPLMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public interface RPLMethodsCache {
    public List<RPLMethodInfo> lookupMethod(Class<?> var1, String var2);

    public List<RPLMethodInfo> lookupMethodWithInherited(Class<?> var1, String var2);

    public List<RPLMethodInfo> listMethods(Class<?> var1);

    public List<RPLMethodInfo> listMethodsWithInherited(Class<?> var1);

    public static class RPLMethodInfo {
        private Method method;
        private RPLMethod rplMethod;

        public RPLMethodInfo(Method method, RPLMethod rplMethod) {
            this.method = method;
            this.rplMethod = rplMethod;
        }

        public Method method() {
            return this.method;
        }

        public String name() {
            return this.method.getName();
        }

        public String syntax() {
            return this.rplMethod.syntax();
        }

        public String description() {
            return this.rplMethod.description();
        }

        public String returnType() {
            return this.rplMethod.returnType();
        }

        public List<String> samples() {
            String[] samples = this.rplMethod.samples();
            if (samples == null || samples.length == 0 || samples.length == 1 && (samples[0] == null || samples[0].length() == 0)) {
                return null;
            }
            return new ArrayList<String>(Arrays.asList(samples));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RPLMethodInfo)) {
                return false;
            }
            RPLMethodInfo that = (RPLMethodInfo)o;
            return Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.method);
        }
    }
}

