/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.lists;

import com.streamscape.ds.stable.lists.ArrayUtils;
import com.streamscape.ds.stable.lists.LongIterable;
import com.streamscape.ds.stable.lists.LongIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;

public class LongArrayList
implements RandomAccess,
Cloneable,
Serializable,
LongIterable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_GROW_FACTOR = 1.5f;
    protected float growFactor = 1.5f;
    protected transient long[] a;
    protected int size;

    public LongArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new long[capacity];
    }

    public LongArrayList() {
        this(16);
    }

    public LongArrayList(long[] a) {
        this(a, 0, a.length);
    }

    public LongArrayList(long[] a, int offset, int length) {
        this(length);
        System.arraycopy(a, offset, this.a, 0, length);
        this.size = length;
    }

    public long[] elements() {
        return this.a;
    }

    public static LongArrayList wrap(long[] a, int length) {
        if (length > a.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
        }
        LongArrayList l = new LongArrayList(a);
        l.size = length;
        return l;
    }

    public static LongArrayList wrap(long[] a) {
        return LongArrayList.wrap(a, a.length);
    }

    public void ensureCapacity(int capacity) {
        this.a = LongArrayList.ensureCapacity(this.a, capacity, this.size);
    }

    public float getGrowFactor() {
        return this.growFactor;
    }

    public void setGrowFactor(float growFactor) {
        this.growFactor = growFactor;
    }

    private void grow(int capacity) {
        this.a = LongArrayList.grow(this.a, capacity, this.size, this.growFactor);
    }

    public void add(int index, long k) {
        ArrayUtils.ensureIndex(index, this.size());
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k;
        ++this.size;
    }

    public boolean add(long k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        return true;
    }

    public long getLong(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    public int indexOf(long k) {
        for (int i = 0; i < this.size; ++i) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long k) {
        int i = this.size;
        while (i-- != 0) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    public long removeByIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        return old;
    }

    public boolean rem(long k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeByIndex(index);
        return true;
    }

    public long set(int index, long k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = this.a[index];
        this.a[index] = k;
        return old;
    }

    public void clear() {
        this.size = 0;
        this.a = new long[16];
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.a != null ? this.a.length : 0;
    }

    public void size(int size) {
        if (size > this.a.length) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            Arrays.fill(this.a, this.size, size, 0L);
        }
        this.size = size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n) {
        if (n >= this.a.length || this.size == this.a.length) {
            return;
        }
        long[] t = new long[Math.max(n, this.size)];
        System.arraycopy(this.a, 0, t, 0, this.size);
        this.a = t;
    }

    public void getElements(int from, long[] a, int offset, int length) {
        ArrayUtils.ensureOffsetLength(a.length, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    public void removeElements(int from, int to) {
        ArrayUtils.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    public void addElements(int index, long[] a, int offset, int length) {
        ArrayUtils.ensureIndex(index, this.size());
        ArrayUtils.ensureOffsetLength(a.length, offset, length);
        this.grow(this.size + length);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a, offset, this.a, index, length);
        this.size += length;
    }

    public long[] toArray(long[] a) {
        if (a == null || a.length < this.size) {
            a = new long[this.size];
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    public boolean addAll(int index, LongArrayList c) {
        ArrayUtils.ensureIndex(index, this.size());
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        }
        System.arraycopy(c.a, 0, this.a, index, c.size);
        this.size += n;
        return true;
    }

    public boolean addAll(int index, Collection<? extends Long> c) {
        ArrayUtils.ensureIndex(index, this.size());
        Iterator<? extends Long> i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index++, i.next());
        }
        return retVal;
    }

    public boolean addAll(Collection<? extends Long> c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(LongArrayList c) {
        return this.addAll(this.size(), c);
    }

    public boolean removeAll(LongArrayList c) {
        long[] a = this.a;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(a[i])) continue;
            a[j++] = a[i];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    public boolean removeAll(Collection<?> c) {
        long[] a = this.a;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(a[i])) continue;
            a[j++] = a[i];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    public LongArrayList clone() {
        LongArrayList c = new LongArrayList(this.size);
        System.arraycopy(this.a, 0, c.a, 0, this.size);
        c.size = this.size;
        return c;
    }

    public boolean equals(LongArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        long[] a1 = this.a;
        long[] a2 = l.a;
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(LongArrayList l) {
        int i;
        int s1 = this.size();
        int s2 = l.size();
        long[] a1 = this.a;
        long[] a2 = l.a;
        for (i = 0; i < s1 && i < s2; ++i) {
            long e1 = a1[i];
            long e2 = a2[i];
            int r = Long.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    public boolean contains(long k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public LongIterator iterator() {
        return new LongIterator(){
            private int i = 0;

            @Override
            public long nextLong() {
                return LongArrayList.this.a[this.i++];
            }

            @Override
            public boolean hasNext() {
                return this.i < LongArrayList.this.size();
            }

            @Override
            public Long next() {
                return LongArrayList.this.a[this.i++];
            }
        };
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            s.writeLong(this.a[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.a[i] = s.readLong();
        }
    }

    public static long[] ensureCapacity(long[] array, int length, int preserve) {
        if (length > array.length) {
            long[] t = new long[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static long[] grow(long[] array, int length, int preserve, float growFactor) {
        if (length > array.length) {
            int newLength = (int)Math.max(Math.min(growFactor * (float)array.length, 2.1474836E9f), (float)length);
            long[] t = new long[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public void trimToSize() {
        if (this.a.length != this.size) {
            this.a = Arrays.copyOf(this.a, this.size);
        }
    }
}

