/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.lists;

import com.streamscape.ds.stable.lists.ArrayUtils;
import com.streamscape.ds.stable.lists.IntIterable;
import com.streamscape.ds.stable.lists.IntIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;

public class IntArrayList
implements RandomAccess,
Cloneable,
Serializable,
IntIterable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_GROW_FACTOR = 1.5f;
    protected float growFactor = 1.5f;
    protected int[] a;
    protected int size;

    public IntArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new int[capacity];
    }

    public IntArrayList() {
        this(16);
    }

    public IntArrayList(int[] a) {
        this(a, 0, a.length);
    }

    public IntArrayList(Collection<Integer> c) {
        this(c.size());
        for (Integer i : c) {
            this.add(i);
        }
    }

    public IntArrayList(int[] a, int offset, int length) {
        this(length);
        System.arraycopy(a, offset, this.a, 0, length);
        this.size = length;
    }

    public int[] elements() {
        return this.a;
    }

    public static IntArrayList wrap(int[] a, int length) {
        if (length > a.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
        }
        IntArrayList l = new IntArrayList(a);
        l.size = length;
        return l;
    }

    public static IntArrayList wrap(int[] a) {
        return IntArrayList.wrap(a, a.length);
    }

    public void ensureCapacity(int capacity) {
        this.a = IntArrayList.ensureCapacity(this.a, capacity, this.size);
    }

    public float getGrowFactor() {
        return this.growFactor;
    }

    public void setGrowFactor(float growFactor) {
        this.growFactor = growFactor;
    }

    private void grow(int capacity) {
        this.a = IntArrayList.grow(this.a, capacity, this.size, this.growFactor);
    }

    public void add(int index, int k) {
        ArrayUtils.ensureIndex(index, this.size());
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k;
        ++this.size;
    }

    public boolean add(int k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        return true;
    }

    public int getInt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    public int indexOf(int k) {
        for (int i = 0; i < this.size; ++i) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int k) {
        int i = this.size;
        while (i-- != 0) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    public int removeByIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        int old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        return old;
    }

    public boolean rem(int k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeByIndex(index);
        return true;
    }

    public int set(int index, int k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        int old = this.a[index];
        this.a[index] = k;
        return old;
    }

    public void clear() {
        this.size = 0;
        this.a = new int[16];
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.a != null ? this.a.length : 0;
    }

    public void size(int size) {
        if (size > this.a.length) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            Arrays.fill(this.a, this.size, size, 0);
        }
        this.size = size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n) {
        if (n >= this.a.length || this.size == this.a.length) {
            return;
        }
        int[] t = new int[Math.max(n, this.size)];
        System.arraycopy(this.a, 0, t, 0, this.size);
        this.a = t;
    }

    public void getElements(int from, int[] a, int offset, int length) {
        ArrayUtils.ensureOffsetLength(a.length, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    public void removeElements(int from, int to) {
        ArrayUtils.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    public void addElements(int index, int[] a, int offset, int length) {
        ArrayUtils.ensureIndex(index, this.size());
        ArrayUtils.ensureOffsetLength(a.length, offset, length);
        this.grow(this.size + length);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a, offset, this.a, index, length);
        this.size += length;
    }

    public int[] toArray(int[] a) {
        if (a == null || a.length < this.size) {
            a = new int[this.size];
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    public boolean addAll(int index, IntArrayList c) {
        ArrayUtils.ensureIndex(index, this.size());
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        }
        System.arraycopy(c.a, 0, this.a, index, c.size);
        this.size += n;
        return true;
    }

    public boolean addAll(int index, Collection<? extends Integer> c) {
        ArrayUtils.ensureIndex(index, this.size());
        Iterator<? extends Integer> i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index++, i.next());
        }
        return retVal;
    }

    public boolean addAll(Collection<? extends Integer> c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(IntArrayList c) {
        return this.addAll(this.size(), c);
    }

    public boolean removeAll(IntArrayList c) {
        int[] a = this.a;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(a[i])) continue;
            a[j++] = a[i];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    public boolean removeAll(Collection<?> c) {
        int[] a = this.a;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(a[i])) continue;
            a[j++] = a[i];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    public IntArrayList clone() {
        IntArrayList c = new IntArrayList(this.size);
        System.arraycopy(this.a, 0, c.a, 0, this.size);
        c.size = this.size;
        return c;
    }

    public boolean equals(IntArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        int[] a1 = this.a;
        int[] a2 = l.a;
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(IntArrayList l) {
        int i;
        int s1 = this.size();
        int s2 = l.size();
        int[] a1 = this.a;
        int[] a2 = l.a;
        for (i = 0; i < s1 && i < s2; ++i) {
            int e1 = a1[i];
            int e2 = a2[i];
            int r = Integer.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    public boolean contains(int k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private int i = 0;

            @Override
            public int nextInt() {
                return IntArrayList.this.a[this.i++];
            }

            @Override
            public boolean hasNext() {
                return this.i < IntArrayList.this.size();
            }

            @Override
            public Integer next() {
                return IntArrayList.this.a[this.i++];
            }
        };
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            s.writeInt(this.a[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.a[i] = s.readInt();
        }
    }

    public static int[] ensureCapacity(int[] array, int length, int preserve) {
        if (length > array.length) {
            int[] t = new int[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static int[] grow(int[] array, int length, int preserve) {
        return IntArrayList.grow(array, length, preserve, 2.0f);
    }

    public static int[] grow(int[] array, int length, int preserve, float growFactor) {
        if (length > array.length) {
            int newLength = (int)Math.max(Math.min(growFactor * (float)array.length, 2.1474836E9f), (float)length);
            int[] t = new int[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public void trimToSize() {
        if (this.a.length != this.size) {
            this.a = Arrays.copyOf(this.a, this.size);
        }
    }
}

