/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.lists;

import com.streamscape.ds.stable.lists.DoubleConsumer;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public interface DoubleIterator
extends Iterator<Double> {
    public double nextDouble();

    @Override
    @Deprecated
    default public Double next() {
        return this.nextDouble();
    }

    default public void forEachRemaining(DoubleConsumer action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.nextDouble());
        }
    }

    @Override
    @Deprecated
    default public void forEachRemaining(Consumer<? super Double> action) {
        this.forEachRemaining(action::accept);
    }

    default public int skip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument must be nonnegative: " + n);
        }
        int i = n;
        while (i-- != 0 && this.hasNext()) {
            this.nextDouble();
        }
        return n - i - 1;
    }
}

