/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.index;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.index.AbstractSIndex;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SIndexMetadata;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.DeletedRowsSelection;
import com.streamscape.ds.stable.utils.ArraySort;
import com.streamscape.ds.stable.utils.Order;
import com.streamscape.ds.stable.utils.Selection;
import java.util.Arrays;
import java.util.List;

public class SReadOnlyIndex
extends AbstractSIndex {
    private boolean built;
    private int[] orderArray;

    public SReadOnlyIndex(String name, List<Column> columns) {
        super(name, columns, null);
    }

    public SReadOnlyIndex(String name, List<Column> columns, List<Order> order) {
        super(name, columns, order);
        this.built = false;
    }

    public SReadOnlyIndex(String name, Column ... columns) {
        this(name, Arrays.asList(columns));
    }

    public SReadOnlyIndex(SIndexMetadata metadata) {
        super(metadata);
        this.built = metadata.isBuilt();
        this.orderArray = this.isBuilt() ? new int[metadata.getSize()] : null;
    }

    @Override
    public void build() {
        if (this.built) {
            return;
        }
        if (this.columns.size() > 0) {
            this.orderArray = new int[((Column)this.columns.get(0)).size()];
            for (int i = 0; i < this.orderArray.length; ++i) {
                this.orderArray[i] = i;
            }
            ArraySort.quickSort(this.orderArray, this.getComparator());
        }
        this.built = true;
    }

    @Override
    public void build(Selection selection) {
        if (this.built) {
            return;
        }
        if (this.columns.size() > 0) {
            this.orderArray = new int[selection.size()];
            IntIterator iterator = selection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                this.orderArray[i++] = iterator.nextInt();
            }
            ArraySort.quickSort(this.orderArray, this.getComparator());
        }
        this.built = true;
    }

    @Override
    public void reset() {
        this.orderArray = null;
        this.built = false;
        this.sizeOnDisk = -1L;
    }

    @Override
    public boolean isBuilt() {
        return this.built;
    }

    public int[] getOrderArray() {
        return this.orderArray;
    }

    @Override
    public long sizeInMemoryData() {
        return this.isBuilt() && this.isValid() ? (long)(this.orderArray.length * 4) : 0L;
    }

    @Override
    public long sizeInMemoryFull() {
        return this.orderArray != null ? (long)(this.orderArray.length * 4) : 0L;
    }

    @Override
    public SIndexType getType() {
        return SIndexType.READ_ONLY;
    }

    @Override
    public int size() {
        return this.orderArray != null ? this.orderArray.length : 0;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isPrimaryKey() {
        return false;
    }

    @Override
    public void onColumnDataAppended(int dataIndex) {
        this.reset();
    }

    @Override
    public void onColumnDataRemoved(int dataIndex) {
        this.reset();
    }

    @Override
    public void onColumnDataChanged(int dataIndex) {
        this.reset();
    }

    @Override
    public void onColumnDataCleared() {
        this.sizeOnDisk = -1L;
        if (((Column)this.columns.get(0)).dataSize() == 0) {
            this.orderArray = new int[0];
        } else {
            this.reset();
        }
    }

    @Override
    public SIndex.RowIndexNode getRowIndexNode() {
        if (this.built) {
            return new SReadOnlyRowIndexNode();
        }
        return null;
    }

    @Override
    public void trimToSize() {
        if (!this.built) {
            this.reset();
        }
    }

    @Override
    public void defrag(int[] moveMap, boolean withTrim) {
        if (!this.built) {
            return;
        }
        for (int i = 0; i < this.orderArray.length; ++i) {
            int from = this.orderArray[i];
            int to = moveMap[from];
            if (to <= 0) continue;
            this.orderArray[i] = --to;
        }
        if (withTrim) {
            this.trimToSize();
        }
    }

    private class SReadOnlyRowIndexNode
    implements SIndex.RowIndexNode {
        private int start;
        private int end;

        public SReadOnlyRowIndexNode() {
            if (this.isEmpty()) {
                this.start = -1;
                this.end = -1;
            } else {
                this.start = 0;
                this.end = SReadOnlyIndex.this.orderArray.length;
            }
        }

        @Override
        public int left(int xx) {
            if (this.isEmpty()) {
                return -1;
            }
            if (this.start != xx) {
                this.end = xx;
                return (this.start + xx) / 2;
            }
            return -1;
        }

        @Override
        public int right(int xx) {
            if (this.isEmpty()) {
                return -1;
            }
            if (this.end - 1 != xx) {
                this.start = xx + 1;
                return (this.end + xx) / 2;
            }
            return -1;
        }

        @Override
        public int root() {
            if (this.isEmpty()) {
                return -1;
            }
            return (this.start + this.end) / 2;
        }

        @Override
        public int value(int xx) {
            if (this.isEmpty()) {
                return -1;
            }
            return SReadOnlyIndex.this.orderArray[xx];
        }

        @Override
        public int first() {
            if (this.isEmpty()) {
                return -1;
            }
            return SReadOnlyIndex.this.orderArray.length > 0 ? 0 : -1;
        }

        @Override
        public int last() {
            if (this.isEmpty()) {
                return -1;
            }
            return SReadOnlyIndex.this.orderArray.length > 0 ? SReadOnlyIndex.this.orderArray.length - 1 : -1;
        }

        @Override
        public boolean isEmpty() {
            return SReadOnlyIndex.this.orderArray == null || SReadOnlyIndex.this.orderArray.length == 0;
        }

        @Override
        public SIndex.RowIndex getRowIndex(int xx) {
            if (this.isEmpty()) {
                return new RowIndexSequence(-1, 0, null);
            }
            return new RowIndexArray(xx == -1 ? SReadOnlyIndex.this.orderArray.length - 1 : xx);
        }
    }

    private class RowIndexArray
    extends RowIndexSequence {
        public RowIndexArray(int start) {
            super(start, SReadOnlyIndex.this.orderArray.length, SReadOnlyIndex.this.columns.size() > 0 ? ((Column)SReadOnlyIndex.this.columns.get(0)).getSnapshotTable().getDeletedRows() : null);
        }

        @Override
        protected int index(int x) {
            if (SReadOnlyIndex.this.orderArray == null || this.count < SReadOnlyIndex.this.orderArray.length) {
                return -1;
            }
            return x >= 0 && x < this.count ? SReadOnlyIndex.this.orderArray[x] : -1;
        }
    }

    public static class RowIndexSequence
    implements SIndex.RowIndex {
        protected final int count;
        protected int current;
        protected int next;
        protected int previous;
        private DeletedRowsSelection removedRows;

        public RowIndexSequence(int start, int count, DeletedRowsSelection removedRows) {
            this.count = count;
            this.current = start;
            this.next = start;
            this.previous = start;
            this.removedRows = removedRows;
            if (count == 0 || this.current >= count) {
                this.current = -1;
                this.next = -1;
                this.previous = -1;
            }
            this.hasNext();
        }

        @Override
        public boolean hasNext() {
            if (this.next != -1 && this.removedRows != null && this.removedRows.contains(this.index(this.next))) {
                this.next = -1;
            }
            if (this.next == -1 && this.current != -1) {
                this.next = this.current + 1;
                if (this.next >= this.count) {
                    this.next = -1;
                }
                while (this.next != -1 && this.removedRows != null && this.removedRows.contains(this.index(this.next))) {
                    ++this.next;
                    if (this.next < this.count) continue;
                    this.next = -1;
                }
            }
            return this.next != -1;
        }

        @Override
        public SIndex.RowIndex next() {
            if (!this.hasNext()) {
                return null;
            }
            this.current = this.next;
            this.next = -1;
            this.previous = -1;
            if (this.current == -1) {
                return null;
            }
            return this;
        }

        @Override
        public boolean hasPrevious() {
            if (this.previous != -1 && this.removedRows != null && this.removedRows.contains(this.index(this.previous))) {
                this.previous = -1;
            }
            if (this.previous == -1 && this.current != -1) {
                this.previous = this.current - 1;
                if (this.previous < 0) {
                    this.previous = -1;
                }
                while (this.previous != -1 && this.removedRows != null && this.removedRows.contains(this.index(this.previous))) {
                    --this.previous;
                    if (this.previous >= 0) continue;
                    this.previous = -1;
                }
            }
            return this.previous != -1;
        }

        @Override
        public SIndex.RowIndex previous() {
            if (!this.hasPrevious()) {
                return null;
            }
            this.current = this.previous;
            this.next = -1;
            this.previous = -1;
            if (this.current == -1) {
                return null;
            }
            return this;
        }

        @Override
        public int currentIndex() {
            return this.index(this.current);
        }

        protected int index(int x) {
            return x;
        }
    }
}

