/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.index;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.stable.utils.Order;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SIndexMetadata {
    private final String id;
    private final String name;
    private final boolean built;
    private final List<String> columns = new ArrayList<String>();
    private List<Order> order;
    private final int size;
    private final SIndexType type;
    private final boolean isUnique;
    private final boolean isPrimaryKey;

    public SIndexMetadata(SIndex sIndex) {
        this.id = sIndex.getId();
        this.name = sIndex.getName();
        this.built = sIndex.isBuilt();
        for (Column column : sIndex.getColumns()) {
            this.columns.add(column.name());
        }
        this.size = sIndex.size();
        this.type = sIndex.getType();
        this.isUnique = sIndex.isUnique();
        this.isPrimaryKey = sIndex.isPrimaryKey();
        this.order = new ArrayList<Order>(sIndex.getOrder());
    }

    public String getName() {
        return this.name;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getId() {
        return this.id;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public int getSize() {
        return this.size;
    }

    public SIndexType getType() {
        return this.type;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public List<Order> getOrder() {
        if (this.order == null) {
            this.order = this.columns.stream().map(c -> Order.ASC).collect(Collectors.toList());
        }
        return this.order;
    }
}

