/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.index;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.index.AVLTree;
import com.streamscape.ds.stable.index.AbstractSIndex;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SIndexMetadata;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.Order;
import com.streamscape.ds.stable.utils.Selection;
import java.util.List;

public class SAVLIndex
extends AbstractSIndex {
    private final AVLTree tree = new AVLTree();
    private boolean isPrimaryKey;
    private boolean built;
    private boolean isUnique;

    public SAVLIndex(String name, boolean isPrimaryKey, boolean isUnique, List<Column> columns) {
        this(name, isPrimaryKey, isUnique, columns, null);
    }

    public SAVLIndex(String name, boolean isPrimaryKey, boolean isUnique, List<Column> columns, List<Order> order) {
        super(name, columns, order);
        this.tree.setComparator(this.getComparator());
        this.built = false;
        this.isUnique = isUnique;
        this.isPrimaryKey = isPrimaryKey;
        this.tree.setUnique(this.isUnique);
    }

    public SAVLIndex(SIndexMetadata metadata) {
        super(metadata);
        this.built = metadata.isBuilt();
        this.isUnique = metadata.isUnique();
        this.isPrimaryKey = metadata.isPrimaryKey();
        this.tree.setUnique(this.isUnique);
    }

    @Override
    public void build() {
        if (this.built) {
            return;
        }
        if (this.columns.size() > 0) {
            this.tree.setComparator(this.getComparator());
            int size = ((Column)this.columns.get(0)).size();
            this.tree.allocate(size);
            for (int i = 0; i < size; ++i) {
                this.tree.insert(i);
            }
            this.built = true;
        }
    }

    @Override
    public void build(Selection selection) {
        if (this.built) {
            return;
        }
        if (this.columns.size() > 0) {
            this.tree.setComparator(this.getComparator());
            this.tree.allocate(selection.size());
            IntIterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this.tree.insert(iterator.nextInt());
            }
            this.built = true;
        }
    }

    @Override
    public void reset() {
        this.tree.reset();
        this.built = false;
    }

    @Override
    public boolean isBuilt() {
        return this.built;
    }

    @Override
    public long sizeInMemoryData() {
        return this.tree.sizeInMemoryData();
    }

    @Override
    public long sizeInMemoryFull() {
        return this.tree.sizeInMemoryFull();
    }

    @Override
    public SIndexType getType() {
        return SIndexType.AVL;
    }

    @Override
    public int size() {
        return this.tree.nodesCount();
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    public void trimToSize() {
        if (!this.built) {
            this.reset();
        } else {
            this.tree.trimToSize();
        }
    }

    @Override
    public void defrag(int[] moveMap, boolean withTrim) {
        if (!this.built) {
            this.reset();
        } else {
            this.tree.defrag(moveMap, withTrim);
        }
    }

    @Override
    public void onColumnDataAppended(int dataIndex) {
        block3: {
            this.sizeOnDisk = -1L;
            if (!this.built) {
                return;
            }
            try {
                this.tree.insert(dataIndex);
            }
            catch (DataspaceException exception) {
                if (exception.getErrorCode() != -104) break block3;
                throw Error.error(104, this.getName());
            }
        }
    }

    @Override
    public void onColumnDataRemoved(int dataIndex) {
        this.sizeOnDisk = -1L;
        if (!this.built) {
            return;
        }
        this.tree.delete(dataIndex);
    }

    @Override
    public void onColumnDataChanged(int dataIndex) {
        block3: {
            this.sizeOnDisk = -1L;
            if (!this.built) {
                return;
            }
            this.tree.delete(dataIndex);
            try {
                this.tree.insert(dataIndex);
            }
            catch (DataspaceException exception) {
                if (exception.getErrorCode() != -104) break block3;
                throw Error.error(104, this.getName());
            }
        }
    }

    @Override
    public void onColumnDataCleared() {
        this.sizeOnDisk = -1L;
        this.tree.reset();
        this.built = true;
    }

    public AVLTree getTree() {
        return this.tree;
    }

    @Override
    public void buildColumnsMetadata(SnapshotTable table) {
        super.buildColumnsMetadata(table);
        this.tree.setComparator(this.getComparator());
    }

    @Override
    public SIndex.RowIndexNode getRowIndexNode() {
        if (this.built) {
            return new SAVLRowIndexNode();
        }
        return null;
    }

    class SAVLRowIndexNode
    implements SIndex.RowIndexNode {
        SAVLRowIndexNode() {
        }

        @Override
        public int left(int xx) {
            if (xx == -1) {
                return -1;
            }
            return SAVLIndex.this.tree.getLefts()[xx] - 1;
        }

        @Override
        public int right(int xx) {
            if (xx == -1) {
                return -1;
            }
            return SAVLIndex.this.tree.getRights()[xx] - 1;
        }

        @Override
        public int root() {
            return SAVLIndex.this.tree.getRoot();
        }

        @Override
        public int value(int xx) {
            return xx;
        }

        @Override
        public int first() {
            return SAVLIndex.this.tree.first();
        }

        @Override
        public int last() {
            return SAVLIndex.this.tree.last();
        }

        @Override
        public boolean isEmpty() {
            return SAVLIndex.this.tree.nodesCount() == 0;
        }

        @Override
        public SIndex.RowIndex getRowIndex(int start) {
            return new SAVLRowIndex(SAVLIndex.this, start);
        }
    }

    class SAVLRowIndex
    implements SIndex.RowIndex {
        private final AVLTree.AVLTreeIterator iterator;

        public SAVLRowIndex(SAVLIndex this$0, int start) {
            this.iterator = start == -1 ? this$0.tree.iterator(this$0.tree.last()) : this$0.tree.iterator(start);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SIndex.RowIndex next() {
            if (!this.hasNext()) {
                return null;
            }
            int x = this.iterator.next();
            if (x == -1) {
                return null;
            }
            return this;
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public SIndex.RowIndex previous() {
            if (!this.hasPrevious()) {
                return null;
            }
            int x = this.iterator.previous();
            if (x == -1) {
                return null;
            }
            return this;
        }

        @Override
        public int currentIndex() {
            return this.iterator.current();
        }
    }
}

