/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.index;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SIndexMetadata;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.Order;
import com.streamscape.ds.stable.utils.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class AbstractSIndex
implements SIndex {
    private final String id;
    private String name;
    protected List<String> columnNames = new ArrayList<String>();
    protected List<Column> columns = new ArrayList<Column>();
    protected boolean valid;
    protected long sizeOnDisk = -1L;
    private IntComparator comparator = null;
    private List<Order> order = new ArrayList<Order>();

    public AbstractSIndex(String name, List<Column> columns, List<Order> order) {
        this.id = UUID.randomUUID().toString();
        this.name = name;
        this.columns = new ArrayList<Column>(columns);
        this.columnNames.addAll(columns.stream().map(c -> c.name()).collect(Collectors.toList()));
        this.order = order != null ? order : columns.stream().map(c -> Order.ASC).collect(Collectors.toList());
        this.valid = true;
    }

    public AbstractSIndex(String name, Column ... columns) {
        this(name, Arrays.asList(columns), null);
    }

    public AbstractSIndex(SIndexMetadata metadata) {
        this.id = metadata.getId();
        this.name = metadata.getName();
        this.columns = new ArrayList<Column>();
        this.columnNames.addAll(metadata.getColumns());
        this.valid = true;
        this.order = new ArrayList<Order>(metadata.getOrder());
    }

    @Override
    public abstract void build();

    @Override
    public abstract void build(Selection var1);

    @Override
    public abstract void reset();

    @Override
    public abstract boolean isBuilt();

    @Override
    public abstract long sizeInMemoryData();

    @Override
    public abstract long sizeInMemoryFull();

    @Override
    public abstract SIndexType getType();

    @Override
    public abstract int size();

    @Override
    public abstract boolean isUnique();

    @Override
    public abstract boolean isPrimaryKey();

    @Override
    public void invalidate() {
        this.reset();
        this.valid = false;
        this.comparator = null;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void rename(String name) {
        this.name = name;
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public boolean removeColumn(Column column) {
        boolean deleted = this.columns.remove(column);
        this.columnNames.remove(column.name());
        return deleted;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void buildColumnsMetadata(SnapshotTable table) {
        for (String name : this.columnNames) {
            this.columns.add(table.column(name));
        }
    }

    @Override
    public long sizeOnDisk() {
        return this.sizeOnDisk;
    }

    @Override
    public void setSizeOnDisk(long sizeOnDisk) {
        this.sizeOnDisk = sizeOnDisk;
    }

    @Override
    public List<Order> getOrder() {
        return this.order;
    }

    protected IntComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = this.columns.size() > 1 ? new IntComparator(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    return this.compare((int)i1, (int)i2);
                }

                @Override
                public int compare(int i1, int i2) {
                    for (int i = 0; i < AbstractSIndex.this.columns.size(); ++i) {
                        int result = AbstractSIndex.this.columns.get(i).rowComparator(AbstractSIndex.this.order.get(i)).compare(i1, i2);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            } : this.columns.get(0).rowComparator(this.order.get(0));
        }
        return this.comparator;
    }

    @Override
    public IntIterator iterator() {
        SIndex.RowIndexNode rowIndexNode = this.getRowIndexNode();
        int xx = rowIndexNode.first();
        if (xx == -1) {
            return new IntIterator(this){

                @Override
                public int nextInt() {
                    return -1;
                }

                @Override
                public boolean hasNext() {
                    return false;
                }
            };
        }
        final SIndex.RowIndex rowIndex = rowIndexNode.getRowIndex(xx);
        return new IntIterator(){

            @Override
            public int nextInt() {
                rowIndex.next();
                return rowIndex.currentIndex();
            }

            @Override
            public boolean hasNext() {
                return rowIndex.hasNext();
            }
        };
    }

    @Override
    public IntIterator reverseIterator() {
        SIndex.RowIndexNode rowIndexNode = this.getRowIndexNode();
        int xx = rowIndexNode.last();
        if (xx == -1) {
            return new IntIterator(this){

                @Override
                public int nextInt() {
                    return -1;
                }

                @Override
                public boolean hasNext() {
                    return false;
                }
            };
        }
        final SIndex.RowIndex rowIndex = rowIndexNode.getRowIndex(xx);
        return new IntIterator(){

            @Override
            public int nextInt() {
                rowIndex.previous();
                return rowIndex.currentIndex();
            }

            @Override
            public boolean hasNext() {
                return rowIndex.hasPrevious();
            }
        };
    }

    @Override
    public abstract void onColumnDataRemoved(int var1);

    @Override
    public abstract void onColumnDataAppended(int var1);

    @Override
    public abstract void onColumnDataChanged(int var1);

    @Override
    public abstract void onColumnDataCleared();

    @Override
    public abstract SIndex.RowIndexNode getRowIndexNode();

    @Override
    public abstract void trimToSize();

    @Override
    public abstract void defrag(int[] var1, boolean var2);

    @Override
    public boolean isGoodForColumns(String[] names) {
        if (this.getColumns().size() < names.length) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (this.getColumns().get(i).name().equals(names[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOrder(Order[] order) {
        if (this.order.size() != order.length) {
            return false;
        }
        for (int i = 0; i < order.length; ++i) {
            if (this.order.get(i) == order[i]) continue;
            return false;
        }
        return true;
    }
}

