/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.index;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.stable.lists.IntArrayList;
import com.streamscape.ds.stable.lists.IntComparator;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class AVLTree {
    private static int DEFAULT_INITIAL_CAPACITY = 8;
    private static float DEFAULT_GROW_FACTOR = 1.5f;
    private final int initialCapacity;
    private final float growFactor;
    private IntComparator comparator;
    private int[] parents;
    private int[] lefts;
    private int[] rights;
    private int[] heights;
    private int root = -1;
    private int nodesCount = 0;
    private int size = -1;
    private boolean isUnique = false;

    public AVLTree() {
        this(DEFAULT_INITIAL_CAPACITY, DEFAULT_GROW_FACTOR);
    }

    public AVLTree(int initialCapacity, float growFactor) {
        this.initialCapacity = initialCapacity;
        this.growFactor = growFactor;
        this.reset();
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public void reset() {
        this.parents = new int[this.initialCapacity];
        this.lefts = new int[this.initialCapacity];
        this.rights = new int[this.initialCapacity];
        this.heights = new int[this.initialCapacity];
        this.root = -1;
        this.nodesCount = 0;
        this.size = -1;
    }

    public void setComparator(IntComparator comparator) {
        this.comparator = comparator;
    }

    public int getRoot() {
        return this.root;
    }

    public int height() {
        return this.height(this.root);
    }

    public int nodesCount() {
        return this.nodesCount;
    }

    public int getSize() {
        return this.size >= 0 ? this.size : 0;
    }

    public int find(int k, int r) {
        if (this.root < 0) {
            return this.root;
        }
        if (r < 0) {
            throw new IllegalArgumentException("Root node " + r + " is less than zero.");
        }
        if (r >= this.size) {
            throw new IllegalArgumentException("Root node " + r + " greater than nodes length " + this.size + ".");
        }
        int c = this.compare(k, r);
        if (c < 0) {
            int left = this.lefts[r];
            if (left > 0) {
                return this.find(k, left - 1);
            }
            return r;
        }
        if (c == 0 && this.isUnique) {
            return r;
        }
        int right = this.rights[r];
        if (right > 0) {
            return this.find(k, right - 1);
        }
        return r;
    }

    public int next(int n) {
        if (this.rights[n] > 0) {
            return this.leftDescendant(this.rights[n] - 1);
        }
        if (this.parents[n] > 0 && this.lefts[this.parents[n] - 1] == n + 1) {
            return this.parents[n] - 1;
        }
        int x = this.rightAncestor(n);
        if (this.compare(n, x) < 0) {
            return x;
        }
        return n;
    }

    public int first() {
        return this.leftDescendant(this.root);
    }

    public int last() {
        return this.rightDescendant(this.root);
    }

    public int previous(int n) {
        if (this.lefts[n] > 0) {
            return this.rightDescendant(this.lefts[n] - 1);
        }
        if (this.parents[n] > 0 && this.rights[this.parents[n] - 1] == n + 1) {
            return this.parents[n] - 1;
        }
        int x = this.leftAncestor(n);
        if (this.compare(n, x) > 0) {
            return x;
        }
        return n;
    }

    public int insert(int k) {
        return this.insert(k, this.root);
    }

    public int delete(int n) {
        if (n >= this.size) {
            return -1;
        }
        int nParent = this.parents[n] - 1;
        if (nParent < 0 && n != this.root) {
            return -1;
        }
        int x = this.deleteSimple(n);
        if (x >= 0 && this.lefts[x] > 0) {
            this.rebalance(this.lefts[x] - 1);
        } else if (nParent >= 0) {
            this.rebalance(nParent);
        }
        return x;
    }

    private int leftDescendant(int n) {
        if (n == -1) {
            return -1;
        }
        if (this.lefts[n] > 0) {
            return this.leftDescendant(this.lefts[n] - 1);
        }
        return n;
    }

    private int rightAncestor(int n) {
        if (n == -1) {
            return -1;
        }
        if (this.parents[n] <= 0) {
            return n;
        }
        if (this.compare(n, this.parents[n] - 1) < 0) {
            return this.parents[n] - 1;
        }
        return this.rightAncestor(this.parents[n] - 1);
    }

    private int rightDescendant(int n) {
        if (n == -1) {
            return -1;
        }
        if (this.rights[n] > 0) {
            return this.rightDescendant(this.rights[n] - 1);
        }
        return n;
    }

    private int leftAncestor(int n) {
        if (n == -1) {
            return -1;
        }
        if (this.parents[n] <= 0) {
            return n;
        }
        if (this.compare(n, this.parents[n] - 1) > 0) {
            return this.parents[n] - 1;
        }
        return this.leftAncestor(this.parents[n] - 1);
    }

    private int compare(int k, int r) {
        if (this.isUnique) {
            return this.compare1(k, r);
        }
        return this.compare2(this.compare1(k, r), k, r);
    }

    private int compare1(int k, int r) {
        return this.comparator.compare(k, r);
    }

    private int compare2(int c, int k, int r) {
        if (c == 0 && k != r) {
            c = k < r ? -1 : 1;
        }
        return c;
    }

    private int insertSimple(int k, int r) {
        this.grow(k + 1);
        if (this.root == -1) {
            this.root = k;
            this.parents[this.root] = 0;
            this.lefts[this.root] = 0;
            this.rights[this.root] = 0;
        } else {
            int p = this.find(k, r);
            if (p < 0) {
                throw new IllegalArgumentException("Found parent of " + k + " under " + r + " is less than 0.");
            }
            if (p >= this.size) {
                throw new IllegalArgumentException("Node " + p + " greater than nodes length " + this.size + ".");
            }
            int c = this.compare(k, p);
            if (this.isUnique && c == 0) {
                throw Error.error(104, "duplicate value");
            }
            if (c < 0) {
                this.lefts[p] = k + 1;
                this.parents[k] = p + 1;
            } else {
                this.rights[p] = k + 1;
                this.parents[k] = p + 1;
            }
        }
        ++this.nodesCount;
        this.size = Math.max(this.size, k + 1);
        return k;
    }

    private int nextForDelete(int n) {
        if (this.rights[n] > 0) {
            return this.leftDescendant(this.rights[n] - 1);
        }
        return this.rightAncestor(n);
    }

    private int deleteSimple(int n) {
        if (n < 0 || n >= this.size) {
            return -1;
        }
        int np = this.parents[n] - 1;
        if (np < 0 && n != this.root) {
            return -1;
        }
        int x = -1;
        if (this.rights[n] <= 0) {
            x = this.lefts[n] - 1;
            if (np < 0) {
                this.root = x;
                if (x >= 0) {
                    this.parents[x] = 0;
                }
            } else {
                if (this.lefts[np] - 1 == n) {
                    this.lefts[np] = x + 1;
                } else {
                    this.rights[np] = x + 1;
                }
                if (x >= 0) {
                    this.parents[x] = np + 1;
                }
            }
        } else {
            x = this.nextForDelete(n);
            int xParent = this.parents[x] - 1;
            int y = this.lefts[n] - 1;
            this.parents[x] = np + 1;
            if (this.parents[x] <= 0) {
                this.root = x;
            }
            if (np >= 0) {
                if (this.lefts[np] == n + 1) {
                    this.lefts[np] = x + 1;
                } else if (this.rights[np] == n + 1) {
                    this.rights[np] = x + 1;
                }
            }
            if (y >= 0) {
                this.parents[y] = x + 1;
            }
            this.lefts[x] = y + 1;
            if (x != this.rights[n] - 1) {
                int a = this.rights[n] - 1;
                int b = this.rights[x] - 1;
                int d = xParent;
                this.rights[x] = a + 1;
                this.parents[a] = x + 1;
                if (b >= 0) {
                    this.lefts[d] = b + 1;
                    this.parents[b] = d + 1;
                } else {
                    this.lefts[d] = 0;
                }
            }
        }
        this.parents[n] = 0;
        this.lefts[n] = 0;
        this.rights[n] = 0;
        this.heights[n] = 0;
        --this.nodesCount;
        if (n == this.size - 1) {
            --this.size;
        }
        return x;
    }

    private int insert(int k, int n) {
        if (k >= 0 && k < this.size && (this.parents[k] > 0 || k == n)) {
            throw new IllegalArgumentException("Node '" + k + "' is already in the tree.");
        }
        this.insertSimple(k, n);
        this.rebalance(k);
        return k;
    }

    private void rebalance(int n) {
        int nParent = this.parents[n] - 1;
        if (this.height(this.lefts[n] - 1) > this.height(this.rights[n] - 1) + 1) {
            this.rebalanceRight(n);
        }
        if (this.height(this.rights[n] - 1) > this.height(this.lefts[n] - 1) + 1) {
            this.rebalanceLeft(n);
        }
        this.adjustHeight(n);
        if (nParent >= 0) {
            this.rebalance(nParent);
        }
    }

    private void adjustHeight(int n) {
        if (n < 0) {
            return;
        }
        this.heights[n] = 1 + Math.max(this.height(this.lefts[n] - 1), this.height(this.rights[n] - 1));
    }

    private void rebalanceLeft(int n) {
        int m = this.rights[n] - 1;
        if (this.height(this.rights[m] - 1) < this.height(this.lefts[m] - 1)) {
            this.rotateRight(m);
        }
        this.rotateLeft(n);
        this.adjustHeight(this.lefts[m] - 1);
        this.adjustHeight(this.rights[m] - 1);
        this.adjustHeight(m);
        this.adjustHeight(this.lefts[n] - 1);
        this.adjustHeight(this.rights[n] - 1);
        this.adjustHeight(n);
        if (this.parents[n] > 0) {
            this.adjustHeight(this.lefts[this.parents[n] - 1] - 1);
            this.adjustHeight(this.rights[this.parents[n] - 1] - 1);
            this.adjustHeight(this.parents[n] - 1);
        }
    }

    private void rebalanceRight(int n) {
        int m = this.lefts[n] - 1;
        if (this.height(this.rights[m] - 1) > this.height(this.lefts[m] - 1)) {
            this.rotateLeft(m);
        }
        this.rotateRight(n);
        this.adjustHeight(this.lefts[m] - 1);
        this.adjustHeight(this.rights[m] - 1);
        this.adjustHeight(m);
        this.adjustHeight(this.lefts[n] - 1);
        this.adjustHeight(this.rights[n] - 1);
        this.adjustHeight(n);
        if (this.parents[n] > 0) {
            this.adjustHeight(this.lefts[this.parents[n] - 1] - 1);
            this.adjustHeight(this.rights[this.parents[n] - 1] - 1);
            this.adjustHeight(this.parents[n] - 1);
        }
    }

    private void rotateLeft(int x) {
        int p = this.parents[x] - 1;
        int y = this.rights[x] - 1;
        if (y < 0) {
            return;
        }
        int a = this.lefts[y] - 1;
        if (p >= 0) {
            this.parents[y] = p + 1;
            if (this.lefts[p] == x + 1) {
                this.lefts[p] = y + 1;
            } else {
                this.rights[p] = y + 1;
            }
        } else {
            this.parents[y] = 0;
            this.root = y;
        }
        this.parents[x] = y + 1;
        this.lefts[y] = x + 1;
        if (a >= 0) {
            this.parents[a] = x + 1;
            this.rights[x] = a + 1;
        } else {
            this.rights[x] = 0;
        }
    }

    private void rotateRight(int x) {
        int p = this.parents[x] - 1;
        int y = this.lefts[x] - 1;
        if (y < 0) {
            return;
        }
        int b = this.rights[y] - 1;
        if (p >= 0) {
            this.parents[y] = p + 1;
            if (this.lefts[p] == x + 1) {
                this.lefts[p] = y + 1;
            } else {
                this.rights[p] = y + 1;
            }
        } else {
            this.parents[y] = 0;
            this.root = y;
        }
        this.parents[x] = y + 1;
        this.rights[y] = x + 1;
        if (b >= 0) {
            this.parents[b] = x + 1;
            this.lefts[x] = b + 1;
        } else {
            this.lefts[x] = 0;
        }
    }

    private int height(int k) {
        if (k >= 0) {
            return this.heights[k];
        }
        return 0;
    }

    private void grow(int capacity) {
        if (capacity <= this.parents.length) {
            return;
        }
        int oldLength = this.parents.length;
        int parentsLength = this.parents.length;
        int leftsLength = this.lefts.length;
        int rightsLength = this.rights.length;
        int heightsLength = this.heights.length;
        try {
            this.parents = IntArrayList.grow(this.parents, capacity, this.parents.length, this.growFactor);
            parentsLength = -1;
            this.lefts = IntArrayList.grow(this.lefts, capacity, this.lefts.length, this.growFactor);
            leftsLength = -1;
            this.rights = IntArrayList.grow(this.rights, capacity, this.rights.length, this.growFactor);
            rightsLength = -1;
            this.heights = IntArrayList.grow(this.heights, capacity, this.heights.length, this.growFactor);
            heightsLength = -1;
        }
        catch (Exception exception) {
            if (parentsLength == -1) {
                this.parents = Arrays.copyOf(this.parents, oldLength);
            }
            if (leftsLength == -1) {
                this.lefts = Arrays.copyOf(this.lefts, oldLength);
            }
            if (rightsLength == -1) {
                this.rights = Arrays.copyOf(this.rights, oldLength);
            }
            if (heightsLength == -1) {
                this.heights = Arrays.copyOf(this.heights, oldLength);
            }
            throw exception;
        }
    }

    public void allocate(int capacity) {
        if (capacity <= this.parents.length) {
            return;
        }
        int oldLength = this.parents.length;
        int parentsLength = this.parents.length;
        int leftsLength = this.lefts.length;
        int rightsLength = this.rights.length;
        int heightsLength = this.heights.length;
        try {
            this.parents = IntArrayList.ensureCapacity(this.parents, capacity, this.parents.length);
            parentsLength = -1;
            this.lefts = IntArrayList.ensureCapacity(this.lefts, capacity, this.lefts.length);
            leftsLength = -1;
            this.rights = IntArrayList.ensureCapacity(this.rights, capacity, this.rights.length);
            rightsLength = -1;
            this.heights = IntArrayList.ensureCapacity(this.heights, capacity, this.heights.length);
            heightsLength = -1;
        }
        catch (Exception exception) {
            if (parentsLength == -1) {
                this.parents = Arrays.copyOf(this.parents, oldLength);
            }
            if (leftsLength == -1) {
                this.lefts = Arrays.copyOf(this.lefts, oldLength);
            }
            if (rightsLength == -1) {
                this.rights = Arrays.copyOf(this.rights, oldLength);
            }
            if (heightsLength == -1) {
                this.heights = Arrays.copyOf(this.heights, oldLength);
            }
            throw exception;
        }
    }

    public long sizeInMemoryData() {
        return this.nodesCount >= 0 ? (long)(4 * this.nodesCount) * 4L : 0L;
    }

    public long sizeInMemoryFull() {
        return this.parents != null ? (long)(4 * this.parents.length) * 4L : 0L;
    }

    public int[] getParents() {
        return this.parents;
    }

    public int[] getLefts() {
        return this.lefts;
    }

    public int[] getRights() {
        return this.rights;
    }

    public int[] getHeights() {
        return this.heights;
    }

    public int[] getSettings() {
        return new int[]{this.root, this.nodesCount, this.size, this.isUnique ? 1 : 0};
    }

    public void init(int[] parents, int[] lefts, int[] rights, int[] heights, int[] settings) {
        this.parents = parents;
        this.lefts = lefts;
        this.rights = rights;
        this.heights = heights;
        this.root = settings[0];
        this.nodesCount = settings[1];
        this.size = settings[2];
        this.isUnique = settings[3] != 0;
    }

    public void trimToSize() {
        if (this.size >= this.parents.length) {
            return;
        }
        int maxId = this.size;
        if (maxId <= 0) {
            maxId = 0;
        }
        this.parents = Arrays.copyOf(this.parents, maxId);
        this.lefts = Arrays.copyOf(this.lefts, maxId);
        this.rights = Arrays.copyOf(this.rights, maxId);
        this.heights = Arrays.copyOf(this.heights, maxId);
    }

    public void defrag(int[] moveMap, boolean withTrim) {
        int count = 0;
        this.root = moveMap[this.root] - 1;
        count = Math.max(count, this.root + 1);
        for (int from = 0; from < moveMap.length; ++from) {
            int to = moveMap[from];
            if (to <= 0) continue;
            if (--to != from) {
                this.parents[to] = this.parents[from];
                this.parents[from] = 0;
            }
            if (this.parents[to] > 0) {
                this.parents[to] = moveMap[this.parents[to] - 1];
                count = Math.max(count, to + 1);
            }
            if (to != from) {
                this.lefts[to] = this.lefts[from];
                this.lefts[from] = 0;
            }
            if (this.lefts[to] > 0) {
                this.lefts[to] = moveMap[this.lefts[to] - 1];
            }
            if (to != from) {
                this.rights[to] = this.rights[from];
                this.rights[from] = 0;
            }
            if (this.rights[to] > 0) {
                this.rights[to] = moveMap[this.rights[to] - 1];
            }
            if (to == from) continue;
            this.heights[to] = this.heights[from];
            this.heights[from] = 0;
        }
        this.size = count;
        if (withTrim) {
            this.trimToSize();
        }
    }

    public AVLTreeIterator iterator(int start) {
        return new AVLTreeIterator(start);
    }

    public void bfs(BfsConsumer consumer) {
        this.bfs(this.root, consumer);
    }

    private void bfs(int n, BfsConsumer consumer) {
        if (n == -1) {
            return;
        }
        int[] level = new int[this.parents.length];
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        queue.add(n);
        while (!queue.isEmpty()) {
            n = (Integer)queue.poll();
            if (this.parents[n] > 0) {
                level[n] = level[this.parents[n] - 1] + 1;
            }
            consumer.apply(n, level[n]);
            if (this.lefts[n] > 0) {
                queue.add(this.lefts[n] - 1);
            }
            if (this.rights[n] <= 0) continue;
            queue.add(this.rights[n] - 1);
        }
    }

    public StringBuilder print(StringBuilder builder) {
        return this.print(builder, null);
    }

    public StringBuilder print(StringBuilder builder, Function<Integer, Object> getter) {
        new Printer(builder, getter).print();
        return builder;
    }

    public String print() {
        return this.print((Function<Integer, Object>)null);
    }

    public String print(Function<Integer, Object> getter) {
        return this.print(new StringBuilder(), getter).toString();
    }

    public StringBuilder printAll(StringBuilder builder, Function<Integer, Object> getter) {
        StringBuilder indexesBuilder = new StringBuilder();
        new Printer(indexesBuilder, null).print();
        StringBuilder valuesBuilder = new StringBuilder();
        new Printer(valuesBuilder, getter).print();
        try {
            String s = null;
            int maxLineLength = 0;
            BufferedReader indexReader = new BufferedReader(new StringReader(indexesBuilder.toString()));
            while ((s = indexReader.readLine()) != null) {
                maxLineLength = Math.max(maxLineLength, s.length());
            }
            indexReader = new BufferedReader(new StringReader(indexesBuilder.toString()));
            BufferedReader valuesReader = new BufferedReader(new StringReader(valuesBuilder.toString()));
            while ((s = indexReader.readLine()) != null) {
                int i;
                builder.append(s);
                for (i = 0; i < maxLineLength - s.length() + 2; ++i) {
                    builder.append(" ");
                }
                builder.append("|");
                for (i = 0; i < 2; ++i) {
                    builder.append(" ");
                }
                s = valuesReader.readLine();
                builder.append(s).append("\n");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return builder;
    }

    public String printAll(Function<Integer, Object> getter) {
        return this.printAll(new StringBuilder(), getter).toString();
    }

    public static void main(String[] args) {
        AVLTree[] tree = new AVLTree[1];
        int[] array = new int[100];
        Function<Integer, Object> getter = i -> array[i];
        Runnable printIterator = () -> {
            Consumer<Integer> printValue = value -> {
                String s = String.valueOf(value);
                if (s.length() < 2) {
                    System.out.print("0");
                }
                System.out.print(s + " ");
            };
            System.out.print("DIRECT : ");
            AVLTreeIterator iterator = tree[0].iterator(tree[0].leftDescendant(tree[0].root));
            while (iterator.hasNext()) {
                printValue.accept(iterator.next());
            }
            System.out.print(" | ");
            iterator = tree[0].iterator(tree[0].leftDescendant(tree[0].root));
            while (iterator.hasNext()) {
                printValue.accept((Integer)getter.apply(iterator.next()));
            }
            System.out.println();
            System.out.print("REVERSE: ");
            iterator = tree[0].iterator(tree[0].rightDescendant(tree[0].root));
            while (iterator.hasPrevious()) {
                printValue.accept(iterator.previous());
            }
            System.out.print(" | ");
            iterator = tree[0].iterator(tree[0].rightDescendant(tree[0].root));
            while (iterator.hasPrevious()) {
                printValue.accept((Integer)getter.apply(iterator.previous()));
            }
            System.out.println();
        };
        BiConsumer<Integer, Integer> add = (i, v) -> {
            System.out.println("Adding value " + v + " at index " + i + ":");
            array[i.intValue()] = v;
            tree[0].insert((int)i);
            System.out.println("height: " + tree[0].height() + ", count: " + tree[0].nodesCount());
            System.out.println(tree[0].printAll(getter));
            printIterator.run();
            System.out.println();
        };
        Consumer<Integer> delete = i -> {
            System.out.println("Removing value " + array[i] + " at index " + i + ":");
            tree[0].delete((int)i);
            System.out.println("height: " + tree[0].height() + ", count: " + tree[0].nodesCount());
            System.out.println(tree[0].printAll(getter));
            printIterator.run();
            System.out.println();
        };
        tree[0] = new AVLTree();
        tree[0].setUnique(false);
        tree[0].setComparator((i, j) -> Integer.compare(array[i], array[j]));
        add.accept(0, 0);
        add.accept(1, 1);
        add.accept(2, 2);
        add.accept(3, 3);
        add.accept(4, 4);
        add.accept(5, 5);
        add.accept(6, 6);
        add.accept(7, 7);
        add.accept(8, 8);
        add.accept(9, 9);
        delete.accept(4);
        delete.accept(5);
        delete.accept(6);
        System.out.println("After defrag:");
        System.out.println("height: " + tree[0].height() + ", count: " + tree[0].nodesCount());
        System.out.println(tree[0].printAll(getter));
        printIterator.run();
        System.out.println();
        tree[0] = new AVLTree();
        tree[0].setUnique(true);
        tree[0].setComparator((i, j) -> Integer.compare(array[i], array[j]));
        add.accept(0, 0);
        add.accept(1, 1);
        add.accept(2, 2);
        add.accept(3, 3);
        add.accept(4, 4);
        add.accept(5, 5);
        add.accept(6, 6);
        add.accept(7, 7);
        add.accept(8, 8);
        add.accept(9, 9);
        tree[0] = new AVLTree();
        tree[0].setComparator((i, j) -> Integer.compare(array[i], array[j]));
        add.accept(0, 50);
        add.accept(1, 20);
        add.accept(2, 30);
        add.accept(3, 10);
        add.accept(4, 11);
        add.accept(5, 11);
        add.accept(6, 11);
        add.accept(7, 22);
        add.accept(8, 55);
        add.accept(9, 9);
        add.accept(10, 13);
        add.accept(11, 56);
        add.accept(12, 57);
        add.accept(13, 11);
        add.accept(14, 11);
        delete.accept(0);
        delete.accept(3);
        delete.accept(5);
        delete.accept(13);
        delete.accept(8);
        delete.accept(1);
        delete.accept(7);
        delete.accept(6);
        delete.accept(14);
        delete.accept(4);
        delete.accept(2);
        delete.accept(12);
        delete.accept(10);
        delete.accept(11);
        delete.accept(9);
    }

    public class AVLTreeIterator {
        private int current;
        private int next = -1;
        private int previous = -1;

        public AVLTreeIterator(int start) {
            this.current = start;
            this.next = start;
            this.previous = start;
        }

        public boolean hasNext() {
            if (this.next == -1 && this.current != -1) {
                this.next = AVLTree.this.next(this.current);
                if (this.next == this.current) {
                    this.next = -1;
                }
            }
            return this.next != -1;
        }

        public int next() {
            this.current = this.next;
            this.next = -1;
            this.previous = -1;
            return this.current;
        }

        public boolean hasPrevious() {
            if (this.previous == -1 && this.current != -1) {
                this.previous = AVLTree.this.previous(this.current);
                if (this.previous == this.current) {
                    this.previous = -1;
                }
            }
            return this.previous != -1;
        }

        public int previous() {
            this.current = this.previous;
            this.next = -1;
            this.previous = -1;
            return this.current;
        }

        public int current() {
            return this.current;
        }
    }

    static interface BfsConsumer {
        public void apply(int var1, int var2);
    }

    class Printer {
        private final StringBuilder builder;
        private Function<Integer, Object> getter;
        private final int[] offsets;
        private final int h;

        public Printer(StringBuilder builder, Function<Integer, Object> getter) {
            this.offsets = new int[AVLTree.this.parents.length];
            this.h = AVLTree.this.height();
            this.builder = builder;
            this.getter = getter;
        }

        private void print() {
            if (AVLTree.this.root < 0) {
                this.builder.append("empty");
                return;
            }
            int lowWidth = (int)(Math.pow(2.0, this.h - 1) * 3.0) - 1;
            int[] currentLevel = new int[]{0};
            int[] currentPosition = new int[]{1};
            ArrayList currentLevelNodes = new ArrayList();
            AVLTree.this.bfs((n, level) -> {
                if (level == 0) {
                    this.offsets[n] = (lowWidth + 1) / 2;
                    this.appendAt(this.offsets[n], 1, n);
                    currentLevelNodes.add(n);
                    return;
                }
                if (level != currentLevel[0]) {
                    this.appendNewLine();
                    this.printLinks(level, currentLevelNodes);
                    currentLevel[0] = level;
                    currentLevelNodes.clear();
                    currentPosition[0] = 1;
                }
                int nParent = AVLTree.this.parents[n] - 1;
                int offsetWidth = (int)((double)(lowWidth + 1) / Math.pow(2.0, level));
                int nOffset = 0;
                if (n == AVLTree.this.lefts[nParent] - 1) {
                    offsetWidth = offsetWidth % 2 == 0 ? (offsetWidth /= 2) : offsetWidth / 2 + 1;
                    nOffset = this.offsets[nParent] - offsetWidth;
                } else {
                    nOffset = this.offsets[nParent] + (offsetWidth /= 2);
                }
                this.appendAt(nOffset, currentPosition[0], n);
                this.offsets[n] = nOffset;
                currentPosition[0] = nOffset + 2;
                currentLevelNodes.add(n);
            });
        }

        private void printLinks(int level, List<Integer> currentLevelNodes) {
            int lines = 0;
            lines = this.h - level <= 2 ? (int)Math.pow(2.0, this.h - level) - 1 : (int)Math.pow(2.0, this.h - level) - (this.h - level) + level - 1;
            for (int line = 0; line < lines; ++line) {
                int position = 1;
                for (int node : currentLevelNodes) {
                    int nodePosition = this.offsets[node];
                    int linkPosition = 0;
                    String link = null;
                    if (AVLTree.this.lefts[node] > 0) {
                        linkPosition = nodePosition - line - (lines > 1 ? 0 : 1);
                        link = "/";
                        this.appendSpaces(linkPosition - position);
                        this.builder.append(link);
                        position = linkPosition + 1;
                    }
                    if (AVLTree.this.rights[node] <= 0) continue;
                    linkPosition = nodePosition + 1 + line;
                    link = "\\";
                    this.appendSpaces(linkPosition - position);
                    this.builder.append(link);
                    position = linkPosition + 1;
                }
                this.appendNewLine();
            }
        }

        private void appendSpaces(int count) {
            while (count-- > 0) {
                this.builder.append(" ");
            }
        }

        private void appendNewLine() {
            this.builder.append("\n");
        }

        private void appendAt(int offset, int position, int n) {
            Object ns = "";
            ns = this.getter != null ? String.valueOf(this.getter.apply(n)) : String.valueOf(n);
            while (((String)ns).length() < 2) {
                ns = "0" + (String)ns;
            }
            while (offset-- > position) {
                this.builder.append(" ");
            }
            this.builder.append((String)ns);
        }
    }
}

