/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.columns.TimeColumn;
import com.streamscape.ds.stable.columns.TimeColumnWrapper;
import com.streamscape.ds.stable.filtering.LongBiPredicate;
import com.streamscape.ds.stable.filtering.LongPredicate;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.lists.LongArrayList;
import com.streamscape.ds.stable.lists.LongIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TimeColumnImpl
extends AbstractColumn
implements TimeColumn {
    public static final long MISSING_VALUE = (Long)ColumnType.LOCAL_TIME.getMissingValue();
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 8;
    private LongArrayList data;
    private final IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        @Override
        public int compare(int i1, int i2) {
            return TimeColumnImpl.this.compare(TimeColumnImpl.this.getLongInternal(i1), TimeColumnImpl.this.getLongInternal(i2));
        }
    };
    private DateTimeFormatter selectedFormatter;
    public static LongPredicate isMissing = i -> i == MISSING_VALUE;
    public static LongPredicate isNotMissing = i -> i != MISSING_VALUE;
    public static LongBiPredicate isGreaterThan = (valueToTest, valueToCompareAgainst) -> valueToTest > valueToCompareAgainst;
    public static LongBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    public static LongBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    public static LongBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    public static LongBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;

    public TimeColumnImpl(String name) {
        this(name, new LongArrayList(128));
    }

    public TimeColumnImpl(String name, int initialSize) {
        this(name, new LongArrayList(initialSize));
    }

    public TimeColumnImpl(String name, List<LocalTime> data) {
        this(name);
        for (LocalTime time : data) {
            this.append(time);
        }
    }

    private TimeColumnImpl(String name, LongArrayList data) {
        super(name);
        this.data = data;
    }

    public TimeColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.data = new LongArrayList(128);
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.LOCAL_TIME;
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create("Column: " + this.name());
        CategoryColumn measure = CategoryColumn.create("Measure");
        CategoryColumn value = CategoryColumn.create("Value");
        table.addColumn(measure);
        table.addColumn(value);
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        measure.append("Earliest");
        value.append(String.valueOf(this.min()));
        measure.append("Latest");
        value.append(String.valueOf(this.max()));
        return table;
    }

    private void appendInternal(long f) {
        this.data.add(f);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void set(int index, long value) {
        this.data.set(index, value);
        this.onDataChanged(index);
    }

    @Override
    public void set(int index, LocalTime value) {
        this.set(index, TimeColumnImpl.localTimeToLong(value));
    }

    @Override
    public void set(int index, Time t) {
        this.set(index, t.toLocalTime().toSecondOfDay() * 1000);
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getLong(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public void append(LocalTime f) {
        this.appendInternal(TimeColumnImpl.localTimeToLong(f));
    }

    @Override
    public void append(long f) {
        this.appendInternal(f);
    }

    @Override
    public void append(Time t) {
        this.appendInternal(t.toLocalTime().toSecondOfDay() * 1000);
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getLong(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(this.getMissingValue());
    }

    @Override
    public void assignWithValue(LocalTime f) {
        this.assignWithValue(TimeColumnImpl.localTimeToLong(f));
    }

    @Override
    public void assignWithValue(Time t) {
        this.assignWithValue(t.toLocalTime().toSecondOfDay() * 1000);
    }

    @Override
    public void assignWithValue(Object object) {
        this.assignWithValue(this.convert(object));
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(this.convert(object), size);
    }

    @Override
    public void assignWithValue(long value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(LocalTime f, int size) {
        this.fillWithValue(TimeColumnImpl.localTimeToLong(f), size);
    }

    @Override
    public void fillWithValue(Time t, int size) {
        this.fillWithValue(t.toLocalTime().toSecondOfDay() * 1000, size);
    }

    @Override
    public void fillWithValue(long value, int size) {
        for (int i = 0; i < size; ++i) {
            this.append(value);
        }
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        long[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            long tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public void set(LocalTime newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void appendObject(Object object) {
        this.appendInternal(this.convert(object));
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public void setObject(int index, Object object) {
        this.set(index, this.convert(object));
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, this.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        throw new UnsupportedOperationException("Time.setInt");
    }

    @Override
    public void setShort(int row, short value) {
        throw new UnsupportedOperationException("Time.setShort");
    }

    @Override
    public void setLong(int row, long value) {
        this.set(row, value);
    }

    @Override
    public void setFloat(int row, float value) {
        throw new UnsupportedOperationException("Time.setFloat");
    }

    @Override
    public void setDouble(int row, double value) {
        throw new UnsupportedOperationException("Time.setDouble");
    }

    @Override
    public void setBoolean(int row, boolean value) {
        throw new UnsupportedOperationException("Time.setBoolean");
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        TimeColumn longColumn = (TimeColumn)column;
        for (int i = 0; i < longColumn.size(); ++i) {
            this.appendInternal(longColumn.getLong(i));
        }
    }

    @Override
    public LongArrayList data() {
        return this.data;
    }

    @Override
    public String getString(int row) {
        return TimeColumnImpl.toTimeString(this.getLongInternal(row));
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int row) {
        return this.getLongInternal(row);
    }

    @Override
    public float getFloat(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing(int row) {
        return this.isMissingValue(this.getLong(row));
    }

    @Override
    public long min(Selection selection) {
        long min = -1L;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            long next = this.getLong(iterator.nextInt());
            if (this.isMissingValue(next) || next >= min) continue;
            min = next;
        }
        if (min == -1L) {
            min = MISSING_VALUE;
        }
        return min;
    }

    @Override
    public long max(Selection selection) {
        long max = Long.MAX_VALUE;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            long next = this.getLong(iterator.nextInt());
            if (this.isMissingValue(next) || next <= max) continue;
            max = next;
        }
        if (max == Long.MAX_VALUE) {
            max = MISSING_VALUE;
        }
        return max;
    }

    @Override
    public long firstElement(Selection selection) {
        IntIterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            return this.getLongInternal(iterator.nextInt());
        }
        return MISSING_VALUE;
    }

    @Override
    public Time get(int index) {
        if (this.isMissing(index)) {
            return null;
        }
        return new Time(this.getLongInternal(index));
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    private long getLongInternal(int index) {
        return this.data.getLong(index);
    }

    private boolean isMissingValue(long l) {
        return l == MISSING_VALUE;
    }

    public long getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public boolean contains(LocalTime localTime) {
        long time = TimeColumnImpl.localTimeToLong(localTime);
        return this.data().contains(time);
    }

    @Override
    public int byteSize() {
        return 8;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(8).putLong(this.getLongInternal(rowNumber)).array();
    }

    @Override
    public List<LocalTime> asList() {
        ArrayList<LocalTime> times = new ArrayList<LocalTime>(this.size());
        Iterator<LocalTime> iter = this.iterator();
        while (iter.hasNext()) {
            times.add(iter.next());
        }
        return times;
    }

    @Override
    public TimeColumn select(Selection selection) {
        IntIterator iterator = selection.iterator();
        TimeColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public TimeColumn selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        TimeColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.getLong(row));
        }
        return result;
    }

    @Override
    public TimeColumn emptyCopy() {
        TimeColumn column = TimeColumn.create(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public TimeColumn emptyCopy(int rowSize) {
        TimeColumn column = TimeColumn.create(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public TimeColumn copy() {
        TimeColumnImpl column = new TimeColumnImpl(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public TimeColumn trimToSelection(Selection selection) {
        TimeColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.getLong(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public LongArrayList top(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList top = new LongArrayList();
        for (int i = result.data().size() - 1; i >= result.data().size() - n - 1 && i >= 0; --i) {
            top.add(result.get(i));
        }
        return top;
    }

    @Override
    public LongArrayList bottom(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList bottom = new LongArrayList();
        for (int i = 0; i < n && i < result.data().size(); ++i) {
            bottom.add(result.get(i));
        }
        return bottom;
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isEqualTo(LocalTime value, Selection selection) {
        long packed = TimeColumnImpl.localTimeToLong(value);
        return this.select(LongColumnImpl.isEqualTo, packed, selection);
    }

    @Override
    public Selection isEqualTo(TimeColumnImpl f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data.size()) {
            if (this.data.elements()[i] != f.data.elements()[i]) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.select(isMissing, selection);
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.select(isNotMissing, selection);
    }

    @Override
    public Selection select(LongPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            long next = this.data.getLong(idx);
            if (!predicate.test(next)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public Selection select(LongBiPredicate predicate, long value, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            long next = this.data.getLong(idx);
            if (!predicate.test(next, value)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getLong(row1), column2.getLong(row2));
    }

    private int compare(long v1, long v2) {
        if (v1 == v2) {
            return 0;
        }
        if (this.isMissingValue(v1)) {
            return -1;
        }
        if (this.isMissingValue(v2)) {
            return 1;
        }
        return Long.compare(v1, v2);
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        LongIterator longIterator = this.data.iterator();
        while (longIterator.hasNext()) {
            long next = (Long)longIterator.next();
            builder.append(String.valueOf(TimeColumnImpl.toTimeString(next)));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "LocalTime column: " + this.name();
    }

    @Override
    public Iterator<LocalTime> iterator(final Selection selection) {
        return new Iterator<LocalTime>(){
            private IntIterator iterator;
            {
                this.iterator = selection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public LocalTime next() {
                return TimeColumnImpl.longToLocalTime(TimeColumnImpl.this.data.getLong(this.iterator.nextInt()));
            }
        };
    }

    public long convert(String value) {
        LocalTime time;
        if (TypeUtils.isNullOrEmpty((String)value) || TypeUtils.MISSING_INDICATORS.contains(value) || ((String)value).equals("-1")) {
            return (Long)ColumnType.LOCAL_TIME.getMissingValue();
        }
        while (((String)value).length() < 4) {
            value = (String)value + "0";
        }
        if (this.selectedFormatter == null) {
            this.selectedFormatter = TypeUtils.getTimeFormatter((String)value);
        }
        try {
            time = LocalTime.parse((CharSequence)value, this.selectedFormatter);
        }
        catch (DateTimeParseException e) {
            this.selectedFormatter = TypeUtils.TIME_FORMATTER;
            time = LocalTime.parse((CharSequence)value, this.selectedFormatter);
        }
        return TimeColumnImpl.localTimeToLong(time);
    }

    public long convert(Object objectValue) {
        if (objectValue == null || objectValue instanceof String) {
            return this.convert((String)objectValue);
        }
        if (objectValue instanceof Number) {
            return ((Number)objectValue).longValue();
        }
        if (objectValue instanceof Time) {
            return ((Time)objectValue).getTime();
        }
        if (objectValue instanceof LocalTime) {
            return TimeColumnImpl.localTimeToLong((LocalTime)objectValue);
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + String.valueOf(objectValue) + " to Time");
    }

    public static long localTimeToLong(LocalTime value) {
        return value.toSecondOfDay() * 1000 + value.getNano();
    }

    public static String toTimeString(long value) {
        return TimeColumnImpl.longToLocalTime(value).toString();
    }

    public static LocalTime longToLocalTime(long value) {
        return LocalTime.ofSecondOfDay(value / 1000L).plusNanos(value % 1000L);
    }

    @Override
    public TimeColumn wrap(Selection selection) {
        return new TimeColumnWrapper(this, selection);
    }
}

