/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.Trace;
import com.streamscape.ds.stable.columns.AbstractStringColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.columns.StringColumnWrapper;
import com.streamscape.ds.stable.filtering.StringPredicate;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

public class StringColumnImpl
extends AbstractStringColumn
implements StringColumn {
    public static final String MISSING_VALUE = (String)((Object)ColumnType.STRING.getMissingValue());
    private static final int BYTE_SIZE = 4;
    private static int DEFAULT_ARRAY_SIZE = 128;
    private List<String> data;
    private static Field elementDataField;

    public StringColumnImpl(String name) {
        super(name);
        this.data = new ArrayList<String>(DEFAULT_ARRAY_SIZE);
    }

    public StringColumnImpl(String name, String[] strings) {
        this(name, Arrays.asList(strings));
    }

    public StringColumnImpl(String name, Collection<String> strings) {
        super(name);
        this.data = new ArrayList<String>(strings);
    }

    public StringColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.data = new ArrayList<String>(DEFAULT_ARRAY_SIZE);
    }

    public StringColumnImpl(String name, int size) {
        super(name);
        this.data = new ArrayList<String>(size);
    }

    @Override
    public ColumnType type() {
        return ColumnType.STRING;
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.size() : 0;
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create(this.name());
        CategoryColumn nameColumn = CategoryColumn.create("Property");
        IntColumn valueColumn = IntColumn.create("Value");
        table.addColumn(nameColumn);
        table.addColumn(valueColumn);
        nameColumn.append("Size");
        valueColumn.append(this.size());
        return table;
    }

    @Override
    public void clear() {
        this.data = new ArrayList<String>(DEFAULT_ARRAY_SIZE);
        this.onDataCleared();
    }

    @Override
    public void set(int rowIndex, String stringValue) {
        if (stringValue == null) {
            stringValue = MISSING_VALUE;
        }
        this.data.set(rowIndex, stringValue);
        this.onDataChanged(rowIndex);
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.remove(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.get(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.remove(this.data.size() - 1);
        }
    }

    @Override
    protected void appendValue(String value) {
        this.data.add(value);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        StringColumn intColumn = (StringColumn)column;
        for (int i = 0; i < intColumn.size(); ++i) {
            this.append(intColumn.get(i));
        }
    }

    @Override
    public void removeRow(int index) {
        if (index >= 0 && index < this.data.size()) {
            this.data.set(index, null);
        }
    }

    @Override
    public void trimToSize() {
        ((ArrayList)this.data).trimToSize();
    }

    @Override
    public void sortAscending() {
        this.data.sort((s1, s2) -> s1.compareTo((String)s2));
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        this.data.sort((s1, s2) -> s2.compareTo((String)s1));
        this.onDataFullyUpdated();
    }

    @Override
    public String get(int rowIndex) {
        return this.data.get(rowIndex);
    }

    public List<String> toList() {
        return this.data;
    }

    public boolean contains(String aString) {
        return this.data.indexOf(aString) >= 0;
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    @Override
    public List<String> data() {
        return this.data;
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        String value = this.get(rowNumber);
        if (this.isMissing(value) || value == null) {
            return new byte[0];
        }
        return value.getBytes();
    }

    @Override
    public String getMissingValue() {
        return MISSING_VALUE;
    }

    private boolean isMissing(String s) {
        return Objects.equals(s, MISSING_VALUE);
    }

    @Override
    public StringColumn emptyCopy() {
        StringColumn copy = StringColumn.create(this.name());
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public StringColumn emptyCopy(int rowSize) {
        StringColumn copy = StringColumn.create(this.name(), rowSize);
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public StringColumn copy() {
        StringColumn newCol = StringColumn.create(this.name(), this.size());
        newCol.data().addAll(this.data);
        newCol.setComment(this.comment());
        return newCol;
    }

    @Override
    public StringColumn trimToSelection(Selection selection) {
        StringColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.get(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public StringColumn upperCase() {
        return (StringColumn)super.upperCase();
    }

    @Override
    public StringColumn lowerCase() {
        return (StringColumn)super.lowerCase();
    }

    @Override
    public StringColumn trim() {
        return (StringColumn)super.trim();
    }

    @Override
    public StringColumn replaceAll(String regex, String replacement) {
        return (StringColumn)super.replaceAll(regex, replacement);
    }

    @Override
    public StringColumn replaceFirst(String regex, String replacement) {
        return (StringColumn)super.replaceFirst(regex, replacement);
    }

    @Override
    public StringColumn substring(int start, int end) {
        return (StringColumn)super.substring(start, end);
    }

    @Override
    public StringColumn substring(int start) {
        return (StringColumn)super.substring(start);
    }

    @Override
    public StringColumn format(String formatString) {
        return (StringColumn)super.format(formatString);
    }

    @Override
    public StringColumn padEnd(int minLength, char padChar) {
        return (StringColumn)super.padEnd(minLength, padChar);
    }

    @Override
    public StringColumn padStart(int minLength, char padChar) {
        return (StringColumn)super.padStart(minLength, padChar);
    }

    @Override
    public StringColumn commonPrefix(Column column2) {
        return (StringColumn)super.commonPrefix(column2);
    }

    @Override
    public StringColumn commonSuffix(Column column2) {
        return (StringColumn)super.commonSuffix(column2);
    }

    @Override
    public StringColumn join(String separator, Column ... column) {
        return (StringColumn)super.join(separator, column);
    }

    @Override
    public StringColumn concat(String append) {
        return (StringColumn)super.concat(append);
    }

    @Override
    public StringColumn tokenizeAndSort(String separator) {
        return (StringColumn)super.tokenizeAndSort(separator);
    }

    @Override
    public StringColumn tokens(String separator) {
        return (StringColumn)super.tokens(separator);
    }

    @Override
    public StringColumn uniqueTokens(String separator) {
        return (StringColumn)super.uniqueTokens(separator);
    }

    @Override
    public StringColumn unique() {
        return (StringColumn)super.unique();
    }

    @Override
    public StringColumn tokenizeAndSort() {
        return (StringColumn)super.tokenizeAndSort();
    }

    @Override
    public StringColumn tokenizeAndRemoveDuplicates(String separator) {
        return (StringColumn)super.tokenizeAndRemoveDuplicates(separator);
    }

    @Override
    public StringColumn selectIf(StringPredicate predicate) {
        StringColumn column = this.emptyCopy();
        IntIterator iterator = this.indexIterator();
        while (iterator.hasNext()) {
            String next = this.get(iterator.nextInt());
            if (!predicate.test(next)) continue;
            column.append(next);
        }
        return column;
    }

    @Override
    public int countUnique(Selection selection) {
        IntIterator iterator = selection.iterator();
        HashSet<String> set = new HashSet<String>();
        while (iterator.hasNext()) {
            set.add(this.get(iterator.nextInt()));
        }
        return set.size();
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isIn(Selection selection, String ... strings) {
        return this.isIn(Arrays.asList(strings));
    }

    @Override
    public Selection isIn(Collection<String> strings, Selection selection) {
        TreeSet<String> set = new TreeSet<String>(strings);
        return this.select((String value) -> set.contains(value), selection);
    }

    @Override
    public Selection isNotIn(Selection selection, String ... strings) {
        return this.isNotIn(Arrays.asList(strings));
    }

    @Override
    public Selection isNotIn(Collection<String> strings, Selection selection) {
        TreeSet<String> set = new TreeSet<String>(strings);
        return this.select((String value) -> !set.contains(value), selection);
    }

    @Override
    public Selection isEqualTo(String string, Selection selection) {
        return this.select((String value) -> value == string || value != null && value.equals(string), selection);
    }

    public String toString() {
        return "String column: " + this.name();
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        for (String next : this.data) {
            builder.append(next);
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public long sizeInMemoryData() {
        long result = 0L;
        result += (long)this.data.size() * 8L;
        for (String string : this.data) {
            result += TypeUtils.stringSize(string);
        }
        return result;
    }

    @Override
    public long sizeInMemoryFull() {
        long result = 0L;
        if (elementDataField != null) {
            try {
                Object[] elementData = (Object[])elementDataField.get(this.data);
                result += (long)elementData.length * 8L;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        for (String string : this.data) {
            result += TypeUtils.stringSize(string);
        }
        return result;
    }

    @Override
    public long sizeInMemory(Selection selection) {
        long result = 0L;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int index = iterator.nextInt();
            if (index < 0 || index >= this.data.size()) continue;
            result += TypeUtils.stringSize(this.data.get(index));
            result += 8L;
        }
        return result;
    }

    @Override
    public StringColumnWrapper wrap(Selection selection) {
        return new StringColumnWrapper(this, selection);
    }

    static {
        try {
            elementDataField = ArrayList.class.getDeclaredField("elementData");
            elementDataField.setAccessible(true);
        }
        catch (Exception exception) {
            Trace.logException(StringColumnImpl.class, exception, true);
        }
    }
}

