/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.FloatColumnImpl;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.IntColumnImpl;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.columns.ShortColumn;
import com.streamscape.ds.stable.columns.ShortColumnWrapper;
import com.streamscape.ds.stable.filtering.ShortBiPredicate;
import com.streamscape.ds.stable.filtering.ShortPredicate;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.lists.ShortArrayList;
import com.streamscape.ds.stable.lists.ShortIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShortColumnImpl
extends AbstractColumn
implements ShortColumn {
    public static final short MISSING_VALUE = (Short)ColumnType.SHORT.getMissingValue();
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 2;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private ShortArrayList data;
    final IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        @Override
        public int compare(int i1, int i2) {
            return ShortColumnImpl.this.compare(ShortColumnImpl.this.data.getShort(i1), ShortColumnImpl.this.data.getShort(i2));
        }
    };
    public static ShortPredicate isZero = i -> i == 0;
    public static ShortPredicate isNegative = i -> i < 0;
    public static ShortPredicate isPositive = i -> i > 0;
    public static ShortPredicate isNonNegative = i -> i >= 0;
    public static ShortPredicate isEven = i -> (i & 1) == 0;
    public static ShortPredicate isOdd = i -> (i & 1) != 0;
    public static ShortBiPredicate isGreaterThan = (valueToTest, valueToCompareAgainst) -> valueToTest > valueToCompareAgainst;
    public static ShortBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    public static ShortBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    public static ShortBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    public static ShortBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;
    public static ShortBiPredicate isNotEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest != valueToCompareAgainst;
    public static ShortPredicate isMissing = i -> i == MISSING_VALUE;
    public static ShortPredicate isNotMissing = i -> i != MISSING_VALUE;

    public ShortColumnImpl(String name) {
        this(name, new ShortArrayList(128));
    }

    public ShortColumnImpl(String name, int initialSize) {
        this(name, new ShortArrayList(initialSize));
    }

    public ShortColumnImpl(String name, short[] arr) {
        this(name, new ShortArrayList(arr));
    }

    private ShortColumnImpl(String name, ShortArrayList data) {
        super(name);
        this.data = data;
    }

    public ShortColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.data = new ShortArrayList(metadata.getSize());
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.SHORT;
    }

    @Override
    public int byteSize() {
        return 2;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(2).putShort(this.get(rowNumber)).array();
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create(this.name());
        CategoryColumn nameColumn = CategoryColumn.create("Property");
        IntColumn valueColumn = IntColumn.create("Value");
        table.addColumn(nameColumn);
        table.addColumn(valueColumn);
        nameColumn.append("Size");
        valueColumn.append(this.size());
        return table;
    }

    @Override
    public void append(short i) {
        this.data.add(i);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void set(int index, short value) {
        this.data.set(index, value);
        this.onDataChanged(index);
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getShort(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public void set(short newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        short[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            short tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public ShortColumn copy() {
        ShortColumn copy = this.emptyCopy(this.size());
        copy.data().addAll(this.data);
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public ShortColumn trimToSelection(Selection selection) {
        ShortColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.get(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public void appendObject(Object object) {
        try {
            this.append(ShortColumnImpl.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getShort(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(ShortColumnImpl.getMissingValue());
    }

    @Override
    public void setObject(int index, Object object) {
        try {
            this.set(index, ShortColumnImpl.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, ShortColumnImpl.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        if (IntColumnImpl.isMissingValue(value)) {
            this.set(row, ShortColumnImpl.getMissingValue());
        } else {
            this.set(row, (short)value);
        }
    }

    @Override
    public void setShort(int row, short value) {
        if (ShortColumnImpl.isMissingValue(value)) {
            this.set(row, ShortColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setLong(int row, long value) {
        if (LongColumnImpl.isMissingValue(value)) {
            this.set(row, ShortColumnImpl.getMissingValue());
        } else {
            this.set(row, (short)value);
        }
    }

    @Override
    public void setFloat(int row, float value) {
        if (FloatColumnImpl.isMissingValue(value)) {
            this.set(row, ShortColumnImpl.getMissingValue());
        } else {
            this.set(row, (short)value);
        }
    }

    @Override
    public void setDouble(int row, double value) {
        if (DoubleColumnImpl.isMissingValue(value)) {
            this.set(row, ShortColumnImpl.getMissingValue());
        } else {
            this.set(row, (short)value);
        }
    }

    @Override
    public void setBoolean(int row, boolean value) {
        this.set(row, (short)(value ? 1 : 0));
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        ShortColumn shortColumn = (ShortColumn)column;
        for (int i = 0; i < shortColumn.size(); ++i) {
            this.append(shortColumn.get(i));
        }
    }

    @Override
    public void assignWithValue(Object object) {
        this.assignWithValue(ShortColumnImpl.convert(object));
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(ShortColumnImpl.convert(object), size);
    }

    @Override
    public void assignWithValue(short value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(short value, int size) {
        for (int i = 0; i < size; ++i) {
            this.append(value);
        }
    }

    @Override
    public short get(int index) {
        return this.data.getShort(index);
    }

    @Override
    public String getString(int row) {
        short value = this.data.getShort(row);
        if (value == MISSING_VALUE) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        if (this.isMissing(row)) {
            return IntColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public short getShort(int row) {
        if (this.isMissing(row)) {
            return MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public long getLong(int row) {
        if (this.isMissing(row)) {
            return LongColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public float getFloat(int row) {
        if (this.isMissing(row)) {
            return FloatColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public double getDouble(int row) {
        if (this.isMissing(row)) {
            return DoubleColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public boolean getBoolean(int row) {
        if (this.isMissing(row)) {
            return false;
        }
        return this.get(row) != 0;
    }

    @Override
    public boolean isMissing(int row) {
        return ShortColumnImpl.isMissingValue(this.get(row));
    }

    protected static boolean isMissingValue(short value) {
        return value == MISSING_VALUE;
    }

    protected static short getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    @Override
    public short firstElement(Selection selection) {
        IntIterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            return this.get(iterator.nextInt());
        }
        return MISSING_VALUE;
    }

    @Override
    public boolean contains(short value) {
        return this.data.contains(value);
    }

    @Override
    public ShortArrayList data() {
        return this.data;
    }

    @Override
    public ShortColumn select(Selection selection) {
        IntIterator iterator = selection.iterator();
        ShortColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public Column selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        ShortColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.get(row));
        }
        return result;
    }

    @Override
    public ShortColumn emptyCopy() {
        ShortColumn column = ShortColumn.create(this.name(), 128);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public ShortColumn emptyCopy(int rowSize) {
        ShortColumn column = ShortColumn.create(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public ShortArrayList top(int n, Selection selection) {
        ShortColumn result = ShortColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        ShortArrayList top = new ShortArrayList();
        for (int i = result.data().size() - 1; i >= result.data().size() - n - 1 && i >= 0; --i) {
            top.add(result.get(i));
        }
        return top;
    }

    @Override
    public ShortArrayList bottom(int n, Selection selection) {
        ShortColumn result = ShortColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        ShortArrayList bottom = new ShortArrayList();
        for (int i = 0; i < n && i < result.data().size(); ++i) {
            bottom.add(result.get(i));
        }
        return bottom;
    }

    @Override
    public ShortColumn selectIf(ShortPredicate predicate) {
        ShortColumn column = this.emptyCopy();
        for (int i = 0; i < this.data.size(); ++i) {
            short next = this.data.getShort(i);
            if (!predicate.test(next)) continue;
            column.append(next);
        }
        return column;
    }

    private ShortColumn executeShortOperation(ShortUnaryOperator operator, String name, Selection selection) {
        ShortColumn result = ShortColumn.create(name, selection.size());
        selection.iterate(i -> result.append(this.isMissing(i) ? MISSING_VALUE : operator.apply(this.get(i))));
        return result;
    }

    private ShortColumn executeShortOperation(ShortBinaryOperator operator, Column column2, String operation, Selection selection) {
        ShortColumn result = ShortColumn.create(this.name() + operation + column2.name(), selection.size());
        IntIterator iterator2 = column2.getSelection().iterator();
        selection.iterate(i -> {
            if (!iterator2.hasNext()) {
                return;
            }
            int i2 = iterator2.nextInt();
            result.append(this.isMissing(i) || column2.isMissing(i2) ? MISSING_VALUE : operator.apply(this.get(i), column2.getShort(i2)));
        });
        return result;
    }

    @Override
    public ShortColumn add(short value, Selection selection) {
        return this.executeShortOperation(v -> (short)(v + value), this.name() + " + " + value, selection);
    }

    @Override
    public ShortColumn add(Column column2, Selection selection) {
        return this.executeShortOperation((v1, v2) -> (short)(v1 + v2), column2, " + ", selection);
    }

    @Override
    public ShortColumn remainder(short value, Selection selection) {
        return this.executeShortOperation(v -> (short)(v % value), this.name() + " % " + value, selection);
    }

    @Override
    public ShortColumn remainder(Column column2, Selection selection) {
        return this.executeShortOperation((v1, v2) -> (short)(v1 % v2), column2, " & ", selection);
    }

    @Override
    public ShortColumn subtract(short value, Selection selection) {
        return this.executeShortOperation(v -> (short)(v - value), this.name() + " - " + value, selection);
    }

    @Override
    public ShortColumn subtract(Column column2, Selection selection) {
        return this.executeShortOperation((v1, v2) -> (short)(v1 - v2), column2, " - ", selection);
    }

    @Override
    public ShortColumn multiply(short value, Selection selection) {
        return this.executeShortOperation(v -> (short)(v * value), this.name() + " * " + value, selection);
    }

    @Override
    public ShortColumn multiply(double value, Selection selection) {
        return this.executeShortOperation(v -> (short)((double)v * value), this.name() + " * " + value, selection);
    }

    @Override
    public ShortColumn multiply(Column column2, Selection selection) {
        return this.executeShortOperation((v1, v2) -> (short)(v1 * v2), column2, " * ", selection);
    }

    @Override
    public ShortColumn divide(short value, Selection selection) {
        return this.executeShortOperation(v -> (short)(v / value), this.name() + " / " + value, selection);
    }

    @Override
    public ShortColumn divide(double value, Selection selection) {
        return this.executeShortOperation(v -> (short)((double)v / value), this.name() + " / " + value, selection);
    }

    @Override
    public ShortColumn divide(Column column2, Selection selection) {
        return this.executeShortOperation((v1, v2) -> (short)(v1 / v2), column2, " / ", selection);
    }

    @Override
    public ShortColumn square(Selection selection) {
        return this.executeShortOperation(v -> (short)Math.pow(v, 2.0), this.name() + "[ square ]", selection);
    }

    @Override
    public ShortColumn cube(Selection selection) {
        return this.executeShortOperation(v -> (short)Math.pow(v, 3.0), this.name() + "[ cube ]", selection);
    }

    @Override
    public ShortColumn abs(Selection selection) {
        return this.executeShortOperation(v -> (short)Math.abs(v), this.name() + "[ abs ]", selection);
    }

    @Override
    public ShortColumn neg(Selection selection) {
        return this.executeShortOperation(v -> (short)(v * -1), this.name() + "[ abs ]", selection);
    }

    @Override
    public ShortColumn cumSum(Selection selection) {
        short[] total = new short[]{0};
        ShortColumn result = ShortColumn.create(this.name() + "[cumSum]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = (short)(total[0] + this.get(i));
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public ShortColumn cumProd(Selection selection) {
        short[] total = new short[]{1};
        ShortColumn result = ShortColumn.create(this.name() + "[cumProd]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = (short)(total[0] * this.get(i));
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public ShortColumn difference(Selection selection) {
        ShortColumn result = ShortColumn.create(this.name(), selection.size());
        int[] previous = new int[]{-1};
        selection.iterate(i -> {
            if (previous[0] == -1) {
                result.append(MISSING_VALUE);
            } else {
                result.append(this.isMissing(i) || this.isMissing(previous[0]) ? MISSING_VALUE : (short)(this.get(i) - this.get(previous[0])));
            }
            previous[0] = i;
        });
        return result;
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.select(isMissing, selection);
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.select(isNotMissing, selection);
    }

    @Override
    public Selection isLessThan(short i, Selection selection) {
        return this.select(isLessThan, i, selection);
    }

    @Override
    public Selection isGreaterThan(short i, Selection selection) {
        return this.select(isGreaterThan, i, selection);
    }

    @Override
    public Selection isEqualTo(ShortColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.data.elements()[i] != f.data().elements()[i]) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isGreaterThan(ShortColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.data.elements()[i] <= f.data().elements()[i]) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isLessThan(ShortColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.data.elements()[i] >= f.data().elements()[i]) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isGreaterThanOrEqualTo(short i, Selection selection) {
        return this.select(isGreaterThanOrEqualTo, i, selection);
    }

    @Override
    public Selection isLessThanOrEqualTo(short i, Selection selection) {
        return this.select(isLessThanOrEqualTo, i, selection);
    }

    @Override
    public Selection isNotEqualTo(short i, Selection selection) {
        return this.select(isNotEqualTo, i, selection);
    }

    @Override
    public Selection isEqualTo(short i, Selection selection) {
        return this.select(isEqualTo, i, selection);
    }

    @Override
    public Selection isPositive(Selection selection) {
        return this.select(isPositive, selection);
    }

    @Override
    public Selection isNegative(Selection selection) {
        return this.select(isNegative, selection);
    }

    @Override
    public Selection isNonNegative(Selection selection) {
        return this.select(isNonNegative, selection);
    }

    @Override
    public Selection isZero(Selection selection) {
        return this.select(isZero, selection);
    }

    @Override
    public Selection isEven(Selection selection) {
        return this.select(isEven, selection);
    }

    @Override
    public Selection isOdd(Selection selection) {
        return this.select(isOdd, selection);
    }

    @Override
    public Selection select(ShortPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            short next = this.data.getShort(idx);
            if (!predicate.test(next)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public Selection select(ShortBiPredicate predicate, short valueToCompareAgainst, Selection selection) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            short next = this.data.getShort(idx);
            if (!predicate.test(next, valueToCompareAgainst)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getShort(row1), column2.getShort(row2));
    }

    private int compare(short v1, short v2) {
        if (v1 == v2) {
            return 0;
        }
        if (ShortColumnImpl.isMissingValue(v1)) {
            return -1;
        }
        if (ShortColumnImpl.isMissingValue(v2)) {
            return 1;
        }
        return Short.compare(v1, v2);
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        ShortIterator shortIterator = this.data.iterator();
        while (shortIterator.hasNext()) {
            short i = (Short)shortIterator.next();
            builder.append(String.valueOf(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "ShortInt column: " + this.name();
    }

    public static short convert(String stringValue) {
        if (TypeUtils.isNullOrEmpty(stringValue) || TypeUtils.MISSING_INDICATORS.contains(stringValue)) {
            return (Short)ColumnType.SHORT.getMissingValue();
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Short.parseShort(matcher.replaceAll(""));
    }

    public static short convert(Object objectValue) {
        if (objectValue == null || objectValue instanceof String) {
            return ShortColumnImpl.convert((String)objectValue);
        }
        if (objectValue instanceof Number) {
            return ((Number)objectValue).shortValue();
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + String.valueOf(objectValue) + " to Short");
    }

    @Override
    public Column wrap(Selection selection) {
        return new ShortColumnWrapper(this, selection);
    }

    static interface ShortUnaryOperator {
        public short apply(short var1);
    }

    static interface ShortBinaryOperator {
        public short apply(short var1, short var2);
    }
}

