/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.rplmethod.ColumnOperation;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.utils.Selection;
import java.util.function.DoubleUnaryOperator;

public interface NumericColumn
extends Column {
    @RPLMethod
    @ColumnOperation
    default public DoubleColumn asRatio() {
        return this.asRatio(this.getSelection());
    }

    default public DoubleColumn asRatio(Selection selection) {
        DoubleColumn pctColumn = DoubleColumn.create(this.name() + " ratio");
        double total = this.sum();
        selection.iterate(i -> {
            if (total == 0.0 || this.isMissing(i)) {
                pctColumn.append(DoubleColumnImpl.MISSING_VALUE);
            } else {
                pctColumn.append(this.getDouble(i) / total);
            }
        });
        return pctColumn;
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn asPercent() {
        return this.asPercent(this.getSelection());
    }

    default public DoubleColumn asPercent(Selection selection) {
        DoubleColumn pctColumn = DoubleColumn.create(this.name() + " percents");
        double total = this.sum();
        selection.iterate(i -> {
            if (total == 0.0 || this.isMissing(i)) {
                pctColumn.append(DoubleColumnImpl.MISSING_VALUE);
            } else {
                pctColumn.append(this.getDouble(i) / total * 100.0);
            }
        });
        return pctColumn;
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn pctChange() {
        return this.pctChange(this.getSelection());
    }

    default public DoubleColumn pctChange(Selection selection) {
        DoubleColumn pctColumn = DoubleColumn.create(this.name() + " [pctChange]");
        pctColumn.append(DoubleColumnImpl.MISSING_VALUE);
        int[] previous = new int[]{-1};
        selection.iterate(i -> {
            if (previous[0] == -1) {
                previous[0] = i;
                return;
            }
            if (this.isMissing(previous[0]) || this.isMissing(i)) {
                pctColumn.append(DoubleColumnImpl.MISSING_VALUE);
            } else {
                pctColumn.append(this.getDouble(previous[0]) / this.getDouble(i));
            }
        });
        return pctColumn;
    }

    default public double sum() {
        return this.sum(this.getSelection());
    }

    default public double sum(Selection selection) {
        double[] total = new double[1];
        selection.iterate(i -> {
            total[0] = total[0] + this.getDouble(i);
        });
        return total[0];
    }

    default public DoubleColumn executeDoubleOperation(DoubleUnaryOperator operation, String name, Selection selection) {
        DoubleColumn result = DoubleColumn.create(this.name() + " [" + name + "]");
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(DoubleColumnImpl.MISSING_VALUE);
            } else {
                result.append(operation.applyAsDouble(this.getDouble(i)));
            }
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn power(double power) {
        return this.power(power, this.getSelection());
    }

    default public DoubleColumn power(double power, Selection selection) {
        return this.executeDoubleOperation(v -> Math.pow(v, power), "power " + power, selection);
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn sqrt() {
        return this.sqrt(this.getSelection());
    }

    default public DoubleColumn sqrt(Selection selection) {
        return this.executeDoubleOperation(v -> Math.sqrt(v), "sqrt", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn cubeRoot() {
        return this.cubeRoot(this.getSelection());
    }

    default public DoubleColumn cubeRoot(Selection selection) {
        return this.executeDoubleOperation(v -> Math.cbrt(v), "cubeRoot", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn logN() {
        return this.sqrt(this.getSelection());
    }

    default public DoubleColumn logN(Selection selection) {
        return this.executeDoubleOperation(v -> Math.log(v), "logN", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn log10() {
        return this.sqrt(this.getSelection());
    }

    default public DoubleColumn log10(Selection selection) {
        return this.executeDoubleOperation(v -> Math.log10(v), "log10", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn log1p() {
        return this.sqrt(this.getSelection());
    }

    default public DoubleColumn log1p(Selection selection) {
        return this.executeDoubleOperation(v -> Math.log1p(v), "log1p", selection);
    }

    @RPLMethod
    @ColumnOperation
    public NumericColumn square();

    public NumericColumn square(Selection var1);

    @RPLMethod
    @ColumnOperation
    public NumericColumn cube();

    public NumericColumn cube(Selection var1);

    @RPLMethod
    @ColumnOperation
    public NumericColumn abs();

    public NumericColumn abs(Selection var1);

    @RPLMethod
    @ColumnOperation
    public NumericColumn neg();

    public NumericColumn neg(Selection var1);

    @RPLMethod
    @ColumnOperation
    public NumericColumn cumSum();

    public NumericColumn cumSum(Selection var1);

    @RPLMethod
    @ColumnOperation
    public NumericColumn cumProd();

    public NumericColumn cumProd(Selection var1);

    @Override
    @RPLMethod
    @ColumnOperation
    public NumericColumn difference();

    @Override
    public NumericColumn difference(Selection var1);
}

