/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.FloatColumnImpl;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.IntColumnImpl;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.LongColumnWrapper;
import com.streamscape.ds.stable.columns.ShortColumnImpl;
import com.streamscape.ds.stable.filtering.LongBiPredicate;
import com.streamscape.ds.stable.filtering.LongPredicate;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.lists.LongArrayList;
import com.streamscape.ds.stable.lists.LongIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LongColumnImpl
extends AbstractColumn
implements LongColumn {
    public static final long MISSING_VALUE = (Long)ColumnType.LONG.getMissingValue();
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 8;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private LongArrayList data;
    private final IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        @Override
        public int compare(int i1, int i2) {
            return LongColumnImpl.this.compare(LongColumnImpl.this.data.getLong(i1), LongColumnImpl.this.data.getLong(i2));
        }
    };
    public static LongPredicate isZero = i -> i == 0L;
    public static LongPredicate isNegative = i -> i < 0L;
    public static LongPredicate isPositive = i -> i > 0L;
    public static LongPredicate isNonNegative = i -> i >= 0L;
    public static LongPredicate isEven = i -> (i & 1L) == 0L;
    public static LongPredicate isOdd = i -> (i & 1L) != 0L;
    public static LongBiPredicate isGreaterThan = (valueToTest, valueToCompareAgainst) -> valueToTest > valueToCompareAgainst;
    public static LongBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    public static LongBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    public static LongBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    public static LongBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;
    public static LongBiPredicate isNotEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest != valueToCompareAgainst;
    public static LongPredicate isMissing = i -> i == MISSING_VALUE;
    public static LongPredicate isNotMissing = i -> i != MISSING_VALUE;

    public LongColumnImpl(String name) {
        this(name, new LongArrayList(128));
    }

    public LongColumnImpl(String name, int initialSize) {
        this(name, new LongArrayList(initialSize));
    }

    public LongColumnImpl(String name, long[] arr) {
        this(name, new LongArrayList(arr));
    }

    private LongColumnImpl(String name, LongArrayList data) {
        super(name);
        this.data = data;
    }

    public LongColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.data = new LongArrayList(metadata.getSize());
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.LONG;
    }

    @Override
    public int byteSize() {
        return 8;
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create(this.name());
        CategoryColumn nameColumn = CategoryColumn.create("Property");
        IntColumn valueColumn = IntColumn.create("Value");
        table.addColumn(nameColumn);
        table.addColumn(valueColumn);
        nameColumn.append("Size");
        valueColumn.append(this.size());
        return table;
    }

    @Override
    public void append(long i) {
        this.data.add(i);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void set(int index, long value) {
        this.data.set(index, value);
        this.onDataChanged(index);
    }

    @Override
    public void set(long newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getLong(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        long[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            long tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public void appendObject(Object object) {
        try {
            this.append(LongColumnImpl.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getLong(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(LongColumnImpl.getMissingValue());
    }

    @Override
    public void setObject(int index, Object object) {
        try {
            this.set(index, LongColumnImpl.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, LongColumnImpl.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        if (IntColumnImpl.isMissingValue(value)) {
            this.set(row, LongColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setShort(int row, short value) {
        if (ShortColumnImpl.isMissingValue(value)) {
            this.set(row, LongColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setLong(int row, long value) {
        if (LongColumnImpl.isMissingValue(value)) {
            this.set(row, LongColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setFloat(int row, float value) {
        if (FloatColumnImpl.isMissingValue(value)) {
            this.set(row, LongColumnImpl.getMissingValue());
        } else {
            this.set(row, (long)value);
        }
    }

    @Override
    public void setDouble(int row, double value) {
        if (DoubleColumnImpl.isMissingValue(value)) {
            this.set(row, LongColumnImpl.getMissingValue());
        } else {
            this.set(row, (long)value);
        }
    }

    @Override
    public void setBoolean(int row, boolean value) {
        this.set(row, value ? 1 : 0);
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        LongColumn longColumn = (LongColumn)column;
        for (int i = 0; i < longColumn.size(); ++i) {
            this.append(longColumn.get(i));
        }
    }

    @Override
    public void assignWithValue(Object object) {
        this.assignWithValue(LongColumnImpl.convert(object));
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(LongColumnImpl.convert(object), size);
    }

    @Override
    public void assignWithValue(long value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(long value, int size) {
        for (int i = 0; i < size; ++i) {
            this.append(value);
        }
    }

    @Override
    public String getString(int row) {
        long value = this.data.getLong(row);
        if (value == MISSING_VALUE) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        if (this.isMissing(row)) {
            return IntColumnImpl.MISSING_VALUE;
        }
        return (int)this.get(row);
    }

    @Override
    public short getShort(int row) {
        if (this.isMissing(row)) {
            return ShortColumnImpl.MISSING_VALUE;
        }
        return (short)this.get(row);
    }

    @Override
    public long getLong(int row) {
        if (this.isMissing(row)) {
            return MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public float getFloat(int row) {
        if (this.isMissing(row)) {
            return FloatColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public double getDouble(int row) {
        if (this.isMissing(row)) {
            return DoubleColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public boolean getBoolean(int row) {
        if (this.isMissing(row)) {
            return false;
        }
        return this.get(row) != 0L;
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    @Override
    public long get(int index) {
        return this.data.getLong(index);
    }

    @Override
    public long firstElement(Selection selection) {
        IntIterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            return this.get(iterator.nextInt());
        }
        return MISSING_VALUE;
    }

    @Override
    public boolean isMissing(int row) {
        return LongColumnImpl.isMissingValue(this.get(row));
    }

    @Override
    public LongArrayList data() {
        return this.data;
    }

    @Override
    public boolean contains(long value) {
        return this.data.contains(value);
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(8).putLong(this.get(rowNumber)).array();
    }

    protected static boolean isMissingValue(long value) {
        return value == MISSING_VALUE;
    }

    protected static long getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public LongColumn select(Selection selection) {
        IntIterator iterator = selection.iterator();
        LongColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public LongColumn selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        LongColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.get(row));
        }
        return result;
    }

    @Override
    public LongColumn emptyCopy() {
        LongColumn column = LongColumn.create(this.name(), 128);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public LongColumn emptyCopy(int rowSize) {
        LongColumn column = LongColumn.create(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public LongColumn copy() {
        LongColumn copy = this.emptyCopy(this.size());
        copy.data().addAll(this.data);
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public LongColumn trimToSelection(Selection selection) {
        LongColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.get(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public LongColumn selectIf(LongPredicate predicate) {
        LongColumn column = this.emptyCopy();
        for (int i = 0; i < this.data.size(); ++i) {
            long next = this.data.getLong(i);
            if (!predicate.test(next)) continue;
            column.append(next);
        }
        return column;
    }

    @Override
    public LongArrayList top(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList top = new LongArrayList();
        for (int i = result.data().size() - 1; i >= result.data().size() - n - 1 && i >= 0; --i) {
            top.add(result.get(i));
        }
        return top;
    }

    @Override
    public LongArrayList bottom(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList bottom = new LongArrayList();
        for (int i = 0; i < n && i < result.data().size(); ++i) {
            bottom.add(result.get(i));
        }
        return bottom;
    }

    private LongColumn executeLongOperation(LongUnaryOperator operator, String name, Selection selection) {
        LongColumn result = LongColumn.create(name, selection.size());
        selection.iterate(i -> result.append(this.isMissing(i) ? MISSING_VALUE : operator.applyAsLong(this.get(i))));
        return result;
    }

    private LongColumn executeLongOperation(LongBinaryOperator operator, Column column2, String operation, Selection selection) {
        LongColumn result = LongColumn.create(this.name() + operation + column2.name(), selection.size());
        IntIterator iterator2 = column2.getSelection().iterator();
        selection.iterate(i -> {
            if (!iterator2.hasNext()) {
                return;
            }
            int i2 = iterator2.nextInt();
            result.append(this.isMissing(i) || column2.isMissing(i2) ? MISSING_VALUE : operator.applyAsLong(this.get(i), column2.getLong(i2)));
        });
        return result;
    }

    @Override
    public LongColumn add(long value, Selection selection) {
        return this.executeLongOperation(v -> v + value, this.name() + " + " + value, selection);
    }

    @Override
    public LongColumn add(Column column2, Selection selection) {
        return this.executeLongOperation((v1, v2) -> v1 + v2, column2, " + ", selection);
    }

    @Override
    public LongColumn remainder(long value, Selection selection) {
        return this.executeLongOperation(v -> v % value, this.name() + " % " + value, selection);
    }

    @Override
    public LongColumn remainder(Column column2, Selection selection) {
        return this.executeLongOperation((v1, v2) -> v1 % v2, column2, " & ", selection);
    }

    @Override
    public LongColumn subtract(long value, Selection selection) {
        return this.executeLongOperation(v -> v - value, this.name() + " - " + value, selection);
    }

    @Override
    public LongColumn subtract(Column column2, Selection selection) {
        return this.executeLongOperation((v1, v2) -> v1 - v2, column2, " - ", selection);
    }

    @Override
    public LongColumn multiply(long value, Selection selection) {
        return this.executeLongOperation(v -> v * value, this.name() + " * " + value, selection);
    }

    @Override
    public LongColumn multiply(double value, Selection selection) {
        return this.executeLongOperation(v -> (long)((double)v * value), this.name() + " * " + value, selection);
    }

    @Override
    public LongColumn multiply(Column column2, Selection selection) {
        return this.executeLongOperation((v1, v2) -> v1 * v2, column2, " * ", selection);
    }

    @Override
    public LongColumn divide(long value, Selection selection) {
        return this.executeLongOperation(v -> v / value, this.name() + " / " + value, selection);
    }

    @Override
    public LongColumn divide(double value, Selection selection) {
        return this.executeLongOperation(v -> (long)((double)v / value), this.name() + " / " + value, selection);
    }

    @Override
    public LongColumn divide(Column column2, Selection selection) {
        return this.executeLongOperation((v1, v2) -> v1 / v2, column2, " / ", selection);
    }

    @Override
    public LongColumn square(Selection selection) {
        return this.executeLongOperation(v -> (long)Math.pow(v, 2.0), this.name() + "[ square ]", selection);
    }

    @Override
    public LongColumn cube(Selection selection) {
        return this.executeLongOperation(v -> (long)Math.pow(v, 3.0), this.name() + "[ cube ]", selection);
    }

    @Override
    public LongColumn abs(Selection selection) {
        return this.executeLongOperation(v -> Math.abs(v), this.name() + "[ abs ]", selection);
    }

    @Override
    public LongColumn neg(Selection selection) {
        return this.executeLongOperation(v -> v * -1L, this.name() + "[ abs ]", selection);
    }

    @Override
    public LongColumn cumSum(Selection selection) {
        long[] total = new long[]{0L};
        LongColumn result = LongColumn.create(this.name() + "[cumSum]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = total[0] + this.get(i);
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public LongColumn cumProd(Selection selection) {
        long[] total = new long[]{1L};
        LongColumn result = LongColumn.create(this.name() + "[cumProd]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = total[0] * this.get(i);
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public LongColumn difference(Selection selection) {
        LongColumn result = LongColumn.create(this.name(), selection.size());
        int[] previous = new int[]{-1};
        selection.iterate(i -> {
            if (previous[0] == -1) {
                result.append(MISSING_VALUE);
            } else {
                result.append(this.isMissing(i) || this.isMissing(previous[0]) ? MISSING_VALUE : this.get(i) - this.get(previous[0]));
            }
            previous[0] = i;
        });
        return result;
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isLessThan(long i, Selection selection) {
        return this.select(isLessThan, i, selection);
    }

    @Override
    public Selection isGreaterThan(long i, Selection selection) {
        return this.select(isGreaterThan, i, selection);
    }

    @Override
    public Selection isGreaterThanOrEqualTo(long i, Selection selection) {
        return this.select(isGreaterThanOrEqualTo, i, selection);
    }

    @Override
    public Selection isLessThanOrEqualTo(long f, Selection selection) {
        return this.select(isLessThanOrEqualTo, f, selection);
    }

    @Override
    public Selection isEqualTo(long i, Selection selection) {
        return this.select(isEqualTo, i, selection);
    }

    @Override
    public Selection isNotEqualTo(long i, Selection selection) {
        return this.select(isNotEqualTo, i, selection);
    }

    @Override
    public Selection isEqualTo(LongColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.data.elements()[i] != f.data().elements()[i]) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isGreaterThan(LongColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.data.elements()[i] <= f.data().elements()[i]) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isLessThan(LongColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.data.elements()[i] >= f.data().elements()[i]) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isPositive(Selection selection) {
        return this.select(isPositive, selection);
    }

    @Override
    public Selection isNegative(Selection selection) {
        return this.select(isNegative, selection);
    }

    @Override
    public Selection isNonNegative(Selection selection) {
        return this.select(isNonNegative, selection);
    }

    @Override
    public Selection isZero(Selection selection) {
        return this.select(isZero, selection);
    }

    @Override
    public Selection isEven(Selection selection) {
        return this.select(isEven, selection);
    }

    @Override
    public Selection isOdd(Selection selection) {
        return this.select(isOdd, selection);
    }

    @Override
    public Selection select(LongPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            long next = this.data.getLong(idx);
            if (!predicate.test(next)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public Selection select(LongBiPredicate predicate, long valueToCompareAgainst, Selection selection) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            long next = this.data.getLong(idx);
            if (!predicate.test(next, valueToCompareAgainst)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.select(isMissing, selection);
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.select(isNotMissing, selection);
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getLong(row1), column2.getLong(row2));
    }

    private int compare(long v1, long v2) {
        if (v1 == v2) {
            return 0;
        }
        if (LongColumnImpl.isMissingValue(v1)) {
            return -1;
        }
        if (LongColumnImpl.isMissingValue(v2)) {
            return 1;
        }
        return Long.compare(v1, v2);
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        LongIterator longIterator = this.data.iterator();
        while (longIterator.hasNext()) {
            long i = (Long)longIterator.next();
            builder.append(String.valueOf(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "LongInt column: " + this.name();
    }

    public static long convert(String stringValue) {
        if (TypeUtils.isNullOrEmpty(stringValue) || TypeUtils.MISSING_INDICATORS.contains(stringValue)) {
            return (Long)ColumnType.LONG.getMissingValue();
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Long.parseLong(matcher.replaceAll(""));
    }

    public static long convert(Object objectValue) {
        if (objectValue == null || objectValue instanceof String) {
            return LongColumnImpl.convert((String)objectValue);
        }
        if (objectValue instanceof Number) {
            return ((Number)objectValue).longValue();
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + String.valueOf(objectValue) + " to Long");
    }

    @Override
    public LongColumn wrap(Selection selection) {
        return new LongColumnWrapper(this, selection);
    }
}

