/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.FloatColumnImpl;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.IntColumnWrapper;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.columns.ShortColumnImpl;
import com.streamscape.ds.stable.filtering.IntBiPredicate;
import com.streamscape.ds.stable.filtering.IntPredicate;
import com.streamscape.ds.stable.lists.IntArrayList;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IntColumnImpl
extends AbstractColumn
implements IntColumn {
    public static final int MISSING_VALUE = (Integer)ColumnType.INTEGER.getMissingValue();
    public static final int DEFAULT_ARRAY_SIZE = 128;
    public static final int BYTE_SIZE = 4;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private IntArrayList data;
    final IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        @Override
        public int compare(int i1, int i2) {
            return IntColumnImpl.this.compare(IntColumnImpl.this.data.getInt(i1), IntColumnImpl.this.data.getInt(i2));
        }
    };
    public static IntPredicate isZero = i -> i == 0;
    public static IntPredicate isNegative = i -> i < 0;
    public static IntPredicate isPositive = i -> i > 0;
    public static IntPredicate isNonNegative = i -> i >= 0;
    public static IntPredicate isEven = i -> (i & 1) == 0;
    public static IntPredicate isOdd = i -> (i & 1) != 0;
    public static IntBiPredicate isGreaterThan = (valueToTest, valueToCompareAgainst) -> valueToTest > valueToCompareAgainst;
    public static IntBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    public static IntBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    public static IntBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    public static IntBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;
    public static IntBiPredicate isNotEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest != valueToCompareAgainst;
    public static IntPredicate isMissing = i -> i == MISSING_VALUE;
    public static IntPredicate isNotMissing = i -> i != MISSING_VALUE;

    public IntColumnImpl(String name) {
        this(name, new IntArrayList(128));
    }

    public IntColumnImpl(String name, int initialSize) {
        this(name, new IntArrayList(initialSize));
    }

    public IntColumnImpl(String name, IntArrayList data) {
        super(name);
        this.data = data;
    }

    public IntColumnImpl(String name, int[] arr) {
        this(name, new IntArrayList(arr));
    }

    public IntColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.data = new IntArrayList(metadata.getSize());
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.INTEGER;
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create(this.name());
        CategoryColumn nameColumn = CategoryColumn.create("Property");
        IntColumn valueColumn = IntColumn.create("Value");
        table.addColumn(nameColumn);
        table.addColumn(valueColumn);
        nameColumn.append("Size");
        valueColumn.append(this.size());
        return table;
    }

    @Override
    public void append(int i) {
        this.data.add(i);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void set(int index, int value) {
        this.data.set(index, value);
        this.onDataChanged(index);
    }

    @Override
    public void set(int newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getInt(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public void appendObject(Object object) {
        this.append(IntColumnImpl.convert(object));
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getInt(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(IntColumnImpl.getMissingValue());
    }

    @Override
    public void setObject(int index, Object object) {
        try {
            this.set(index, IntColumnImpl.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, IntColumnImpl.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        if (IntColumnImpl.isMissingValue(value)) {
            this.set(row, IntColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setShort(int row, short value) {
        if (ShortColumnImpl.isMissingValue(value)) {
            this.set(row, IntColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setLong(int row, long value) {
        if (LongColumnImpl.isMissingValue(value)) {
            this.set(row, IntColumnImpl.getMissingValue());
        } else {
            this.set(row, (int)value);
        }
    }

    @Override
    public void setFloat(int row, float value) {
        if (FloatColumnImpl.isMissingValue(value)) {
            this.set(row, IntColumnImpl.getMissingValue());
        } else {
            this.set(row, (int)value);
        }
    }

    @Override
    public void setDouble(int row, double value) {
        if (DoubleColumnImpl.isMissingValue(value)) {
            this.set(row, IntColumnImpl.getMissingValue());
        } else {
            this.set(row, (int)value);
        }
    }

    @Override
    public void setBoolean(int row, boolean value) {
        this.set(row, value ? 1 : 0);
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        IntColumnImpl intColumn = (IntColumnImpl)column;
        for (int i = 0; i < intColumn.size(); ++i) {
            this.append(intColumn.get(i));
        }
    }

    @Override
    public void assignWithValue(Object object) {
        this.assignWithValue(IntColumnImpl.convert(object));
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(IntColumnImpl.convert(object), size);
    }

    @Override
    public void assignWithValue(int value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(int value, int size) {
        for (int i = 0; i < size; ++i) {
            this.append(value);
        }
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        int[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            int tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public String getString(int row) {
        int value = this.data.getInt(row);
        if (value == MISSING_VALUE) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        if (this.isMissing(row)) {
            return MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public short getShort(int row) {
        if (this.isMissing(row)) {
            return ShortColumnImpl.MISSING_VALUE;
        }
        return (short)this.get(row);
    }

    @Override
    public long getLong(int row) {
        if (this.isMissing(row)) {
            return LongColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public float getFloat(int row) {
        if (this.isMissing(row)) {
            return FloatColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public double getDouble(int row) {
        if (this.isMissing(row)) {
            return DoubleColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public boolean getBoolean(int row) {
        if (this.isMissing(row)) {
            return false;
        }
        return this.get(row) != 0;
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    @Override
    public int get(int index) {
        return this.data.getInt(index);
    }

    @Override
    public boolean contains(int i) {
        return this.data.contains(i);
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(4).putInt(this.get(rowNumber)).array();
    }

    @Override
    public int firstElement() {
        if (this.size() > 0) {
            return this.get(0);
        }
        return MISSING_VALUE;
    }

    @Override
    public boolean isMissing(int row) {
        return IntColumnImpl.isMissingValue(this.get(row));
    }

    @Override
    public IntArrayList data() {
        return this.data;
    }

    public static boolean isMissingValue(int value) {
        return value == MISSING_VALUE;
    }

    public static int getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public IntColumn unique(Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator intIterator = selection.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            result.add(this.data.getInt(i));
        }
        return IntColumn.create(this.name() + " Unique values", IntArrayList.wrap(result.toArray()));
    }

    @Override
    public IntColumn select(Selection selection) {
        IntIterator iterator = selection.iterator();
        IntColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public IntColumn selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        IntColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.get(row));
        }
        return result;
    }

    @Override
    public IntColumn selectIf(IntPredicate predicate, Selection selection) {
        IntColumn column = this.emptyCopy();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (!predicate.test(i)) continue;
            column.append(i);
        }
        return column;
    }

    @Override
    public IntColumn emptyCopy() {
        IntColumn column = IntColumn.create(this.name(), 128);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public IntColumn emptyCopy(int rowSize) {
        IntColumn column = IntColumn.create(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public IntColumn copy() {
        IntColumn column = IntColumn.create(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public IntColumn trimToSelection(Selection selection) {
        IntColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.get(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public IntArrayList top(int n, Selection selection) {
        IntColumn result = IntColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        IntArrayList top = new IntArrayList();
        for (int i = result.data().size() - 1; i >= result.data().size() - n - 1 && i >= 0; --i) {
            top.add(result.get(i));
        }
        return top;
    }

    @Override
    public IntArrayList bottom(int n, Selection selection) {
        IntColumn result = IntColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        IntArrayList bottom = new IntArrayList();
        for (int i = 0; i < n && i < result.data().size(); ++i) {
            bottom.add(result.get(i));
        }
        return bottom;
    }

    private IntColumn executeIntOperation(IntUnaryOperator operator, String name, Selection selection) {
        IntColumn result = IntColumn.create(name, selection.size());
        selection.iterate(i -> result.append(this.isMissing(i) ? MISSING_VALUE : operator.applyAsInt(this.get(i))));
        return result;
    }

    private IntColumn executeIntOperation(IntBinaryOperator operator, Column column2, String operation, Selection selection) {
        IntColumn result = IntColumn.create(this.name() + operation + column2.name(), selection.size());
        IntIterator iterator2 = column2.getSelection().iterator();
        selection.iterate(i -> {
            if (!iterator2.hasNext()) {
                return;
            }
            int i2 = iterator2.nextInt();
            result.append(this.isMissing(i) || column2.isMissing(i2) ? MISSING_VALUE : operator.applyAsInt(this.get(i), column2.getInt(i2)));
        });
        return result;
    }

    @Override
    public IntColumn add(int value, Selection selection) {
        return this.executeIntOperation(v -> v + value, this.name() + " + " + value, selection);
    }

    @Override
    public IntColumn add(Column column2, Selection selection) {
        return this.executeIntOperation((v1, v2) -> v1 + v2, column2, " + ", selection);
    }

    @Override
    public IntColumn remainder(int value, Selection selection) {
        return this.executeIntOperation(v -> v % value, this.name() + " % " + value, selection);
    }

    @Override
    public IntColumn remainder(Column column2, Selection selection) {
        return this.executeIntOperation((v1, v2) -> v1 % v2, column2, " & ", selection);
    }

    @Override
    public IntColumn subtract(int value, Selection selection) {
        return this.executeIntOperation(v -> v - value, this.name() + " - " + value, selection);
    }

    @Override
    public IntColumn subtract(Column column2, Selection selection) {
        return this.executeIntOperation((v1, v2) -> v1 - v2, column2, " - ", selection);
    }

    @Override
    public IntColumn multiply(int value, Selection selection) {
        return this.executeIntOperation(v -> v * value, this.name() + " * " + value, selection);
    }

    @Override
    public IntColumn multiply(double value, Selection selection) {
        return this.executeIntOperation(v -> (int)((double)v * value), this.name() + " * " + value, selection);
    }

    @Override
    public IntColumn multiply(Column column2, Selection selection) {
        return this.executeIntOperation((v1, v2) -> v1 * v2, column2, " * ", selection);
    }

    @Override
    public IntColumn divide(int value, Selection selection) {
        return this.executeIntOperation(v -> v / value, this.name() + " / " + value, selection);
    }

    @Override
    public IntColumn divide(double value, Selection selection) {
        return this.executeIntOperation(v -> (int)((double)v / value), this.name() + " / " + value, selection);
    }

    @Override
    public IntColumn divide(Column column2, Selection selection) {
        return this.executeIntOperation((v1, v2) -> v1 / v2, column2, " / ", selection);
    }

    @Override
    public IntColumn square(Selection selection) {
        return this.executeIntOperation(v -> (int)Math.pow(v, 2.0), this.name() + "[ square ]", selection);
    }

    @Override
    public IntColumn cube(Selection selection) {
        return this.executeIntOperation(v -> (int)Math.pow(v, 3.0), this.name() + "[ cube ]", selection);
    }

    @Override
    public IntColumn abs(Selection selection) {
        return this.executeIntOperation(v -> Math.abs(v), this.name() + "[ abs ]", selection);
    }

    @Override
    public IntColumn neg(Selection selection) {
        return this.executeIntOperation(v -> v * -1, this.name() + "[ abs ]", selection);
    }

    @Override
    public IntColumn cumSum(Selection selection) {
        int[] total = new int[]{0};
        IntColumn result = IntColumn.create(this.name() + "[cumSum]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = total[0] + this.get(i);
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public IntColumn cumProd(Selection selection) {
        int[] total = new int[]{1};
        IntColumn result = IntColumn.create(this.name() + "[cumProd]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = total[0] * this.get(i);
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public IntColumn difference(Selection selection) {
        IntColumn result = IntColumn.create(this.name(), selection.size());
        int[] previous = new int[]{-1};
        selection.iterate(i -> {
            if (previous[0] == -1) {
                result.append(MISSING_VALUE);
            } else {
                result.append(this.isMissing(i) || this.isMissing(previous[0]) ? MISSING_VALUE : this.get(i) - this.get(previous[0]));
            }
            previous[0] = i;
        });
        return result;
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique(Selection selection) {
        IntIterator iterator = selection.iterator();
        BitmapBackedSelection count = new BitmapBackedSelection();
        while (iterator.hasNext()) {
            count.add(this.get(iterator.nextInt()));
        }
        return count.size();
    }

    @Override
    public long sumIf(IntPredicate predicate, Selection selection) {
        long sum = 0L;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int next = this.get(iterator.nextInt());
            if (!predicate.test(next)) continue;
            sum += (long)next;
        }
        return sum;
    }

    @Override
    public long countIf(IntPredicate predicate, Selection selection) {
        long count = 0L;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int next = this.get(iterator.nextInt());
            if (!predicate.test(next)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isLessThan(int i, Selection selection) {
        return this.select(isLessThan, i, selection);
    }

    @Override
    public Selection isGreaterThan(int i, Selection selection) {
        return this.select(isGreaterThan, i, selection);
    }

    @Override
    public Selection isGreaterThanOrEqualTo(int i, Selection selection) {
        return this.select(isGreaterThanOrEqualTo, i, selection);
    }

    @Override
    public Selection isLessThanOrEqualTo(int i, Selection selection) {
        return this.select(isLessThanOrEqualTo, i, selection);
    }

    @Override
    public Selection isNotEqualTo(int i, Selection selection) {
        return this.select(isNotEqualTo, i, selection);
    }

    @Override
    public Selection isEqualTo(int i, Selection selection) {
        return this.select(isEqualTo, i, selection);
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.select(isMissing, selection);
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.select(isNotMissing, selection);
    }

    @Override
    public Selection isIn(Selection selection, int ... values) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        block0: while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            int next = this.data.getInt(idx);
            for (int v : values) {
                if (v != next) continue;
                bitmap.add(idx);
                continue block0;
            }
        }
        return bitmap;
    }

    @Override
    public Selection isEqualTo(IntColumn other, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        IntIterator otherIterator = other.getSelection().iterator();
        while (true) {
            boolean hasNext = iterator.hasNext();
            boolean otherHasNext = otherIterator.hasNext();
            if (!hasNext || !otherHasNext) break;
            int next = iterator.nextInt();
            int otherNext = otherIterator.nextInt();
            if (this.get(next) != this.get(otherNext)) continue;
            results.add(next);
        }
        return results;
    }

    @Override
    public Selection isGreaterThan(IntColumn other, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        IntIterator otherIterator = other.getSelection().iterator();
        while (true) {
            boolean hasNext = iterator.hasNext();
            boolean otherHasNext = otherIterator.hasNext();
            if (!hasNext || !otherHasNext) break;
            int next = iterator.nextInt();
            int otherNext = otherIterator.nextInt();
            if (this.get(next) <= this.get(otherNext)) continue;
            results.add(next);
        }
        return results;
    }

    @Override
    public Selection isLessThan(IntColumn other, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        IntIterator otherIterator = other.getSelection().iterator();
        while (true) {
            boolean hasNext = iterator.hasNext();
            boolean otherHasNext = otherIterator.hasNext();
            if (!hasNext || !otherHasNext) break;
            int next = iterator.nextInt();
            int otherNext = otherIterator.nextInt();
            if (this.get(next) <= this.get(otherNext)) continue;
            results.add(next);
        }
        return results;
    }

    @Override
    public Selection isPositive(Selection selection) {
        return this.select(isPositive, selection);
    }

    @Override
    public Selection isNegative(Selection selection) {
        return this.select(isNegative, selection);
    }

    @Override
    public Selection isNonNegative(Selection selection) {
        return this.select(isNonNegative, selection);
    }

    @Override
    public Selection isZero(Selection selection) {
        return this.select(isZero, selection);
    }

    @Override
    public Selection isEven(Selection selection) {
        return this.select(isEven, selection);
    }

    @Override
    public Selection isOdd(Selection selection) {
        return this.select(isOdd, selection);
    }

    @Override
    public Selection select(IntPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            int next = this.data.getInt(idx);
            if (!predicate.test(next)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public Selection select(IntBiPredicate predicate, int value, Selection selection) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            int next = this.data.getInt(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getInt(row1), column2.getInt(row2));
    }

    private int compare(int v1, int v2) {
        if (v1 == v2) {
            return 0;
        }
        if (IntColumnImpl.isMissingValue(v1)) {
            return -1;
        }
        if (IntColumnImpl.isMissingValue(v2)) {
            return 1;
        }
        return Integer.compare(v1, v2);
    }

    private static int convert(String stringValue) {
        if (TypeUtils.isNullOrEmpty(stringValue) || TypeUtils.MISSING_INDICATORS.contains(stringValue)) {
            return MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Integer.parseInt(matcher.replaceAll(""));
    }

    public static int convert(Object objectValue) {
        if (objectValue == null || objectValue instanceof String) {
            return IntColumnImpl.convert((String)objectValue);
        }
        if (objectValue instanceof Number) {
            return ((Number)objectValue).intValue();
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + String.valueOf(objectValue) + " to Int");
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        IntIterator intIterator = this.data.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            builder.append(String.valueOf(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "Int column: " + this.name();
    }

    @Override
    public IntColumn wrap(Selection selection) {
        return new IntColumnWrapper(this, selection);
    }
}

