/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.FloatColumn;
import com.streamscape.ds.stable.columns.FloatColumnWrapper;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.IntColumnImpl;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.columns.ShortColumnImpl;
import com.streamscape.ds.stable.filtering.FloatBiPredicate;
import com.streamscape.ds.stable.filtering.FloatPredicate;
import com.streamscape.ds.stable.lists.FloatArrayList;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FloatColumnImpl
extends AbstractColumn
implements FloatColumn {
    public static final float MISSING_VALUE = ((Float)ColumnType.FLOAT.getMissingValue()).floatValue();
    private static final int BYTE_SIZE = 4;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private FloatArrayList data;
    private final IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer r1, Integer r2) {
            return this.compare((int)r1, (int)r2);
        }

        @Override
        public int compare(int r1, int r2) {
            return FloatColumnImpl.this.compare(FloatColumnImpl.this.data.getFloat(r1), FloatColumnImpl.this.data.getFloat(r2));
        }
    };
    FloatPredicate isZero = i -> i == 0.0f;
    FloatPredicate isNegative = i -> i < 0.0f;
    FloatPredicate isPositive = i -> i > 0.0f;
    FloatPredicate isNonNegative = i -> i >= 0.0f;
    FloatBiPredicate isGreaterThan = (valueToTest, valueToCompareAgainst) -> valueToTest > valueToCompareAgainst;
    FloatBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    FloatBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    FloatBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    FloatBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;
    FloatBiPredicate isNotEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest != valueToCompareAgainst;
    FloatPredicate isMissing = i -> i != i;
    FloatPredicate isNotMissing = i -> i == i;

    public FloatColumnImpl(String name) {
        this(name, new FloatArrayList(128));
    }

    public FloatColumnImpl(String name, int initialSize) {
        this(name, new FloatArrayList(initialSize));
    }

    public FloatColumnImpl(String name, float[] arr) {
        this(name, new FloatArrayList(arr));
    }

    public FloatColumnImpl(String name, FloatArrayList data) {
        super(name);
        this.data = data;
    }

    public FloatColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.data = new FloatArrayList(metadata.getSize());
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.FLOAT;
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create(this.name());
        CategoryColumn nameColumn = CategoryColumn.create("Property");
        IntColumn valueColumn = IntColumn.create("Value");
        table.addColumn(nameColumn);
        table.addColumn(valueColumn);
        nameColumn.append("Size");
        valueColumn.append(this.size());
        return table;
    }

    @Override
    public void append(float f) {
        this.data.add(f);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void append(double d) {
        this.data.add((float)d);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void appendObject(Object object) {
        try {
            this.append(FloatColumnImpl.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getFloat(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(this.getMissingValue());
    }

    @Override
    public void setObject(int index, Object object) {
        try {
            this.set(index, FloatColumnImpl.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, FloatColumnImpl.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        if (IntColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setShort(int row, short value) {
        if (ShortColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setLong(int row, long value) {
        if (LongColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setFloat(int row, float value) {
        if (FloatColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setDouble(int row, double value) {
        if (DoubleColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, (float)value);
        }
    }

    @Override
    public void setBoolean(int row, boolean value) {
        this.set(row, value ? 1.0f : 0.0f);
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void set(int r, float value) {
        this.data.set(r, value);
        this.onDataChanged(r);
    }

    @Override
    public void set(float newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        FloatColumn floatColumn = (FloatColumn)column;
        for (int i = 0; i < floatColumn.size(); ++i) {
            this.append(floatColumn.get(i));
        }
    }

    @Override
    public void assignWithValue(Object object) {
        float value = FloatColumnImpl.convert(object);
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(FloatColumnImpl.convert(object), size);
    }

    @Override
    public void assignWithValue(float value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(float value, int size) {
        for (int i = 0; i < size; ++i) {
            this.append(value);
        }
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getFloat(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        float[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            float tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public float get(int index) {
        return this.data.getFloat(index);
    }

    @Override
    public String getString(int row) {
        float value = this.data.getFloat(row);
        if (FloatColumnImpl.isMissingValue(value)) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Object getObject(int row) {
        return Float.valueOf(this.get(row));
    }

    @Override
    public int getInt(int row) {
        if (this.isMissing(row)) {
            return IntColumnImpl.MISSING_VALUE;
        }
        return (int)this.get(row);
    }

    @Override
    public short getShort(int row) {
        if (this.isMissing(row)) {
            return ShortColumnImpl.MISSING_VALUE;
        }
        return (short)this.get(row);
    }

    @Override
    public long getLong(int row) {
        if (this.isMissing(row)) {
            return LongColumnImpl.MISSING_VALUE;
        }
        return (long)this.get(row);
    }

    @Override
    public float getFloat(int row) {
        if (this.isMissing(row)) {
            return MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public double getDouble(int row) {
        if (this.isMissing(row)) {
            return DoubleColumnImpl.MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public boolean getBoolean(int row) {
        if (this.isMissing(row)) {
            return false;
        }
        return this.get(row) != 0.0f;
    }

    @Override
    public boolean isMissing(int row) {
        return FloatColumnImpl.isMissingValue(this.get(row));
    }

    public float getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public FloatArrayList data() {
        return this.data;
    }

    @Override
    public float firstElement(Selection selection) {
        IntIterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            return this.data.getFloat(iterator.nextInt());
        }
        return MISSING_VALUE;
    }

    public static boolean isMissingValue(float value) {
        return Float.compare(value, MISSING_VALUE) == 0;
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    @Override
    public boolean contains(float value) {
        return this.data.contains(value);
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(4).putFloat(this.get(rowNumber)).array();
    }

    @Override
    public FloatColumn select(Selection selection) {
        IntIterator iterator = selection.iterator();
        FloatColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public FloatColumn selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        FloatColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.get(row));
        }
        return result;
    }

    @Override
    public FloatColumn emptyCopy() {
        FloatColumn column = FloatColumn.create(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public FloatColumn emptyCopy(int rowSize) {
        FloatColumn column = FloatColumn.create(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public FloatColumn copy() {
        FloatColumn column = FloatColumn.create(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public FloatColumn trimToSelection(Selection selection) {
        FloatColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.get(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public FloatArrayList top(int n, Selection selection) {
        FloatColumn result = FloatColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        FloatArrayList top = new FloatArrayList();
        for (int i = result.data().size() - 1; i >= result.data().size() - n - 1 && i >= 0; --i) {
            top.add(result.get(i));
        }
        return top;
    }

    @Override
    public FloatArrayList bottom(int n, Selection selection) {
        FloatColumn result = FloatColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        FloatArrayList top = new FloatArrayList();
        for (int i = 0; i < n && i < result.data().size(); ++i) {
            top.add(result.get(i));
        }
        return top;
    }

    private FloatColumn executeFloatOperation(FloatUnaryOperator operator, String name, Selection selection) {
        FloatColumn result = FloatColumn.create(name, selection.size());
        selection.iterate(i -> result.append(this.isMissing(i) ? MISSING_VALUE : operator.apply(this.get(i))));
        return result;
    }

    private FloatColumn executeFloatOperation(FloatBinaryOperator operator, Column column2, String operation, Selection selection) {
        FloatColumn result = FloatColumn.create(this.name() + operation + column2.name(), selection.size());
        IntIterator iterator2 = column2.getSelection().iterator();
        selection.iterate(i -> {
            if (!iterator2.hasNext()) {
                return;
            }
            int i2 = iterator2.nextInt();
            result.append(this.isMissing(i) || column2.isMissing(i2) ? MISSING_VALUE : operator.apply(this.get(i), column2.getFloat(i2)));
        });
        return result;
    }

    @Override
    public FloatColumn add(float value, Selection selection) {
        return this.executeFloatOperation(v -> v + value, this.name() + " + " + value, selection);
    }

    @Override
    public FloatColumn add(Column column2, Selection selection) {
        return this.executeFloatOperation((v1, v2) -> v1 + v2, column2, " + ", selection);
    }

    @Override
    public FloatColumn remainder(float value, Selection selection) {
        return this.executeFloatOperation(v -> v % value, this.name() + " % " + value, selection);
    }

    @Override
    public FloatColumn remainder(Column column2, Selection selection) {
        return this.executeFloatOperation((v1, v2) -> v1 % v2, column2, " & ", selection);
    }

    @Override
    public FloatColumn subtract(float value, Selection selection) {
        return this.executeFloatOperation(v -> v - value, this.name() + " - " + value, selection);
    }

    @Override
    public FloatColumn subtract(Column column2, Selection selection) {
        return this.executeFloatOperation((v1, v2) -> v1 - v2, column2, " - ", selection);
    }

    @Override
    public FloatColumn multiply(float value, Selection selection) {
        return this.executeFloatOperation(v -> v * value, this.name() + " * " + value, selection);
    }

    @Override
    public FloatColumn multiply(Column column2, Selection selection) {
        return this.executeFloatOperation((v1, v2) -> v1 * v2, column2, " * ", selection);
    }

    @Override
    public FloatColumn divide(float value, Selection selection) {
        return this.executeFloatOperation(v -> v / value, this.name() + " / " + value, selection);
    }

    @Override
    public FloatColumn divide(Column column2, Selection selection) {
        return this.executeFloatOperation((v1, v2) -> v1 / v2, column2, " / ", selection);
    }

    @Override
    public FloatColumn round(Selection selection) {
        return this.executeFloatOperation(v -> Math.round(v), this.name() + " round", selection);
    }

    @Override
    public FloatColumn square(Selection selection) {
        return this.executeFloatOperation(v -> (float)Math.pow(v, 2.0), this.name() + "[ square ]", selection);
    }

    @Override
    public FloatColumn cube(Selection selection) {
        return this.executeFloatOperation(v -> (float)Math.pow(v, 3.0), this.name() + "[ cube ]", selection);
    }

    @Override
    public FloatColumn abs(Selection selection) {
        return this.executeFloatOperation(v -> Math.abs(v), this.name() + "[ abs ]", selection);
    }

    @Override
    public FloatColumn neg(Selection selection) {
        return this.executeFloatOperation(v -> v * -1.0f, this.name() + "[ abs ]", selection);
    }

    @Override
    public FloatColumn cumSum(Selection selection) {
        float[] total = new float[]{0.0f};
        FloatColumn result = FloatColumn.create(this.name() + "[cumSum]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = total[0] + this.get(i);
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public FloatColumn cumProd(Selection selection) {
        float[] total = new float[]{1.0f};
        FloatColumn result = FloatColumn.create(this.name() + "[cumProd]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = total[0] * this.get(i);
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public FloatColumn difference(Selection selection) {
        FloatColumn result = FloatColumn.create(this.name(), selection.size());
        int[] previous = new int[]{-1};
        selection.iterate(i -> {
            if (previous[0] == -1) {
                result.append(MISSING_VALUE);
            } else {
                result.append(this.isMissing(i) || this.isMissing(previous[0]) ? MISSING_VALUE : this.get(i) - this.get(previous[0]));
            }
            previous[0] = i;
        });
        return result;
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isLessThan(float f, Selection selection) {
        return this.select(this.isLessThan, f, selection);
    }

    @Override
    public Selection isZero(Selection selection) {
        return this.select(this.isZero, selection);
    }

    @Override
    public Selection isNegative(Selection selection) {
        return this.select(this.isNegative, selection);
    }

    @Override
    public Selection isPositive(Selection selection) {
        return this.select(this.isPositive, selection);
    }

    @Override
    public Selection isNonNegative(Selection selection) {
        return this.select(this.isNonNegative, selection);
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.select(this.isMissing, selection);
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.select(this.isNotMissing, selection);
    }

    @Override
    public Selection isGreaterThan(float f, Selection selection) {
        return this.select(this.isGreaterThan, f, selection);
    }

    @Override
    public Selection isGreaterThanOrEqualTo(float f, Selection selection) {
        return this.select(this.isGreaterThanOrEqualTo, f, selection);
    }

    @Override
    public Selection isLessThanOrEqualTo(float f, Selection selection) {
        return this.select(this.isLessThanOrEqualTo, f, selection);
    }

    @Override
    public Selection isNotEqualTo(float f, Selection selection) {
        return this.select(this.isNotEqualTo, f, selection);
    }

    @Override
    public Selection isEqualTo(float f, Selection selection) {
        return this.select(this.isEqualTo, f, selection);
    }

    @Override
    public Selection isEqualTo(FloatColumn other, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        IntIterator otherIterator = other.getSelection().iterator();
        while (true) {
            boolean hasNext = iterator.hasNext();
            boolean otherHasNext = otherIterator.hasNext();
            if (!hasNext || !otherHasNext) break;
            int next = iterator.nextInt();
            int otherNext = otherIterator.nextInt();
            if (this.get(next) != this.get(otherNext)) continue;
            results.add(next);
        }
        return results;
    }

    @Override
    public Selection isGreaterThan(FloatColumn other, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        IntIterator otherIterator = other.getSelection().iterator();
        while (true) {
            boolean hasNext = iterator.hasNext();
            boolean otherHasNext = otherIterator.hasNext();
            if (!hasNext || !otherHasNext) break;
            int next = iterator.nextInt();
            int otherNext = otherIterator.nextInt();
            if (!(this.get(next) > this.get(otherNext))) continue;
            results.add(next);
        }
        return results;
    }

    @Override
    public Selection isLessThan(FloatColumn other, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        IntIterator otherIterator = other.getSelection().iterator();
        while (true) {
            boolean hasNext = iterator.hasNext();
            boolean otherHasNext = otherIterator.hasNext();
            if (!hasNext || !otherHasNext) break;
            int next = iterator.nextInt();
            int otherNext = otherIterator.nextInt();
            if (!(this.get(next) < this.get(otherNext))) continue;
            results.add(next);
        }
        return results;
    }

    @Override
    public Selection isCloseTo(float target, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            float f = this.get(i);
            if (Float.compare(f, target) != 0) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isCloseTo(double target, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            float f = this.get(i);
            if (Double.compare(f, 0.0) != 0) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection select(FloatPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            float next = this.data.getFloat(idx);
            if (!predicate.test(next)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public Selection select(FloatBiPredicate predicate, float value) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            float next = this.data.getFloat(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public Selection select(FloatBiPredicate predicate, float value, Selection selection) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            float next = this.data.getFloat(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getFloat(row1), column2.getFloat(row2));
    }

    private int compare(float v1, float v2) {
        if (v1 == v2) {
            return 0;
        }
        if (FloatColumnImpl.isMissingValue(v1)) {
            return -1;
        }
        if (FloatColumnImpl.isMissingValue(v2)) {
            return 1;
        }
        return Float.compare(v1, v2);
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        for (Float aData : this.data) {
            builder.append(String.valueOf(aData));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "Float column: " + this.name();
    }

    public static float convert(String stringValue) {
        if (TypeUtils.isNullOrEmpty(stringValue) || TypeUtils.MISSING_INDICATORS.contains(stringValue)) {
            return MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Float.parseFloat(matcher.replaceAll(""));
    }

    public static float convert(Object objectValue) {
        if (objectValue == null || objectValue instanceof String) {
            return FloatColumnImpl.convert((String)objectValue);
        }
        if (objectValue instanceof Number) {
            return ((Number)objectValue).floatValue();
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + String.valueOf(objectValue) + " to Float");
    }

    @Override
    public FloatColumn wrap(Selection selection) {
        return new FloatColumnWrapper(this, selection);
    }

    static interface FloatUnaryOperator {
        public float apply(float var1);
    }

    static interface FloatBinaryOperator {
        public float apply(float var1, float var2);
    }
}

