/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.DoubleColumnWrapper;
import com.streamscape.ds.stable.columns.FloatColumnImpl;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.IntColumnImpl;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.columns.ShortColumnImpl;
import com.streamscape.ds.stable.filtering.DoubleBiPredicate;
import com.streamscape.ds.stable.filtering.DoublePredicate;
import com.streamscape.ds.stable.lists.DoubleArrayList;
import com.streamscape.ds.stable.lists.DoubleIterator;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DoubleColumnImpl
extends AbstractColumn
implements DoubleColumn {
    public static final double MISSING_VALUE = (Double)ColumnType.DOUBLE.getMissingValue();
    private static final int BYTE_SIZE = 8;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static int DEFAULT_ARRAY_SIZE = 128;
    private DoubleArrayList data;
    private final IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer r1, Integer r2) {
            double f1 = DoubleColumnImpl.this.data.getDouble(r1);
            double f2 = DoubleColumnImpl.this.data.getDouble(r2);
            return Double.compare(f1, f2);
        }

        @Override
        public int compare(int r1, int r2) {
            return DoubleColumnImpl.this.compare(DoubleColumnImpl.this.data.getDouble(r1), DoubleColumnImpl.this.data.getDouble(r2));
        }
    };
    public static DoublePredicate isZero = i -> i == 0.0;
    public static DoublePredicate isNegative = i -> i < 0.0;
    public static DoublePredicate isPositive = i -> i > 0.0;
    public static DoublePredicate isNonNegative = i -> i >= 0.0;
    public static DoubleBiPredicate isGreaterThan = (valueToTest, valueToCompareAgainst) -> valueToTest > valueToCompareAgainst;
    public static DoubleBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    public static DoubleBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    public static DoubleBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    public static DoubleBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;
    public static DoubleBiPredicate isNotEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest != valueToCompareAgainst;
    public static DoublePredicate isMissing = i -> i != i;
    public static DoublePredicate isNotMissing = i -> i == i;

    public DoubleColumnImpl(String name) {
        this(name, new DoubleArrayList(DEFAULT_ARRAY_SIZE));
    }

    public DoubleColumnImpl(String name, int initialSize) {
        this(name, new DoubleArrayList(initialSize));
    }

    public DoubleColumnImpl(String name, double[] arr) {
        this(name, new DoubleArrayList(arr));
    }

    private DoubleColumnImpl(String name, DoubleArrayList data) {
        super(name);
        this.data = data;
    }

    public DoubleColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.data = new DoubleArrayList(metadata.getSize());
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.DOUBLE;
    }

    @Override
    public int byteSize() {
        return 8;
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create(this.name());
        CategoryColumn nameColumn = CategoryColumn.create("Property");
        IntColumn valueColumn = IntColumn.create("Value");
        table.addColumn(nameColumn);
        table.addColumn(valueColumn);
        nameColumn.append("Size");
        valueColumn.append(this.size());
        return table;
    }

    @Override
    public void append(float f) {
        this.data.add(f);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void append(double d) {
        this.data.add(d);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void appendObject(Object object) {
        try {
            this.append(DoubleColumnImpl.convert(object));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getDouble(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(DoubleColumnImpl.getMissingValue());
    }

    @Override
    public void setObject(int index, Object object) {
        try {
            this.set(index, DoubleColumnImpl.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, DoubleColumnImpl.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        if (IntColumnImpl.isMissingValue(value)) {
            this.set(row, DoubleColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setShort(int row, short value) {
        if (ShortColumnImpl.isMissingValue(value)) {
            this.set(row, DoubleColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setLong(int row, long value) {
        if (LongColumnImpl.isMissingValue(value)) {
            this.set(row, DoubleColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setFloat(int row, float value) {
        if (FloatColumnImpl.isMissingValue(value)) {
            this.set(row, DoubleColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setDouble(int row, double value) {
        if (DoubleColumnImpl.isMissingValue(value)) {
            this.set(row, DoubleColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setBoolean(int row, boolean value) {
        this.set(row, value ? 1.0 : 0.0);
    }

    @Override
    public void set(int r, double value) {
        this.data.set(r, value);
        this.onDataChanged(r);
    }

    @Override
    public void set(double newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getDouble(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        DoubleColumn doubleColumn = (DoubleColumn)column;
        for (int i = 0; i < doubleColumn.size(); ++i) {
            this.append(doubleColumn.get(i));
        }
    }

    @Override
    public void assignWithValue(Object object) {
        this.assignWithValue(DoubleColumnImpl.convert(object));
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(DoubleColumnImpl.convert(object), size);
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public void assignWithValue(double value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(double value, int size) {
        for (int i = 0; i < size; ++i) {
            this.append(value);
        }
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        double[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            double tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public double get(int index) {
        return this.data.getDouble(index);
    }

    @Override
    public String getString(int row) {
        double value = this.data.getDouble(row);
        if (DoubleColumnImpl.isMissingValue(value)) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        if (this.isMissing(row)) {
            return IntColumnImpl.MISSING_VALUE;
        }
        return (int)this.get(row);
    }

    @Override
    public short getShort(int row) {
        if (this.isMissing(row)) {
            return ShortColumnImpl.MISSING_VALUE;
        }
        return (short)this.get(row);
    }

    @Override
    public long getLong(int row) {
        if (this.isMissing(row)) {
            return LongColumnImpl.MISSING_VALUE;
        }
        return (long)this.get(row);
    }

    @Override
    public float getFloat(int row) {
        if (this.isMissing(row)) {
            return FloatColumnImpl.MISSING_VALUE;
        }
        return (float)this.get(row);
    }

    @Override
    public double getDouble(int row) {
        if (this.isMissing(row)) {
            return MISSING_VALUE;
        }
        return this.get(row);
    }

    @Override
    public boolean getBoolean(int row) {
        if (this.isMissing(row)) {
            return false;
        }
        return this.get(row) != 0.0;
    }

    @Override
    public boolean isMissing(int row) {
        return DoubleColumnImpl.isMissingValue(this.get(row));
    }

    public static boolean isMissingValue(double value) {
        return Double.compare(value, MISSING_VALUE) == 0;
    }

    public static double getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public DoubleArrayList data() {
        return this.data;
    }

    @Override
    public double firstElement(Selection selection) {
        IntIterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            return this.data.getDouble(iterator.nextInt());
        }
        return MISSING_VALUE;
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    @Override
    public boolean contains(double value) {
        return this.data.contains(value);
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(8).putDouble(this.get(rowNumber)).array();
    }

    @Override
    public DoubleColumn select(Selection selection) {
        IntIterator iterator = selection.iterator();
        DoubleColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public DoubleColumn selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        DoubleColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.get(row));
        }
        return result;
    }

    @Override
    public DoubleColumn emptyCopy() {
        DoubleColumn column = DoubleColumn.create(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DoubleColumn emptyCopy(int rowSize) {
        DoubleColumn column = DoubleColumn.create(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DoubleColumn copy() {
        DoubleColumnImpl column = new DoubleColumnImpl(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DoubleColumn trimToSelection(Selection selection) {
        DoubleColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.get(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public DoubleArrayList top(int n, Selection selection) {
        DoubleColumn result = DoubleColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        DoubleArrayList top = new DoubleArrayList();
        for (int i = result.data().size() - 1; i >= result.data().size() - n - 1 && i >= 0; --i) {
            top.add(result.get(i));
        }
        return top;
    }

    @Override
    public DoubleArrayList bottom(int n, Selection selection) {
        DoubleColumn result = DoubleColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.get(iterator.nextInt()));
        }
        result.sortAscending();
        DoubleArrayList top = new DoubleArrayList();
        for (int i = 0; i < n && i < result.data().size(); ++i) {
            top.add(result.get(i));
        }
        return top;
    }

    private DoubleColumn executeDoubleOperation1(DoubleUnaryOperator operator, String name, Selection selection) {
        DoubleColumn result = DoubleColumn.create(name, selection.size());
        selection.iterate(i -> result.append(this.isMissing(i) ? MISSING_VALUE : operator.applyAsDouble(this.get(i))));
        return result;
    }

    private DoubleColumn executeDoubleOperation(DoubleBinaryOperator operator, Column column2, String operation, Selection selection) {
        DoubleColumn result = DoubleColumn.create(this.name() + operation + column2.name(), selection.size());
        IntIterator iterator2 = column2.getSelection().iterator();
        selection.iterate(i -> {
            if (!iterator2.hasNext()) {
                return;
            }
            int i2 = iterator2.nextInt();
            result.append(this.isMissing(i) || column2.isMissing(i2) ? MISSING_VALUE : operator.applyAsDouble(this.get(i), column2.getDouble(i2)));
        });
        return result;
    }

    @Override
    public DoubleColumn add(double value, Selection selection) {
        return this.executeDoubleOperation1(v -> v + value, this.name() + " + " + value, selection);
    }

    @Override
    public DoubleColumn add(Column column2, Selection selection) {
        return this.executeDoubleOperation((v1, v2) -> v1 + v2, column2, " + ", selection);
    }

    @Override
    public DoubleColumn remainder(double value, Selection selection) {
        return this.executeDoubleOperation1(v -> v % value, this.name() + " % " + value, selection);
    }

    @Override
    public DoubleColumn remainder(Column column2, Selection selection) {
        return this.executeDoubleOperation((v1, v2) -> v1 % v2, column2, " & ", selection);
    }

    @Override
    public DoubleColumn subtract(double value, Selection selection) {
        return this.executeDoubleOperation1(v -> v - value, this.name() + " - " + value, selection);
    }

    @Override
    public DoubleColumn subtract(Column column2, Selection selection) {
        return this.executeDoubleOperation((v1, v2) -> v1 - v2, column2, " - ", selection);
    }

    @Override
    public DoubleColumn multiply(double value, Selection selection) {
        return this.executeDoubleOperation1(v -> v * value, this.name() + " * " + value, selection);
    }

    @Override
    public DoubleColumn multiply(Column column2, Selection selection) {
        return this.executeDoubleOperation((v1, v2) -> v1 * v2, column2, " * ", selection);
    }

    @Override
    public DoubleColumn divide(double value, Selection selection) {
        return this.executeDoubleOperation1(v -> v / value, this.name() + " / " + value, selection);
    }

    @Override
    public DoubleColumn divide(Column column2, Selection selection) {
        return this.executeDoubleOperation((v1, v2) -> v1 / v2, column2, " / ", selection);
    }

    @Override
    public DoubleColumn round(Selection selection) {
        return this.executeDoubleOperation1(v -> Math.round(v), this.name() + " round", selection);
    }

    @Override
    public DoubleColumn square(Selection selection) {
        return this.executeDoubleOperation1(v -> Math.pow(v, 2.0), this.name() + "[ square ]", selection);
    }

    @Override
    public DoubleColumn cube(Selection selection) {
        return this.executeDoubleOperation1(v -> Math.pow(v, 3.0), this.name() + "[ cube ]", selection);
    }

    @Override
    public DoubleColumn abs(Selection selection) {
        return this.executeDoubleOperation1(v -> Math.abs(v), this.name() + "[ abs ]", selection);
    }

    @Override
    public DoubleColumn neg(Selection selection) {
        return this.executeDoubleOperation1(v -> v * -1.0, this.name() + "[ abs ]", selection);
    }

    @Override
    public DoubleColumn cumSum(Selection selection) {
        double[] total = new double[]{0.0};
        DoubleColumn result = DoubleColumn.create(this.name() + "[cumSum]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = total[0] + this.get(i);
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public DoubleColumn cumProd(Selection selection) {
        double[] total = new double[]{1.0};
        DoubleColumn result = DoubleColumn.create(this.name() + "[cumProd]", selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = total[0] * this.get(i);
                result.append(total[0]);
            }
        });
        return result;
    }

    @Override
    public DoubleColumn difference(Selection selection) {
        DoubleColumn result = DoubleColumn.create(this.name(), selection.size());
        int[] previous = new int[]{-1};
        selection.iterate(i -> {
            if (previous[0] == -1) {
                result.append(MISSING_VALUE);
            } else {
                result.append(this.isMissing(i) || this.isMissing(previous[0]) ? MISSING_VALUE : this.get(i) - this.get(previous[0]));
            }
            previous[0] = i;
        });
        return result;
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isLessThan(double f, Selection selection) {
        return this.select(isLessThan, f, selection);
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.select(isMissing, selection);
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.select(isNotMissing, selection);
    }

    @Override
    public Selection isGreaterThan(double f, Selection selection) {
        return this.select(isGreaterThan, f, selection);
    }

    @Override
    public Selection isGreaterThanOrEqualTo(double f, Selection selection) {
        return this.select(isGreaterThanOrEqualTo, f, selection);
    }

    @Override
    public Selection isLessThanOrEqualTo(double f, Selection selection) {
        return this.select(isLessThanOrEqualTo, f, selection);
    }

    @Override
    public Selection isNotEqualTo(double d, Selection selection) {
        return this.select(isNotEqualTo, d, selection);
    }

    @Override
    public Selection isEqualTo(double d, Selection selection) {
        return this.select(isEqualTo, d, selection);
    }

    @Override
    public Selection isEqualTo(DoubleColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.dataSize()) {
            if (this.data.elements()[i] != f.get(i)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isGreaterThan(DoubleColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.dataSize()) {
            if (!(this.data.elements()[i] > f.get(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isLessThan(DoubleColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.dataSize()) {
            if (!(this.data.elements()[i] < f.get(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isCloseTo(float target, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (Double.compare(this.get(i), target) != 0) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isCloseTo(double target, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (Double.compare(this.get(i), target) != 0) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isPositive(Selection selection) {
        return this.select(isPositive, selection);
    }

    @Override
    public Selection isZero(Selection selection) {
        return this.select(isZero, selection);
    }

    @Override
    public Selection isNegative(Selection selection) {
        return this.select(isNegative, selection);
    }

    @Override
    public Selection isNonNegative(Selection selection) {
        return this.select(isNonNegative, selection);
    }

    @Override
    public Selection select(DoublePredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            double next = this.data.getDouble(idx);
            if (!predicate.test(next)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public Selection select(DoubleBiPredicate predicate, double value, Selection selection) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            double next = this.data.getDouble(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getDouble(row1), column2.getDouble(row2));
    }

    private int compare(double v1, double v2) {
        if (v1 == v2) {
            return 0;
        }
        if (DoubleColumnImpl.isMissingValue(v1)) {
            return -1;
        }
        if (DoubleColumnImpl.isMissingValue(v2)) {
            return 1;
        }
        return Double.compare(v1, v2);
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        DoubleIterator doubleIterator = this.data.iterator();
        while (doubleIterator.hasNext()) {
            double aData = (Double)doubleIterator.next();
            builder.append(String.valueOf(aData));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "Double column: " + this.name();
    }

    public static double convert(String stringValue) {
        if (TypeUtils.isNullOrEmpty(stringValue) || TypeUtils.MISSING_INDICATORS.contains(stringValue)) {
            return MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Double.parseDouble(matcher.replaceAll(""));
    }

    public static double convert(Object objectValue) {
        if (objectValue == null || objectValue instanceof String) {
            return DoubleColumnImpl.convert((String)objectValue);
        }
        if (objectValue instanceof Number) {
            return ((Number)objectValue).doubleValue();
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + String.valueOf(objectValue) + " to Double");
    }

    @Override
    public DoubleColumn wrap(Selection selection) {
        return new DoubleColumnWrapper(this, selection);
    }
}

