/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DecimalColumnImpl;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.math.BigDecimal;

public class DecimalColumnUtils {
    public static final int MAX_ALLOWED_PRECISION = 19;
    static final long[] MULTIPLIERS = new long[20];
    static final double[] MULTIPLIERS_NEG = new double[20];

    public static void checkPrecisionScale(int precision, int scale) {
        if (precision < 0 || precision > 19) {
            throw new IllegalArgumentException("Decimal precision for snapshot table must be between 0 and 19, but provided " + precision + ".");
        }
        if (scale < 0 || scale > precision) {
            throw new IllegalArgumentException("Decimal scale for snapshot table must be  must be between 0 and current precision value " + precision + ", but provided " + scale + ".");
        }
    }

    public static void checkScale(int scale) {
        DecimalColumnUtils.checkPrecisionScale(19, scale);
    }

    public static long convertToLongInScale(long value, int valueScale, int scale) {
        if (value == DecimalColumnImpl.MISSING_VALUE) {
            return value;
        }
        DecimalColumnUtils.checkScale(scale);
        if (valueScale == scale) {
            return value;
        }
        if (valueScale < scale) {
            return value * MULTIPLIERS[scale - valueScale];
        }
        return value / MULTIPLIERS[valueScale - scale];
    }

    public static long convertToLongInScale(BigDecimal value, int scale) {
        DecimalColumnUtils.checkPrecisionScale(value.precision(), 0);
        DecimalColumnUtils.checkScale(scale);
        if (value.scale() == scale) {
            return value.unscaledValue().longValue();
        }
        if (value.scale() > scale) {
            return value.scaleByPowerOfTen(scale).longValue();
        }
        return value.scaleByPowerOfTen(scale - value.scale()).longValue();
    }

    public static long convertToLongInScale(double value, int scale) {
        DecimalColumnUtils.checkScale(scale);
        return DecimalColumnUtils.fromDouble0(value, scale);
    }

    private static long fromDouble0(double value, int scale) {
        long multiplier = MULTIPLIERS[scale];
        double multiplied = value * (double)multiplier;
        long converted = Math.round(multiplied);
        return converted;
    }

    public static long convertFromStringInScale(String value, int scale) {
        if (TypeUtils.isNullOrEmpty(value) || TypeUtils.MISSING_INDICATORS.contains(value)) {
            return (Long)ColumnType.DECIMAL.getMissingValue();
        }
        return DecimalColumnUtils.convertToLongInScale(new BigDecimal(value), scale);
    }

    public static long convertFromObjectInScale(Object value, int scale) {
        if (value == null || value instanceof String) {
            return DecimalColumnUtils.convertFromStringInScale((String)value, scale);
        }
        if (value instanceof Double) {
            return DecimalColumnUtils.convertToLongInScale((Double)value, scale);
        }
        if (value instanceof BigDecimal) {
            return DecimalColumnUtils.convertToLongInScale((BigDecimal)value, scale);
        }
        if (value instanceof Number) {
            return DecimalColumnUtils.convertToLongInScale(((Number)value).longValue(), scale);
        }
        return DecimalColumnUtils.convertFromStringInScale(value.toString(), scale);
    }

    public static String convertToString(long value, int scale) {
        DecimalColumnUtils.checkScale(scale);
        if (scale == 0) {
            return Long.toString(value);
        }
        return String.valueOf(value / MULTIPLIERS[scale]) + "." + String.valueOf(value % MULTIPLIERS[scale]);
    }

    public static double convertToDouble(long value, int scale) {
        return (double)value / (double)MULTIPLIERS[scale];
    }

    private static BigDecimal convertToBigDecimal(long value, int scale) {
        return BigDecimal.valueOf(value, scale);
    }

    public static long sumInScale(long v1, double v2, int scale) {
        return v1 + DecimalColumnUtils.convertToLongInScale(v2, scale);
    }

    public static long sumInScale(long v1, long v2, int v1Scale, int v2Scale) {
        return v1 + DecimalColumnUtils.convertToLongInScale(v2, v2Scale, v1Scale);
    }

    public static long sumInScale(long v1, BigDecimal v2, int scale) {
        return v1 + DecimalColumnUtils.convertToLongInScale(v2, scale);
    }

    public static long reminderInScale(long v1, long v2, int scale) {
        return v1 % DecimalColumnUtils.convertToLongInScale(v2, scale);
    }

    public static long reminderInScale(long v1, double v2, int scale) {
        return v1 % DecimalColumnUtils.convertToLongInScale(v2, scale);
    }

    public static long reminderInScale(long v1, long v2, int v1Scale, int v2Scale) {
        return v1 % DecimalColumnUtils.convertToLongInScale(v2, v2Scale, v1Scale);
    }

    public static long reminderInScale(long v1, BigDecimal v2, int scale) {
        return v1 % DecimalColumnUtils.convertToLongInScale(v2, scale);
    }

    public static long subtractInScale(long v1, double v2, int scale) {
        return v1 - DecimalColumnUtils.convertToLongInScale(v2, scale);
    }

    public static long subtractInScale(long v1, long v2, int v1Scale, int v2Scale) {
        return v1 - DecimalColumnUtils.convertToLongInScale(v2, v2Scale, v1Scale);
    }

    public static long subtractInScale(long v1, BigDecimal v2, int scale) {
        return v1 - DecimalColumnUtils.convertToLongInScale(v2, scale);
    }

    public static long multiplyInScale(long v1, double v2, int scale) {
        return Math.round((double)v1 * v2);
    }

    public static long multiplyInScale(long v1, long v2, int v1Scale, int v2Scale) {
        return v1 * DecimalColumnUtils.convertToLongInScale(v2, v2Scale, v1Scale) / MULTIPLIERS[v1Scale];
    }

    public static long multiplyInScale(long v1, BigDecimal v2, int scale) {
        v2 = v2.multiply(DecimalColumnUtils.convertToBigDecimal(v1, scale));
        return DecimalColumnUtils.convertToLongInScale(v2, scale);
    }

    public static long divideInScale(long v1, double v2, int scale) {
        return Math.round((double)v1 / v2);
    }

    public static long divideInScale(long v1, long v2, int v1Scale, int v2Scale) {
        return Math.round((double)v1 / (double)DecimalColumnUtils.convertToLongInScale(v2, v2Scale, v1Scale) * (double)MULTIPLIERS[v1Scale]);
    }

    public static long divideInScale(long v1, BigDecimal v2, int scale) {
        return DecimalColumnUtils.convertToLongInScale(DecimalColumnUtils.convertToDouble(v1, scale) / v2.doubleValue(), scale);
    }

    static {
        long val = 1L;
        for (int i = 0; i <= 19; ++i) {
            DecimalColumnUtils.MULTIPLIERS[i] = val;
            DecimalColumnUtils.MULTIPLIERS_NEG[i] = 1.0 / (double)val;
            val *= 10L;
        }
    }
}

