/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DecimalColumnUtils;
import com.streamscape.ds.stable.columns.DecimalColumnWrapper;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.FloatColumnImpl;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.IntColumnImpl;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.columns.ShortColumnImpl;
import com.streamscape.ds.stable.filtering.IntPredicate;
import com.streamscape.ds.stable.filtering.LongBiPredicate;
import com.streamscape.ds.stable.filtering.LongPredicate;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.lists.LongArrayList;
import com.streamscape.ds.stable.lists.LongIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.LongUnaryOperator;

public class DecimalColumnImpl
extends AbstractColumn
implements DecimalColumn {
    public static final long MISSING_VALUE = (Long)ColumnType.DECIMAL.getMissingValue();
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 8;
    private LongArrayList data;
    private int precision;
    private int scale;
    private final IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        @Override
        public int compare(int i1, int i2) {
            return DecimalColumnImpl.this.compare(DecimalColumnImpl.this.data.getLong(i1), DecimalColumnImpl.this.data.getLong(i2));
        }
    };
    public static LongPredicate isZero = i -> i == 0L;
    public static LongPredicate isNegative = i -> i < 0L;
    public static LongPredicate isPositive = i -> i > 0L;
    public static LongPredicate isNonNegative = i -> i >= 0L;
    public static LongPredicate isEven = i -> (i & 1L) == 0L;
    public static LongPredicate isOdd = i -> (i & 1L) != 0L;
    public static LongPredicate isMissing = i -> i == LongColumnImpl.MISSING_VALUE;
    public static LongPredicate isNotMissing = i -> i != LongColumnImpl.MISSING_VALUE;

    public DecimalColumnImpl(String name, int scale) {
        this(name, 19, scale);
    }

    public DecimalColumnImpl(String name, int precision, int scale) {
        this(name, precision, scale, new LongArrayList(128));
    }

    public DecimalColumnImpl(String name, int precision, int scale, int initialSize) {
        this(name, precision, scale, new LongArrayList(initialSize));
    }

    public DecimalColumnImpl(String name, int precision, int scale, long[] arr) {
        this(name, precision, scale, new LongArrayList(arr));
    }

    private DecimalColumnImpl(String name, int precision, int scale, LongArrayList data) {
        super(name);
        this.data = data;
        this.precision = precision;
        this.scale = scale;
        DecimalColumnUtils.checkPrecisionScale(this.precision, this.scale);
    }

    public DecimalColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.data = new LongArrayList(metadata.getSize());
        this.precision = metadata.getPrecision();
        this.scale = metadata.getScale();
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.DECIMAL;
    }

    @Override
    public int byteSize() {
        return 8;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create(this.name());
        CategoryColumn nameColumn = CategoryColumn.create("Property");
        IntColumn valueColumn = IntColumn.create("Value");
        table.addColumn(nameColumn);
        table.addColumn(valueColumn);
        nameColumn.append("Size");
        valueColumn.append(this.size());
        return table;
    }

    private void appendInternal(long value) {
        this.data.add(value);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void append(long value, int valueScale) {
        this.appendInternal(DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale));
    }

    @Override
    public void append(BigDecimal value) {
        this.appendInternal(DecimalColumnUtils.convertToLongInScale(value, this.scale));
    }

    @Override
    public void append(double value) {
        this.appendInternal(DecimalColumnUtils.convertToLongInScale(value, this.scale));
    }

    private void setInternal(int index, long value) {
        this.data.set(index, value);
        this.onDataChanged(index);
    }

    @Override
    public void set(int index, long value, int valueScale) {
        this.setInternal(index, DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale));
    }

    @Override
    public void set(int index, BigDecimal value) {
        this.setInternal(index, DecimalColumnUtils.convertToLongInScale(value, this.scale));
    }

    @Override
    public void set(int index, double value) {
        this.setInternal(index, DecimalColumnUtils.convertToLongInScale(value, this.scale));
    }

    private void setInternal(long newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void set(long newValue, int valueScale, Selection rowSelection) {
        this.setInternal(DecimalColumnUtils.convertToLongInScale(newValue, valueScale, this.scale), rowSelection);
    }

    @Override
    public void set(BigDecimal newValue, Selection rowSelection) {
        this.setInternal(DecimalColumnUtils.convertToLongInScale(newValue, this.scale), rowSelection);
    }

    @Override
    public void set(double newValue, Selection rowSelection) {
        this.setInternal(DecimalColumnUtils.convertToLongInScale(newValue, this.scale), rowSelection);
    }

    private void assignWithValueInternal(long value) {
        for (int i = 0; i < this.size(); ++i) {
            this.setInternal(i, value);
        }
    }

    @Override
    public void assignWithValue(long value, int valueScale) {
        this.assignWithValueInternal(DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale));
    }

    @Override
    public void assignWithValue(BigDecimal value) {
        this.assignWithValueInternal(DecimalColumnUtils.convertToLongInScale(value, this.scale));
    }

    @Override
    public void assignWithValue(double value) {
        this.assignWithValueInternal(DecimalColumnUtils.convertToLongInScale(value, this.scale));
    }

    private void fillWithValueInternal(long value, int size) {
        for (int i = 0; i < size; ++i) {
            this.appendInternal(value);
        }
    }

    @Override
    public void fillWithValue(long value, int valueScale, int size) {
        this.fillWithValueInternal(DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale), size);
    }

    @Override
    public void fillWithValue(BigDecimal value, int size) {
        this.fillWithValueInternal(DecimalColumnUtils.convertToLongInScale(value, this.scale), size);
    }

    @Override
    public void fillWithValue(double value, int size) {
        this.fillWithValueInternal(DecimalColumnUtils.convertToLongInScale(value, this.scale), size);
    }

    @Override
    public void assignWithValue(Object object) {
        this.assignWithValue(DecimalColumnUtils.convertFromObjectInScale(object, this.scale));
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(DecimalColumnUtils.convertFromObjectInScale(object, this.scale), size);
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        DecimalColumn decimalColumn = (DecimalColumn)column;
        for (int i = 0; i < decimalColumn.size(); ++i) {
            this.append(decimalColumn.getLongUnscaled(i), decimalColumn.getScale());
        }
    }

    @Override
    public void appendObject(Object object) {
        try {
            this.append(DecimalColumnUtils.convertFromObjectInScale(object, this.scale), this.scale);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(((DecimalColumn)column2).getLongUnscaled(row2), column2.getScale());
        }
    }

    @Override
    public void appendMissing() {
        this.append(DecimalColumnImpl.getMissingValue());
    }

    @Override
    public void setObject(int index, Object object) {
        try {
            this.set(index, DecimalColumnUtils.convertFromObjectInScale(object, this.scale));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, DecimalColumnUtils.convertFromObjectInScale(value, this.scale));
    }

    @Override
    public void setInt(int row, int value) {
        if (IntColumnImpl.isMissingValue(value)) {
            this.set(row, DecimalColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setShort(int row, short value) {
        if (ShortColumnImpl.isMissingValue(value)) {
            this.set(row, DecimalColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setLong(int row, long value) {
        if (LongColumnImpl.isMissingValue(value)) {
            this.set(row, DecimalColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setFloat(int row, float value) {
        if (FloatColumnImpl.isMissingValue(value)) {
            this.set(row, DecimalColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setDouble(int row, double value) {
        if (DoubleColumnImpl.isMissingValue(value)) {
            this.set(row, DecimalColumnImpl.getMissingValue());
        } else {
            this.set(row, value);
        }
    }

    @Override
    public void setBoolean(int row, boolean value) {
        this.set(row, value ? 1 : 0);
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getLong(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        long[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            long tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public long getLongUnscaled(int row) {
        if (this.isMissing(row)) {
            return LongColumnImpl.MISSING_VALUE;
        }
        return this.getInternal(row);
    }

    @Override
    public BigDecimal get(int row) {
        if (this.isMissing(row)) {
            return null;
        }
        return BigDecimal.valueOf(this.getInternal(row), this.scale);
    }

    @Override
    public String getString(int row) {
        if (this.isMissing(row)) {
            return null;
        }
        return DecimalColumnUtils.convertToString(this.getInternal(row), this.scale);
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        if (this.isMissing(row)) {
            return IntColumnImpl.MISSING_VALUE;
        }
        return (int)this.getLong(row);
    }

    @Override
    public short getShort(int row) {
        if (this.isMissing(row)) {
            return ShortColumnImpl.MISSING_VALUE;
        }
        return (short)this.getLong(row);
    }

    @Override
    public long getLong(int row) {
        if (this.isMissing(row)) {
            return LongColumnImpl.MISSING_VALUE;
        }
        return DecimalColumnUtils.convertToLongInScale(this.getInternal(row), this.scale, 0);
    }

    @Override
    public float getFloat(int row) {
        if (this.isMissing(row)) {
            return FloatColumnImpl.MISSING_VALUE;
        }
        return (float)this.getDouble(row);
    }

    @Override
    public double getDouble(int row) {
        if (this.isMissing(row)) {
            return DoubleColumnImpl.MISSING_VALUE;
        }
        return DecimalColumnUtils.convertToDouble(this.getInternal(row), this.scale);
    }

    @Override
    public boolean getBoolean(int row) {
        if (this.isMissing(row)) {
            return false;
        }
        return this.getInternal(row) != 0L;
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    public long getInternal(int index) {
        return this.data.getLong(index);
    }

    @Override
    public BigDecimal firstElement(Selection selection) {
        IntIterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            return this.get(iterator.nextInt());
        }
        return null;
    }

    @Override
    public boolean isMissing(int row) {
        return DecimalColumnImpl.isMissingValue(this.getInternal(row));
    }

    @Override
    public LongArrayList data() {
        return this.data;
    }

    @Override
    public boolean contains(long value, int valueScale) {
        return this.data.contains(DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale));
    }

    @Override
    public boolean contains(BigDecimal value) {
        return this.data.contains(DecimalColumnUtils.convertToLongInScale(value, this.scale));
    }

    @Override
    public boolean contains(double value) {
        return this.data.contains(DecimalColumnUtils.convertToLongInScale(value, this.scale));
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(8).putLong(this.getInternal(rowNumber)).array();
    }

    protected static boolean isMissingValue(long value) {
        return value == MISSING_VALUE;
    }

    protected static long getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public DecimalColumn select(Selection selection) {
        IntIterator iterator = selection.iterator();
        DecimalColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.getLongUnscaled(iterator.nextInt()), this.scale);
        }
        return result;
    }

    @Override
    public DecimalColumn selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        DecimalColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.getLongUnscaled(row), this.scale);
        }
        return result;
    }

    @Override
    public DecimalColumn emptyCopy() {
        DecimalColumn column = DecimalColumn.create(this.name(), this.precision, this.scale, 128);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DecimalColumn emptyCopy(int rowSize) {
        DecimalColumn column = DecimalColumn.create(this.name(), this.precision, this.scale, rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DecimalColumn copy() {
        DecimalColumn copy = this.emptyCopy(this.size());
        copy.data().addAll(this.data);
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public DecimalColumn trimToSelection(Selection selection) {
        DecimalColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.getLongUnscaled(iterator.nextInt()), this.scale);
        }
        return column;
    }

    @Override
    public DecimalColumn selectIf(LongPredicate predicate) {
        DecimalColumn column = this.emptyCopy();
        for (int i = 0; i < this.data.size(); ++i) {
            long next = this.data.getLong(i);
            if (!predicate.test(next)) continue;
            column.append(next, this.scale);
        }
        return column;
    }

    @Override
    public LongArrayList top(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList top = new LongArrayList();
        for (int i = result.data().size() - 1; i >= result.data().size() - n - 1 && i >= 0; --i) {
            top.add(result.get(i));
        }
        return top;
    }

    @Override
    public LongArrayList bottom(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList bottom = new LongArrayList();
        for (int i = 0; i < n && i < result.data().size(); ++i) {
            bottom.add(result.get(i));
        }
        return bottom;
    }

    private DecimalColumn executeLongOperation(LongUnaryOperator operator, String name, Selection selection) {
        DecimalColumn result = this.emptyCopy(selection.size());
        selection.iterate(i -> result.append(this.isMissing(i) ? MISSING_VALUE : operator.applyAsLong(this.getLongUnscaled(i)), this.scale));
        return result;
    }

    private DecimalColumn executeLongOperation(BinaryDecimalOperation operator, Column column2, String operation, Selection selection) {
        DecimalColumn result = this.emptyCopy(selection.size());
        result.setName(this.name() + operation + column2.name());
        IntIterator iterator2 = column2.getSelection().iterator();
        selection.iterate(i -> {
            if (!iterator2.hasNext()) {
                return;
            }
            int i2 = iterator2.nextInt();
            if (this.isMissing(i) || column2.isMissing(i2)) {
                result.add(MISSING_VALUE);
            } else {
                long v1 = this.getLongUnscaled(i);
                if (column2.type() == ColumnType.DOUBLE || column2.type() == ColumnType.FLOAT) {
                    result.append(operator.applyAsDouble(v1, column2.getDouble(i)), this.scale);
                } else {
                    result.append(operator.applyAsLong(v1, column2.getLongUnscaled(i), column2.getScale()), this.scale);
                }
            }
        });
        return result;
    }

    @Override
    public DecimalColumn add(long value, Selection selection) {
        return this.executeLongOperation(v -> v + DecimalColumnUtils.sumInScale(v, value, this.scale), this.name() + " + " + value, selection);
    }

    @Override
    public DecimalColumn add(double value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.sumInScale(v, value, this.scale), this.name() + " + " + value, selection);
    }

    @Override
    public DecimalColumn add(BigDecimal value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.sumInScale(v, value, this.scale), this.name() + " + " + String.valueOf(value), selection);
    }

    @Override
    public DecimalColumn add(Column column2, Selection selection) {
        BinaryDecimalOperation operation = new BinaryDecimalOperation(){

            @Override
            public long applyAsDouble(long v1, double v2) {
                return DecimalColumnUtils.sumInScale(v1, v2, DecimalColumnImpl.this.scale);
            }

            @Override
            public long applyAsLong(long v1, long v2, int v2Scale) {
                return DecimalColumnUtils.sumInScale(v1, v2, DecimalColumnImpl.this.scale, v2Scale);
            }
        };
        return this.executeLongOperation(operation, column2, " + ", selection);
    }

    @Override
    public DecimalColumn subtract(long value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.subtractInScale(v, value, this.scale), this.name() + " - " + value, selection);
    }

    @Override
    public DecimalColumn subtract(double value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.subtractInScale(v, value, this.scale), this.name() + " - " + value, selection);
    }

    @Override
    public DecimalColumn subtract(BigDecimal value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.subtractInScale(v, value, this.scale), this.name() + " - " + String.valueOf(value), selection);
    }

    @Override
    public DecimalColumn subtract(Column column2, Selection selection) {
        BinaryDecimalOperation operation = new BinaryDecimalOperation(){

            @Override
            public long applyAsDouble(long v1, double v2) {
                return DecimalColumnUtils.subtractInScale(v1, v2, DecimalColumnImpl.this.scale);
            }

            @Override
            public long applyAsLong(long v1, long v2, int v2Scale) {
                return DecimalColumnUtils.subtractInScale(v1, v2, DecimalColumnImpl.this.scale, v2Scale);
            }
        };
        return this.executeLongOperation(operation, column2, " - ", selection);
    }

    @Override
    public DecimalColumn remainder(long value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.reminderInScale(v, value, this.scale), this.name() + " % " + value, selection);
    }

    @Override
    public DecimalColumn remainder(double value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.reminderInScale(v, value, this.scale), this.name() + " % " + value, selection);
    }

    @Override
    public DecimalColumn remainder(BigDecimal value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.reminderInScale(v, value, this.scale), this.name() + " % " + String.valueOf(value), selection);
    }

    @Override
    public DecimalColumn remainder(Column column2, Selection selection) {
        BinaryDecimalOperation operation = new BinaryDecimalOperation(){

            @Override
            public long applyAsDouble(long v1, double v2) {
                return DecimalColumnUtils.reminderInScale(v1, v2, DecimalColumnImpl.this.scale);
            }

            @Override
            public long applyAsLong(long v1, long v2, int v2Scale) {
                return DecimalColumnUtils.reminderInScale(v1, v2, DecimalColumnImpl.this.scale, v2Scale);
            }
        };
        return this.executeLongOperation(operation, column2, " % ", selection);
    }

    @Override
    public DecimalColumn multiply(long value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.multiplyInScale(v, value, this.scale), this.name() + " * " + value, selection);
    }

    @Override
    public DecimalColumn multiply(double value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.multiplyInScale(v, value, this.scale), this.name() + " * " + value, selection);
    }

    @Override
    public DecimalColumn multiply(BigDecimal value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.multiplyInScale(v, value, this.scale), this.name() + " * " + String.valueOf(value), selection);
    }

    @Override
    public DecimalColumn multiply(Column column2, Selection selection) {
        BinaryDecimalOperation operation = new BinaryDecimalOperation(){

            @Override
            public long applyAsDouble(long v1, double v2) {
                return DecimalColumnUtils.multiplyInScale(v1, v2, DecimalColumnImpl.this.scale);
            }

            @Override
            public long applyAsLong(long v1, long v2, int v2Scale) {
                return DecimalColumnUtils.multiplyInScale(v1, v2, DecimalColumnImpl.this.scale, v2Scale);
            }
        };
        return this.executeLongOperation(operation, column2, " * ", selection);
    }

    @Override
    public DecimalColumn divide(long value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.divideInScale(v, value, this.scale), this.name() + " / " + value, selection);
    }

    @Override
    public DecimalColumn divide(double value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.divideInScale(v, value, this.scale), this.name() + " / " + value, selection);
    }

    @Override
    public DecimalColumn divide(BigDecimal value, Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.divideInScale(v, value, this.scale), this.name() + " / " + String.valueOf(value), selection);
    }

    @Override
    public DecimalColumn divide(Column column2, Selection selection) {
        BinaryDecimalOperation operation = new BinaryDecimalOperation(){

            @Override
            public long applyAsDouble(long v1, double v2) {
                return DecimalColumnUtils.divideInScale(v1, v2, DecimalColumnImpl.this.scale);
            }

            @Override
            public long applyAsLong(long v1, long v2, int v2Scale) {
                return DecimalColumnUtils.divideInScale(v1, v2, DecimalColumnImpl.this.scale, v2Scale);
            }
        };
        return this.executeLongOperation(operation, column2, " / ", selection);
    }

    @Override
    public DecimalColumn square(Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.multiplyInScale(v, v, this.scale, this.scale), this.name() + "[ square ]", selection);
    }

    @Override
    public DecimalColumn cube(Selection selection) {
        return this.executeLongOperation(v -> DecimalColumnUtils.multiplyInScale(v, DecimalColumnUtils.multiplyInScale(v, v, this.scale, this.scale), this.scale, this.scale), this.name() + "[ cube ]", selection);
    }

    @Override
    public DecimalColumn abs(Selection selection) {
        return this.executeLongOperation(v -> Math.abs(v), this.name() + "[ abs ]", selection);
    }

    @Override
    public DecimalColumn neg(Selection selection) {
        return this.executeLongOperation(v -> v * -1L, this.name() + "[ abs ]", selection);
    }

    @Override
    public DecimalColumn cumSum(Selection selection) {
        long[] total = new long[]{0L};
        DecimalColumn result = this.emptyCopy(selection.size());
        result.setName(this.name() + "[cumSum]");
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = total[0] + this.getLongUnscaled(i);
                result.append(total[0], this.scale);
            }
        });
        return result;
    }

    @Override
    public DecimalColumn cumProd(Selection selection) {
        long[] total = new long[]{1L};
        DecimalColumn result = this.emptyCopy(selection.size());
        result.setName(this.name() + "[cumProd]");
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(MISSING_VALUE);
            } else {
                total[0] = DecimalColumnUtils.multiplyInScale(total[0], this.getLongUnscaled(i), this.scale, this.scale);
                result.append(total[0], this.scale);
            }
        });
        return result;
    }

    @Override
    public DecimalColumn difference(Selection selection) {
        DecimalColumn result = this.emptyCopy(selection.size());
        result.setName(this.name() + "[diff]");
        int[] previous = new int[]{-1};
        selection.iterate(i -> {
            if (previous[0] == -1 || this.isMissing(i) || this.isMissing(previous[0])) {
                result.append(LongColumnImpl.MISSING_VALUE);
            } else {
                result.append(this.getLongUnscaled(i) - this.getLongUnscaled(previous[0]), this.scale);
            }
            previous[0] = i;
        });
        return result;
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isLessThan(long value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLong(idx) < value, selection);
    }

    @Override
    public Selection isLessThan(long value, int valueScale, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) < DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale), selection);
    }

    @Override
    public Selection isLessThan(double value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) < DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isLessThan(BigDecimal value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) < DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isLessThanOrEqualTo(long value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLong(idx) <= value, selection);
    }

    @Override
    public Selection isLessThanOrEqualTo(long value, int valueScale, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) <= DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale), selection);
    }

    @Override
    public Selection isLessThanOrEqualTo(double value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) <= DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isLessThanOrEqualTo(BigDecimal value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) <= DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isGreaterThan(long value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLong(idx) > value, selection);
    }

    @Override
    public Selection isGreaterThan(long value, int valueScale, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) > DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale), selection);
    }

    @Override
    public Selection isGreaterThan(double value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) > DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isGreaterThan(BigDecimal value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) > DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isGreaterThanOrEqualTo(long value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLong(idx) >= value, selection);
    }

    @Override
    public Selection isGreaterThanOrEqualTo(long value, int valueScale, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) >= DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale), selection);
    }

    @Override
    public Selection isGreaterThanOrEqualTo(double value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) >= DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isGreaterThanOrEqualTo(BigDecimal value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) >= DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isEqualTo(long value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLong(idx) == value, selection);
    }

    @Override
    public Selection isEqualTo(long value, int valueScale, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) == DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale), selection);
    }

    @Override
    public Selection isEqualTo(double value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) == DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isEqualTo(BigDecimal value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) == DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isNotEqualTo(long value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLong(idx) != value, selection);
    }

    @Override
    public Selection isNotEqualTo(long value, int valueScale, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) != DecimalColumnUtils.convertToLongInScale(value, valueScale, this.scale), selection);
    }

    @Override
    public Selection isNotEqualTo(double value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) != DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isNotEqualTo(BigDecimal value, Selection selection) {
        return this.selectWithIndexPredicate(idx -> !this.isMissing(idx) && this.getLongUnscaled(idx) != DecimalColumnUtils.convertToLongInScale(value, this.scale), selection);
    }

    @Override
    public Selection isPositive(Selection selection) {
        return this.selectWithLongUnscaled(isPositive, selection);
    }

    @Override
    public Selection isNegative(Selection selection) {
        return this.selectWithLongUnscaled(isNegative, selection);
    }

    @Override
    public Selection isNonNegative(Selection selection) {
        return this.selectWithLongUnscaled(isNonNegative, selection);
    }

    @Override
    public Selection isZero(Selection selection) {
        return this.selectWithLongUnscaled(isZero, selection);
    }

    @Override
    public Selection isEven(Selection selection) {
        return this.selectWithLongUnscaled(isEven, selection);
    }

    @Override
    public Selection isOdd(Selection selection) {
        return this.selectWithLongUnscaled(isOdd, selection);
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.selectWithLongUnscaled(isMissing, selection);
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.selectWithLongUnscaled(isNotMissing, selection);
    }

    @Override
    public Selection isEqualTo(DecimalColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.getLongUnscaled(i) != DecimalColumnUtils.convertToLongInScale(f.getLongUnscaled(i), f.getScale(), this.scale)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isGreaterThan(DecimalColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.getLongUnscaled(i) <= DecimalColumnUtils.convertToLongInScale(f.getLongUnscaled(i), f.getScale(), this.scale)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isLessThan(DecimalColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.getLongUnscaled(i) >= DecimalColumnUtils.convertToLongInScale(f.getLongUnscaled(i), f.getScale(), this.scale)) continue;
            results.add(i);
        }
        return results;
    }

    public Selection selectWithIndexPredicate(IntPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        selection.iterate(idx -> {
            if (predicate.test(idx)) {
                result.add(idx);
            }
        });
        return result;
    }

    @Override
    public Selection selectWithLongUnscaled(LongPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        selection.iterate(idx -> {
            if (predicate.test(this.getLongUnscaled(idx))) {
                result.add(idx);
            }
        });
        return result;
    }

    @Override
    public Selection selectWithLongUnscaled(LongBiPredicate predicate, long valueToCompareAgainst, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        selection.iterate(idx -> {
            if (predicate.test(this.getLongUnscaled(idx), valueToCompareAgainst)) {
                result.add(idx);
            }
        });
        return result;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getLong(row1), column2.getLong(row2));
    }

    private int compare(long v1, long v2) {
        if (v1 == v2) {
            return 0;
        }
        if (DecimalColumnImpl.isMissingValue(v1)) {
            return -1;
        }
        if (DecimalColumnImpl.isMissingValue(v2)) {
            return 1;
        }
        return Long.compare(v1, v2);
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        LongIterator longIterator = this.data.iterator();
        while (longIterator.hasNext()) {
            long i = (Long)longIterator.next();
            builder.append(String.valueOf(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "Decimal(" + this.precision + "," + this.scale + ") column: " + this.name();
    }

    @Override
    public DecimalColumn wrap(Selection selection) {
        return new DecimalColumnWrapper(this, selection);
    }

    static interface BinaryDecimalOperation {
        public long applyAsDouble(long var1, double var3);

        public long applyAsLong(long var1, long var3, int var5);
    }
}

