/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DateTimeColumn;
import com.streamscape.ds.stable.columns.DateTimeColumnWrapper;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.filtering.LongBiPredicate;
import com.streamscape.ds.stable.filtering.LongPredicate;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.lists.LongArrayList;
import com.streamscape.ds.stable.lists.LongIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class DateTimeColumnImpl
extends AbstractColumn
implements DateTimeColumn {
    public static final long MISSING_VALUE = (Long)ColumnType.LOCAL_DATE_TIME.getMissingValue();
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 8;
    private LongArrayList data;
    private final IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        @Override
        public int compare(int i1, int i2) {
            return DateTimeColumnImpl.this.compare(DateTimeColumnImpl.this.getLongInternal(i1), DateTimeColumnImpl.this.getLongInternal(i2));
        }
    };
    private TypeUtils.DateTimeConverter selectedFormatter;
    private final Locale locale;
    public static LongPredicate isMissing = i -> i == MISSING_VALUE;
    public static LongPredicate isNotMissing = i -> i != MISSING_VALUE;
    public static LongBiPredicate isGreaterThan = (valueToTest, valueToCompareAgainst) -> valueToTest > valueToCompareAgainst;
    public static LongBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    public static LongBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    public static LongBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    public static LongBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;

    public DateTimeColumnImpl(String name) {
        this(name, Locale.getDefault());
    }

    public DateTimeColumnImpl(String name, Locale locale) {
        this(name, new LongArrayList(128), locale);
    }

    public DateTimeColumnImpl(String name, int initialSize) {
        this(name, new LongArrayList(initialSize));
    }

    public DateTimeColumnImpl(String name, List<LocalDateTime> data) {
        this(name);
        for (LocalDateTime time : data) {
            this.append(time);
        }
    }

    private DateTimeColumnImpl(String name, LongArrayList data) {
        this(name, data, Locale.getDefault());
    }

    private DateTimeColumnImpl(String name, LongArrayList data, Locale locale) {
        super(name);
        this.data = data;
        this.locale = locale;
    }

    public DateTimeColumnImpl(ColumnMetadata metadata) {
        this(metadata, Locale.getDefault());
    }

    public DateTimeColumnImpl(ColumnMetadata metadata, Locale locale) {
        super(metadata);
        this.data = new LongArrayList(128);
        this.locale = locale;
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.LOCAL_DATE_TIME;
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create("Column: " + this.name());
        CategoryColumn measure = CategoryColumn.create("Measure");
        CategoryColumn value = CategoryColumn.create("Value");
        table.addColumn(measure);
        table.addColumn(value);
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        measure.append("Earliest");
        value.append(String.valueOf(this.min()));
        measure.append("Latest");
        value.append(String.valueOf(this.max()));
        return table;
    }

    private void appendInternal(long f) {
        this.data.add(f);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void set(int index, long value) {
        this.data.set(index, value);
        this.onDataChanged(index);
    }

    @Override
    public void set(int index, LocalDateTime value) {
        this.set(index, DateTimeColumnImpl.localDateTimeToLong(value));
    }

    @Override
    public void set(int index, Timestamp t) {
        this.set(index, t.getTime());
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getLong(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public void append(LocalDateTime f) {
        this.appendInternal(DateTimeColumnImpl.localDateTimeToLong(f));
    }

    @Override
    public void append(long f) {
        this.appendInternal(f);
    }

    @Override
    public void append(Timestamp t) {
        this.appendInternal(t.getTime());
    }

    @Override
    public void assignWithValue(LocalDateTime f) {
        this.assignWithValue(DateTimeColumnImpl.localDateTimeToLong(f));
    }

    @Override
    public void assignWithValue(Timestamp t) {
        this.assignWithValue(t.getTime());
    }

    @Override
    public void assignWithValue(Object object) {
        this.assignWithValue(this.convert(object));
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(this.convert(object), size);
    }

    @Override
    public void assignWithValue(long value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(Timestamp t, int size) {
        this.fillWithValue(t.getTime(), size);
    }

    @Override
    public void fillWithValue(LocalDateTime f, int size) {
        this.fillWithValue(DateTimeColumnImpl.localDateTimeToLong(f), size);
    }

    @Override
    public void fillWithValue(long value, int size) {
        for (int i = 0; i < size; ++i) {
            this.appendInternal(value);
        }
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        long[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            long tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public long firstElement(Selection selection) {
        IntIterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            return this.getLongInternal(iterator.nextInt());
        }
        return MISSING_VALUE;
    }

    @Override
    public void set(LocalDateTime newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        DateTimeColumn longColumn = (DateTimeColumn)column;
        for (int i = 0; i < longColumn.size(); ++i) {
            this.appendInternal(longColumn.getLong(i));
        }
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public void appendObject(Object object) {
        this.appendInternal(this.convert(object));
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getLong(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(this.getMissingValue());
    }

    @Override
    public void setObject(int index, Object object) {
        this.set(index, this.convert(object));
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, this.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        throw new UnsupportedOperationException("DateTime.setInt");
    }

    @Override
    public void setShort(int row, short value) {
        throw new UnsupportedOperationException("DateTime.setShort");
    }

    @Override
    public void setLong(int row, long value) {
        this.set(row, value);
    }

    @Override
    public void setFloat(int row, float value) {
        throw new UnsupportedOperationException("DateTime.setFloat");
    }

    @Override
    public void setDouble(int row, double value) {
        throw new UnsupportedOperationException("DateTime.setDouble");
    }

    @Override
    public void setBoolean(int row, boolean value) {
        throw new UnsupportedOperationException("DateTime.setBoolean");
    }

    @Override
    public Timestamp get(int index) {
        if (this.isMissing(index)) {
            return null;
        }
        return new Timestamp(this.getLongInternal(index));
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    @Override
    public LongArrayList data() {
        return this.data;
    }

    @Override
    public String getString(int row) {
        return DateTimeColumnImpl.toDateTimeString(this.getLongInternal(row));
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int row) {
        return this.getLongInternal(row);
    }

    @Override
    public float getFloat(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing(int row) {
        return this.isMissingValue(this.getLong(row));
    }

    @Override
    public long min(Selection selection) {
        long min = -1L;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            long next = this.getLong(iterator.nextInt());
            if (this.isMissingValue(next) || next >= min) continue;
            min = next;
        }
        if (min == -1L) {
            min = MISSING_VALUE;
        }
        return min;
    }

    @Override
    public long max(Selection selection) {
        long max = Long.MAX_VALUE;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            long next = this.getLong(iterator.nextInt());
            if (this.isMissingValue(next) || next <= max) continue;
            max = next;
        }
        if (max == Long.MAX_VALUE) {
            max = MISSING_VALUE;
        }
        return max;
    }

    private long getLongInternal(int index) {
        return this.data.getLong(index);
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.select(isMissing, selection);
    }

    private boolean isMissingValue(long l) {
        return l == MISSING_VALUE;
    }

    public long getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public List<LocalDateTime> asList() {
        ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>(this.size());
        Iterator<LocalDateTime> iter = this.iterator();
        while (iter.hasNext()) {
            times.add(iter.next());
        }
        return times;
    }

    @Override
    public boolean contains(LocalDateTime localDateTime) {
        long time = DateTimeColumnImpl.localDateTimeToLong(localDateTime);
        return this.data().contains(time);
    }

    @Override
    public int byteSize() {
        return 8;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(8).putLong(this.getLongInternal(rowNumber)).array();
    }

    @Override
    public Column select(Selection selection) {
        IntIterator iterator = selection.iterator();
        DateTimeColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public Column selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        DateTimeColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.getLong(row));
        }
        return result;
    }

    @Override
    public DateTimeColumn emptyCopy() {
        DateTimeColumn column = DateTimeColumn.create(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DateTimeColumn emptyCopy(int rowSize) {
        DateTimeColumn column = DateTimeColumn.create(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DateTimeColumn copy() {
        DateTimeColumnImpl column = new DateTimeColumnImpl(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DateTimeColumn trimToSelection(Selection selection) {
        DateTimeColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.getLong(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public LongArrayList top(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList top = new LongArrayList();
        for (int i = result.data().size() - 1; i >= result.data().size() - n - 1 && i >= 0; --i) {
            top.add(result.get(i));
        }
        return top;
    }

    @Override
    public LongArrayList bottom(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList bottom = new LongArrayList();
        for (int i = 0; i < n && i < result.data().size(); ++i) {
            bottom.add(result.get(i));
        }
        return bottom;
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isEqualTo(LocalDateTime value, Selection selection) {
        long packed = DateTimeColumnImpl.localDateTimeToLong(value);
        return this.select(LongColumnImpl.isEqualTo, packed, selection);
    }

    @Override
    public Selection isEqualTo(DateTimeColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.data.elements()[i] != f.data().elements()[i]) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.select(isNotMissing, selection);
    }

    @Override
    public Selection select(LongPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            long next = this.data.getLong(idx);
            if (!predicate.test(next)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public Selection select(LongBiPredicate predicate, long value, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            long next = this.data.getLong(idx);
            if (!predicate.test(next, value)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getLong(row1), column2.getLong(row2));
    }

    private int compare(long v1, long v2) {
        if (v1 == v2) {
            return 0;
        }
        if (this.isMissingValue(v1)) {
            return -1;
        }
        if (this.isMissingValue(v2)) {
            return 1;
        }
        return Long.compare(v1, v2);
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        LongIterator longIterator = this.data.iterator();
        while (longIterator.hasNext()) {
            long next = (Long)longIterator.next();
            builder.append(String.valueOf(DateTimeColumnImpl.toDateTimeString(next)));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "LocalDateTime column: " + this.name();
    }

    @Override
    public Iterator<LocalDateTime> iterator(final Selection selection) {
        return new Iterator<LocalDateTime>(){
            IntIterator iterator;
            {
                this.iterator = selection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public LocalDateTime next() {
                return DateTimeColumnImpl.longToLocalDateTime(DateTimeColumnImpl.this.data.getLong(this.iterator.nextInt()));
            }
        };
    }

    public long convert(String value) {
        if (TypeUtils.isNullOrEmpty((String)value) || TypeUtils.MISSING_INDICATORS.contains(value) || ((String)value).equals("-1")) {
            return MISSING_VALUE;
        }
        while (((String)value).length() < 4) {
            value = (String)value + "0";
        }
        if (this.selectedFormatter == null) {
            this.selectedFormatter = TypeUtils.getDateTimeFormatter((String)value);
        }
        LocalDateTime datetime = this.selectedFormatter.convert((String)value);
        return DateTimeColumnImpl.localDateTimeToLong(datetime);
    }

    public long convert(Object objectValue) {
        if (objectValue == null || objectValue instanceof String) {
            return this.convert((String)objectValue);
        }
        if (objectValue instanceof Number) {
            return ((Number)objectValue).longValue();
        }
        if (objectValue instanceof Timestamp) {
            return ((Timestamp)objectValue).getTime();
        }
        if (objectValue instanceof LocalDateTime) {
            return DateTimeColumnImpl.localDateTimeToLong((LocalDateTime)objectValue);
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + String.valueOf(objectValue) + " to DateTime");
    }

    public static long localDateTimeToLong(LocalDateTime value) {
        return value.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static String toDateTimeString(long value) {
        return DateTimeColumnImpl.longToLocalDateTime(value).toString();
    }

    public static LocalDateTime longToLocalDateTime(long value) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneId.of("UTC"));
    }

    @Override
    public DateTimeColumnWrapper wrap(Selection selection) {
        return new DateTimeColumnWrapper(this, selection);
    }
}

