/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DateColumn;
import com.streamscape.ds.stable.columns.DateColumnWrapper;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.filtering.LongBiPredicate;
import com.streamscape.ds.stable.filtering.LongPredicate;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.lists.LongArrayList;
import com.streamscape.ds.stable.lists.LongIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class DateColumnImpl
extends AbstractColumn
implements DateColumn {
    public static final long MISSING_VALUE = (Long)ColumnType.LOCAL_DATE.getMissingValue();
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 8;
    private LongArrayList data;
    private final IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        @Override
        public int compare(int i1, int i2) {
            return DateColumnImpl.this.compare(DateColumnImpl.this.getLongInternal(i1), DateColumnImpl.this.getLongInternal(i2));
        }
    };
    private DateTimeFormatter selectedFormatter;
    private final Locale locale;
    public static LongPredicate isMissing = i -> i == MISSING_VALUE;
    public static LongPredicate isNotMissing = i -> i != MISSING_VALUE;
    public static LongBiPredicate isGreaterThan = (valueToTest, valueToCompareAgainst) -> valueToTest > valueToCompareAgainst;
    public static LongBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    public static LongBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    public static LongBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    public static LongBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;

    public DateColumnImpl(String name) {
        this(name, Locale.getDefault());
    }

    public DateColumnImpl(String name, Locale locale) {
        this(name, new LongArrayList(128), locale);
    }

    public DateColumnImpl(String name, int initialSize) {
        this(name, new LongArrayList(initialSize));
    }

    public DateColumnImpl(String name, List<LocalDate> data) {
        this(name);
        for (LocalDate date : data) {
            this.append(date);
        }
    }

    private DateColumnImpl(String name, LongArrayList data) {
        this(name, data, Locale.getDefault());
    }

    private DateColumnImpl(String name, LongArrayList data, Locale locale) {
        super(name);
        this.data = data;
        this.locale = locale;
    }

    public DateColumnImpl(ColumnMetadata metadata) {
        this(metadata, Locale.getDefault());
    }

    public DateColumnImpl(ColumnMetadata metadata, Locale locale) {
        super(metadata);
        this.data = new LongArrayList(128);
        this.locale = locale;
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.LOCAL_DATE;
    }

    @Override
    public SnapshotTable summary() {
        SnapshotTable table = SnapshotTable.create("Column: " + this.name());
        CategoryColumn measure = CategoryColumn.create("Measure");
        CategoryColumn value = CategoryColumn.create("Value");
        table.addColumn(measure);
        table.addColumn(value);
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        measure.append("Earliest");
        value.append(String.valueOf(this.min()));
        measure.append("Latest");
        value.append(String.valueOf(this.max()));
        return table;
    }

    private void appendInternal(long f) {
        this.data.add(f);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void set(int index, long value) {
        this.data.set(index, value);
        this.onDataChanged(index);
    }

    @Override
    public void set(int index, LocalDate value) {
        this.set(index, DateColumnImpl.localDateToLong(value));
    }

    @Override
    public void set(int index, java.util.Date d) {
        this.set(index, d.getTime());
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getLong(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public void append(LocalDate f) {
        this.appendInternal(DateColumnImpl.localDateToLong(f));
    }

    @Override
    public void append(java.util.Date d) {
        this.appendInternal(d.getTime());
    }

    @Override
    public void append(long l) {
        this.appendInternal(l);
    }

    @Override
    public void assignWithValue(LocalDate f) {
        this.assignWithValue(DateColumnImpl.localDateToLong(f));
    }

    @Override
    public void assignWithValue(java.util.Date d) {
        this.assignWithValue(d.getTime());
    }

    @Override
    public void assignWithValue(long value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(LocalDate f, int size) {
        this.fillWithValue(DateColumnImpl.localDateToLong(f), size);
    }

    @Override
    public void fillWithValue(java.util.Date d, int size) {
        this.fillWithValue(d.getTime(), size);
    }

    @Override
    public void fillWithValue(long value, int size) {
        for (int i = 0; i < size; ++i) {
            this.append(value);
        }
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void set(LocalDate newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        long[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            long tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public void assignWithValue(Object object) {
        long value = this.convert(object);
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(this.convert(object), size);
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        DateColumn longColumn = (DateColumn)column;
        for (int i = 0; i < longColumn.size(); ++i) {
            this.appendInternal(longColumn.getLong(i));
        }
    }

    @Override
    public LongArrayList data() {
        return this.data;
    }

    @Override
    public String getString(int row) {
        return DateColumnImpl.toDateString(this.getLongInternal(row));
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int row) {
        return this.getLongInternal(row);
    }

    @Override
    public float getFloat(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing(int row) {
        return this.isMissingValue(this.getLong(row));
    }

    @Override
    public long firstElement(Selection selection) {
        IntIterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            return this.getLongInternal(iterator.nextInt());
        }
        return MISSING_VALUE;
    }

    @Override
    public Date get(int index) {
        if (this.isMissing(index)) {
            return null;
        }
        return new Date(this.getLongInternal(index));
    }

    @Override
    public void appendObject(Object value) {
        this.appendInternal(this.convert(value));
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getLong(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(this.getMissingValue());
    }

    @Override
    public void setObject(int index, Object object) {
        this.set(index, this.convert(object));
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, this.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        throw new UnsupportedOperationException("Date.setInt");
    }

    @Override
    public void setShort(int row, short value) {
        throw new UnsupportedOperationException("Date.setShort");
    }

    @Override
    public void setLong(int row, long value) {
        this.set(row, value);
    }

    @Override
    public void setFloat(int row, float value) {
        throw new UnsupportedOperationException("Date.setFloat");
    }

    @Override
    public void setDouble(int row, double value) {
        throw new UnsupportedOperationException("Date.setDouble");
    }

    @Override
    public void setBoolean(int row, boolean value) {
        throw new UnsupportedOperationException("Date.setBoolean");
    }

    private long getLongInternal(int index) {
        return this.data.getLong(index);
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    private boolean isMissingValue(long l) {
        return l == MISSING_VALUE;
    }

    public long getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.select(isNotMissing, selection);
    }

    @Override
    public List<LocalDate> asList() {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(this.size());
        Iterator<LocalDate> iter = this.iterator();
        while (iter.hasNext()) {
            dates.add(iter.next());
        }
        return dates;
    }

    public boolean contains(LocalDate localDate) {
        long date = DateColumnImpl.localDateToLong(localDate);
        return this.data().contains(date);
    }

    @Override
    public int byteSize() {
        return 8;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(8).putLong(this.getLongInternal(rowNumber)).array();
    }

    @Override
    public long min(Selection selection) {
        long min = -1L;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            long next = this.getLong(iterator.nextInt());
            if (this.isMissingValue(next) || next >= min) continue;
            min = next;
        }
        if (min == -1L) {
            min = MISSING_VALUE;
        }
        return min;
    }

    @Override
    public long max(Selection selection) {
        long max = Long.MAX_VALUE;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            long next = this.getLong(iterator.nextInt());
            if (this.isMissingValue(next) || next <= max) continue;
            max = next;
        }
        if (max == Long.MAX_VALUE) {
            max = MISSING_VALUE;
        }
        return max;
    }

    @Override
    public Column select(Selection selection) {
        IntIterator iterator = selection.iterator();
        DateColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public Column selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        DateColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.getLong(row));
        }
        return result;
    }

    @Override
    public DateColumn emptyCopy() {
        DateColumn column = DateColumn.create(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DateColumn emptyCopy(int rowSize) {
        DateColumn column = DateColumn.create(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DateColumn copy() {
        DateColumnImpl column = new DateColumnImpl(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DateColumn trimToSelection(Selection selection) {
        DateColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.getLong(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public LongArrayList top(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList top = new LongArrayList();
        for (int i = result.data().size() - 1; i >= result.data().size() - n - 1 && i >= 0; --i) {
            top.add(result.get(i));
        }
        return top;
    }

    @Override
    public LongArrayList bottom(int n, Selection selection) {
        LongColumn result = LongColumn.create("tmp", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            result.append(this.getLong(iterator.nextInt()));
        }
        result.sortAscending();
        LongArrayList bottom = new LongArrayList();
        for (int i = 0; i < n && i < result.data().size(); ++i) {
            bottom.add(result.get(i));
        }
        return bottom;
    }

    @Override
    public DateColumn difference(Selection selection) {
        throw new UnsupportedOperationException("DateTimeColumn.difference() currently not supported");
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isEqualTo(LocalDate value, Selection selection) {
        long packed = DateColumnImpl.localDateToLong(value);
        return this.select(LongColumnImpl.isEqualTo, packed, selection);
    }

    @Override
    public Selection isEqualTo(DateColumn f, Selection selection) {
        int i;
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext() && (i = iterator.nextInt()) < f.data().size()) {
            if (this.data.elements()[i] != f.data().elements()[i]) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.select(isMissing, selection);
    }

    @Override
    public Selection select(LongPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            long next = this.data.getLong(idx);
            if (!predicate.test(next)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public Selection select(LongBiPredicate predicate, long value, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            long next = this.data.getLong(idx);
            if (!predicate.test(next, value)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getLong(row1), column2.getLong(row2));
    }

    private int compare(long v1, long v2) {
        if (v1 == v2) {
            return 0;
        }
        if (this.isMissingValue(v1)) {
            return -1;
        }
        if (this.isMissingValue(v2)) {
            return 1;
        }
        return Long.compare(v1, v2);
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        LongIterator longIterator = this.data.iterator();
        while (longIterator.hasNext()) {
            long next = (Long)longIterator.next();
            builder.append(String.valueOf(DateColumnImpl.toDateString(next)));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "LocalDate column: " + this.name();
    }

    @Override
    public Iterator<LocalDate> iterator(final Selection selection) {
        return new Iterator<LocalDate>(){
            IntIterator iterator;
            {
                this.iterator = selection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public LocalDate next() {
                return DateColumnImpl.longToLocalDate(DateColumnImpl.this.data.getLong(this.iterator.nextInt()));
            }
        };
    }

    static String dateColumnName(Column column1, int value, TemporalUnit unit) {
        return column1.name() + ": " + value + " " + unit.toString() + "(s)";
    }

    public static long localDateToLong(LocalDate value) {
        return Date.valueOf(value).getTime();
    }

    public static String toDateString(long value) {
        return DateColumnImpl.longToLocalDate(value).toString();
    }

    public static LocalDate longToLocalDate(long value) {
        return new Date(value).toLocalDate();
    }

    public long convert(String value) {
        LocalDate date;
        if (TypeUtils.isNullOrEmpty(value) || TypeUtils.MISSING_INDICATORS.contains(value) || value.equals("-1")) {
            return (Long)ColumnType.LOCAL_DATE.getMissingValue();
        }
        Object paddedValue = value;
        while (((String)paddedValue).length() < 4) {
            paddedValue = (String)paddedValue + "0";
        }
        if (this.selectedFormatter == null) {
            this.selectedFormatter = TypeUtils.getDateFormatter((String)paddedValue).withLocale(this.locale);
        }
        try {
            date = LocalDate.parse((CharSequence)paddedValue, this.selectedFormatter);
        }
        catch (DateTimeParseException e) {
            this.selectedFormatter = TypeUtils.DATE_FORMATTER.withLocale(this.locale);
            date = LocalDate.parse((CharSequence)paddedValue, this.selectedFormatter);
        }
        return DateColumnImpl.localDateToLong(date);
    }

    public long convert(Object objectValue) {
        if (objectValue == null || objectValue instanceof String) {
            return this.convert((String)objectValue);
        }
        if (objectValue instanceof Number) {
            return ((Number)objectValue).longValue();
        }
        if (objectValue instanceof java.util.Date) {
            return ((java.util.Date)objectValue).getTime();
        }
        if (objectValue instanceof LocalDate) {
            return DateColumnImpl.localDateToLong((LocalDate)objectValue);
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + String.valueOf(objectValue) + " to Date");
    }

    @Override
    public DateColumn wrap(Selection selection) {
        return new DateColumnWrapper(this, selection);
    }
}

