/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.DateColumnImpl;
import com.streamscape.ds.stable.filtering.LongBiPredicate;
import com.streamscape.ds.stable.filtering.LongPredicate;
import com.streamscape.ds.stable.lists.LongArrayList;
import com.streamscape.ds.stable.utils.Selection;
import java.time.LocalDate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public interface DateColumn
extends Column {
    public static DateColumn create(String name) {
        return new DateColumnImpl(name);
    }

    public static DateColumn create(String name, Locale locale) {
        return new DateColumnImpl(name, locale);
    }

    public static DateColumn create(String name, int initialSize) {
        return new DateColumnImpl(name, initialSize);
    }

    public static DateColumn create(String name, List<LocalDate> data) {
        return new DateColumnImpl(name, data);
    }

    public static DateColumn create(ColumnMetadata metadata) {
        return new DateColumnImpl(metadata);
    }

    public static DateColumn create(ColumnMetadata metadata, Locale locale) {
        return new DateColumnImpl(metadata, locale);
    }

    public void set(int var1, long var2);

    public void set(int var1, LocalDate var2);

    public void set(int var1, Date var2);

    public void append(LocalDate var1);

    public void append(Date var1);

    public void append(long var1);

    public void assignWithValue(LocalDate var1);

    public void assignWithValue(Date var1);

    public void assignWithValue(long var1);

    public void fillWithValue(LocalDate var1, int var2);

    public void fillWithValue(Date var1, int var2);

    public void fillWithValue(long var1, int var3);

    public void set(LocalDate var1, Selection var2);

    public LongArrayList data();

    default public long firstElement() {
        return this.firstElement(this.getSelection());
    }

    public long firstElement(Selection var1);

    public java.sql.Date get(int var1);

    public List<LocalDate> asList();

    default public long min() {
        return this.min(this.getSelection());
    }

    public long min(Selection var1);

    default public long max() {
        return this.max(this.getSelection());
    }

    public long max(Selection var1);

    @Override
    public DateColumn emptyCopy();

    @Override
    public DateColumn emptyCopy(int var1);

    @Override
    public DateColumn copy();

    default public LongArrayList top(int n) {
        return this.top(n, this.getSelection());
    }

    public LongArrayList top(int var1, Selection var2);

    default public LongArrayList bottom(int n) {
        return this.bottom(n, this.getSelection());
    }

    public LongArrayList bottom(int var1, Selection var2);

    default public Selection isEqualTo(LocalDate value) {
        return this.isEqualTo(value, this.getSelection());
    }

    public Selection isEqualTo(LocalDate var1, Selection var2);

    default public Selection isEqualTo(DateColumn f) {
        return this.isEqualTo(f, this.getSelection());
    }

    public Selection isEqualTo(DateColumn var1, Selection var2);

    default public Selection select(LongPredicate predicate) {
        return this.select(predicate, this.getSelection());
    }

    public Selection select(LongPredicate var1, Selection var2);

    default public Selection select(LongBiPredicate predicate, long value) {
        return this.select(predicate, value, this.getSelection());
    }

    public Selection select(LongBiPredicate var1, long var2, Selection var4);

    default public Iterator<LocalDate> iterator() {
        return this.iterator(this.getSelection());
    }

    public Iterator<LocalDate> iterator(Selection var1);

    public static long localDateToLong(LocalDate value) {
        return java.sql.Date.valueOf(value).getTime();
    }

    public static String toDateString(long value) {
        return DateColumn.longToLocalDate(value).toString();
    }

    public static LocalDate longToLocalDate(long value) {
        return new java.sql.Date(value).toLocalDate();
    }
}

