/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.DateColumn;
import com.streamscape.ds.stable.columns.DateTimeColumn;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.FloatColumn;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.ShortColumn;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.columns.TimeColumn;
import com.streamscape.ds.types.Type;

public enum ColumnType {
    BOOLEAN(Byte.valueOf((byte)-128)),
    CATEGORY(null),
    STRING(null),
    FLOAT(Float.valueOf(Float.NaN)),
    DOUBLE(Double.valueOf(Double.NaN)),
    SHORT(Short.valueOf((short)Short.MIN_VALUE)),
    INTEGER(Integer.valueOf(Integer.MIN_VALUE)),
    LONG(Long.valueOf(Long.MIN_VALUE)),
    DECIMAL(Long.valueOf(Long.MIN_VALUE)),
    LOCAL_DATE(Long.valueOf(Long.MIN_VALUE)),
    LOCAL_DATE_TIME(Long.valueOf(Long.MIN_VALUE)),
    LOCAL_TIME(Long.valueOf(-1L));

    private final Comparable<?> missingValue;

    private ColumnType(Comparable<?> missingValue) {
        this.missingValue = missingValue;
    }

    public Comparable<?> getMissingValue() {
        return this.missingValue;
    }

    public boolean isNumeric() {
        switch (this.ordinal()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public String getInterfaceName() {
        switch (this.ordinal()) {
            case 0: {
                return BooleanColumn.class.getSimpleName();
            }
            case 1: {
                return CategoryColumn.class.getSimpleName();
            }
            case 2: {
                return StringColumn.class.getSimpleName();
            }
            case 3: {
                return FloatColumn.class.getSimpleName();
            }
            case 4: {
                return DoubleColumn.class.getSimpleName();
            }
            case 5: {
                return ShortColumn.class.getSimpleName();
            }
            case 6: {
                return IntColumn.class.getSimpleName();
            }
            case 7: {
                return LongColumn.class.getSimpleName();
            }
            case 9: {
                return DateColumn.class.getSimpleName();
            }
            case 10: {
                return DateTimeColumn.class.getSimpleName();
            }
            case 11: {
                return TimeColumn.class.getSimpleName();
            }
            case 8: {
                return DecimalColumn.class.getSimpleName();
            }
        }
        return "unknown";
    }

    public Type toDataspaceType() {
        switch (this.ordinal()) {
            case 0: {
                return Type.SQL_BOOLEAN;
            }
            case 1: {
                return Type.CATEGORY;
            }
            case 2: {
                return Type.STRING;
            }
            case 3: {
                return Type.SQL_FLOAT;
            }
            case 4: {
                return Type.SQL_DOUBLE;
            }
            case 5: {
                return Type.SQL_SMALLINT;
            }
            case 6: {
                return Type.SQL_INTEGER;
            }
            case 7: {
                return Type.LONG;
            }
            case 9: {
                return Type.SQL_DATE;
            }
            case 10: {
                return Type.SQL_TIMESTAMP;
            }
            case 11: {
                return Type.SQL_TIME;
            }
            case 8: {
                return Type.SQL_DECIMAL;
            }
        }
        throw new DataspaceException("Unknown type " + String.valueOf((Object)this));
    }
}

