/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DateColumn;
import com.streamscape.ds.stable.columns.DateTimeColumn;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.FloatColumn;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.ShortColumn;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.columns.TimeColumn;

public class ColumnMetadata {
    private final String id;
    private final String name;
    private final ColumnType type;
    private final int size;
    private final int precision;
    private final int scale;

    public ColumnMetadata(Column column) {
        this.id = column.id();
        this.name = column.name();
        this.type = column.type();
        this.size = column.dataSize();
        this.precision = column.getPrecision();
        this.scale = column.getScale();
    }

    public String toString() {
        return "ColumnMetadata{id='" + this.id + "', name='" + this.name + "', type=" + String.valueOf((Object)this.type) + ", size=" + this.size + ", precision=" + this.precision + ", scale=" + this.scale + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMetadata that = (ColumnMetadata)o;
        if (this.size != that.size) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.size;
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public Column createColumn() {
        switch (this.getType()) {
            case FLOAT: {
                return FloatColumn.create(this);
            }
            case DOUBLE: {
                return DoubleColumn.create(this);
            }
            case INTEGER: {
                return IntColumn.create(this);
            }
            case BOOLEAN: {
                return BooleanColumn.create(this);
            }
            case LOCAL_DATE: {
                return DateColumn.create(this);
            }
            case LOCAL_TIME: {
                return TimeColumn.create(this);
            }
            case LOCAL_DATE_TIME: {
                return DateTimeColumn.create(this);
            }
            case CATEGORY: {
                return CategoryColumn.create(this);
            }
            case STRING: {
                return StringColumn.create(this);
            }
            case SHORT: {
                return ShortColumn.create(this);
            }
            case LONG: {
                return LongColumn.create(this);
            }
            case DECIMAL: {
                return DecimalColumn.create(this);
            }
        }
        throw new IllegalStateException("Unhandled column type writing columns");
    }
}

