/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DateColumn;
import com.streamscape.ds.stable.columns.DateTimeColumn;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.FloatColumn;
import com.streamscape.ds.stable.columns.FloatColumnImpl;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.IntColumnImpl;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.columns.ShortColumn;
import com.streamscape.ds.stable.columns.ShortColumnImpl;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.columns.StringColumnImpl;
import com.streamscape.ds.stable.columns.TimeColumn;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.rplmethod.ColumnOperation;
import com.streamscape.ds.stable.rplmethod.IsMethod;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.Order;
import com.streamscape.ds.stable.utils.Selection;
import java.lang.reflect.Proxy;

public interface Column {
    public String name();

    public Column setName(String var1);

    public String id();

    public ColumnType type();

    public String comment();

    public void setComment(String var1);

    public ColumnMetadata columnMetadata();

    public int dataSize();

    default public int size() {
        return this.size(this.getSelection());
    }

    default public int size(Selection selection) {
        return selection.size();
    }

    default public int getPrecision() {
        return 0;
    }

    default public int getScale() {
        return 0;
    }

    default public Column withName(String name) {
        Class columnInterface = switch (this.type()) {
            case ColumnType.BOOLEAN -> BooleanColumn.class;
            case ColumnType.CATEGORY -> CategoryColumn.class;
            case ColumnType.STRING -> StringColumn.class;
            case ColumnType.FLOAT -> FloatColumn.class;
            case ColumnType.DOUBLE -> DoubleColumn.class;
            case ColumnType.SHORT -> ShortColumn.class;
            case ColumnType.INTEGER -> IntColumn.class;
            case ColumnType.LONG -> LongColumn.class;
            case ColumnType.LOCAL_DATE -> DateColumn.class;
            case ColumnType.LOCAL_DATE_TIME -> DateTimeColumn.class;
            case ColumnType.LOCAL_TIME -> TimeColumn.class;
            case ColumnType.DECIMAL -> DecimalColumn.class;
            default -> throw new DataspaceException("Invalid column type '" + String.valueOf((Object)this.type()) + "'.");
        };
        return (Column)Proxy.newProxyInstance(columnInterface.getClassLoader(), new Class[]{columnInterface}, (proxy, method, args) -> {
            if (method.getName().equals("name")) {
                return name;
            }
            Object result = method.invoke((Object)this, args);
            if (method.getName().equals("trimToSelection")) {
                ((Column)result).setName(name);
            }
            return result;
        });
    }

    public int capacity();

    public int columnWidth();

    public int byteSize();

    public void setSnapshotTable(SnapshotTable var1);

    public SnapshotTable getSnapshotTable();

    public void setIndex(int var1);

    public int getIndex();

    public void appendObject(Object var1);

    public void append(Column var1);

    public void append(Column var1, int var2);

    public void appendMissing();

    public void assignWithValue(Object var1);

    public void fillWithValue(Object var1, int var2);

    public void sortAscending();

    public void sortDescending();

    public void trimToSize();

    public void removeLast();

    public void clear();

    public void setObject(int var1, Object var2);

    public void setString(int var1, String var2);

    public void setInt(int var1, int var2);

    public void setShort(int var1, short var2);

    public void setLong(int var1, long var2);

    public void setFloat(int var1, float var2);

    public void setDouble(int var1, double var2);

    public void setBoolean(int var1, boolean var2);

    public Column emptyCopy();

    public Column emptyCopy(int var1);

    public Column copy();

    default public Column trimToSelection() {
        return this.trimToSelection(this.getSelection());
    }

    public Column trimToSelection(Selection var1);

    @RPLMethod
    @ColumnOperation
    default public ShortColumn asShortColumn() {
        return this.asShortColumn(this.getSelection());
    }

    default public ShortColumn asShortColumn(Selection selection) {
        if (this instanceof ShortColumn) {
            return (ShortColumn)this;
        }
        ShortColumn result = ShortColumn.create(this.name(), selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(ShortColumnImpl.MISSING_VALUE);
            } else {
                result.append(this.getShort(i));
            }
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public IntColumn asIntColumn() {
        return this.asIntColumn(this.getSelection());
    }

    default public IntColumn asIntColumn(Selection selection) {
        if (this instanceof IntColumn) {
            return (IntColumn)this;
        }
        IntColumn result = IntColumn.create(this.name(), selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(IntColumnImpl.MISSING_VALUE);
            } else {
                result.append(this.getInt(i));
            }
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public LongColumn asLongColumn() {
        return this.asLongColumn(this.getSelection());
    }

    default public LongColumn asLongColumn(Selection selection) {
        if (this instanceof LongColumn) {
            return (LongColumn)this;
        }
        LongColumn result = LongColumn.create(this.name(), selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(LongColumnImpl.MISSING_VALUE);
            } else {
                result.append(this.getLong(i));
            }
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public FloatColumn asFloatColumn() {
        return this.asFloatColumn(this.getSelection());
    }

    default public FloatColumn asFloatColumn(Selection selection) {
        if (this instanceof FloatColumn) {
            return (FloatColumn)this;
        }
        FloatColumn result = FloatColumn.create(this.name(), selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(FloatColumnImpl.MISSING_VALUE);
            } else {
                result.append(this.getFloat(i));
            }
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn asDoubleColumn() {
        return this.asDoubleColumn(this.getSelection());
    }

    default public DoubleColumn asDoubleColumn(Selection selection) {
        if (this instanceof DoubleColumn) {
            return (DoubleColumn)this;
        }
        DoubleColumn result = DoubleColumn.create(this.name(), selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(DoubleColumnImpl.MISSING_VALUE);
            } else {
                result.append(this.getDouble(i));
            }
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public StringColumn asStringColumn() {
        return this.asStringColumn(this.getSelection());
    }

    default public StringColumn asStringColumn(Selection selection) {
        if (this instanceof StringColumn) {
            return (StringColumn)this;
        }
        StringColumn result = StringColumn.create(this.name(), selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append(StringColumnImpl.MISSING_VALUE);
            } else {
                result.append(this.getString(i));
            }
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public BooleanColumn asBooleanColumn() {
        return this.asBooleanColumn(this.getSelection());
    }

    default public BooleanColumn asBooleanColumn(Selection selection) {
        if (this instanceof BooleanColumn) {
            return (BooleanColumn)this;
        }
        BooleanColumn result = BooleanColumn.create(this.name(), selection.size());
        selection.iterate(i -> {
            if (this.isMissing(i)) {
                result.append((byte)-128);
            } else {
                result.append(this.getBoolean(i));
            }
        });
        return result;
    }

    public String getString(int var1);

    public Object getObject(int var1);

    public int getInt(int var1);

    public short getShort(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public boolean getBoolean(int var1);

    default public long getLongUnscaled(int row) {
        return this.getLong(row);
    }

    default public boolean isEmpty() {
        return this.isEmpty(this.getSelection());
    }

    public boolean isEmpty(Selection var1);

    public byte[] asBytes(int var1);

    public boolean isMissing(int var1);

    default public IntComparator rowComparator(Order order) {
        IntComparator comparator = this.rowComparator();
        if (order == Order.ASC) {
            return comparator;
        }
        return (k1, k2) -> 0 - comparator.compare(k1, k2);
    }

    public IntComparator rowComparator();

    public int compare(int var1, Column var2, int var3);

    public long sizeInMemoryData();

    public long sizeInMemoryFull();

    public long sizeOnDisk();

    public Selection getSelection();

    public IntIterator indexIterator();

    default public Column first(int numRows) {
        return this.first(numRows, this.getSelection());
    }

    default public Column first(int numRows, Selection selection) {
        Column col = this.emptyCopy();
        IntIterator iterator = selection.iterator();
        for (int rows = 0; iterator.hasNext() && rows < numRows; ++rows) {
            col.appendObject(this.getString(iterator.nextInt()));
        }
        return col;
    }

    default public Column last(int numRows) {
        return this.last(numRows, this.getSelection());
    }

    default public Column last(int numRows, Selection selection) {
        Column col = this.emptyCopy();
        IntIterator iterator = selection.reverseIterator();
        for (int rows = 0; iterator.hasNext() && rows < numRows; ++rows) {
            col.appendObject(this.getString(iterator.nextInt()));
        }
        return col;
    }

    default public String first() {
        return this.first(this.getSelection());
    }

    default public String first(Selection selection) {
        IntIterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            return this.getString(iterator.nextInt());
        }
        return null;
    }

    default public String last() {
        return this.last(this.getSelection());
    }

    default public String last(Selection selection) {
        IntIterator iterator = selection.reverseIterator();
        if (iterator.hasNext()) {
            return this.getString(iterator.nextInt());
        }
        return null;
    }

    public Selection isMissing(Selection var1);

    @RPLMethod(description="Filters missing rows.")
    @IsMethod
    default public Selection isMissing() {
        return this.isMissing(this.getSelection());
    }

    public Selection isNotMissing(Selection var1);

    @RPLMethod(description="Filters not missing rows.")
    @IsMethod
    default public Selection isNotMissing() {
        return this.isNotMissing(this.getSelection());
    }

    public int countMissing(Selection var1);

    default public int countMissing() {
        return this.countMissing(this.getSelection());
    }

    default public int countUnique(Selection selection) {
        throw new UnsupportedOperationException("Method countUnique() is not supported yet");
    }

    default public int countUnique() {
        return this.countUnique(this.getSelection());
    }

    default public Column subset(Selection rows) {
        Column c = this.emptyCopy();
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            c.appendObject(this.getString(row));
        }
        return c;
    }

    default public Column unique() {
        return this.unique(this.getSelection());
    }

    default public Column unique(Selection selection) {
        throw new UnsupportedOperationException("Method unique() is not supported yet");
    }

    default public Column difference() {
        return this.difference(this.getSelection());
    }

    default public Column difference(Selection selection) {
        throw new UnsupportedOperationException("difference() method not supported for all data types");
    }

    public Column select(Selection var1);

    public Column selectNoMissing(Selection var1);

    default public Column selectNoMissing() {
        return this.selectNoMissing(this.getSelection());
    }

    default public double[] toDoubleArray() {
        return this.toDoubleArray(this.getSelection());
    }

    default public double[] toDoubleArray(Selection selection) {
        double[] output = new double[selection.size()];
        int i = 0;
        IntIterator intIterator = selection.iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            output[i++] = this.getDouble(id);
        }
        return output;
    }

    public void defrag(int[] var1, boolean var2);

    public String print();

    default public String title() {
        return "Column: " + this.name() + "\n";
    }

    default public SnapshotTable summary() {
        throw new UnsupportedOperationException("Method summary() is not supported yet");
    }

    default public Column wrap(Selection selection) {
        return this;
    }
}

