/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.google.common.base.Strings;
import com.streamscape.ds.schema.procedure.phonetic.Levenshtein;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.filtering.StringBiPredicate;
import com.streamscape.ds.stable.filtering.StringPredicate;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.rplmethod.ColumnOperation;
import com.streamscape.ds.stable.rplmethod.IsMethod;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.lib.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface CategoryStringColumn
extends Column {
    public long sizeInMemory(Selection var1);

    public void removeRow(int var1);

    public void append(String var1);

    public void appendAll(List<String> var1);

    public void set(int var1, String var2);

    public void set(String var1, Selection var2);

    public String get(int var1);

    public String getMissingValue();

    default public CategoryStringColumn executeStringOperation(Function<String, String> operator, String name, Selection selection) {
        CategoryStringColumn result = (CategoryStringColumn)this.emptyCopy(selection.size());
        result.setName(name);
        selection.iterate(i -> result.append(this.isMissing(i) ? this.getMissingValue() : (String)operator.apply(this.get(i))));
        return result;
    }

    default public CategoryStringColumn executeStringOperation(BiFunction<String, String, String> operator, Column column2, String operation, Selection selection) {
        CategoryStringColumn result = (CategoryStringColumn)this.emptyCopy(selection.size());
        result.setName(this.name() + operation + column2.name());
        IntIterator iterator2 = column2.getSelection().iterator();
        selection.iterate(i -> {
            if (!iterator2.hasNext()) {
                return;
            }
            int i2 = iterator2.nextInt();
            result.append(this.isMissing(i) || column2.isMissing(i2) ? this.getMissingValue() : (String)operator.apply(this.get(i), column2.getString(i2)));
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn upperCase() {
        return this.upperCase(this.getSelection());
    }

    default public CategoryStringColumn upperCase(Selection selection) {
        return this.executeStringOperation(s -> s.toUpperCase(), this.name() + " upperCase", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn lowerCase() {
        return this.lowerCase(this.getSelection());
    }

    default public CategoryStringColumn lowerCase(Selection selection) {
        return this.executeStringOperation(s -> s.toLowerCase(), this.name() + " lowerCase", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn trim() {
        return this.trim(this.getSelection());
    }

    default public CategoryStringColumn trim(Selection selection) {
        return this.executeStringOperation(s -> s.trim(), this.name() + " trim", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn replaceAll(String regex, String replacement) {
        return this.replaceAll(regex, replacement, this.getSelection());
    }

    default public CategoryStringColumn replaceAll(String regex, String replacement, Selection selection) {
        return this.executeStringOperation(s -> s.replaceAll(regex, replacement), this.name() + " replaceAll", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn replaceFirst(String regex, String replacement) {
        return this.replaceFirst(regex, replacement, this.getSelection());
    }

    default public CategoryStringColumn replaceFirst(String regex, String replacement, Selection selection) {
        return this.executeStringOperation(s -> s.replaceFirst(regex, replacement), this.name() + " replaceFirst", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn substring(int start, int end) {
        return this.substring(start, end, this.getSelection());
    }

    default public CategoryStringColumn substring(int start, int end, Selection selection) {
        return this.executeStringOperation(s -> s.substring(start, end), this.name() + " substring", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn substring(int start) {
        return this.substring(start, this.getSelection());
    }

    default public CategoryStringColumn substring(int start, Selection selection) {
        return this.executeStringOperation(s -> s.substring(start), this.name() + " substring", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn format(String formatString) {
        return this.format(formatString, this.getSelection());
    }

    default public CategoryStringColumn format(String formatString, Selection selection) {
        return this.executeStringOperation(s -> String.format(formatString, s), this.name() + " format", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn padEnd(int minLength, char padChar) {
        return this.padEnd(minLength, padChar, this.getSelection());
    }

    default public CategoryStringColumn padEnd(int minLength, char padChar, Selection selection) {
        return this.executeStringOperation(s -> Strings.padEnd((String)s, (int)minLength, (char)padChar), this.name() + " padEnd", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn padStart(int minLength, char padChar) {
        return this.padStart(minLength, padChar, this.getSelection());
    }

    default public CategoryStringColumn padStart(int minLength, char padChar, Selection selection) {
        return this.executeStringOperation(s -> Strings.padStart((String)s, (int)minLength, (char)padChar), this.name() + " padStart", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn commonPrefix(Column column2) {
        return this.commonPrefix(column2, this.getSelection());
    }

    default public CategoryStringColumn commonPrefix(Column column2, Selection selection) {
        return this.executeStringOperation((s1, s2) -> Strings.commonPrefix((CharSequence)s1, (CharSequence)s2), column2, "commonPrefix", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn commonSuffix(Column column2) {
        return this.commonSuffix(column2, this.getSelection());
    }

    default public CategoryStringColumn commonSuffix(Column column2, Selection selection) {
        return this.executeStringOperation((s1, s2) -> Strings.commonSuffix((CharSequence)s1, (CharSequence)s2), column2, "commonSuffix", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn distance(Column column2) {
        return this.distance(column2, this.getSelection());
    }

    default public DoubleColumn distance(Column column2, Selection selection) {
        DoubleColumn result = DoubleColumn.create(this.name() + " distance " + column2.name(), selection.size());
        selection.iterate(i -> result.append(this.isMissing(i) ? DoubleColumnImpl.MISSING_VALUE : (double)Levenshtein.distance(this.get(i), column2.getString(i))));
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn join(String separator, Column ... column) {
        return this.join(this.getSelection(), separator, column);
    }

    default public CategoryStringColumn join(Selection selection, String separator, Column ... column) {
        CategoryStringColumn result = (CategoryStringColumn)this.emptyCopy(selection.size());
        result.setName(this.name() + " join ");
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(this);
        columns.addAll(Arrays.asList(column));
        selection.iterate(i -> result.append(columns.stream().map(c -> c.getString(i)).collect(Collectors.joining(separator))));
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn concat(String append) {
        return this.concat(append, this.getSelection());
    }

    default public CategoryStringColumn concat(String append, Selection selection) {
        return this.executeStringOperation(s -> s + append, this.name() + " append", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn tokenizeAndSort(String separator) {
        return this.tokenizeAndSort(separator, this.getSelection());
    }

    default public CategoryStringColumn tokenizeAndSort(String separator, Selection selection) {
        return this.executeStringOperation(s -> {
            List<String> tokens = StringUtils.split(s, separator);
            tokens = tokens.stream().map(t -> t.trim()).filter(t -> t.length() > 0).collect(Collectors.toList());
            Collections.sort(tokens);
            return String.join((CharSequence)separator, tokens);
        }, this.name() + " tokenizeAndSort", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public DoubleColumn countTokens(String separator) {
        return this.countTokens(separator, this.getSelection());
    }

    default public DoubleColumn countTokens(String separator, Selection selection) {
        DoubleColumn result = DoubleColumn.create(this.name() + " token count", selection.size());
        selection.iterate(i -> {
            String s = this.getString(i);
            List<String> tokens = StringUtils.split(s, separator);
            result.append(tokens.stream().map(t -> t.trim()).filter(t -> t.length() > 0).count());
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn tokens(String separator) {
        return this.tokens(separator, this.getSelection());
    }

    default public CategoryStringColumn tokens(String separator, Selection selection) {
        CategoryStringColumn result = (CategoryStringColumn)this.emptyCopy(selection.size());
        result.setName(this.name() + " tokens");
        selection.iterate(i -> {
            String s = this.getString(i);
            List<String> tokens = StringUtils.split(s, separator);
            tokens = tokens.stream().map(t -> t.trim()).filter(t -> t.length() > 0).collect(Collectors.toList());
            for (String token : tokens) {
                result.append(token);
            }
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn uniqueTokens(String separator) {
        return this.uniqueTokens(separator, this.getSelection());
    }

    default public CategoryStringColumn uniqueTokens(String separator, Selection selection) {
        return this.tokens(separator, selection).unique();
    }

    @Override
    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn unique() {
        return this.unique(this.getSelection());
    }

    @Override
    default public CategoryStringColumn unique(Selection selection) {
        HashSet<String> set = new HashSet<String>();
        selection.iterate(i -> set.add(this.get(i)));
        if (this instanceof CategoryColumn) {
            return CategoryColumn.create(this.name() + " unique values", set);
        }
        return StringColumn.create(this.name() + " unique values", set);
    }

    @RPLMethod
    @ColumnOperation
    default public IntColumn length() {
        return this.length(this.getSelection());
    }

    default public IntColumn length(Selection selection) {
        IntColumn result = IntColumn.create(this.name() + " length", selection.size());
        selection.iterate(i -> {
            String s = this.getString(i);
            result.append(s != null ? s.length() : 0);
        });
        return result;
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn tokenizeAndSort() {
        return this.tokenizeAndSort(this.getSelection());
    }

    default public CategoryStringColumn tokenizeAndSort(Selection selection) {
        return this.executeStringOperation(s -> {
            List<String> tokens = Arrays.asList(s.split("\\s"));
            tokens = tokens.stream().map(t -> t.trim()).filter(t -> t.length() > 0).collect(Collectors.toList());
            Collections.sort(tokens);
            return String.join((CharSequence)" ", tokens);
        }, this.name() + " tokenizeAndSort", selection);
    }

    @RPLMethod
    @ColumnOperation
    default public CategoryStringColumn tokenizeAndRemoveDuplicates(String separator) {
        return this.tokenizeAndRemoveDuplicates(separator, this.getSelection());
    }

    default public CategoryStringColumn tokenizeAndRemoveDuplicates(String separator, Selection selection) {
        return this.executeStringOperation(s -> {
            List<String> tokens = StringUtils.split(s, separator);
            tokens = tokens.stream().map(t -> t.trim()).filter(t -> t.length() > 0).collect(Collectors.toList());
            return tokens.stream().distinct().collect(Collectors.joining(separator));
        }, this.name() + " tokenizeAndRemoveDuplicates", selection);
    }

    default public Selection isEqualTo(CategoryStringColumn other) {
        return this.isEqualTo(other, this.getSelection());
    }

    public Selection isEqualTo(CategoryStringColumn var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection isEqualTo(String string) {
        return this.isEqualTo(string, this.getSelection());
    }

    public Selection isEqualTo(String var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection isNotEqualTo(String string) {
        return this.isNotEqualTo(string, this.getSelection());
    }

    public Selection isNotEqualTo(String var1, Selection var2);

    default public Selection select(StringPredicate predicate) {
        return this.select(predicate, this.getSelection());
    }

    public Selection select(StringPredicate var1, Selection var2);

    default public Selection select(StringBiPredicate predicate, String value) {
        return this.select(predicate, value, this.getSelection());
    }

    public Selection select(StringBiPredicate var1, String var2, Selection var3);

    @RPLMethod
    @IsMethod
    default public Selection equalToIgnoringCase(String string) {
        return this.equalToIgnoringCase(string, this.getSelection());
    }

    public Selection equalToIgnoringCase(String var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection startsWith(String string) {
        return this.startsWith(string, this.getSelection());
    }

    public Selection startsWith(String var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection endsWith(String string) {
        return this.endsWith(string, this.getSelection());
    }

    public Selection endsWith(String var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection stringContains(String string) {
        return this.stringContains(string, this.getSelection());
    }

    public Selection stringContains(String var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection matchesRegex(String string) {
        return this.matchesRegex(string, this.getSelection());
    }

    public Selection matchesRegex(String var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection empty() {
        return this.empty(this.getSelection());
    }

    public Selection empty(Selection var1);

    @RPLMethod
    @IsMethod
    default public Selection isAlpha() {
        return this.isAlpha(this.getSelection());
    }

    public Selection isAlpha(Selection var1);

    @RPLMethod
    @IsMethod
    default public Selection isNumeric() {
        return this.isNumeric(this.getSelection());
    }

    public Selection isNumeric(Selection var1);

    @RPLMethod
    @IsMethod
    default public Selection isAlphaNumeric() {
        return this.isAlphaNumeric(this.getSelection());
    }

    public Selection isAlphaNumeric(Selection var1);

    @RPLMethod
    @IsMethod
    default public Selection isUpperCase() {
        return this.isUpperCase(this.getSelection());
    }

    public Selection isUpperCase(Selection var1);

    @RPLMethod
    @IsMethod
    default public Selection isLowerCase() {
        return this.isLowerCase(this.getSelection());
    }

    public Selection isLowerCase(Selection var1);

    @RPLMethod
    @IsMethod
    default public Selection hasLengthEqualTo(int lengthChars) {
        return this.hasLengthEqualTo(lengthChars, this.getSelection());
    }

    public Selection hasLengthEqualTo(int var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection isShorterThan(int lengthChars) {
        return this.isShorterThan(lengthChars, this.getSelection());
    }

    public Selection isShorterThan(int var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection isLongerThan(int lengthChars) {
        return this.isLongerThan(lengthChars, this.getSelection());
    }

    public Selection isLongerThan(int var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection isIn(String ... strings) {
        return this.isIn(this.getSelection(), strings);
    }

    public Selection isIn(Selection var1, String ... var2);

    default public Selection isIn(Collection<String> strings) {
        return this.isIn(strings, this.getSelection());
    }

    public Selection isIn(Collection<String> var1, Selection var2);

    @RPLMethod
    @IsMethod
    default public Selection isNotIn(String ... strings) {
        return this.isNotIn(this.getSelection(), strings);
    }

    public Selection isNotIn(Selection var1, String ... var2);

    default public Selection isNotIn(Collection<String> strings) {
        return this.isNotIn(strings, this.getSelection());
    }

    public Selection isNotIn(Collection<String> var1, Selection var2);

    default public Set<String> asSet() {
        return this.asSet(this.getSelection());
    }

    public Set<String> asSet(Selection var1);

    default public List<String> top(int n) {
        return this.top(n, this.getSelection());
    }

    public List<String> top(int var1, Selection var2);

    default public List<String> bottom(int n) {
        return this.bottom(n, this.getSelection());
    }

    public List<String> bottom(int var1, Selection var2);
}

