/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractStringColumn;
import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.CategoryColumnWrapper;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.filtering.StringPredicate;
import com.streamscape.ds.stable.lists.IntArrayList;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.DictionaryMap;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CategoryColumnImpl
extends AbstractStringColumn
implements CategoryColumn {
    public static final String MISSING_VALUE = (String)((Object)ColumnType.CATEGORY.getMissingValue());
    private static final int BYTE_SIZE = 4;
    private static int DEFAULT_ARRAY_SIZE = 128;
    private int id = 0;
    private IntArrayList values;
    private DictionaryMap lookupTable = new DictionaryMap();

    public CategoryColumnImpl(String name) {
        super(name);
        this.values = new IntArrayList(DEFAULT_ARRAY_SIZE);
    }

    public CategoryColumnImpl(String name, String[] categories) {
        this(name, Arrays.asList(categories));
    }

    public CategoryColumnImpl(String name, Collection<String> categories) {
        super(name);
        this.values = new IntArrayList(categories.size());
        for (String string : categories) {
            this.append(string);
        }
    }

    public CategoryColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.values = new IntArrayList(metadata.getSize());
    }

    public CategoryColumnImpl(String name, int size) {
        super(name);
        this.values = new IntArrayList(size);
    }

    public void initId() {
        this.id = this.dictionaryMap().keyToValueMap().keySet().stream().max(Integer::compare).orElse(0) + 1;
    }

    @Override
    public int dataSize() {
        return this.values.size();
    }

    @Override
    public int capacity() {
        return this.values != null ? this.values.capacity() : 0;
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public ColumnType type() {
        return ColumnType.CATEGORY;
    }

    @Override
    public long sizeInMemoryData() {
        return this.size() * 4 + this.lookupTable.sizeInMemoryData();
    }

    @Override
    public long sizeInMemoryFull() {
        return this.capacity() * 4 + this.lookupTable.sizeInMemoryFull();
    }

    @Override
    public long sizeInMemory(Selection selection) {
        long result = 0L;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int index = iterator.nextInt();
            if (index < 0 || index >= this.values.size()) continue;
            result += 4L;
            int key = this.values.getInt(index);
            if (key < 0) continue;
            result += TypeUtils.stringSize(this.lookupTable.get(key));
        }
        return result;
    }

    @Override
    public SnapshotTable summary() {
        return this.countByCategory();
    }

    public SnapshotTable countByCategory() {
        SnapshotTable t = SnapshotTable.create("Column: " + this.name());
        CategoryColumn categories = CategoryColumn.create("Category");
        IntColumn counts = IntColumn.create("Count");
        HashMap<Integer, Integer> valueToCount = new HashMap<Integer, Integer>();
        Iterator<Integer> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (valueToCount.containsKey(n)) {
                valueToCount.put(n, (Integer)valueToCount.get(n) + 1);
                continue;
            }
            valueToCount.put(n, 1);
        }
        for (Map.Entry entry : valueToCount.entrySet()) {
            categories.append(this.lookupTable.get((Integer)entry.getKey()));
            counts.append((Integer)entry.getValue());
        }
        t.addColumn(categories);
        t.addColumn(counts);
        return t;
    }

    public DictionaryMap dictionaryMap() {
        return this.lookupTable;
    }

    @Override
    public void clear() {
        this.values.clear();
        this.lookupTable.clear();
        this.id = 0;
        this.onDataCleared();
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        int removedId = this.values.removeByIndex(this.dataSize() - 1);
        if (removedId == -1) {
            return;
        }
        this.lookupTable.decrementUsages(removedId);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.values.set(to, this.values.getInt(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.values.size() - size; toRemove > 0; --toRemove) {
            this.values.removeByIndex(this.values.size() - 1);
        }
    }

    @Override
    public void set(int rowIndex, String stringValue) {
        if (stringValue == null) {
            stringValue = MISSING_VALUE;
        }
        int oldValueId = this.values.getInt(rowIndex);
        this.lookupTable.decrementUsages(oldValueId);
        int valueId = this.lookupTable.get(stringValue);
        if (valueId == -1) {
            valueId = this.id++;
            this.lookupTable.put(valueId, stringValue);
        } else {
            this.lookupTable.incrementUsages(valueId);
        }
        this.values.set(rowIndex, valueId);
        this.onDataChanged(rowIndex);
    }

    @Override
    protected void appendValue(String value) {
        int key = this.lookupTable.get(value);
        if (key < 0) {
            key = this.id++;
            this.lookupTable.put(key, value);
        } else {
            this.lookupTable.incrementUsages(key);
        }
        this.values.add(key);
        this.onDataAppended(this.values.size() - 1);
    }

    public void initializeWith(IntArrayList list, DictionaryMap map) {
        IntIterator intIterator = list.iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            this.append(map.get(key));
        }
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        CategoryColumn categoryColumn = (CategoryColumn)column;
        for (int i = 0; i < categoryColumn.size(); ++i) {
            this.append(categoryColumn.get(i));
        }
    }

    @Override
    public void removeRow(int index) {
        int key = this.values.getInt(index);
        this.lookupTable.decrementUsages(key);
        this.values.set(index, -1);
    }

    @Override
    public void trimToSize() {
        this.values.trimToSize();
        this.lookupTable.trimToSize();
    }

    @Override
    public void sortAscending() {
        throw new UnsupportedOperationException("Method 'sortAscending' not yet implemented");
    }

    @Override
    public void sortDescending() {
        throw new UnsupportedOperationException("Method 'sortDescending' not yet implemented");
    }

    @Override
    public Set<String> asSet(Selection selection) {
        if (selection.size() == this.dataSize()) {
            return new HashSet<String>(this.lookupTable.categories());
        }
        return super.asSet(selection);
    }

    public IntArrayList values() {
        return this.values;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(4).putInt(this.values.getInt(rowNumber)).array();
    }

    @Override
    public String get(int rowIndex) {
        int k = this.values.getInt(rowIndex);
        if (k == -1) {
            return null;
        }
        return this.lookupTable.get(k);
    }

    public boolean contains(String aString) {
        return this.values.indexOf(this.dictionaryMap().get(aString)) >= 0;
    }

    public IntArrayList getValues(IntArrayList indexes) {
        IntArrayList newList = new IntArrayList(indexes.size());
        IntIterator intIterator = indexes.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            newList.add(this.values.getInt(i));
        }
        return newList;
    }

    public List<BooleanColumn> getDummies() {
        ArrayList<BooleanColumn> results = new ArrayList<BooleanColumn>();
        for (Map.Entry<Integer, String> entry : this.lookupTable.keyToValueMap().entrySet()) {
            BooleanColumn column = BooleanColumn.create(entry.getValue());
            results.add(column);
        }
        IntIterator intIterator = this.values.iterator();
        while (intIterator.hasNext()) {
            int next = (Integer)intIterator.next();
            String category = this.lookupTable.get(next);
            for (BooleanColumn column : results) {
                if (category.equals(column.name())) {
                    column.append(true);
                    continue;
                }
                column.append(false);
            }
        }
        return results;
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.values.isEmpty();
    }

    @Override
    public String getMissingValue() {
        return MISSING_VALUE;
    }

    @Override
    public CategoryColumn emptyCopy() {
        CategoryColumn copy = CategoryColumn.create(this.name());
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public CategoryColumn emptyCopy(int rowSize) {
        CategoryColumn copy = CategoryColumn.create(this.name(), rowSize);
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public CategoryColumn copy() {
        CategoryColumn column = CategoryColumn.create(this.name(), this.size());
        ((CategoryColumnImpl)column).lookupTable = new DictionaryMap(this.lookupTable);
        ((CategoryColumnImpl)column).values.addAll(this.values);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public CategoryColumn trimToSelection(Selection selection) {
        CategoryColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.get(iterator.nextInt()));
        }
        return column;
    }

    @Override
    public CategoryColumn upperCase() {
        return (CategoryColumn)super.upperCase();
    }

    @Override
    public CategoryColumn lowerCase() {
        return (CategoryColumn)super.lowerCase();
    }

    @Override
    public CategoryColumn trim() {
        return (CategoryColumn)super.trim();
    }

    @Override
    public CategoryColumn replaceAll(String regex, String replacement) {
        return (CategoryColumn)super.replaceAll(regex, replacement);
    }

    @Override
    public CategoryColumn replaceFirst(String regex, String replacement) {
        return (CategoryColumn)super.replaceFirst(regex, replacement);
    }

    @Override
    public CategoryColumn substring(int start, int end) {
        return (CategoryColumn)super.substring(start, end);
    }

    @Override
    public CategoryColumn substring(int start) {
        return (CategoryColumn)super.substring(start);
    }

    @Override
    public CategoryColumn format(String formatString) {
        return (CategoryColumn)super.format(formatString);
    }

    @Override
    public CategoryColumn padEnd(int minLength, char padChar) {
        return (CategoryColumn)super.padEnd(minLength, padChar);
    }

    @Override
    public CategoryColumn padStart(int minLength, char padChar) {
        return (CategoryColumn)super.padStart(minLength, padChar);
    }

    @Override
    public CategoryColumn commonPrefix(Column column2) {
        return (CategoryColumn)super.commonPrefix(column2);
    }

    @Override
    public CategoryColumn commonSuffix(Column column2) {
        return (CategoryColumn)super.commonSuffix(column2);
    }

    @Override
    public CategoryColumn join(String separator, Column ... column) {
        return (CategoryColumn)super.join(separator, column);
    }

    @Override
    public CategoryColumn concat(String append) {
        return (CategoryColumn)super.concat(append);
    }

    @Override
    public CategoryColumn tokenizeAndSort(String separator) {
        return (CategoryColumn)super.tokenizeAndSort(separator);
    }

    @Override
    public CategoryColumn tokens(String separator) {
        return (CategoryColumn)super.tokens(separator);
    }

    @Override
    public CategoryColumn uniqueTokens(String separator) {
        return (CategoryColumn)super.uniqueTokens(separator);
    }

    @Override
    public CategoryColumn unique() {
        return (CategoryColumn)super.unique();
    }

    @Override
    public CategoryColumn tokenizeAndSort() {
        return (CategoryColumn)super.tokenizeAndSort();
    }

    @Override
    public CategoryColumn tokenizeAndRemoveDuplicates(String separator) {
        return (CategoryColumn)super.tokenizeAndRemoveDuplicates(separator);
    }

    @Override
    public CategoryColumn unique(Selection selection) {
        if (selection.size() == this.dataSize()) {
            ArrayList<String> strings = new ArrayList<String>(this.lookupTable.categories());
            return CategoryColumn.create(this.name() + " Unique values", strings);
        }
        IntIterator iterator = selection.iterator();
        HashSet<String> set = new HashSet<String>();
        while (iterator.hasNext()) {
            set.add(this.get(iterator.nextInt()));
        }
        return CategoryColumn.create(this.name() + " Unique values", new ArrayList<String>(set));
    }

    @Override
    public CategoryColumn selectIf(StringPredicate predicate) {
        CategoryColumn column = this.emptyCopy();
        IntIterator iterator = this.indexIterator();
        while (iterator.hasNext()) {
            String next = this.get(iterator.nextInt());
            if (!predicate.test(next)) continue;
            column.append(next);
        }
        return column;
    }

    @Override
    public int countUnique(Selection selection) {
        if (selection.size() == this.dataSize()) {
            return this.lookupTable.size();
        }
        IntIterator iterator = selection.iterator();
        HashSet<String> set = new HashSet<String>();
        while (iterator.hasNext()) {
            set.add(this.get(iterator.nextInt()));
        }
        return set.size();
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!this.isMissing(iterator.nextInt())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isEqualTo(String string, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int key = this.lookupTable.get(string);
        if (key >= 0) {
            IntIterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                int i = iterator.nextInt();
                if (this.values.getInt(i) != key) continue;
                results.add(i);
            }
        }
        return results;
    }

    @Override
    public Selection isIn(Selection selection, String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (String string : strings) {
            int key = this.lookupTable.get(string);
            if (key < 0) continue;
            IntIterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                int i = iterator.nextInt();
                int next = this.values.getInt(i);
                if (key == next) {
                    results.add(i);
                }
                ++i;
            }
        }
        return results;
    }

    @Override
    public Selection isNotIn(Selection selection, String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (String string : strings) {
            int key = this.lookupTable.get(string);
            if (key < 0) continue;
            IntIterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                int i = iterator.nextInt();
                int next = this.values.getInt(i);
                if (key != next) {
                    results.add(i);
                }
                ++i;
            }
        }
        return results;
    }

    @Override
    public Selection isIn(Collection<String> strings, Selection selection) {
        return this.isIn(strings.toArray(new String[strings.size()]));
    }

    @Override
    public Selection isNotIn(Collection<String> strings, Selection selection) {
        return this.isNotIn(strings.toArray(new String[strings.size()]));
    }

    @Override
    public Selection select(StringPredicate predicate, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        HashSet<Integer> sorted = new HashSet<Integer>();
        for (Map.Entry<String, Integer> entry : this.lookupTable.valueToKeyMap().entrySet()) {
            String key = entry.getKey();
            if (!predicate.test(key)) continue;
            sorted.add(entry.getValue());
        }
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            int next = this.values.getInt(i);
            if (!sorted.contains(next)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public IntColumn toIntColumn() {
        IntColumn intColumn = IntColumn.create(this.name() + ": codes", this.size());
        IntArrayList data = this.values();
        for (int i = 0; i < this.size(); ++i) {
            intColumn.append(data.getInt(i));
        }
        return intColumn;
    }

    public String toString() {
        return "Category column: " + this.name();
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        IntIterator intIterator = this.values.iterator();
        while (intIterator.hasNext()) {
            int next = (Integer)intIterator.next();
            builder.append(this.get(next));
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public CategoryColumn wrap(Selection selection) {
        return new CategoryColumnWrapper(this, selection);
    }
}

