/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.BooleanColumnWrapper;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.FloatColumnImpl;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.IntColumnImpl;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.columns.ShortColumnImpl;
import com.streamscape.ds.stable.filtering.BooleanPredicate;
import com.streamscape.ds.stable.lists.ByteArrayList;
import com.streamscape.ds.stable.lists.ByteIterator;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class BooleanColumnImpl
extends AbstractColumn
implements BooleanColumn {
    public static final byte MISSING_VALUE = -128;
    private static final int BYTE_SIZE = 1;
    private static int DEFAULT_ARRAY_SIZE = 128;
    private ByteArrayList data;
    IntComparator comparator = new IntComparator(){

        @Override
        public int compare(Integer r1, Integer r2) {
            return this.compare((int)r1, (int)r2);
        }

        @Override
        public int compare(int r1, int r2) {
            return this.compare(BooleanColumnImpl.this.getByte(r1), BooleanColumnImpl.this.getByte(r2));
        }
    };
    public static BooleanPredicate isMissing = i -> BooleanColumnImpl.isMissingValue(i);
    public static BooleanPredicate isNotMissing = i -> BooleanColumnImpl.isMissingValue(i);

    protected BooleanColumnImpl(ColumnMetadata metadata) {
        super(metadata);
        this.data = new ByteArrayList(metadata.getSize());
    }

    protected BooleanColumnImpl(String name) {
        this(name, new ByteArrayList(DEFAULT_ARRAY_SIZE));
    }

    protected BooleanColumnImpl(String name, int initialSize) {
        this(name, new ByteArrayList(initialSize));
    }

    private BooleanColumnImpl(String name, ByteArrayList values) {
        super(name);
        this.data = values;
    }

    protected BooleanColumnImpl(String name, Selection hits, int columnSize) {
        super(name);
        if (columnSize > 0) {
            ByteArrayList data = new ByteArrayList(columnSize);
            for (int i = 0; i < columnSize; ++i) {
                data.add((byte)0);
            }
            for (Integer hit : hits) {
                data.set(hit, (byte)1);
            }
            this.data = data;
        }
    }

    protected BooleanColumnImpl(String name, boolean[] array) {
        super(name);
        this.data = new ByteArrayList(array.length);
        for (boolean b : array) {
            this.append(b);
        }
    }

    @Override
    public int dataSize() {
        return this.data.size();
    }

    @Override
    public int capacity() {
        return this.data != null ? this.data.capacity() : 0;
    }

    @Override
    public ColumnType type() {
        return ColumnType.BOOLEAN;
    }

    @Override
    public int byteSize() {
        return 1;
    }

    @Override
    public SnapshotTable summary() {
        HashMap<Byte, Integer> counts = new HashMap<Byte, Integer>();
        counts.put((byte)0, 0);
        counts.put((byte)1, 0);
        ByteIterator byteIterator = this.data.iterator();
        while (byteIterator.hasNext()) {
            byte next = (Byte)byteIterator.next();
            counts.put(next, (Integer)counts.get(next) + 1);
        }
        SnapshotTable table = SnapshotTable.create(this.name());
        BooleanColumn booleanColumn = BooleanColumn.create("Value");
        IntColumn countColumn = IntColumn.create("Count");
        table.addColumn(booleanColumn);
        table.addColumn(countColumn);
        for (Map.Entry entry : counts.entrySet()) {
            booleanColumn.append((Byte)entry.getKey());
            countColumn.append((Integer)entry.getValue());
        }
        return table;
    }

    @Override
    public void append(boolean b) {
        if (b) {
            this.data.add((byte)1);
        } else {
            this.data.add((byte)0);
        }
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void append(byte b) {
        this.data.add(b);
        this.onDataAppended(this.data.size() - 1);
    }

    @Override
    public void appendObject(Object object) {
        this.append(BooleanColumnImpl.convert(object));
    }

    @Override
    public void append(Column column) {
        if (column.type() != this.type()) {
            throw new IllegalArgumentException();
        }
        BooleanColumn booleanColumn = (BooleanColumn)column;
        for (int i = 0; i < booleanColumn.size(); ++i) {
            this.append(booleanColumn.get(i));
        }
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getBoolean(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(BooleanColumnImpl.getMissingValue());
    }

    @Override
    public void set(int i, boolean b) {
        this.data.set(i, b ? (byte)1 : 0);
        this.onDataChanged(i);
    }

    @Override
    public void set(int i, byte b) {
        this.data.set(i, b);
        this.onDataChanged(i);
    }

    @Override
    public void set(boolean newValue, Selection selection) {
        IntIterator intIterator = selection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void removeLast() {
        if (this.dataSize() == 0) {
            return;
        }
        this.data.removeByIndex(this.dataSize() - 1);
        this.onDataRemoved(this.dataSize());
    }

    @Override
    public void assignWithValue(Object object) {
        byte value = BooleanColumnImpl.convert(object);
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(Object object, int size) {
        this.fillWithValue(BooleanColumnImpl.convert(object), size);
    }

    @Override
    public void assignWithValue(boolean value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(boolean value, int size) {
        for (int i = 0; i < size; ++i) {
            this.append(value);
        }
    }

    @Override
    public void fillWithValue(byte value, int size) {
        for (int i = 0; i < size; ++i) {
            this.append(value);
        }
    }

    @Override
    public void clear() {
        this.data.clear();
        this.onDataCleared();
    }

    @Override
    public void trimToSize() {
        this.data.trimToSize();
    }

    @Override
    public void sortAscending() {
        Arrays.sort(this.data.elements(), 0, this.data.size());
        this.onDataFullyUpdated();
    }

    @Override
    public void sortDescending() {
        int length = this.data.size();
        byte[] a = this.data.elements();
        Arrays.sort(a, 0, length);
        for (int i = 0; i < length / 2; ++i) {
            byte tmp = a[i];
            a[i] = a[length - i - 1];
            a[length - i - 1] = tmp;
        }
        this.onDataFullyUpdated();
    }

    @Override
    public void setObject(int index, Object object) {
        this.set(index, BooleanColumnImpl.convert(object));
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, BooleanColumnImpl.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        if (IntColumnImpl.isMissingValue(value)) {
            this.set(row, BooleanColumnImpl.getMissingValue());
        } else {
            this.set(row, value == 1);
        }
    }

    @Override
    public void setShort(int row, short value) {
        if (ShortColumnImpl.isMissingValue(value)) {
            this.set(row, BooleanColumnImpl.getMissingValue());
        } else {
            this.set(row, value == 1);
        }
    }

    @Override
    public void setLong(int row, long value) {
        if (LongColumnImpl.isMissingValue(value)) {
            this.set(row, BooleanColumnImpl.getMissingValue());
        } else {
            this.set(row, value == 1L);
        }
    }

    @Override
    public void setFloat(int row, float value) {
        if (FloatColumnImpl.isMissingValue(value)) {
            this.set(row, BooleanColumnImpl.getMissingValue());
        } else {
            this.set(row, (double)value == 1.0);
        }
    }

    @Override
    public void setDouble(int row, double value) {
        if (DoubleColumnImpl.isMissingValue(value)) {
            this.set(row, BooleanColumnImpl.getMissingValue());
        } else {
            this.set(row, value == 1.0);
        }
    }

    @Override
    public void setBoolean(int row, boolean value) {
        this.set(row, value);
    }

    @Override
    public String getString(int row) {
        return String.valueOf(this.get(row));
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        if (this.isMissing(row)) {
            return IntColumnImpl.MISSING_VALUE;
        }
        return this.getByte(row);
    }

    @Override
    public short getShort(int row) {
        if (this.isMissing(row)) {
            return ShortColumnImpl.MISSING_VALUE;
        }
        return this.getByte(row);
    }

    @Override
    public long getLong(int row) {
        if (this.isMissing(row)) {
            return LongColumnImpl.MISSING_VALUE;
        }
        return this.getByte(row);
    }

    @Override
    public float getFloat(int row) {
        if (this.isMissing(row)) {
            return FloatColumnImpl.MISSING_VALUE;
        }
        return this.getByte(row);
    }

    @Override
    public double getDouble(int row) {
        if (this.isMissing(row)) {
            return DoubleColumnImpl.MISSING_VALUE;
        }
        return this.getByte(row);
    }

    @Override
    public boolean getBoolean(int row) {
        return this.getBoolean(row);
    }

    @Override
    public Boolean get(int i) {
        byte b = this.data.getByte(i);
        if (b == 1) {
            return Boolean.TRUE;
        }
        if (b == 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public byte getByte(int i) {
        return this.data.getByte(i);
    }

    @Override
    public byte[] asBytes(int row) {
        byte[] result = new byte[]{(byte)(this.get(row) != false ? 1 : 0)};
        return result;
    }

    @Override
    public boolean isMissing(int row) {
        return BooleanColumnImpl.isMissingValue(this.getByte(row));
    }

    public static boolean isMissingValue(byte b) {
        return b == -128;
    }

    public static byte getMissingValue() {
        return -128;
    }

    @Override
    public boolean isEmpty(Selection selection) {
        return this.data.isEmpty() || selection.isEmpty();
    }

    @Override
    public ByteArrayList data() {
        return this.data;
    }

    @Override
    public Column select(Selection selection) {
        IntIterator iterator = selection.iterator();
        BooleanColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.getByte(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public Column selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        BooleanColumn result = this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.getBoolean(row));
        }
        return result;
    }

    @Override
    public BooleanColumn emptyCopy() {
        BooleanColumn column = BooleanColumn.create(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public BooleanColumn emptyCopy(int rowSize) {
        BooleanColumn column = BooleanColumn.create(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public BooleanColumn copy() {
        BooleanColumnImpl column = new BooleanColumnImpl(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public BooleanColumn trimToSelection(Selection selection) {
        BooleanColumn column = this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            column.append(this.getByte(iterator.nextInt()));
        }
        return column;
    }

    private BooleanColumn executeBooleanOperation(ByteBinaryOperator operator, BooleanColumn column2, String operation, Selection selection) {
        BooleanColumn result = BooleanColumn.create(this.name() + operation + column2.name(), selection.size());
        IntIterator iterator2 = column2.getSelection().iterator();
        selection.iterate(i -> {
            if (!iterator2.hasNext()) {
                return;
            }
            int i2 = iterator2.nextInt();
            result.append(this.isMissing(i) || column2.isMissing(i2) ? (byte)-128 : operator.apply(this.getByte(i), column2.getByte(i2)));
        });
        return result;
    }

    @Override
    public BooleanColumn and(BooleanColumn column, Selection selection) {
        return this.executeBooleanOperation((b1, b2) -> (byte)(b1 == 1 && b2 == 1 ? 1 : 0), column, this.name() + " and " + column.name(), selection);
    }

    @Override
    public BooleanColumn or(BooleanColumn column, Selection selection) {
        return this.executeBooleanOperation((b1, b2) -> (byte)(b1 == 1 || b2 == 1 ? 1 : 0), column, this.name() + " or " + column.name(), selection);
    }

    @Override
    public BooleanColumn andNot(BooleanColumn column, Selection selection) {
        return this.executeBooleanOperation((b1, b2) -> (byte)(b1 == 1 && b2 == 0 ? 1 : 0), column, this.name() + " andNot " + column.name(), selection);
    }

    @Override
    public int countMissing(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!BooleanColumnImpl.isMissingValue(this.getByte(iterator.nextInt()))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countTrue(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            byte b = this.data.getByte(iterator.nextInt());
            if (b != 1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countFalse(Selection selection) {
        int count = 0;
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            byte b = this.data.getByte(iterator.nextInt());
            if (b != 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double proportionTrue(Selection selection) {
        double n = this.size() - this.countMissing(selection);
        double trueCount = this.countTrue(selection);
        return trueCount / n;
    }

    @Override
    public double proportionFalse(Selection selection) {
        return 1.0 - this.proportionTrue(selection);
    }

    @Override
    public int countUnique(Selection selection) {
        IntIterator iterator = selection.iterator();
        HashSet<Byte> count = new HashSet<Byte>();
        while (iterator.hasNext()) {
            count.add(this.getByte(iterator.nextInt()));
        }
        return count.size();
    }

    @Override
    public Selection isFalse(Selection selection) {
        IntIterator iterator = selection.iterator();
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        while (iterator.hasNext()) {
            byte next = this.getByte(iterator.nextInt());
            if (next == 0) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public Selection isTrue(Selection selection) {
        IntIterator iterator = selection.iterator();
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        while (iterator.hasNext()) {
            byte next = this.getByte(iterator.nextInt());
            if (next == 1) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public Selection isEqualTo(BooleanColumn other, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        IntIterator otherIterator = other.getSelection().iterator();
        while (true) {
            boolean hasNext = iterator.hasNext();
            boolean otherHasNext = otherIterator.hasNext();
            if (!hasNext || !otherHasNext) break;
            int next = iterator.nextInt();
            int otherNext = otherIterator.nextInt();
            if (this.get(next) != this.get(otherNext)) continue;
            results.add(next);
        }
        return results;
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.where(isMissing, selection);
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.where(isNotMissing, selection);
    }

    @Override
    public Selection where(BooleanPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = iterator.nextInt();
            byte next = this.data.getByte(idx);
            if (!predicate.test(next)) continue;
            result.add(idx);
        }
        return result;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.getByte(row1), column2.isMissing(row2) ? BooleanColumnImpl.getMissingValue() : (byte)(column2.getBoolean(row2) ? 1 : 0));
    }

    private int compare(byte v1, byte v2) {
        if (v1 == v2) {
            return 0;
        }
        if (BooleanColumnImpl.isMissingValue(v1)) {
            return -1;
        }
        if (BooleanColumnImpl.isMissingValue(v2)) {
            return 1;
        }
        return Byte.compare(v1, v2);
    }

    @Override
    public IntColumn toIntColumn(Selection selection) {
        IntColumn intColumn = IntColumn.create(this.name() + ": ints", selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            intColumn.append(this.data.getByte(iterator.nextInt()));
        }
        return intColumn;
    }

    public static byte convert(String stringValue) {
        if (stringValue == null || stringValue.isEmpty() || TypeUtils.MISSING_INDICATORS.contains(stringValue)) {
            return -128;
        }
        if (TypeUtils.TRUE_STRINGS.contains(stringValue)) {
            return 1;
        }
        if (TypeUtils.FALSE_STRINGS.contains(stringValue)) {
            return 0;
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + stringValue + " to Boolean");
    }

    public static byte convert(Object objectValue) {
        if (objectValue == null || objectValue instanceof String) {
            return BooleanColumnImpl.convert((String)objectValue);
        }
        if (objectValue instanceof Byte) {
            return (Byte)objectValue;
        }
        if (objectValue instanceof Boolean) {
            return (byte)(objectValue.equals(Boolean.TRUE) ? 1 : 0);
        }
        if (objectValue instanceof Number) {
            return (byte)(((Number)objectValue).intValue() == 1 ? 1 : 0);
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + String.valueOf(objectValue) + " to Boolean");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanColumnImpl that = (BooleanColumnImpl)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "Boolean column: " + this.name();
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        ByteIterator byteIterator = this.data.iterator();
        while (byteIterator.hasNext()) {
            byte next = (Byte)byteIterator.next();
            if (next == 0) {
                builder.append(false);
            } else if (next == 1) {
                builder.append(true);
            } else {
                builder.append("NA");
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    protected void moveInternal(int from, int to) {
        this.data.set(to, this.data.getByte(from));
    }

    @Override
    protected void setSize(int size) {
        for (int toRemove = this.data.size() - size; toRemove > 0; --toRemove) {
            this.data.removeByIndex(this.data.size() - 1);
        }
    }

    @Override
    public BooleanColumn wrap(Selection selection) {
        return new BooleanColumnWrapper(this, selection);
    }

    static interface ByteBinaryOperator {
        public byte apply(byte var1, byte var2);
    }
}

