/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.AbstractColumn;
import com.streamscape.ds.stable.columns.CategoryStringColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.FloatColumnImpl;
import com.streamscape.ds.stable.columns.IntColumnImpl;
import com.streamscape.ds.stable.columns.LongColumnImpl;
import com.streamscape.ds.stable.columns.ShortColumnImpl;
import com.streamscape.ds.stable.columns.StringColumnImpl;
import com.streamscape.ds.stable.filtering.StringBiPredicate;
import com.streamscape.ds.stable.filtering.StringIntegerBiPredicate;
import com.streamscape.ds.stable.filtering.StringPatternBiPredicate;
import com.streamscape.ds.stable.filtering.StringPredicate;
import com.streamscape.ds.stable.lists.IntComparator;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.utils.BitmapBackedSelection;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.stable.utils.TypeUtils;
import com.streamscape.lib.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractStringColumn
extends AbstractColumn
implements CategoryStringColumn {
    private final IntComparator rowComparator = new IntComparator(){

        @Override
        public int compare(int i, int i1) {
            return AbstractStringColumn.this.compare(AbstractStringColumn.this.get(i), AbstractStringColumn.this.get(i1));
        }

        @Override
        public int compare(Integer i, Integer i1) {
            return this.compare((int)i, (int)i1);
        }
    };
    public static StringPredicate isMissing = i -> i.equals(StringColumnImpl.MISSING_VALUE);
    public static StringPredicate isNotMissing = i -> !i.equals(StringColumnImpl.MISSING_VALUE);
    public static StringBiPredicate isEqualsIgnoreCase = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst || valueToTest != null && valueToTest.equalsIgnoreCase(valueToCompareAgainst);
    public static StringBiPredicate isStartsWith = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst || valueToTest != null && valueToTest.startsWith(valueToCompareAgainst);
    public static StringBiPredicate isEndsWith = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst || valueToTest != null && valueToTest.endsWith(valueToCompareAgainst);
    public static StringBiPredicate isStringContains = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst || valueToTest != null && valueToTest.contains(valueToCompareAgainst);
    public static StringPatternBiPredicate isMatchesRegexp = (valueToTest, pattern) -> valueToTest != null && pattern.matcher(valueToTest).matches();
    public static StringIntegerBiPredicate isLengthEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest != null && valueToTest.length() == valueToCompareAgainst;
    public static StringIntegerBiPredicate isLongerThan = (valueToTest, valueToCompareAgainst) -> valueToTest != null && valueToTest.length() > valueToCompareAgainst;
    public static StringIntegerBiPredicate isShorterThan = (valueToTest, valueToCompareAgainst) -> valueToTest != null && valueToTest.length() < valueToCompareAgainst;
    public static StringPredicate isEmpty = s -> s != null && s.isEmpty();
    public static StringPredicate isNumeric = s -> s != null && StringUtils.isNumeric(s);
    public static StringPredicate isAlpha = s -> s != null && StringUtils.isAlpha(s);
    public static StringPredicate isAlphaNumeric = s -> s != null && StringUtils.isAlphanumeric(s);
    public static StringPredicate isUpperCase = s -> s != null && StringUtils.isAllUpperCase(s);
    public static StringPredicate isLowerCase = s -> s != null && StringUtils.isAllLowerCase(s);

    public AbstractStringColumn(String name) {
        super(name);
    }

    public AbstractStringColumn(ColumnMetadata metadata) {
        super(metadata);
    }

    @Override
    public abstract long sizeInMemory(Selection var1);

    @Override
    public abstract void set(int var1, String var2);

    protected abstract void appendValue(String var1);

    @Override
    public abstract void removeRow(int var1);

    @Override
    public void append(String value) {
        this.appendValue(this.convert(value));
    }

    @Override
    public void appendAll(List<String> stringValues) {
        for (String stringValue : stringValues) {
            this.append(stringValue);
        }
    }

    @Override
    public void appendObject(Object object) {
        this.appendValue(this.convert(object));
    }

    @Override
    public void append(Column column2, int row2) {
        if (column2.isMissing(row2)) {
            this.appendMissing();
        } else {
            this.append(column2.getString(row2));
        }
    }

    @Override
    public void appendMissing() {
        this.append(this.getMissingValue());
    }

    @Override
    public void assignWithValue(Object object) {
        String value = this.convert(object);
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, value);
        }
    }

    @Override
    public void fillWithValue(Object object, int size) {
        for (int i = 0; i < size; ++i) {
            this.appendValue(this.convert(object));
        }
    }

    @Override
    public void set(String newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    @Override
    public void setObject(int index, Object object) {
        this.set(index, this.convert(object));
    }

    @Override
    public void setString(int row, String value) {
        this.set(row, this.convert(value));
    }

    @Override
    public void setInt(int row, int value) {
        if (IntColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, Integer.toString(value));
        }
    }

    @Override
    public void setShort(int row, short value) {
        if (ShortColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, Short.toString(value));
        }
    }

    @Override
    public void setLong(int row, long value) {
        if (LongColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, Long.toString(value));
        }
    }

    @Override
    public void setFloat(int row, float value) {
        if (FloatColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, Float.toString(value));
        }
    }

    @Override
    public void setDouble(int row, double value) {
        if (DoubleColumnImpl.isMissingValue(value)) {
            this.set(row, this.getMissingValue());
        } else {
            this.set(row, Double.toString(value));
        }
    }

    @Override
    public void setBoolean(int row, boolean value) {
        this.set(row, Boolean.toString(value));
    }

    @Override
    public abstract String get(int var1);

    @Override
    public String getString(int row) {
        return this.get(row);
    }

    @Override
    public Object getObject(int row) {
        return this.get(row);
    }

    @Override
    public int getInt(int row) {
        String value = this.get(row);
        if (this.isMissingValue(value)) {
            return IntColumnImpl.MISSING_VALUE;
        }
        return Integer.valueOf(value);
    }

    @Override
    public short getShort(int row) {
        String value = this.get(row);
        if (this.isMissingValue(value)) {
            return ShortColumnImpl.MISSING_VALUE;
        }
        return Short.valueOf(value);
    }

    @Override
    public long getLong(int row) {
        String value = this.get(row);
        if (this.isMissingValue(value)) {
            return LongColumnImpl.MISSING_VALUE;
        }
        return Long.valueOf(value);
    }

    @Override
    public float getFloat(int row) {
        String value = this.get(row);
        if (this.isMissingValue(value)) {
            return FloatColumnImpl.MISSING_VALUE;
        }
        return Float.valueOf(value).floatValue();
    }

    @Override
    public double getDouble(int row) {
        String value = this.get(row);
        if (this.isMissingValue(value)) {
            return DoubleColumnImpl.MISSING_VALUE;
        }
        return Double.valueOf(value);
    }

    @Override
    public boolean getBoolean(int row) {
        String value = this.get(row);
        if (this.isMissingValue(value)) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public boolean isMissing(int row) {
        return this.isMissingValue(this.get(row));
    }

    protected boolean isMissingValue(String value) {
        return Objects.equals(value, this.getMissingValue());
    }

    @Override
    public Set<String> asSet(Selection selection) {
        HashSet<String> set = new HashSet<String>();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            set.add(this.get(i));
        }
        return set;
    }

    @Override
    public Column select(Selection selection) {
        IntIterator iterator = selection.iterator();
        AbstractStringColumn result = (AbstractStringColumn)this.emptyCopy();
        while (iterator.hasNext()) {
            result.append(this.getString(iterator.nextInt()));
        }
        return result;
    }

    @Override
    public Column selectNoMissing(Selection selection) {
        IntIterator iterator = selection.iterator();
        AbstractStringColumn result = (AbstractStringColumn)this.emptyCopy();
        while (iterator.hasNext()) {
            int row = iterator.nextInt();
            if (this.isMissing(row)) continue;
            result.append(this.getString(row));
        }
        return result;
    }

    @Override
    public List<String> top(int n, Selection selection) {
        AbstractStringColumn tmp = (AbstractStringColumn)this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            tmp.append(this.get(iterator.nextInt()));
        }
        tmp.sortAscending();
        ArrayList<String> top = new ArrayList<String>();
        for (int i = tmp.size() - 1; i >= tmp.size() - n - 1 && i >= 0; --i) {
            top.add(tmp.get(i));
        }
        return top;
    }

    @Override
    public List<String> bottom(int n, Selection selection) {
        AbstractStringColumn tmp = (AbstractStringColumn)this.emptyCopy(selection.size());
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            tmp.append(this.get(iterator.nextInt()));
        }
        tmp.sortAscending();
        ArrayList<String> bottom = new ArrayList<String>();
        for (int i = 0; i < n && i < tmp.size(); ++i) {
            bottom.add(tmp.get(i));
        }
        return bottom;
    }

    @Override
    public Selection isEqualTo(CategoryStringColumn other, Selection selection) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        IntIterator otherIterator = other.getSelection().iterator();
        while (true) {
            boolean hasNext = iterator.hasNext();
            boolean otherHasNext = otherIterator.hasNext();
            if (!hasNext || !otherHasNext) break;
            int next = iterator.nextInt();
            int otherNext = otherIterator.nextInt();
            if (!Objects.equals(this.get(next), this.get(otherNext))) continue;
            results.add(next);
        }
        return results;
    }

    @Override
    public Selection isNotEqualTo(String string, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        result.or(selection);
        result.andNot(this.isEqualTo(string));
        return selection;
    }

    @Override
    public Selection equalToIgnoringCase(String string, Selection selection) {
        return this.select(isEqualsIgnoreCase, string, selection);
    }

    @Override
    public Selection startsWith(String string, Selection selection) {
        return this.select(isStartsWith, string, selection);
    }

    @Override
    public Selection endsWith(String string, Selection selection) {
        return this.select(isEndsWith, string, selection);
    }

    @Override
    public Selection stringContains(String string, Selection selection) {
        return this.select(isStringContains, string, selection);
    }

    @Override
    public Selection matchesRegex(String string, Selection selection) {
        Pattern p = Pattern.compile(string);
        return this.select(isMatchesRegexp, p, selection);
    }

    @Override
    public Selection empty(Selection selection) {
        return this.select(isEmpty, selection);
    }

    @Override
    public Selection isAlpha(Selection selection) {
        return this.select(isAlpha, selection);
    }

    @Override
    public Selection isNumeric(Selection selection) {
        return this.select(isNumeric, selection);
    }

    @Override
    public Selection isAlphaNumeric(Selection selection) {
        return this.select(isAlphaNumeric, selection);
    }

    @Override
    public Selection isUpperCase(Selection selection) {
        return this.select(isUpperCase, selection);
    }

    @Override
    public Selection isLowerCase(Selection selection) {
        return this.select(isLowerCase, selection);
    }

    @Override
    public Selection hasLengthEqualTo(int lengthChars, Selection selection) {
        return this.select(isLengthEqualTo, lengthChars, selection);
    }

    @Override
    public Selection isShorterThan(int lengthChars, Selection selection) {
        return this.select(isShorterThan, lengthChars, selection);
    }

    @Override
    public Selection isLongerThan(int lengthChars, Selection selection) {
        return this.select(isLongerThan, lengthChars, selection);
    }

    @Override
    public Selection isMissing(Selection selection) {
        return this.select(isMissing, selection);
    }

    @Override
    public Selection isNotMissing(Selection selection) {
        return this.select(isNotMissing, selection);
    }

    @Override
    public Selection select(StringPredicate predicate, Selection selection) {
        BitmapBackedSelection result = new BitmapBackedSelection();
        IntIterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            int id = iterator.nextInt();
            String next = this.get(id);
            if (!predicate.test(next)) continue;
            result.add(id);
        }
        return result;
    }

    @Override
    public Selection select(StringBiPredicate predicate, String value, Selection selection) {
        return this.select((String valueToTest) -> predicate.test(valueToTest, value), selection);
    }

    public Selection select(StringPatternBiPredicate predicate, Pattern pattern, Selection selection) {
        return this.select((String valueToTest) -> predicate.test(valueToTest, pattern), selection);
    }

    public Selection select(StringIntegerBiPredicate predicate, int value, Selection selection) {
        return this.select((String valueToTest) -> predicate.test(valueToTest, value), selection);
    }

    @Override
    public IntComparator rowComparator() {
        return this.rowComparator;
    }

    @Override
    public int compare(int row1, Column column2, int row2) {
        return this.compare(this.get(row1), column2.getString(row2));
    }

    private int compare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public String convert(String stringValue) {
        if (TypeUtils.isNullOrEmpty(stringValue) || TypeUtils.MISSING_INDICATORS.contains(stringValue)) {
            return this.getMissingValue();
        }
        return stringValue;
    }

    public String convert(Object objectValue) {
        if (objectValue != null && !(objectValue instanceof String)) {
            objectValue = String.valueOf(objectValue);
        }
        return this.convert((String)objectValue);
    }
}

