/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.columns;

import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnMetadata;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.ContinuousSelection;
import com.streamscape.ds.stable.utils.Selection;
import java.util.UUID;

public abstract class AbstractColumn
implements Column {
    private String id;
    private String name;
    private String comment;
    private SnapshotTable snapshotTable;
    private int index = -1;
    private long sizeOnDisk = -1L;

    public AbstractColumn(String name) {
        this.name = name;
        this.comment = "";
        this.id = UUID.randomUUID().toString();
    }

    public AbstractColumn(ColumnMetadata metadata) {
        this.name = metadata.getName();
        this.comment = "";
        this.id = metadata.getId();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Column setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public ColumnMetadata columnMetadata() {
        return new ColumnMetadata(this);
    }

    @Override
    public int columnWidth() {
        int width = this.name().length();
        for (int rowNum = 0; rowNum < this.size(); ++rowNum) {
            width = Math.max(width, String.valueOf(this.getString(rowNum)).length());
        }
        return width;
    }

    @Override
    public SnapshotTable getSnapshotTable() {
        return this.snapshotTable;
    }

    @Override
    public void setSnapshotTable(SnapshotTable snapshotTable) {
        this.snapshotTable = snapshotTable;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public long sizeInMemoryData() {
        return this.size() * this.byteSize();
    }

    @Override
    public long sizeInMemoryFull() {
        return this.capacity() * this.byteSize();
    }

    @Override
    public long sizeOnDisk() {
        return this.sizeOnDisk;
    }

    public void setSizeOnDisk(long sizeOnDisk) {
        this.sizeOnDisk = sizeOnDisk;
    }

    @Override
    public Selection getSelection() {
        if (this.snapshotTable != null) {
            return this.snapshotTable.getSelection();
        }
        return new ContinuousSelection(this.dataSize());
    }

    @Override
    public IntIterator indexIterator() {
        return this.getSelection().iterator();
    }

    protected void onDataFullyUpdated() {
        if (this.snapshotTable != null) {
            this.snapshotTable.onColumnDataFullyUpdated(this.index);
        }
        this.sizeOnDisk = -1L;
    }

    protected void onDataAppended(int dataIndex) {
        if (this.snapshotTable != null) {
            this.snapshotTable.onColumnDataAppended(this.index, dataIndex);
        }
        this.sizeOnDisk = -1L;
    }

    protected void onDataRemoved(int dataIndex) {
        if (this.snapshotTable != null) {
            this.snapshotTable.onColumnDataRemoved(this.index, dataIndex);
        }
        this.sizeOnDisk = -1L;
    }

    protected void onDataChanged(int dataIndex) {
        if (this.snapshotTable != null) {
            this.snapshotTable.onColumnDataChanged(this.index, dataIndex);
        }
        this.sizeOnDisk = -1L;
    }

    protected void onDataCleared() {
        if (this.snapshotTable != null) {
            this.snapshotTable.onColumnDataCleared(this.index);
        }
        this.sizeOnDisk = -1L;
    }

    @Override
    public void defrag(int[] moveMap, boolean withTrim) {
        int size = 0;
        for (int from = 0; from < moveMap.length; ++from) {
            int to = moveMap[from];
            if (to <= 0) continue;
            if (--to != from) {
                this.moveInternal(from, to);
            }
            ++size;
        }
        this.setSize(size);
        if (withTrim) {
            this.trimToSize();
        }
    }

    protected abstract void moveInternal(int var1, int var2);

    protected abstract void setSize(int var1);
}

