/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.aggregate;

import com.streamscape.ds.stable.aggregate.AggregateFunctionPair;
import com.streamscape.ds.stable.aggregate.DecimalAggregateFunction;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.table.SnapshotSlice;
import com.streamscape.ds.stable.table.SnapshotSliceGroup;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Summarizer {
    private Snapshot table;
    private Map<String, List<AggregateFunctionPair>> columnNameToFunctionsMap = new LinkedHashMap<String, List<AggregateFunctionPair>>();
    private List<AggregateFunctionPair> functionPairs;

    public Summarizer(Snapshot table, AggregateFunctionPair ... functionPairs) {
        this(table, Arrays.asList(functionPairs));
    }

    public Summarizer(Snapshot table, List<AggregateFunctionPair> functionPairs) {
        this.table = table;
        this.functionPairs = new ArrayList<AggregateFunctionPair>(functionPairs);
        for (AggregateFunctionPair functionPair : functionPairs) {
            Column column = table.column(functionPair.getColumnName());
            if (!functionPair.getFunction().isCompatibleWith(column.type())) {
                throw new IllegalArgumentException("Function '" + functionPair.getFunction().functionName() + "' is not compatible with column '" + column.name() + "' of type + '" + column.type().name() + "'.");
            }
            List<AggregateFunctionPair> list = this.columnNameToFunctionsMap.get(functionPair.getColumnName());
            if (list == null) {
                list = new ArrayList<AggregateFunctionPair>();
                this.columnNameToFunctionsMap.put(functionPair.getColumnName(), list);
            }
            list.add(functionPair);
        }
    }

    @RPLMethod(syntax="(<column name>.<is method name>(...) {and | or | and not} ....)", returnType="Summarizer", samples={"myTable.where(age.isGreaterThan(30) and state.isEqualsTo('NY'))"}, description="Returns selection from the table according to the specified selector.")
    public Summarizer where(Selection selection) {
        this.table = new SnapshotSlice(this.table, selection);
        return this;
    }

    @RPLMethod(syntax="", description="Groups all rows.")
    public SnapshotTable by() {
        SnapshotSliceGroup group = new SnapshotSliceGroup(this.table, new String[0]);
        return this.summarize(group);
    }

    @RPLMethod(syntax="(<column name>, ....)", description="Groups result by the specified columns. If columns not specified groups over all rows.")
    public SnapshotTable by(String ... columnNames) {
        SnapshotSliceGroup group = new SnapshotSliceGroup(this.table, columnNames);
        return this.summarize(group);
    }

    public SnapshotTable by(List<String> columnNames) {
        return this.by(columnNames.toArray(new String[0]));
    }

    private SnapshotTable summarize(SnapshotSliceGroup group) {
        SnapshotTable result = SnapshotTable.create(this.table.name() + "-summarize");
        for (AggregateFunctionPair functionPair : this.functionPairs) {
            Column originalColumn = this.table.column(functionPair.getColumnName());
            if (originalColumn.type() == ColumnType.DECIMAL && functionPair.getFunction() instanceof DecimalAggregateFunction) {
                result.addColumn(DecimalColumn.create(functionPair.asName(), originalColumn.getPrecision(), originalColumn.getScale()));
            } else {
                result.addColumn(DoubleColumn.create(functionPair.asName()));
            }
            functionPair.setColumnIndex(result.columnCount() - 1);
        }
        for (Column column : group.getSplitColumns()) {
            result.addColumn(column.emptyCopy());
        }
        List<Column> splitColumns = group.getSplitColumns();
        for (SnapshotSliceGroup.SnapshotSlicePair slice : group.getSlices()) {
            for (Map.Entry<String, List<AggregateFunctionPair>> entry : this.columnNameToFunctionsMap.entrySet()) {
                Column column = slice.getSlice().column(entry.getKey());
                for (AggregateFunctionPair pair : entry.getValue()) {
                    Column resultColumn = result.column(pair.getColumnIndex());
                    if (column.type() == ColumnType.DECIMAL && resultColumn.type() == ColumnType.DECIMAL && pair.getFunction() instanceof DecimalAggregateFunction) {
                        long value = ((DecimalAggregateFunction)((Object)pair.getFunction())).summarize((DecimalColumn)column, slice.getSlice().getSelection());
                        ((DecimalColumn)resultColumn).append(value, column.getScale());
                        continue;
                    }
                    double value = pair.getFunction().summarize(column, slice.getSlice().getSelection());
                    ((DoubleColumn)resultColumn).append(value);
                }
            }
            for (int i = 0; i < splitColumns.size(); ++i) {
                Column column = splitColumns.get(i);
                result.column(result.columnCount() - splitColumns.size() + i).appendObject(column.getObject(slice.getRow()));
            }
        }
        return result;
    }
}

